/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.BooleanType;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.IntType;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodType;
import org.apache.xalan.xsltc.compiler.util.MultiHashtable;
import org.apache.xalan.xsltc.compiler.util.ObjectType;
import org.apache.xalan.xsltc.compiler.util.ReferenceType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.runtime.TransletLoader;

class FunctionCall
extends Expression {
    private QName _fname;
    private final Vector _arguments;
    private static final Vector EMPTY_ARG_LIST = new Vector(0);
    protected static final String EXT_XSLTC = "http://xml.apache.org/xalan/xsltc";
    protected static final String JAVA_EXT_XSLTC = "http://xml.apache.org/xalan/xsltc/java";
    protected static final String EXT_XALAN = "http://xml.apache.org/xalan";
    protected static final String JAVA_EXT_XALAN = "http://xml.apache.org/xalan/java";
    protected static final String JAVA_EXT_XALAN_OLD = "http://xml.apache.org/xslt/java";
    protected static final String EXSLT_COMMON = "http://exslt.org/common";
    protected static final String EXSLT_MATH = "http://exslt.org/math";
    protected static final String EXSLT_SETS = "http://exslt.org/sets";
    protected static final String EXSLT_DATETIME = "http://exslt.org/dates-and-times";
    protected static final String EXSLT_STRINGS = "http://exslt.org/strings";
    protected static final int NAMESPACE_FORMAT_JAVA = 0;
    protected static final int NAMESPACE_FORMAT_CLASS = 1;
    protected static final int NAMESPACE_FORMAT_PACKAGE = 2;
    protected static final int NAMESPACE_FORMAT_CLASS_OR_PACKAGE = 3;
    private int _namespace_format = 0;
    Expression _thisArgument = null;
    private String _className;
    private Class _clazz;
    private Method _chosenMethod;
    private Constructor _chosenConstructor;
    private MethodType _chosenMethodType;
    private boolean unresolvedExternal;
    private boolean _isExtConstructor = false;
    private boolean _isStatic = false;
    private static final MultiHashtable _internal2Java = new MultiHashtable();
    private static final Hashtable _java2Internal = new Hashtable();
    private static final Hashtable _extensionNamespaceTable = new Hashtable();
    private static final Hashtable _extensionFunctionTable = new Hashtable();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public FunctionCall(QName qName, Vector vector) {
        this._fname = qName;
        this._arguments = vector;
        this._type = null;
    }

    public FunctionCall(QName qName) {
        this(qName, EMPTY_ARG_LIST);
    }

    public String getName() {
        return this._fname.toString();
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        if (this._arguments != null) {
            int n = this._arguments.size();
            int n2 = 0;
            while (n2 < n) {
                Expression expression = (Expression)this._arguments.elementAt(n2);
                expression.setParser(parser2);
                expression.setParent(this);
                ++n2;
            }
        }
    }

    public String getClassNameFromUri(String string) {
        String string2 = (String)_extensionNamespaceTable.get(string);
        if (string2 != null) {
            return string2;
        }
        if (string.startsWith(JAVA_EXT_XSLTC)) {
            int n = JAVA_EXT_XSLTC.length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith(JAVA_EXT_XALAN)) {
            int n = JAVA_EXT_XALAN.length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        if (string.startsWith(JAVA_EXT_XALAN_OLD)) {
            int n = JAVA_EXT_XALAN_OLD.length() + 1;
            return string.length() > n ? string.substring(n) : "";
        }
        int n = string.lastIndexOf(47);
        return n > 0 ? string.substring(n + 1) : string;
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this._type != null) {
            return this._type;
        }
        String string = this._fname.getNamespace();
        String string2 = this._fname.getLocalPart();
        if (this.isExtension()) {
            this._fname = new QName(null, null, string2);
            return this.typeCheckStandard(symbolTable);
        }
        if (this.isStandard()) {
            return this.typeCheckStandard(symbolTable);
        }
        try {
            this._className = this.getClassNameFromUri(string);
            int n = string2.lastIndexOf(46);
            if (n > 0) {
                this._isStatic = true;
                if (this._className != null && this._className.length() > 0) {
                    this._namespace_format = 2;
                    this._className = this._className + "." + string2.substring(0, n);
                } else {
                    this._namespace_format = 0;
                    this._className = string2.substring(0, n);
                }
                this._fname = new QName(string, null, string2.substring(n + 1));
            } else {
                Object object;
                if (this._className != null && this._className.length() > 0) {
                    try {
                        object = new TransletLoader();
                        this._clazz = ((TransletLoader)object).loadClass(this._className);
                        this._namespace_format = 1;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this._namespace_format = 2;
                    }
                } else {
                    this._namespace_format = 0;
                }
                if (string2.indexOf(45) > 0) {
                    string2 = FunctionCall.replaceDash(string2);
                }
                if ((object = (String)_extensionFunctionTable.get(string + ":" + string2)) != null) {
                    this._fname = new QName(null, null, (String)object);
                    return this.typeCheckStandard(symbolTable);
                }
                this._fname = new QName(string, null, string2);
            }
            return this.typeCheckExternal(symbolTable);
        }
        catch (TypeCheckError typeCheckError) {
            ErrorMsg errorMsg = typeCheckError.getErrorMsg();
            if (errorMsg == null) {
                String string3 = this._fname.getLocalPart();
                errorMsg = new ErrorMsg("METHOD_NOT_FOUND_ERR", string3);
            }
            this.getParser().reportError(3, errorMsg);
            this._type = Type.Void;
            return this._type;
        }
    }

    public Type typeCheckStandard(SymbolTable symbolTable) throws TypeCheckError {
        this._fname.clearNamespace();
        int n = this._arguments.size();
        Vector vector = this.typeCheckArgs(symbolTable);
        MethodType methodType = new MethodType(Type.Void, vector);
        MethodType methodType2 = this.lookupPrimop(symbolTable, this._fname.getLocalPart(), methodType);
        if (methodType2 != null) {
            int n2 = 0;
            while (n2 < n) {
                Expression expression;
                Type type = (Type)methodType2.argsType().elementAt(n2);
                if (!type.identicalTo((expression = (Expression)this._arguments.elementAt(n2)).getType())) {
                    try {
                        this._arguments.setElementAt(new CastExpr(expression, type), n2);
                    }
                    catch (TypeCheckError typeCheckError) {
                        throw new TypeCheckError(this);
                    }
                }
                ++n2;
            }
            this._chosenMethodType = methodType2;
            this._type = methodType2.resultType();
            return this._type;
        }
        throw new TypeCheckError(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Type typeCheckConstructor(SymbolTable symbolTable) throws TypeCheckError {
        Vector vector = this.findConstructors();
        if (vector == null) {
            throw new TypeCheckError("CONSTRUCTOR_NOT_FOUND", this._className);
        }
        int n = vector.size();
        int n2 = this._arguments.size();
        Vector vector2 = this.typeCheckArgs(symbolTable);
        int n3 = Integer.MAX_VALUE;
        this._type = null;
        int n4 = 0;
        while (n4 < n) {
            Constructor constructor = (Constructor)vector.elementAt(n4);
            Class<?>[] classArray = constructor.getParameterTypes();
            Class<?> clazz = null;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                clazz = classArray[n6];
                Type type = (Type)vector2.elementAt(n6);
                Object object = _internal2Java.maps(type, clazz);
                if (object != null) {
                    n5 += ((JavaType)object).distance;
                } else if (type instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)type;
                    if (objectType.getJavaClass() != clazz) {
                        if (clazz.isAssignableFrom(objectType.getJavaClass())) {
                            ++n5;
                        } else {
                            n5 = Integer.MAX_VALUE;
                            break;
                        }
                    }
                } else {
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                ++n6;
            }
            if (n6 == n2 && n5 < n3) {
                this._chosenConstructor = constructor;
                this._isExtConstructor = true;
                n3 = n5;
                this._type = this._clazz != null ? new ObjectType(this._clazz) : new ObjectType(this._className);
            }
            ++n4;
        }
        if (this._type != null) {
            return this._type;
        }
        throw new TypeCheckError("ARGUMENT_CONVERSION_ERR", this.getMethodSignature(vector2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Type typeCheckExternal(SymbolTable symbolTable) throws TypeCheckError {
        Vector vector;
        Class<?> clazz;
        int n = this._arguments.size();
        String string = this._fname.getLocalPart();
        if (this._fname.getLocalPart().equals("new")) {
            return this.typeCheckConstructor(symbolTable);
        }
        boolean bl = false;
        if (n == 0) {
            this._isStatic = true;
        }
        if (!this._isStatic) {
            if (this._namespace_format == 0 || this._namespace_format == 2) {
                bl = true;
            }
            clazz = (Expression)this._arguments.elementAt(0);
            Type type = ((Expression)((Object)clazz)).typeCheck(symbolTable);
            if (this._namespace_format == 1 && type instanceof ObjectType && this._clazz != null && this._clazz.isAssignableFrom(((ObjectType)type).getJavaClass())) {
                bl = true;
            }
            if (bl) {
                this._thisArgument = (Expression)this._arguments.elementAt(0);
                this._arguments.remove(0);
                --n;
                if (!(type instanceof ObjectType)) {
                    throw new TypeCheckError("NO_JAVA_FUNCT_THIS_REF", string);
                }
                this._className = ((ObjectType)type).getJavaClassName();
            }
        } else if (this._className.length() == 0) {
            Parser parser2 = this.getParser();
            if (parser2 != null) {
                this.reportWarning(this, parser2, "FUNCTION_RESOLVE_ERR", this._fname.toString());
            }
            this.unresolvedExternal = true;
            this._type = Type.Int;
            return this._type;
        }
        if ((vector = this.findMethods()) == null) {
            throw new TypeCheckError("METHOD_NOT_FOUND_ERR", this._className + "." + string);
        }
        clazz = null;
        int n2 = vector.size();
        Vector vector2 = this.typeCheckArgs(symbolTable);
        int n3 = Integer.MAX_VALUE;
        this._type = null;
        int n4 = 0;
        while (n4 < n2) {
            Method method = (Method)vector.elementAt(n4);
            Class<?>[] classArray = method.getParameterTypes();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                block23: {
                    block26: {
                        Type type;
                        block25: {
                            block24: {
                                clazz = classArray[n6];
                                type = (Type)vector2.elementAt(n6);
                                Object object = _internal2Java.maps(type, clazz);
                                if (object == null) break block24;
                                n5 += ((JavaType)object).distance;
                                break block23;
                            }
                            if (!(type instanceof ReferenceType)) break block25;
                            ++n5;
                            break block23;
                        }
                        if (!(type instanceof ObjectType)) break block26;
                        ObjectType objectType = (ObjectType)type;
                        if (clazz.getName().equals(objectType.getJavaClassName())) {
                            n5 += 0;
                            break block23;
                        } else if (clazz.isAssignableFrom(objectType.getJavaClass())) {
                            ++n5;
                            break block23;
                        } else {
                            n5 = Integer.MAX_VALUE;
                            break;
                        }
                    }
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                ++n6;
            }
            if (n6 == n) {
                clazz = method.getReturnType();
                this._type = (Type)_java2Internal.get(clazz);
                if (this._type == null) {
                    this._type = new ObjectType(clazz);
                }
                if (this._type != null && n5 < n3) {
                    this._chosenMethod = method;
                    n3 = n5;
                }
            }
            ++n4;
        }
        if (this._chosenMethod != null && this._thisArgument == null && !Modifier.isStatic(this._chosenMethod.getModifiers())) {
            throw new TypeCheckError("NO_JAVA_FUNCT_THIS_REF", this.getMethodSignature(vector2));
        }
        if (this._type == null) {
            throw new TypeCheckError("ARGUMENT_CONVERSION_ERR", this.getMethodSignature(vector2));
        }
        if (this._type == Type.NodeSet) {
            this.getXSLTC().setMultiDocument(true);
        }
        return this._type;
    }

    public Vector typeCheckArgs(SymbolTable symbolTable) throws TypeCheckError {
        Vector<Type> vector = new Vector<Type>();
        Enumeration enumeration = this._arguments.elements();
        while (enumeration.hasMoreElements()) {
            Expression expression = (Expression)enumeration.nextElement();
            vector.addElement(expression.typeCheck(symbolTable));
        }
        return vector;
    }

    protected final Expression argument(int n) {
        return (Expression)this._arguments.elementAt(n);
    }

    protected final Expression argument() {
        return this.argument(0);
    }

    protected final int argumentCount() {
        return this._arguments.size();
    }

    protected final void setArgument(int n, Expression expression) {
        this._arguments.setElementAt(expression, n);
    }

    public void translateDesynthesized(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Type type = Type.Boolean;
        if (this._chosenMethodType != null) {
            type = this._chosenMethodType.resultType();
        }
        InstructionList instructionList = methodGenerator.getInstructionList();
        this.translate(classGenerator, methodGenerator);
        if (type instanceof BooleanType || type instanceof IntType) {
            this._falseList.add(instructionList.append(new IFEQ(null)));
        }
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        int n = this.argumentCount();
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this.isStandard() || this.isExtension()) {
            Object object;
            int n2 = 0;
            while (n2 < n) {
                object = this.argument(n2);
                ((Expression)object).translate(classGenerator, methodGenerator);
                ((Expression)object).startResetIterator(classGenerator, methodGenerator);
                ++n2;
            }
            object = this._fname.toString().replace('-', '_') + "F";
            String string = "";
            if (((String)object).equals("sumF")) {
                string = "Lorg/apache/xalan/xsltc/DOM;";
                instructionList.append(methodGenerator.loadDOM());
            } else if (((String)object).equals("normalize_spaceF") && this._chosenMethodType.toSignature(string).equals("()Ljava/lang/String;")) {
                string = "ILorg/apache/xalan/xsltc/DOM;";
                instructionList.append(methodGenerator.loadContextNode());
                instructionList.append(methodGenerator.loadDOM());
            }
            int n3 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", (String)object, this._chosenMethodType.toSignature(string));
            instructionList.append(new INVOKESTATIC(n3));
        } else if (this.unresolvedExternal) {
            int n4 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "unresolved_externalF", "(Ljava/lang/String;)V");
            instructionList.append(new PUSH(constantPoolGen, this._fname.toString()));
            instructionList.append(new INVOKESTATIC(n4));
        } else if (this._isExtConstructor) {
            Object object;
            String string = this._chosenConstructor.getDeclaringClass().getName();
            Class<?>[] classArray = this._chosenConstructor.getParameterTypes();
            instructionList.append(new NEW(constantPoolGen.addClass(this._className)));
            instructionList.append(InstructionConstants.DUP);
            int n5 = 0;
            while (n5 < n) {
                object = this.argument(n5);
                ((Expression)object).translate(classGenerator, methodGenerator);
                ((Expression)object).startResetIterator(classGenerator, methodGenerator);
                ((Expression)object).getType().translateTo(classGenerator, methodGenerator, classArray[n5]);
                ++n5;
            }
            object = new StringBuffer();
            ((StringBuffer)object).append('(');
            int n6 = 0;
            while (n6 < classArray.length) {
                ((StringBuffer)object).append(FunctionCall.getSignature(classArray[n6]));
                ++n6;
            }
            ((StringBuffer)object).append(')');
            ((StringBuffer)object).append("V");
            int n7 = constantPoolGen.addMethodref(string, "<init>", ((StringBuffer)object).toString());
            instructionList.append(new INVOKESPECIAL(n7));
            Type.Object.translateFrom(classGenerator, methodGenerator, this._chosenConstructor.getDeclaringClass());
        } else {
            Object object;
            String string = this._chosenMethod.getDeclaringClass().getName();
            Class<?>[] classArray = this._chosenMethod.getParameterTypes();
            if (this._thisArgument != null) {
                this._thisArgument.translate(classGenerator, methodGenerator);
            }
            int n8 = 0;
            while (n8 < n) {
                object = this.argument(n8);
                ((Expression)object).translate(classGenerator, methodGenerator);
                ((Expression)object).startResetIterator(classGenerator, methodGenerator);
                ((Expression)object).getType().translateTo(classGenerator, methodGenerator, classArray[n8]);
                ++n8;
            }
            object = new StringBuffer();
            ((StringBuffer)object).append('(');
            int n9 = 0;
            while (n9 < classArray.length) {
                ((StringBuffer)object).append(FunctionCall.getSignature(classArray[n9]));
                ++n9;
            }
            ((StringBuffer)object).append(')');
            ((StringBuffer)object).append(FunctionCall.getSignature(this._chosenMethod.getReturnType()));
            int n10 = constantPoolGen.addMethodref(string, this._fname.getLocalPart(), ((StringBuffer)object).toString());
            instructionList.append(this._thisArgument != null ? new INVOKEVIRTUAL(n10) : new INVOKESTATIC(n10));
            this._type.translateFrom(classGenerator, methodGenerator, this._chosenMethod.getReturnType());
        }
    }

    public String toString() {
        return "funcall(" + this._fname + ", " + this._arguments + ')';
    }

    public boolean isStandard() {
        String string = this._fname.getNamespace();
        return string == null || string.equals("");
    }

    public boolean isExtension() {
        String string = this._fname.getNamespace();
        return string != null && string.equals(EXT_XSLTC);
    }

    private Vector findMethods() {
        Vector<Method> vector = null;
        String string = this._fname.getNamespace();
        if (this._className != null && this._className.length() > 0) {
            int n = this._arguments.size();
            try {
                Object object;
                Object object2;
                if (this._clazz == null) {
                    object2 = new TransletLoader();
                    this._clazz = ((TransletLoader)object2).loadClass(this._className);
                    if (this._clazz == null) {
                        object = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                        this.getParser().reportError(3, (ErrorMsg)object);
                    }
                }
                object2 = this._fname.getLocalPart();
                object = this._clazz.getMethods();
                int n2 = 0;
                while (n2 < ((Method[])object).length) {
                    int n3 = object[n2].getModifiers();
                    if (Modifier.isPublic(n3) && object[n2].getName().equals(object2) && object[n2].getParameterTypes().length == n) {
                        if (vector == null) {
                            vector = new Vector<Method>();
                        }
                        vector.addElement(object[n2]);
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                this.getParser().reportError(3, errorMsg);
            }
        }
        return vector;
    }

    private Vector findConstructors() {
        Vector vector = null;
        String string = this._fname.getNamespace();
        int n = this._arguments.size();
        try {
            Constructor<?>[] constructorArray;
            if (this._clazz == null) {
                constructorArray = new TransletLoader();
                this._clazz = constructorArray.loadClass(this._className);
                if (this._clazz == null) {
                    ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                    this.getParser().reportError(3, errorMsg);
                }
            }
            constructorArray = this._clazz.getConstructors();
            int n2 = 0;
            while (n2 < constructorArray.length) {
                int n3 = constructorArray[n2].getModifiers();
                if (Modifier.isPublic(n3) && constructorArray[n2].getParameterTypes().length == n) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.addElement(constructorArray[n2]);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
            this.getParser().reportError(3, errorMsg);
        }
        return vector;
    }

    static final String getSignature(Class clazz) {
        if (clazz.isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?> clazz2 = clazz;
            while (clazz2.isArray()) {
                stringBuffer.append("[");
                clazz2 = clazz2.getComponentType();
            }
            stringBuffer.append(FunctionCall.getSignature(clazz2));
            return stringBuffer.toString();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            String string = clazz.toString();
            ErrorMsg errorMsg = new ErrorMsg("UNKNOWN_SIG_TYPE_ERR", string);
            throw new Error(errorMsg.toString());
        }
        return "L" + clazz.getName().replace('.', '/') + ';';
    }

    static final String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(FunctionCall.getSignature(classArray[n]));
            ++n;
        }
        return stringBuffer.append(')').append(FunctionCall.getSignature(method.getReturnType())).toString();
    }

    static final String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(FunctionCall.getSignature(classArray[n]));
            ++n;
        }
        return stringBuffer.append(")V").toString();
    }

    private String getMethodSignature(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(this._className);
        stringBuffer.append('.').append(this._fname.getLocalPart()).append('(');
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Type type = (Type)vector.elementAt(n2);
            stringBuffer.append(type.toString());
            if (n2 < n - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    protected static String replaceDash(String string) {
        char c = '-';
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < string.length()) {
            if (n > 0 && string.charAt(n - 1) == c) {
                stringBuffer.append(Character.toUpperCase(string.charAt(n)));
            } else if (string.charAt(n) != c) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.lang.Object");
            Class<?> clazz2 = Class.forName("java.lang.String");
            Class<?> clazz3 = Class.forName("org.w3c.dom.Node");
            Class<?> clazz4 = Class.forName("org.w3c.dom.NodeList");
            _internal2Java.put(Type.Boolean, new JavaType(clazz, 2));
            _internal2Java.put(Type.Boolean, new JavaType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = FunctionCall.class$("java.lang.Boolean")) : class$java$lang$Boolean, 1));
            _internal2Java.put(Type.Boolean, new JavaType(Boolean.TYPE, 0));
            _internal2Java.put(Type.Int, new JavaType(clazz, 8));
            _internal2Java.put(Type.Int, new JavaType(Character.TYPE, 7));
            _internal2Java.put(Type.Int, new JavaType(Byte.TYPE, 6));
            _internal2Java.put(Type.Int, new JavaType(Short.TYPE, 5));
            _internal2Java.put(Type.Int, new JavaType(Integer.TYPE, 0));
            _internal2Java.put(Type.Int, new JavaType(class$java$lang$Integer == null ? (class$java$lang$Integer = FunctionCall.class$("java.lang.Integer")) : class$java$lang$Integer, 1));
            _internal2Java.put(Type.Int, new JavaType(Long.TYPE, 2));
            _internal2Java.put(Type.Int, new JavaType(Float.TYPE, 3));
            _internal2Java.put(Type.Int, new JavaType(Double.TYPE, 4));
            _internal2Java.put(Type.Real, new JavaType(clazz, 8));
            _internal2Java.put(Type.Real, new JavaType(Character.TYPE, 7));
            _internal2Java.put(Type.Real, new JavaType(Byte.TYPE, 6));
            _internal2Java.put(Type.Real, new JavaType(Short.TYPE, 5));
            _internal2Java.put(Type.Real, new JavaType(Integer.TYPE, 4));
            _internal2Java.put(Type.Real, new JavaType(Long.TYPE, 3));
            _internal2Java.put(Type.Real, new JavaType(Float.TYPE, 2));
            _internal2Java.put(Type.Real, new JavaType(class$java$lang$Double == null ? (class$java$lang$Double = FunctionCall.class$("java.lang.Double")) : class$java$lang$Double, 1));
            _internal2Java.put(Type.Real, new JavaType(Double.TYPE, 0));
            _internal2Java.put(Type.String, new JavaType(clazz, 1));
            _internal2Java.put(Type.String, new JavaType(clazz2, 0));
            _internal2Java.put(Type.Node, new JavaType(clazz3, 0));
            _internal2Java.put(Type.Node, new JavaType(clazz4, 1));
            _internal2Java.put(Type.Node, new JavaType(clazz, 2));
            _internal2Java.put(Type.Node, new JavaType(clazz2, 3));
            _internal2Java.put(Type.NodeSet, new JavaType(Integer.TYPE, 10));
            _internal2Java.put(Type.NodeSet, new JavaType(clazz2, 3));
            _internal2Java.put(Type.NodeSet, new JavaType(clazz, 2));
            _internal2Java.put(Type.NodeSet, new JavaType(clazz3, 1));
            _internal2Java.put(Type.NodeSet, new JavaType(clazz4, 0));
            _internal2Java.put(Type.ResultTree, new JavaType(clazz3, 1));
            _internal2Java.put(Type.ResultTree, new JavaType(clazz4, 0));
            _internal2Java.put(Type.ResultTree, new JavaType(clazz, 2));
            _internal2Java.put(Type.ResultTree, new JavaType(clazz2, 3));
            _internal2Java.put(Type.ResultTree, new JavaType(Double.TYPE, 4));
            _internal2Java.put(Type.Reference, new JavaType(clazz, 0));
            _java2Internal.put(Boolean.TYPE, Type.Boolean);
            _java2Internal.put(Void.TYPE, Type.Void);
            _java2Internal.put(Character.TYPE, Type.Real);
            _java2Internal.put(Byte.TYPE, Type.Real);
            _java2Internal.put(Short.TYPE, Type.Real);
            _java2Internal.put(Integer.TYPE, Type.Real);
            _java2Internal.put(Long.TYPE, Type.Real);
            _java2Internal.put(Float.TYPE, Type.Real);
            _java2Internal.put(Double.TYPE, Type.Real);
            _java2Internal.put(clazz2, Type.String);
            _java2Internal.put(clazz, Type.Reference);
            _java2Internal.put(clazz4, Type.NodeSet);
            _java2Internal.put(clazz3, Type.NodeSet);
            _extensionNamespaceTable.put(EXT_XALAN, "org.apache.xalan.lib.Extensions");
            _extensionNamespaceTable.put(EXSLT_COMMON, "org.apache.xalan.lib.ExsltCommon");
            _extensionNamespaceTable.put(EXSLT_MATH, "org.apache.xalan.lib.ExsltMath");
            _extensionNamespaceTable.put(EXSLT_SETS, "org.apache.xalan.lib.ExsltSets");
            _extensionNamespaceTable.put(EXSLT_DATETIME, "org.apache.xalan.lib.ExsltDatetime");
            _extensionNamespaceTable.put(EXSLT_STRINGS, "org.apache.xalan.lib.ExsltStrings");
            _extensionFunctionTable.put("http://exslt.org/common:nodeSet", "nodeset");
            _extensionFunctionTable.put("http://exslt.org/common:objectType", "objectType");
            _extensionFunctionTable.put("http://xml.apache.org/xalan:nodeset", "nodeset");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
        }
    }

    static class JavaType {
        public Class type;
        public int distance;

        public JavaType(Class clazz, int n) {
            this.type = clazz;
            this.distance = n;
        }

        public boolean equals(Object object) {
            return object.equals(this.type);
        }
    }
}

