/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.FunctionCall;
import org.apache.xalan.xsltc.compiler.LiteralExpr;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;
import org.apache.xalan.xsltc.runtime.TransletLoader;

final class FunctionAvailableCall
extends FunctionCall {
    private Expression _arg;
    private String _nameOfFunct = null;
    private String _namespaceOfFunct = null;
    private boolean _isFunctionAvailable = false;

    public FunctionAvailableCall(QName qName, Vector vector) {
        super(qName, vector);
        this._arg = (Expression)vector.elementAt(0);
        this._type = null;
        if (this._arg instanceof LiteralExpr) {
            LiteralExpr literalExpr = (LiteralExpr)this._arg;
            this._namespaceOfFunct = literalExpr.getNamespace();
            this._nameOfFunct = literalExpr.getValue();
            if (!this.isInternalNamespace()) {
                this._isFunctionAvailable = this.hasMethods();
            }
        }
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this._type != null) {
            return this._type;
        }
        if (this._arg instanceof LiteralExpr) {
            this._type = Type.Boolean;
            return this._type;
        }
        ErrorMsg errorMsg = new ErrorMsg("NEED_LITERAL_ERR", (Object)"function-available", this);
        throw new TypeCheckError(errorMsg);
    }

    public Object evaluateAtCompileTime() {
        return this.getResult() ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean hasMethods() {
        Object object;
        LiteralExpr literalExpr = (LiteralExpr)this._arg;
        String string = this.getClassNameFromUri(this._namespaceOfFunct);
        String string2 = null;
        int n = this._nameOfFunct.indexOf(":");
        if (n > 0) {
            object = this._nameOfFunct.substring(n + 1);
            int n2 = ((String)object).lastIndexOf(46);
            if (n2 > 0) {
                string2 = ((String)object).substring(n2 + 1);
                string = string != null && !string.equals("") ? string + "." + ((String)object).substring(0, n2) : ((String)object).substring(0, n2);
            } else {
                string2 = object;
            }
        } else {
            string2 = this._nameOfFunct;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.indexOf(45) > 0) {
            string2 = FunctionCall.replaceDash(string2);
        }
        try {
            object = new TransletLoader();
            Class clazz = ((TransletLoader)object).loadClass(string);
            if (clazz == null) {
                return false;
            }
            Method[] methodArray = clazz.getMethods();
            int n3 = 0;
            while (n3 < methodArray.length) {
                int n4 = methodArray[n3].getModifiers();
                if (Modifier.isPublic(n4) && Modifier.isStatic(n4) && methodArray[n3].getName().equals(string2)) {
                    return true;
                }
                ++n3;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return false;
    }

    public boolean getResult() {
        if (this._nameOfFunct == null) {
            return false;
        }
        if (this.isInternalNamespace()) {
            Parser parser2 = this.getParser();
            this._isFunctionAvailable = parser2.functionSupported(Util.getLocalName(this._nameOfFunct));
        }
        return this._isFunctionAvailable;
    }

    private boolean isInternalNamespace() {
        return this._namespaceOfFunct == null || this._namespaceOfFunct.equals("") || this._namespaceOfFunct.equals("http://xml.apache.org/xalan/xsltc");
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        methodGenerator.getInstructionList().append(new PUSH(constantPoolGen, this.getResult()));
    }
}

