/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.NEW;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.Predicate;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.NodeSetType;
import org.apache.xalan.xsltc.compiler.util.ReferenceType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;

class FilterExpr
extends Expression {
    private Expression _primary;
    private final Vector _predicates;

    public FilterExpr(Expression expression, Vector vector) {
        this._primary = expression;
        this._predicates = vector;
        expression.setParent(this);
    }

    protected Expression getExpr() {
        if (this._primary instanceof CastExpr) {
            return ((CastExpr)this._primary).getExpr();
        }
        return this._primary;
    }

    public void setParser(Parser parser2) {
        super.setParser(parser2);
        this._primary.setParser(parser2);
        if (this._predicates != null) {
            int n = this._predicates.size();
            int n2 = 0;
            while (n2 < n) {
                Expression expression = (Expression)this._predicates.elementAt(n2);
                expression.setParser(parser2);
                expression.setParent(this);
                ++n2;
            }
        }
    }

    public String toString() {
        return "filter-expr(" + this._primary + ", " + this._predicates + ")";
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        Type type = this._primary.typeCheck(symbolTable);
        if (!(type instanceof NodeSetType)) {
            if (type instanceof ReferenceType) {
                this._primary = new CastExpr(this._primary, Type.NodeSet);
            } else {
                throw new TypeCheckError(this);
            }
        }
        int n = this._predicates.size();
        int n2 = 0;
        while (n2 < n) {
            Expression expression = (Expression)this._predicates.elementAt(n2);
            expression.typeCheck(symbolTable);
            ++n2;
        }
        this._type = Type.NodeSet;
        return this._type;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        if (this._predicates.size() > 0) {
            this.translatePredicates(classGenerator, methodGenerator);
        } else {
            this._primary.translate(classGenerator, methodGenerator);
            this._primary.startResetIterator(classGenerator, methodGenerator);
        }
    }

    public void translatePredicates(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        ConstantPoolGen constantPoolGen = classGenerator.getConstantPool();
        InstructionList instructionList = methodGenerator.getInstructionList();
        if (this._predicates.size() == 0) {
            this.translate(classGenerator, methodGenerator);
        } else {
            int n = constantPoolGen.addMethodref("org.apache.xalan.xsltc.dom.CurrentNodeListIterator", "<init>", "(Lorg/apache/xml/dtm/DTMAxisIterator;ZLorg/apache/xalan/xsltc/dom/CurrentNodeListFilter;ILorg/apache/xalan/xsltc/runtime/AbstractTranslet;)V");
            Predicate predicate = (Predicate)this._predicates.lastElement();
            this._predicates.remove(predicate);
            if (predicate.isNthPositionFilter()) {
                int n2 = constantPoolGen.addInterfaceMethodref("org.apache.xml.dtm.DTMAxisIterator", "setStartNode", "(I)Lorg/apache/xml/dtm/DTMAxisIterator;");
                int n3 = constantPoolGen.addInterfaceMethodref("org.apache.xml.dtm.DTMAxisIterator", "reset", "()Lorg/apache/xml/dtm/DTMAxisIterator;");
                this.translatePredicates(classGenerator, methodGenerator);
                predicate.translate(classGenerator, methodGenerator);
                instructionList.append(new INVOKEINTERFACE(n2, 2));
                instructionList.append(new INVOKEINTERFACE(n3, 1));
                int n4 = constantPoolGen.addMethodref("org.apache.xalan.xsltc.runtime.BasisLibrary", "getSingleNode", "(Lorg/apache/xml/dtm/DTMAxisIterator;)Lorg/apache/xml/dtm/DTMAxisIterator;");
                instructionList.append(new INVOKESTATIC(n4));
            } else {
                instructionList.append(new NEW(constantPoolGen.addClass("org.apache.xalan.xsltc.dom.CurrentNodeListIterator")));
                instructionList.append(InstructionConstants.DUP);
                this.translatePredicates(classGenerator, methodGenerator);
                instructionList.append(InstructionConstants.ICONST_1);
                predicate.translate(classGenerator, methodGenerator);
                instructionList.append(methodGenerator.loadCurrentNode());
                instructionList.append(classGenerator.loadTranslet());
                instructionList.append(new INVOKESPECIAL(n));
            }
        }
    }
}

