/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Text;
import org.apache.xalan.xsltc.compiler.TopLevelElement;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.XslAttribute;
import org.apache.xalan.xsltc.compiler.util.AttributeSetMethodGenerator;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;

final class AttributeSet
extends TopLevelElement {
    private static final String AttributeSetPrefix = "$as$";
    private QName _name;
    private UseAttributeSets _useSets;
    private AttributeSet _mergeSet;
    private String _method;
    private boolean _ignore = false;

    AttributeSet() {
    }

    public QName getName() {
        return this._name;
    }

    public String getMethodName() {
        return this._method;
    }

    public void ignore() {
        this._ignore = true;
    }

    public void parseContents(Parser parser2) {
        Object object;
        this._name = parser2.getQNameIgnoreDefaultNs(this.getAttribute("name"));
        if (this._name == null || this._name.equals("")) {
            object = new ErrorMsg("UNNAMED_ATTRIBSET_ERR", this);
            parser2.reportError(3, (ErrorMsg)object);
        }
        if (((String)(object = this.getAttribute("use-attribute-sets"))).length() > 0) {
            this._useSets = new UseAttributeSets((String)object, parser2);
        }
        Vector vector = this.getContents();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SyntaxTreeNode syntaxTreeNode = (SyntaxTreeNode)vector.elementAt(n2);
            if (syntaxTreeNode instanceof XslAttribute) {
                parser2.getSymbolTable().setCurrentNode(syntaxTreeNode);
                syntaxTreeNode.parseContents(parser2);
            } else if (!(syntaxTreeNode instanceof Text)) {
                ErrorMsg errorMsg = new ErrorMsg("ILLEGAL_CHILD_ERR", this);
                parser2.reportError(3, errorMsg);
            }
            ++n2;
        }
        parser2.getSymbolTable().setCurrentNode(this);
    }

    public Type typeCheck(SymbolTable symbolTable) throws TypeCheckError {
        if (this._ignore) {
            return Type.Void;
        }
        this._mergeSet = symbolTable.addAttributeSet(this);
        this._method = AttributeSetPrefix + this.getXSLTC().nextAttributeSetSerial();
        if (this._useSets != null) {
            this._useSets.typeCheck(symbolTable);
        }
        this.typeCheckContents(symbolTable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGenerator, MethodGenerator methodGenerator) {
        Object object;
        Object object2;
        Object object3;
        if (this._ignore) {
            return;
        }
        methodGenerator = new AttributeSetMethodGenerator(this._method, classGenerator);
        if (this._mergeSet != null) {
            object3 = classGenerator.getConstantPool();
            object2 = methodGenerator.getInstructionList();
            object = this._mergeSet.getMethodName();
            ((InstructionList)object2).append(classGenerator.loadTranslet());
            ((InstructionList)object2).append(methodGenerator.loadHandler());
            ((InstructionList)object2).append(methodGenerator.loadIterator());
            int n = ((ConstantPoolGen)object3).addMethodref(classGenerator.getClassName(), (String)object, "(Lorg/apache/xml/serializer/SerializationHandler;Lorg/apache/xml/dtm/DTMAxisIterator;)V");
            ((InstructionList)object2).append(new INVOKESPECIAL(n));
        }
        if (this._useSets != null) {
            this._useSets.translate(classGenerator, methodGenerator);
        }
        object3 = this.elements();
        while (object3.hasMoreElements()) {
            object2 = (SyntaxTreeNode)object3.nextElement();
            if (!(object2 instanceof XslAttribute)) continue;
            object = (XslAttribute)object2;
            ((XslAttribute)object).translate(classGenerator, methodGenerator);
        }
        object2 = methodGenerator.getInstructionList();
        ((InstructionList)object2).append(InstructionConstants.RETURN);
        methodGenerator.stripAttributes(true);
        methodGenerator.setMaxLocals();
        methodGenerator.setMaxStack();
        methodGenerator.removeNOPs();
        classGenerator.addMethod(methodGenerator.getMethod());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("attribute-set: ");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            XslAttribute xslAttribute = (XslAttribute)enumeration.nextElement();
            stringBuffer.append(xslAttribute);
        }
        return stringBuffer.toString();
    }
}

