/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.cmdline.getopt;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.xalan.xsltc.cmdline.getopt.IllegalArgumentException;
import org.apache.xalan.xsltc.cmdline.getopt.MissingOptArgException;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;

public class GetOpt {
    private Option theCurrentOption = null;
    private ListIterator theOptionsIterator;
    private List theOptions = new ArrayList();
    private List theCmdArgs = null;
    private OptionMatcher theOptionMatcher = null;

    public GetOpt(String[] stringArray, String string) {
        int n = 0;
        this.theCmdArgs = new ArrayList();
        this.theOptionMatcher = new OptionMatcher(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            String string2 = stringArray[n2];
            int n4 = string2.length();
            if (string2.equals("--")) {
                n = n2 + 1;
                break;
            }
            if (string2.startsWith("-") && n4 == 2) {
                this.theOptions.add(new Option(string2.charAt(1)));
            } else if (string2.startsWith("-") && n4 > 2) {
                n3 = 1;
                while (n3 < n4) {
                    this.theOptions.add(new Option(string2.charAt(n3)));
                    ++n3;
                }
            } else if (!string2.startsWith("-")) {
                if (this.theOptions.size() == 0) {
                    n = n2;
                    break;
                }
                n3 = 0;
                n3 = this.theOptions.size() - 1;
                Option option = (Option)this.theOptions.get(n3);
                char c = option.getArgLetter();
                if (!option.hasArg() && this.theOptionMatcher.hasArg(c)) {
                    option.setArg(string2);
                } else {
                    n = n2;
                    break;
                }
            }
            ++n2;
        }
        this.theOptionsIterator = this.theOptions.listIterator();
        int n5 = n;
        while (n5 < stringArray.length) {
            String string3 = stringArray[n5];
            this.theCmdArgs.add(string3);
            ++n5;
        }
    }

    public void printOptions() {
        ListIterator listIterator = this.theOptions.listIterator();
        while (listIterator.hasNext()) {
            Option option = (Option)listIterator.next();
            System.out.print("OPT =" + option.getArgLetter());
            String string = option.getArgument();
            if (string != null) {
                System.out.print(" " + string);
            }
            System.out.println();
        }
    }

    public int getNextOption() throws IllegalArgumentException, MissingOptArgException {
        int n = -1;
        if (this.theOptionsIterator.hasNext()) {
            this.theCurrentOption = (Option)this.theOptionsIterator.next();
            char c = this.theCurrentOption.getArgLetter();
            boolean bl = this.theOptionMatcher.hasArg(c);
            String string = this.theCurrentOption.getArgument();
            if (!this.theOptionMatcher.match(c)) {
                ErrorMsg errorMsg = new ErrorMsg("ILLEGAL_CMDLINE_OPTION_ERR", new Character(c));
                throw new IllegalArgumentException(errorMsg.toString());
            }
            if (bl && string == null) {
                ErrorMsg errorMsg = new ErrorMsg("CMDLINE_OPT_MISSING_ARG_ERR", new Character(c));
                throw new MissingOptArgException(errorMsg.toString());
            }
            n = c;
        }
        return n;
    }

    public String getOptionArg() {
        String string = null;
        String string2 = this.theCurrentOption.getArgument();
        char c = this.theCurrentOption.getArgLetter();
        if (this.theOptionMatcher.hasArg(c)) {
            string = string2;
        }
        return string;
    }

    public String[] getCmdArgs() {
        String[] stringArray = new String[this.theCmdArgs.size()];
        int n = 0;
        ListIterator listIterator = this.theCmdArgs.listIterator();
        while (listIterator.hasNext()) {
            stringArray[n++] = (String)listIterator.next();
        }
        return stringArray;
    }

    class OptionMatcher {
        private String theOptString = null;

        public OptionMatcher(String string) {
            this.theOptString = string;
        }

        public boolean match(char c) {
            boolean bl = false;
            if (this.theOptString.indexOf(c) != -1) {
                bl = true;
            }
            return bl;
        }

        public boolean hasArg(char c) {
            boolean bl = false;
            int n = this.theOptString.indexOf(c) + 1;
            if (n == this.theOptString.length()) {
                bl = false;
            } else if (this.theOptString.charAt(n) == ':') {
                bl = true;
            }
            return bl;
        }
    }

    class Option {
        private char theArgLetter;
        private String theArgument = null;

        public Option(char c) {
            this.theArgLetter = c;
        }

        public void setArg(String string) {
            this.theArgument = string;
        }

        public boolean hasArg() {
            return this.theArgument != null;
        }

        public char getArgLetter() {
            return this.theArgLetter;
        }

        public String getArgument() {
            return this.theArgument;
        }
    }
}

