/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.cmdline;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.dom.SAXImpl;
import org.apache.xalan.xsltc.dom.XSLTCDTMManager;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.Parameter;
import org.apache.xalan.xsltc.runtime.TransletLoader;
import org.apache.xalan.xsltc.runtime.output.TransletOutputHandlerFactory;
import org.apache.xml.serializer.SerializationHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class Transform {
    private SerializationHandler _handler;
    private String _fileName;
    private String _className;
    private String _jarFileSrc;
    private boolean _isJarFileSpecified = false;
    private Vector _params = null;
    private boolean _uri;
    private boolean _debug;
    private int _iterations;
    private static boolean _allowExit = true;

    public Transform(String string, String string2, boolean bl, boolean bl2, int n) {
        this._fileName = string2;
        this._className = string;
        this._uri = bl;
        this._debug = bl2;
        this._iterations = n;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getClassName() {
        return this._className;
    }

    public void setParameters(Vector vector) {
        this._params = vector;
    }

    private void setJarFileInputSrc(boolean bl, String string) {
        this._isJarFileSpecified = bl;
        this._jarFileSrc = string;
    }

    private Class loadTranslet(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            TransletLoader transletLoader = new TransletLoader();
            return transletLoader.loadTranslet(string);
        }
    }

    private void doTransform() {
        block34: {
            try {
                Object object;
                Class clazz = this.loadTranslet(this._className);
                AbstractTranslet abstractTranslet = (AbstractTranslet)clazz.newInstance();
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                try {
                    sAXParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
                }
                catch (Exception exception) {
                    sAXParserFactory.setNamespaceAware(true);
                }
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                XSLTCDTMManager xSLTCDTMManager = XSLTCDTMManager.newInstance();
                SAXImpl sAXImpl = (SAXImpl)xSLTCDTMManager.getDTM(new SAXSource(xMLReader, new InputSource(this._fileName)), false, null, true, false, abstractTranslet.hasIdCall());
                sAXImpl.setDocumentURI(this._fileName);
                abstractTranslet.prepassDocument(sAXImpl);
                int n = this._params.size();
                int n2 = 0;
                while (n2 < n) {
                    object = (Parameter)this._params.elementAt(n2);
                    abstractTranslet.addParameter(((Parameter)object)._name, ((Parameter)object)._value);
                    ++n2;
                }
                object = TransletOutputHandlerFactory.newInstance();
                ((TransletOutputHandlerFactory)object).setOutputType(0);
                ((TransletOutputHandlerFactory)object).setEncoding(abstractTranslet._encoding);
                ((TransletOutputHandlerFactory)object).setOutputMethod(abstractTranslet._method);
                if (this._iterations == -1) {
                    abstractTranslet.transform((DOM)sAXImpl, ((TransletOutputHandlerFactory)object).getSerializationHandler());
                } else if (this._iterations > 0) {
                    long l = System.currentTimeMillis();
                    int n3 = 0;
                    while (n3 < this._iterations) {
                        abstractTranslet.transform((DOM)sAXImpl, ((TransletOutputHandlerFactory)object).getSerializationHandler());
                        ++n3;
                    }
                    l = System.currentTimeMillis() - l;
                    System.err.println("\n<!--");
                    System.err.println("  transform  = " + (double)l / (double)this._iterations + " ms");
                    System.err.println("  throughput = " + 1000.0 / ((double)l / (double)this._iterations) + " tps");
                    System.err.println("-->");
                }
            }
            catch (TransletException transletException) {
                if (this._debug) {
                    transletException.printStackTrace();
                }
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + transletException.getMessage());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (RuntimeException runtimeException) {
                if (this._debug) {
                    runtimeException.printStackTrace();
                }
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + runtimeException.getMessage());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this._debug) {
                    fileNotFoundException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("FILE_NOT_FOUND_ERR", this._fileName);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (this._debug) {
                    malformedURLException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("INVALID_URI_ERR", this._fileName);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this._debug) {
                    classNotFoundException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("CLASS_NOT_FOUND_ERR", this._className);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (this._debug) {
                    unknownHostException.printStackTrace();
                }
                ErrorMsg errorMsg = new ErrorMsg("INVALID_URI_ERR", this._fileName);
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + errorMsg.toString());
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (this._debug) {
                    if (exception != null) {
                        exception.printStackTrace();
                    }
                    sAXException.printStackTrace();
                }
                System.err.print(new ErrorMsg("RUNTIME_ERROR_KEY"));
                if (exception != null) {
                    System.err.println(exception.getMessage());
                } else {
                    System.err.println(sAXException.getMessage());
                }
                if (_allowExit) {
                    System.exit(-1);
                }
            }
            catch (Exception exception) {
                if (this._debug) {
                    exception.printStackTrace();
                }
                System.err.println(new ErrorMsg("RUNTIME_ERROR_KEY") + exception.getMessage());
                if (!_allowExit) break block34;
                System.exit(-1);
            }
        }
    }

    public static void printUsage() {
        System.err.println(new ErrorMsg("TRANSFORM_USAGE_STR"));
        if (_allowExit) {
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                int n = -1;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                String string = null;
                int n2 = 0;
                while (n2 < stringArray.length && stringArray[n2].charAt(0) == '-') {
                    if (stringArray[n2].equals("-u")) {
                        bl = true;
                    } else if (stringArray[n2].equals("-x")) {
                        bl2 = true;
                    } else if (stringArray[n2].equals("-s")) {
                        _allowExit = false;
                    } else if (stringArray[n2].equals("-j")) {
                        bl3 = true;
                        string = stringArray[++n2];
                    } else if (stringArray[n2].equals("-n")) {
                        try {
                            n = Integer.parseInt(stringArray[++n2]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        Transform.printUsage();
                    }
                    ++n2;
                }
                if (stringArray.length - n2 < 2) {
                    Transform.printUsage();
                }
                Transform transform = new Transform(stringArray[n2 + 1], stringArray[n2], bl, bl2, n);
                transform.setJarFileInputSrc(bl3, string);
                Vector<Parameter> vector = new Vector<Parameter>();
                n2 += 2;
                while (n2 < stringArray.length) {
                    int n3 = stringArray[n2].indexOf(61);
                    if (n3 > 0) {
                        String string2 = stringArray[n2].substring(0, n3);
                        String string3 = stringArray[n2].substring(n3 + 1);
                        vector.addElement(new Parameter(string2, string3));
                    } else {
                        Transform.printUsage();
                    }
                    ++n2;
                }
                if (n2 == stringArray.length) {
                    transform.setParameters(vector);
                    transform.doTransform();
                    if (_allowExit) {
                        System.exit(0);
                    }
                }
            } else {
                Transform.printUsage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

