/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerIdentityImpl
extends Transformer
implements TransformerHandler,
DeclHandler {
    boolean m_flushedStartDoc = false;
    private FileOutputStream m_outputStream = null;
    private ContentHandler m_resultContentHandler;
    private LexicalHandler m_resultLexicalHandler;
    private DTDHandler m_resultDTDHandler;
    private DeclHandler m_resultDeclHandler;
    private Serializer m_serializer;
    private Result m_result;
    private String m_systemID;
    private Hashtable m_params;
    private ErrorListener m_errorListener = new DefaultErrorHandler();
    URIResolver m_URIResolver;
    private OutputProperties m_outputFormat = new OutputProperties("xml");
    boolean m_foundFirstElement;

    public void setResult(Result result) throws IllegalArgumentException {
        if (null == result) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_RESULT_NULL", null));
        }
        this.m_result = result;
    }

    public void setSystemId(String string) {
        this.m_systemID = string;
    }

    public String getSystemId() {
        return this.m_systemID;
    }

    public Transformer getTransformer() {
        return this;
    }

    private void createResultContentHandler(Result result) throws TransformerException {
        if (result instanceof SAXResult) {
            SAXResult sAXResult = (SAXResult)result;
            this.m_resultContentHandler = sAXResult.getHandler();
            this.m_resultLexicalHandler = sAXResult.getLexicalHandler();
            if (this.m_resultContentHandler instanceof Serializer) {
                this.m_serializer = (Serializer)((Object)this.m_resultContentHandler);
            }
        } else if (result instanceof DOMResult) {
            Document document;
            short s;
            DOMResult dOMResult = (DOMResult)result;
            Node node = dOMResult.getNode();
            if (null != node) {
                s = node.getNodeType();
                document = 9 == s ? (Document)node : node.getOwnerDocument();
            } else {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    document = documentBuilder.newDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new TransformerException(parserConfigurationException);
                }
                node = document;
                s = node.getNodeType();
                ((DOMResult)result).setNode(node);
            }
            this.m_resultContentHandler = 11 == s ? new DOMBuilder(document, (DocumentFragment)node) : new DOMBuilder(document, node);
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        } else if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            String string = this.m_outputFormat.getProperty("method");
            try {
                Serializer serializer;
                this.m_serializer = serializer = SerializerFactory.getSerializer(this.m_outputFormat.getProperties());
                if (null != streamResult.getWriter()) {
                    serializer.setWriter(streamResult.getWriter());
                } else if (null != streamResult.getOutputStream()) {
                    serializer.setOutputStream(streamResult.getOutputStream());
                } else if (null != streamResult.getSystemId()) {
                    String string2 = streamResult.getSystemId();
                    if (string2.startsWith("file:///")) {
                        string2 = string2.substring(8).indexOf(":") > 0 ? string2.substring(8) : string2.substring(7);
                    }
                    this.m_outputStream = new FileOutputStream(string2);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage("ER_NO_OUTPUT_SPECIFIED", null));
                }
                this.m_resultContentHandler = serializer.asContentHandler();
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_TO_RESULT_TYPE", new Object[]{result.getClass().getName()}));
        }
        if (this.m_resultContentHandler instanceof DTDHandler) {
            this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof DeclHandler) {
            this.m_resultDeclHandler = (DeclHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof LexicalHandler) {
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source var1_1, Result var2_2) throws TransformerException {
        block47: {
            block44: {
                block46: {
                    block43: {
                        this.createResultContentHandler(var2_2);
                        try {
                            if (var1_1 instanceof DOMSource) {
                                block42: {
                                    var3_3 = (DOMSource)var1_1;
                                    this.m_systemID = var3_3.getSystemId();
                                    var4_5 = var3_3.getNode();
                                    if (null == var4_5) {
                                        var5_11 = XSLMessages.createMessage("ER_ILLEGAL_DOMSOURCE_INPUT", null);
                                        throw new IllegalArgumentException(var5_11);
                                    }
                                    try {
                                        if (var4_5.getNodeType() != 9) {
                                            this.startDocument();
                                        }
                                        try {
                                            if (var4_5.getNodeType() == 2) {
                                                var5_8 = var4_5.getNodeValue();
                                                var6_17 = var5_8.toCharArray();
                                                this.characters(var6_17, 0, var6_17.length);
                                            } else {
                                                var5_9 = new TreeWalker(this, new DOM2Helper(), this.m_systemID);
                                                var5_9.traverse(var4_5);
                                            }
                                            var8_23 = null;
                                            if (var4_5.getNodeType() == 9) break block42;
                                        }
                                        catch (Throwable var7_26) {
                                            var8_24 = null;
                                            if (var4_5.getNodeType() == 9) throw var7_26;
                                            this.endDocument();
                                            throw var7_26;
                                        }
                                        this.endDocument();
                                    }
                                    catch (SAXException var5_10) {
                                        throw new TransformerException(var5_10);
                                    }
                                }
                                var10_28 = null;
                                if (null == this.m_outputStream) return;
                                break block43;
                            }
                            var3_4 = SAXSource.sourceToInputSource(var1_1);
                            if (null == var3_4) {
                                throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_TRANSFORM_SOURCE_TYPE", new Object[]{var1_1.getClass().getName()}));
                            }
                            if (null != var3_4.getSystemId()) {
                                this.m_systemID = var3_4.getSystemId();
                            }
                            try {
                                var4_6 = null;
                                if (var1_1 instanceof SAXSource) {
                                    var4_6 = ((SAXSource)var1_1).getXMLReader();
                                }
                                if (null == var4_6) {
                                    try {
                                        var5_12 = SAXParserFactory.newInstance();
                                        var5_12.setNamespaceAware(true);
                                        var6_18 = var5_12.newSAXParser();
                                        var4_6 = var6_18.getXMLReader();
                                    }
                                    catch (ParserConfigurationException var5_13) {
                                        throw new SAXException(var5_13);
                                    }
                                    catch (FactoryConfigurationError var6_19) {
                                        throw new SAXException(var6_19.toString());
                                    }
                                    catch (NoSuchMethodError var7_27) {
                                    }
                                    catch (AbstractMethodError var8_25) {
                                        // empty catch block
                                    }
                                }
                                if (null == var4_6) {
                                    var4_6 = XMLReaderFactory.createXMLReader();
                                }
                                try {
                                    var4_6.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                                }
                                catch (SAXException var5_14) {
                                    // empty catch block
                                }
                                var5_12 = this;
                                var4_6.setContentHandler((ContentHandler)var5_12);
                                if (var5_12 instanceof DTDHandler) {
                                    var4_6.setDTDHandler((DTDHandler)var5_12);
                                }
                                try {
                                    if (var5_12 instanceof LexicalHandler) {
                                        var4_6.setProperty("http://xml.org/sax/properties/lexical-handler", var5_12);
                                    }
                                    if (var5_12 instanceof DeclHandler) {
                                        var4_6.setProperty("http://xml.org/sax/properties/declaration-handler", var5_12);
                                    }
                                }
                                catch (SAXException var6_20) {
                                    // empty catch block
                                }
                                try {
                                    if (var5_12 instanceof LexicalHandler) {
                                        var4_6.setProperty("http://xml.org/sax/handlers/LexicalHandler", var5_12);
                                    }
                                    if (var5_12 instanceof DeclHandler) {
                                        var4_6.setProperty("http://xml.org/sax/handlers/DeclHandler", var5_12);
                                    }
                                }
                                catch (SAXNotRecognizedException var6_21) {
                                    // empty catch block
                                }
                                var4_6.parse(var3_4);
                                break block44;
                            }
                            catch (WrappedRuntimeException var4_7) {
                                var5_15 = var4_7.getException();
                            }
                            while (true) {
                                if (!(var5_15 instanceof WrappedRuntimeException)) {
                                    throw new TransformerException(var4_7.getException());
                                }
                                var5_15 = ((WrappedRuntimeException)var5_15).getException();
                            }
                            catch (SAXException var5_16) {
                                throw new TransformerException(var5_16);
                            }
                            catch (IOException var6_22) {
                                throw new TransformerException(var6_22);
                            }
                        }
                        catch (Throwable var9_34) {
                            var10_30 = null;
                            if (null == this.m_outputStream) throw var9_34;
                            try {
                                this.m_outputStream.close();
                            }
                            catch (IOException var11_33) {
                                // empty catch block
                            }
                            this.m_outputStream = null;
                            throw var9_34;
                        }
                    }
                    ** try [egrp 8[TRYBLOCK] [13 : 578->588)] { 
lbl117:
                    // 1 sources

                    this.m_outputStream.close();
                    break block46;
lbl119:
                    // 1 sources

                    catch (IOException var11_31) {
                        // empty catch block
                    }
                }
                this.m_outputStream = null;
                return;
            }
            var10_29 = null;
            if (null == this.m_outputStream) return;
            ** try [egrp 8[TRYBLOCK] [13 : 578->588)] { 
lbl128:
            // 1 sources

            this.m_outputStream.close();
            break block47;
lbl130:
            // 1 sources

            catch (IOException var11_32) {
                // empty catch block
            }
        }
        this.m_outputStream = null;
    }

    public void setParameter(String string, Object object) {
        if (null == this.m_params) {
            this.m_params = new Hashtable();
        }
        this.m_params.put(string, object);
    }

    public Object getParameter(String string) {
        if (null == this.m_params) {
            return null;
        }
        return this.m_params.get(string);
    }

    public void clearParameters() {
        if (null == this.m_params) {
            return;
        }
        this.m_params.clear();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_URIResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.m_URIResolver;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (null != properties) {
            String string = (String)((Hashtable)properties).get("method");
            this.m_outputFormat = null != string ? new OutputProperties(string) : new OutputProperties();
        }
        if (null != properties) {
            this.m_outputFormat.copyFrom(properties);
        }
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.m_outputFormat.getProperties()).clone();
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        if (!OutputProperties.isLegalPropertyKey(string)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
        }
        this.m_outputFormat.setProperty(string, string2);
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        String string2 = null;
        OutputProperties outputProperties = this.m_outputFormat;
        string2 = outputProperties.getProperty(string);
        if (null == string2 && !OutputProperties.isLegalPropertyKey(string)) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_OUTPUT_PROPERTY_NOT_RECOGNIZED", new Object[]{string}));
        }
        return string2;
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        if (errorListener == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NULL_ERROR_HANDLER", null));
        }
        this.m_errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (null != this.m_resultDTDHandler) {
            this.m_resultDTDHandler.notationDecl(string, string2, string3);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (null != this.m_resultDTDHandler) {
            this.m_resultDTDHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (null == this.m_resultContentHandler) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
        this.m_resultContentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        try {
            if (null == this.m_resultContentHandler) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException.getMessage(), transformerException);
        }
        this.m_flushedStartDoc = false;
        this.m_foundFirstElement = false;
    }

    protected final void flushStartDoc() throws SAXException {
        if (!this.m_flushedStartDoc) {
            if (this.m_resultContentHandler == null) {
                try {
                    this.createResultContentHandler(this.m_result);
                }
                catch (TransformerException transformerException) {
                    throw new SAXException(transformerException);
                }
            }
            this.m_resultContentHandler.startDocument();
            this.m_flushedStartDoc = true;
        }
    }

    public void endDocument() throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endDocument();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endPrefixMapping(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.m_foundFirstElement && null != this.m_serializer) {
            Serializer serializer;
            this.m_foundFirstElement = true;
            try {
                serializer = SerializerSwitcher.switchSerializerIfHTML(string, string2, this.m_outputFormat.getProperties(), this.m_serializer);
            }
            catch (TransformerException transformerException) {
                throw new SAXException(transformerException);
            }
            if (serializer != this.m_serializer) {
                try {
                    this.m_resultContentHandler = serializer.asContentHandler();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
                if (this.m_resultContentHandler instanceof DTDHandler) {
                    this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
                }
                if (this.m_resultContentHandler instanceof LexicalHandler) {
                    this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
                }
                this.m_serializer = serializer;
            }
        }
        this.flushStartDoc();
        this.m_resultContentHandler.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_resultContentHandler.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.characters(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.m_resultContentHandler.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.processingInstruction(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.skippedEntity(string);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushStartDoc();
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startDTD(string, string2, string3);
        }
    }

    public void endDTD() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endDTD();
        }
    }

    public void startEntity(String string) throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startEntity(string);
        }
    }

    public void endEntity(String string) throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endEntity(string);
        }
    }

    public void startCDATA() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.endCDATA();
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushStartDoc();
        if (null != this.m_resultLexicalHandler) {
            this.m_resultLexicalHandler.comment(cArray, n, n2);
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.elementDecl(string, string2);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.attributeDecl(string, string2, string3, string4, string5);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.internalEntityDecl(string, string2);
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (null != this.m_resultDeclHandler) {
            this.m_resultDeclHandler.externalEntityDecl(string, string2, string3);
        }
    }
}

