/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.ObjectStack;

public class StackGuard {
    public static int m_recursionLimit = -1;
    TransformerImpl m_transformer;

    public int getRecursionLimit() {
        return m_recursionLimit;
    }

    public void setRecursionLimit(int n) {
        m_recursionLimit = n;
    }

    public StackGuard(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
    }

    public int countLikeTemplates(ElemTemplate elemTemplate, int n) {
        ObjectStack objectStack = this.m_transformer.getCurrentTemplateElements();
        int n2 = 1;
        int n3 = n - 1;
        while (n3 >= 0) {
            if ((ElemTemplateElement)objectStack.elementAt(n3) == elemTemplate) {
                ++n2;
            }
            --n3;
        }
        return n2;
    }

    private ElemTemplate getNextMatchOrNamedTemplate(int n) {
        ObjectStack objectStack = this.m_transformer.getCurrentTemplateElements();
        int n2 = n;
        while (n2 >= 0) {
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)objectStack.elementAt(n2);
            if (null != elemTemplateElement && elemTemplateElement.getXSLToken() == 19) {
                return (ElemTemplate)elemTemplateElement;
            }
            --n2;
        }
        return null;
    }

    public void checkForInfinateLoop() throws TransformerException {
        int n = this.m_transformer.getCurrentTemplateElementsCount();
        if (n < m_recursionLimit) {
            return;
        }
        if (m_recursionLimit <= 0) {
            return;
        }
        int n2 = n - 1;
        while (n2 >= m_recursionLimit) {
            ElemTemplate elemTemplate = this.getNextMatchOrNamedTemplate(n2);
            if (null == elemTemplate) break;
            int n3 = this.countLikeTemplates(elemTemplate, n2);
            if (n3 >= m_recursionLimit) {
                String string = XSLMessages.createMessage(null != elemTemplate.getName() ? "nameIs" : "matchPatternIs", null);
                Object[] objectArray = new Object[]{new Integer(n3), string, null != elemTemplate.getName() ? elemTemplate.getName().toString() : elemTemplate.getMatch().getPatternString()};
                String string2 = XSLMessages.createMessage("recursionTooDeep", objectArray);
                throw new TransformerException(string2);
            }
            --n2;
        }
    }
}

