/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.transformer.KeyIterator;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class KeyTable {
    private int m_docKey;
    private Vector m_keyDeclarations;
    private Hashtable m_refsTable = null;
    private XNodeSet m_keyNodes;

    public int getDocKey() {
        return this.m_docKey;
    }

    KeyIterator getKeyIterator() {
        return (KeyIterator)this.m_keyNodes.getContainedIter();
    }

    public KeyTable(int n, PrefixResolver prefixResolver, QName qName, Vector vector, XPathContext xPathContext) throws TransformerException {
        this.m_docKey = n;
        this.m_keyDeclarations = vector;
        KeyIterator keyIterator = new KeyIterator(qName, vector);
        this.m_keyNodes = new XNodeSet(keyIterator);
        this.m_keyNodes.allowDetachToRelease(false);
        this.m_keyNodes.setRoot(n, xPathContext);
    }

    public XNodeSet getNodeSetDTMByKey(QName qName, XMLString xMLString) {
        XNodeSet xNodeSet = (XNodeSet)this.getRefsTable().get(xMLString);
        try {
            if (xNodeSet != null) {
                xNodeSet = (XNodeSet)xNodeSet.cloneWithReset();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            xNodeSet = null;
        }
        if (xNodeSet == null) {
            KeyIterator keyIterator = (KeyIterator)this.m_keyNodes.getContainedIter();
            XPathContext xPathContext = keyIterator.getXPathContext();
            xNodeSet = new XNodeSet(xPathContext.getDTMManager()){

                public void setRoot(int n, Object object) {
                }
            };
            xNodeSet.reset();
        }
        return xNodeSet;
    }

    public QName getKeyTableName() {
        return this.getKeyIterator().getName();
    }

    private KeyDeclaration getKeyDeclaration() {
        int n = this.m_keyDeclarations.size();
        int n2 = 0;
        while (n2 < n) {
            KeyDeclaration keyDeclaration = (KeyDeclaration)this.m_keyDeclarations.elementAt(n2);
            if (keyDeclaration.getName().equals(this.getKeyTableName())) {
                return keyDeclaration;
            }
            ++n2;
        }
        return null;
    }

    private Hashtable getRefsTable() {
        if (this.m_refsTable == null) {
            int n;
            this.m_refsTable = new Hashtable(89);
            KeyIterator keyIterator = (KeyIterator)this.m_keyNodes.getContainedIter();
            XPathContext xPathContext = keyIterator.getXPathContext();
            KeyDeclaration keyDeclaration = this.getKeyDeclaration();
            this.m_keyNodes.reset();
            while (-1 != (n = this.m_keyNodes.nextNode())) {
                try {
                    int n2;
                    Object object;
                    XObject xObject = keyDeclaration.getUse().execute(xPathContext, n, keyIterator.getPrefixResolver());
                    if (xObject.getType() != 4) {
                        object = xObject.xstr();
                        this.addValueInRefsTable(xPathContext, (XMLString)object, n);
                        continue;
                    }
                    object = ((XNodeSet)xObject).iterRaw();
                    while (-1 != (n2 = object.nextNode())) {
                        DTM dTM = xPathContext.getDTM(n2);
                        XMLString xMLString = dTM.getStringValue(n2);
                        this.addValueInRefsTable(xPathContext, xMLString, n);
                    }
                }
                catch (TransformerException transformerException) {
                    throw new WrappedRuntimeException(transformerException);
                }
            }
        }
        return this.m_refsTable;
    }

    private void addValueInRefsTable(XPathContext xPathContext, XMLString xMLString, int n) {
        XNodeSet xNodeSet = (XNodeSet)this.m_refsTable.get(xMLString);
        if (xNodeSet == null) {
            xNodeSet = new XNodeSet(n, xPathContext.getDTMManager());
            xNodeSet.nextNode();
            this.m_refsTable.put(xMLString, xNodeSet);
        } else if (xNodeSet.getCurrentNode() != n) {
            xNodeSet.mutableNodeset().addNode(n);
            xNodeSet.nextNode();
        }
    }
}

