/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExtensionNamespacesManager;
import org.apache.xalan.processor.XSLTSchema;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.DecimalFormatProperties;
import org.apache.xalan.templates.ElemApplyTemplates;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.TemplateList;
import org.apache.xalan.templates.WhiteSpaceInfo;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.IntStack;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;

public class StylesheetRoot
extends StylesheetComposed
implements Serializable,
Templates {
    private Hashtable m_availElems;
    private ExtensionNamespacesManager m_extNsMgr = null;
    private StylesheetComposed[] m_globalImportList;
    private OutputProperties m_outputProperties;
    private boolean m_outputMethodSet = false;
    private Hashtable m_attrSets;
    private Hashtable m_decimalFormatSymbols;
    private Vector m_keyDecls;
    private Hashtable m_namespaceAliasComposed;
    private TemplateList m_templateList;
    private Vector m_variables;
    private TemplateList m_whiteSpaceInfoList;
    private ElemTemplate m_defaultTextRule;
    private ElemTemplate m_defaultRule;
    private ElemTemplate m_defaultRootRule;
    private ElemTemplate m_startRule;
    XPath m_selectDefault;
    private ComposeState m_composeState;

    public StylesheetRoot(ErrorListener errorListener) throws TransformerConfigurationException {
        super(null);
        this.setStylesheetRoot(this);
        try {
            this.m_selectDefault = new XPath("node()", this, this, 0, errorListener);
            this.initDefaultRule(errorListener);
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(XSLMessages.createMessage("ER_CANNOT_INIT_DEFAULT_TEMPLATES", null), transformerException);
        }
    }

    public StylesheetRoot(XSLTSchema xSLTSchema, ErrorListener errorListener) throws TransformerConfigurationException {
        this(errorListener);
        this.m_availElems = xSLTSchema.getElemsAvailable();
    }

    public boolean isRoot() {
        return true;
    }

    public Hashtable getAvailableElements() {
        return this.m_availElems;
    }

    public ExtensionNamespacesManager getExtensionNamespacesManager() {
        if (this.m_extNsMgr == null) {
            this.m_extNsMgr = new ExtensionNamespacesManager();
        }
        return this.m_extNsMgr;
    }

    public Vector getExtensions() {
        return this.m_extNsMgr != null ? this.m_extNsMgr.getExtensions() : null;
    }

    public Transformer newTransformer() {
        return new TransformerImpl(this);
    }

    public Properties getDefaultOutputProps() {
        return this.m_outputProperties.getProperties();
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.getDefaultOutputProps()).clone();
    }

    public void recompose() throws TransformerException {
        int n;
        Vector vector = new Vector();
        if (null == this.m_globalImportList) {
            Vector vector2 = new Vector();
            this.addImports(this, true, vector2);
            this.m_globalImportList = new StylesheetComposed[vector2.size()];
            n = 0;
            int n2 = vector2.size() - 1;
            while (n < vector2.size()) {
                this.m_globalImportList[n2] = (StylesheetComposed)vector2.elementAt(n);
                this.m_globalImportList[n2].recomposeIncludes(this.m_globalImportList[n2]);
                this.m_globalImportList[n2--].recomposeImports();
                ++n;
            }
        }
        int n3 = this.getGlobalImportCount();
        n = 0;
        while (n < n3) {
            StylesheetComposed stylesheetComposed = this.getGlobalImport(n);
            stylesheetComposed.recompose(vector);
            ++n;
        }
        this.QuickSort2(vector, 0, vector.size() - 1);
        this.m_outputProperties = new OutputProperties("");
        this.m_attrSets = new Hashtable();
        this.m_decimalFormatSymbols = new Hashtable();
        this.m_keyDecls = new Vector();
        this.m_namespaceAliasComposed = new Hashtable();
        this.m_templateList = new TemplateList();
        this.m_variables = new Vector();
        int n4 = vector.size() - 1;
        while (n4 >= 0) {
            ((ElemTemplateElement)vector.elementAt(n4)).recompose(this);
            --n4;
        }
        this.initComposeState();
        this.m_templateList.compose(this);
        this.m_outputProperties.compose(this);
        this.m_outputProperties.endCompose(this);
        n3 = this.getGlobalImportCount();
        int n5 = 0;
        while (n5 < n3) {
            StylesheetComposed stylesheetComposed = this.getGlobalImport(n5);
            int n6 = stylesheetComposed.getIncludeCountComposed();
            int n7 = -1;
            while (n7 < n6) {
                Stylesheet stylesheet = stylesheetComposed.getIncludeComposed(n7);
                this.composeTemplates(stylesheet);
                ++n7;
            }
            ++n5;
        }
        if (this.m_extNsMgr != null) {
            this.m_extNsMgr.registerUnregisteredNamespaces();
        }
        this.clearComposeState();
    }

    void composeTemplates(ElemTemplateElement elemTemplateElement) throws TransformerException {
        elemTemplateElement.compose(this);
        ElemTemplateElement elemTemplateElement2 = elemTemplateElement.getFirstChildElem();
        while (elemTemplateElement2 != null) {
            this.composeTemplates(elemTemplateElement2);
            elemTemplateElement2 = elemTemplateElement2.getNextSiblingElem();
        }
        elemTemplateElement.endCompose(this);
    }

    protected void addImports(Stylesheet stylesheet, boolean bl, Vector vector) {
        Stylesheet stylesheet2;
        int n;
        int n2 = stylesheet.getImportCount();
        if (n2 > 0) {
            n = 0;
            while (n < n2) {
                stylesheet2 = stylesheet.getImport(n);
                this.addImports(stylesheet2, true, vector);
                ++n;
            }
        }
        if ((n2 = stylesheet.getIncludeCount()) > 0) {
            n = 0;
            while (n < n2) {
                stylesheet2 = stylesheet.getInclude(n);
                this.addImports(stylesheet2, false, vector);
                ++n;
            }
        }
        if (bl) {
            vector.addElement(stylesheet);
        }
    }

    public StylesheetComposed getGlobalImport(int n) {
        return this.m_globalImportList[n];
    }

    public int getGlobalImportCount() {
        return this.m_globalImportList != null ? this.m_globalImportList.length : 1;
    }

    public int getImportNumber(StylesheetComposed stylesheetComposed) {
        if (this == stylesheetComposed) {
            return 0;
        }
        int n = this.getGlobalImportCount();
        int n2 = 0;
        while (n2 < n) {
            if (stylesheetComposed == this.getGlobalImport(n2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    void recomposeOutput(OutputProperties outputProperties) throws TransformerException {
        this.m_outputProperties.copyFrom(outputProperties);
    }

    public OutputProperties getOutputComposed() {
        return this.m_outputProperties;
    }

    public boolean isOutputMethodSet() {
        return this.m_outputMethodSet;
    }

    void recomposeAttributeSets(ElemAttributeSet elemAttributeSet) {
        Vector<ElemAttributeSet> vector = (Vector<ElemAttributeSet>)this.m_attrSets.get(elemAttributeSet.getName());
        if (null == vector) {
            vector = new Vector<ElemAttributeSet>();
            this.m_attrSets.put(elemAttributeSet.getName(), vector);
        }
        vector.addElement(elemAttributeSet);
    }

    public Vector getAttributeSetComposed(QName qName) throws ArrayIndexOutOfBoundsException {
        return (Vector)this.m_attrSets.get(qName);
    }

    void recomposeDecimalFormats(DecimalFormatProperties decimalFormatProperties) {
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(decimalFormatProperties.getName());
        if (null == decimalFormatSymbols) {
            this.m_decimalFormatSymbols.put(decimalFormatProperties.getName(), decimalFormatProperties.getDecimalFormatSymbols());
        } else if (!decimalFormatProperties.getDecimalFormatSymbols().equals(decimalFormatSymbols)) {
            String string = decimalFormatProperties.getName().equals(new QName("")) ? XSLMessages.createWarning("WG_ONE_DEFAULT_XSLDECIMALFORMAT_ALLOWED", new Object[0]) : XSLMessages.createWarning("WG_XSLDECIMALFORMAT_NAMES_MUST_BE_UNIQUE", new Object[]{decimalFormatProperties.getName()});
            this.error(string);
        }
    }

    public DecimalFormatSymbols getDecimalFormatComposed(QName qName) {
        return (DecimalFormatSymbols)this.m_decimalFormatSymbols.get(qName);
    }

    void recomposeKeys(KeyDeclaration keyDeclaration) {
        this.m_keyDecls.addElement(keyDeclaration);
    }

    public Vector getKeysComposed() {
        return this.m_keyDecls;
    }

    void recomposeNamespaceAliases(NamespaceAlias namespaceAlias) {
        this.m_namespaceAliasComposed.put(namespaceAlias.getStylesheetNamespace(), namespaceAlias);
    }

    public NamespaceAlias getNamespaceAliasComposed(String string) {
        return null == this.m_namespaceAliasComposed ? null : this.m_namespaceAliasComposed.get(string);
    }

    void recomposeTemplates(ElemTemplate elemTemplate) {
        this.m_templateList.setTemplate(elemTemplate);
    }

    public final TemplateList getTemplateListComposed() {
        return this.m_templateList;
    }

    public final void setTemplateListComposed(TemplateList templateList) {
        this.m_templateList = templateList;
    }

    public ElemTemplate getTemplateComposed(XPathContext xPathContext, int n, QName qName, boolean bl, DTM dTM) throws TransformerException {
        return this.m_templateList.getTemplate(xPathContext, n, qName, bl, dTM);
    }

    public ElemTemplate getTemplateComposed(XPathContext xPathContext, int n, QName qName, int n2, int n3, boolean bl, DTM dTM) throws TransformerException {
        return this.m_templateList.getTemplate(xPathContext, n, qName, n2, n3, bl, dTM);
    }

    public ElemTemplate getTemplateComposed(QName qName) {
        return this.m_templateList.getTemplate(qName);
    }

    void recomposeVariables(ElemVariable elemVariable) {
        if (this.getVariableOrParamComposed(elemVariable.getName()) == null) {
            elemVariable.setIsTopLevel(true);
            elemVariable.setIndex(this.m_variables.size());
            this.m_variables.addElement(elemVariable);
        }
    }

    public ElemVariable getVariableOrParamComposed(QName qName) {
        if (null != this.m_variables) {
            int n = this.m_variables.size();
            int n2 = 0;
            while (n2 < n) {
                ElemVariable elemVariable = (ElemVariable)this.m_variables.elementAt(n2);
                if (elemVariable.getName().equals(qName)) {
                    return elemVariable;
                }
                ++n2;
            }
        }
        return null;
    }

    public Vector getVariablesAndParamsComposed() {
        return this.m_variables;
    }

    void recomposeWhiteSpaceInfo(WhiteSpaceInfo whiteSpaceInfo) {
        if (null == this.m_whiteSpaceInfoList) {
            this.m_whiteSpaceInfoList = new TemplateList();
        }
        this.m_whiteSpaceInfoList.setTemplate(whiteSpaceInfo);
    }

    public boolean shouldCheckWhitespace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public WhiteSpaceInfo getWhiteSpaceInfo(XPathContext xPathContext, int n, DTM dTM) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            return (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(xPathContext, n, null, false, dTM);
        }
        return null;
    }

    public boolean shouldStripWhiteSpace(XPathContext xPathContext, int n) throws TransformerException {
        if (null != this.m_whiteSpaceInfoList) {
            while (-1 != n) {
                DTM dTM = xPathContext.getDTM(n);
                WhiteSpaceInfo whiteSpaceInfo = (WhiteSpaceInfo)this.m_whiteSpaceInfoList.getTemplate(xPathContext, n, null, false, dTM);
                if (null != whiteSpaceInfo) {
                    return whiteSpaceInfo.getShouldStripSpace();
                }
                int n2 = dTM.getParent(n);
                n = -1 != n2 && 1 == dTM.getNodeType(n2) ? n2 : -1;
            }
        }
        return false;
    }

    public boolean canStripWhiteSpace() {
        return null != this.m_whiteSpaceInfoList;
    }

    public final ElemTemplate getDefaultTextRule() {
        return this.m_defaultTextRule;
    }

    public final ElemTemplate getDefaultRule() {
        return this.m_defaultRule;
    }

    public final ElemTemplate getDefaultRootRule() {
        return this.m_defaultRootRule;
    }

    public final ElemTemplate getStartRule() {
        return this.m_startRule;
    }

    private void initDefaultRule(ErrorListener errorListener) throws TransformerException {
        this.m_defaultRule = new ElemTemplate();
        this.m_defaultRule.setStylesheet(this);
        XPath xPath = new XPath("*", this, this, 1, errorListener);
        this.m_defaultRule.setMatch(xPath);
        ElemApplyTemplates elemApplyTemplates = new ElemApplyTemplates();
        elemApplyTemplates.setIsDefaultTemplate(true);
        elemApplyTemplates.setSelect(this.m_selectDefault);
        this.m_defaultRule.appendChild(elemApplyTemplates);
        this.m_startRule = this.m_defaultRule;
        this.m_defaultTextRule = new ElemTemplate();
        this.m_defaultTextRule.setStylesheet(this);
        xPath = new XPath("text() | @*", this, this, 1, errorListener);
        this.m_defaultTextRule.setMatch(xPath);
        ElemValueOf elemValueOf = new ElemValueOf();
        this.m_defaultTextRule.appendChild(elemValueOf);
        XPath xPath2 = new XPath(".", this, this, 0, errorListener);
        elemValueOf.setSelect(xPath2);
        this.m_defaultRootRule = new ElemTemplate();
        this.m_defaultRootRule.setStylesheet(this);
        xPath = new XPath("/", this, this, 1, errorListener);
        this.m_defaultRootRule.setMatch(xPath);
        elemApplyTemplates = new ElemApplyTemplates();
        elemApplyTemplates.setIsDefaultTemplate(true);
        this.m_defaultRootRule.appendChild(elemApplyTemplates);
        elemApplyTemplates.setSelect(this.m_selectDefault);
    }

    /*
     * Unable to fully structure code
     */
    private void QuickSort2(Vector var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = (ElemTemplateElement)var1_1.elementAt((var2_2 + var3_3) / 2);
            ** GOTO lbl18
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && ((ElemTemplateElement)var1_1.elementAt(var4_4)).compareTo(var6_6) < 0) continue block0;
                    while (var5_5 > var2_2 && ((ElemTemplateElement)var1_1.elementAt(var5_5)).compareTo(var6_6) > 0) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    var7_7 = (ElemTemplateElement)var1_1.elementAt(var4_4);
                    var1_1.setElementAt(var1_1.elementAt(var5_5), var4_4);
                    var1_1.setElementAt(var7_7, var5_5);
                    ++var4_4;
                    --var5_5;
lbl18:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.QuickSort2(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.QuickSort2(var1_1, var4_4, var3_3);
            }
        }
    }

    void initComposeState() {
        this.m_composeState = new ComposeState();
    }

    ComposeState getComposeState() {
        return this.m_composeState;
    }

    private void clearComposeState() {
        this.m_composeState = null;
    }

    class ComposeState {
        private ExpandedNameTable m_ent = new ExpandedNameTable();
        private Vector m_variableNames = new Vector();
        IntStack m_marks = new IntStack();
        private int m_maxStackFrameSize;

        ComposeState() {
            int n = StylesheetRoot.this.m_variables.size();
            int n2 = 0;
            while (n2 < n) {
                ElemVariable elemVariable = (ElemVariable)StylesheetRoot.this.m_variables.elementAt(n2);
                this.m_variableNames.addElement(elemVariable.getName());
                ++n2;
            }
        }

        public int getQNameID(QName qName) {
            return this.m_ent.getExpandedTypeID(qName.getNamespace(), qName.getLocalName(), 1);
        }

        int addVariableName(QName qName) {
            int n = this.m_variableNames.size();
            this.m_variableNames.addElement(qName);
            int n2 = this.m_variableNames.size() - this.getGlobalsSize();
            if (n2 > this.m_maxStackFrameSize) {
                ++this.m_maxStackFrameSize;
            }
            return n;
        }

        void resetStackFrameSize() {
            this.m_maxStackFrameSize = 0;
        }

        int getFrameSize() {
            return this.m_maxStackFrameSize;
        }

        int getCurrentStackFrameSize() {
            return this.m_variableNames.size();
        }

        void setCurrentStackFrameSize(int n) {
            this.m_variableNames.setSize(n);
        }

        int getGlobalsSize() {
            return StylesheetRoot.this.m_variables.size();
        }

        void pushStackMark() {
            this.m_marks.push(this.getCurrentStackFrameSize());
        }

        void popStackMark() {
            int n = this.m_marks.pop();
            this.setCurrentStackFrameSize(n);
        }

        Vector getVariableNames() {
            return this.m_variableNames;
        }
    }
}

