/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.AbsPathChecker;
import org.apache.xalan.templates.ElemForEach;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.ElemVariablePsuedo;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.VarNameCollector;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPath;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.FilterExprIteratorSimple;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SelfIteratorNoPredicate;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.operations.Variable;
import org.apache.xpath.operations.VariableSafeAbsRef;
import org.w3c.dom.DOMException;

public class RedundentExprEliminator
extends XSLTVisitor {
    Vector m_paths = null;
    Vector m_absPaths;
    boolean m_isSameContext = true;
    AbsPathChecker m_absPathChecker = new AbsPathChecker();
    static int m_uniquePsuedoVarID = 1;
    static final String PSUEDOVARNAMESPACE = "http://xml.apache.org/xalan/psuedovar";
    public static boolean DEBUG = false;
    public static boolean DIAGNOSE_NUM_PATHS_REDUCED = false;
    public static boolean DIAGNOSE_MULTISTEPLIST = false;
    VarNameCollector m_varNameCollector = new VarNameCollector();

    public RedundentExprEliminator() {
        this.m_absPaths = new Vector();
    }

    public void eleminateRedundentLocals(ElemTemplateElement elemTemplateElement) {
        this.eleminateRedundent(elemTemplateElement, this.m_paths);
    }

    public void eleminateRedundentGlobals(StylesheetRoot stylesheetRoot) {
        this.eleminateRedundent(stylesheetRoot, this.m_absPaths);
    }

    protected void eleminateRedundent(ElemTemplateElement elemTemplateElement, Vector vector) {
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            ExpressionOwner expressionOwner = (ExpressionOwner)vector.elementAt(n4);
            if (null != expressionOwner) {
                int n5 = this.findAndEliminateRedundant(n4 + 1, n4, expressionOwner, elemTemplateElement, vector);
                if (n5 > 0) {
                    ++n3;
                }
                n2 += n5;
            }
            ++n4;
        }
        this.eleminateSharedPartialPaths(elemTemplateElement, vector);
        if (DIAGNOSE_NUM_PATHS_REDUCED) {
            this.diagnoseNumPaths(vector, n2, n3);
        }
    }

    protected void eleminateSharedPartialPaths(ElemTemplateElement elemTemplateElement, Vector vector) {
        MultistepExprHolder multistepExprHolder = this.createMultistepExprList(vector);
        if (null != multistepExprHolder) {
            if (DIAGNOSE_MULTISTEPLIST) {
                multistepExprHolder.diagnose();
            }
            boolean bl = vector == this.m_absPaths;
            int n = multistepExprHolder.m_stepCount;
            int n2 = n - 1;
            while (n2 >= 1) {
                MultistepExprHolder multistepExprHolder2 = multistepExprHolder;
                while (null != multistepExprHolder2) {
                    if (multistepExprHolder2.m_stepCount < n2) break;
                    multistepExprHolder = this.matchAndEliminatePartialPaths(multistepExprHolder2, multistepExprHolder, bl, n2, elemTemplateElement);
                    multistepExprHolder2 = multistepExprHolder2.m_next;
                }
                --n2;
            }
        }
    }

    protected MultistepExprHolder matchAndEliminatePartialPaths(MultistepExprHolder multistepExprHolder, MultistepExprHolder multistepExprHolder2, boolean bl, int n, ElemTemplateElement elemTemplateElement) {
        if (null == multistepExprHolder.m_exprOwner) {
            return multistepExprHolder2;
        }
        WalkingIterator walkingIterator = (WalkingIterator)multistepExprHolder.m_exprOwner.getExpression();
        if (this.partialIsVariable(multistepExprHolder, n)) {
            return multistepExprHolder2;
        }
        MultistepExprHolder multistepExprHolder3 = null;
        MultistepExprHolder multistepExprHolder4 = null;
        MultistepExprHolder multistepExprHolder5 = multistepExprHolder2;
        while (null != multistepExprHolder5) {
            WalkingIterator walkingIterator2;
            if (multistepExprHolder5 != multistepExprHolder && null != multistepExprHolder5.m_exprOwner && this.stepsEqual(walkingIterator, walkingIterator2 = (WalkingIterator)multistepExprHolder5.m_exprOwner.getExpression(), n)) {
                if (null == multistepExprHolder3) {
                    try {
                        multistepExprHolder3 = (MultistepExprHolder)multistepExprHolder.clone();
                        multistepExprHolder.m_exprOwner = null;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                    multistepExprHolder4 = multistepExprHolder3;
                    multistepExprHolder4.m_next = null;
                }
                try {
                    multistepExprHolder4.m_next = (MultistepExprHolder)multistepExprHolder5.clone();
                    multistepExprHolder5.m_exprOwner = null;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                multistepExprHolder4 = multistepExprHolder4.m_next;
                multistepExprHolder4.m_next = null;
            }
            multistepExprHolder5 = multistepExprHolder5.m_next;
        }
        int n2 = 0;
        if (null != multistepExprHolder3) {
            ElemTemplateElement elemTemplateElement2 = bl ? elemTemplateElement : this.findCommonAncestor(multistepExprHolder3);
            WalkingIterator walkingIterator3 = (WalkingIterator)multistepExprHolder3.m_exprOwner.getExpression();
            WalkingIterator walkingIterator4 = this.createIteratorFromSteps(walkingIterator3, n);
            ElemVariable elemVariable = this.createPsuedoVarDecl(elemTemplateElement2, walkingIterator4, bl);
            if (DIAGNOSE_MULTISTEPLIST) {
                System.err.println("Created var: " + elemVariable.getName() + (bl ? "(Global)" : ""));
            }
            while (null != multistepExprHolder3) {
                ExpressionOwner expressionOwner = multistepExprHolder3.m_exprOwner;
                WalkingIterator walkingIterator5 = (WalkingIterator)expressionOwner.getExpression();
                if (DIAGNOSE_MULTISTEPLIST) {
                    this.diagnoseLineNumber(walkingIterator5);
                }
                LocPathIterator locPathIterator = this.changePartToRef(elemVariable.getName(), walkingIterator5, n, bl);
                expressionOwner.setExpression(locPathIterator);
                multistepExprHolder3 = multistepExprHolder3.m_next;
            }
        }
        if (DIAGNOSE_MULTISTEPLIST) {
            this.diagnoseMultistepList(n2, n, bl);
        }
        return multistepExprHolder2;
    }

    boolean partialIsVariable(MultistepExprHolder multistepExprHolder, int n) {
        WalkingIterator walkingIterator;
        return 1 == n && (walkingIterator = (WalkingIterator)multistepExprHolder.m_exprOwner.getExpression()).getFirstWalker() instanceof FilterExprWalker;
    }

    protected void diagnoseLineNumber(Expression expression) {
        ElemTemplateElement elemTemplateElement = this.getElemFromExpression(expression);
        System.err.println("   " + elemTemplateElement.getSystemId() + " Line " + elemTemplateElement.getLineNumber());
    }

    protected ElemTemplateElement findCommonAncestor(MultistepExprHolder multistepExprHolder) {
        int n;
        int n2;
        int n3 = multistepExprHolder.getLength();
        ElemTemplateElement[] elemTemplateElementArray = new ElemTemplateElement[n3];
        int[] nArray = new int[n3];
        MultistepExprHolder multistepExprHolder2 = multistepExprHolder;
        int n4 = 10000;
        int n5 = 0;
        while (n5 < n3) {
            ElemTemplateElement elemTemplateElement;
            elemTemplateElementArray[n5] = elemTemplateElement = this.getElemFromExpression(multistepExprHolder2.m_exprOwner.getExpression());
            nArray[n5] = n2 = this.countAncestors(elemTemplateElement);
            if (n2 < n4) {
                n4 = n2;
            }
            multistepExprHolder2 = multistepExprHolder2.m_next;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n3) {
            if (nArray[n6] > n4) {
                n2 = nArray[n6] - n4;
                n = 0;
                while (n < n2) {
                    elemTemplateElementArray[n6] = elemTemplateElementArray[n6].getParentElem();
                    ++n;
                }
            }
            ++n6;
        }
        ElemTemplateElement elemTemplateElement = null;
        while (n4-- >= 0) {
            n = 1;
            elemTemplateElement = elemTemplateElementArray[0];
            int n7 = 1;
            while (n7 < n3) {
                if (elemTemplateElement != elemTemplateElementArray[n7]) {
                    n = 0;
                    break;
                }
                ++n7;
            }
            if (n != 0 && this.isNotSameAsOwner(multistepExprHolder, elemTemplateElement) && elemTemplateElement.canAcceptVariables()) {
                if (DIAGNOSE_MULTISTEPLIST) {
                    System.err.print(elemTemplateElement.getClass().getName());
                    System.err.println(" at   " + elemTemplateElement.getSystemId() + " Line " + elemTemplateElement.getLineNumber());
                }
                return elemTemplateElement;
            }
            int n8 = 0;
            while (n8 < n3) {
                elemTemplateElementArray[n8] = elemTemplateElementArray[n8].getParentElem();
                ++n8;
            }
        }
        RedundentExprEliminator.assertion(false, "Could not find common ancestor!!!");
        return null;
    }

    protected boolean isNotSameAsOwner(MultistepExprHolder multistepExprHolder, ElemTemplateElement elemTemplateElement) {
        MultistepExprHolder multistepExprHolder2 = multistepExprHolder;
        while (null != multistepExprHolder2) {
            ElemTemplateElement elemTemplateElement2 = this.getElemFromExpression(multistepExprHolder2.m_exprOwner.getExpression());
            if (elemTemplateElement2 == elemTemplateElement) {
                return false;
            }
            multistepExprHolder2 = multistepExprHolder2.m_next;
        }
        return true;
    }

    protected int countAncestors(ElemTemplateElement elemTemplateElement) {
        int n = 0;
        while (null != elemTemplateElement) {
            ++n;
            elemTemplateElement = elemTemplateElement.getParentElem();
        }
        return n;
    }

    protected void diagnoseMultistepList(int n, int n2, boolean bl) {
        if (n > 0) {
            System.err.print("Found multistep matches: " + n + ", " + n2 + " length");
            if (bl) {
                System.err.println(" (global)");
            } else {
                System.err.println();
            }
        }
    }

    protected LocPathIterator changePartToRef(QName qName, WalkingIterator walkingIterator, int n, boolean bl) {
        Cloneable cloneable;
        ExpressionNode expressionNode;
        Variable variable = new Variable();
        variable.setQName(qName);
        variable.setIsGlobal(bl);
        if (bl) {
            expressionNode = this.getElemFromExpression(walkingIterator);
            StylesheetRoot stylesheetRoot = ((ElemTemplateElement)expressionNode).getStylesheetRoot();
            cloneable = stylesheetRoot.getVariablesAndParamsComposed();
            variable.setIndex(((Vector)cloneable).size() - 1);
        }
        expressionNode = walkingIterator.getFirstWalker();
        int n2 = 0;
        while (n2 < n) {
            RedundentExprEliminator.assertion(null != expressionNode, "Walker should not be null!");
            expressionNode = ((AxesWalker)expressionNode).getNextWalker();
            ++n2;
        }
        if (null != expressionNode) {
            cloneable = new FilterExprWalker(walkingIterator);
            ((FilterExprWalker)cloneable).setInnerExpression(variable);
            ((Expression)((Object)cloneable)).exprSetParent(walkingIterator);
            ((AxesWalker)cloneable).setNextWalker((AxesWalker)expressionNode);
            ((AxesWalker)expressionNode).setPrevWalker((AxesWalker)cloneable);
            walkingIterator.setFirstWalker((AxesWalker)cloneable);
            return walkingIterator;
        }
        cloneable = new FilterExprIteratorSimple(variable);
        ((Expression)((Object)cloneable)).exprSetParent(walkingIterator.exprGetParent());
        return cloneable;
    }

    protected WalkingIterator createIteratorFromSteps(WalkingIterator walkingIterator, int n) {
        WalkingIterator walkingIterator2 = new WalkingIterator(walkingIterator.getPrefixResolver());
        try {
            AxesWalker axesWalker = (AxesWalker)walkingIterator.getFirstWalker().clone();
            walkingIterator2.setFirstWalker(axesWalker);
            axesWalker.setLocPathIterator(walkingIterator2);
            int n2 = 1;
            while (n2 < n) {
                AxesWalker axesWalker2 = (AxesWalker)axesWalker.getNextWalker().clone();
                axesWalker.setNextWalker(axesWalker2);
                axesWalker2.setLocPathIterator(walkingIterator2);
                axesWalker = axesWalker2;
                ++n2;
            }
            axesWalker.setNextWalker(null);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WrappedRuntimeException(cloneNotSupportedException);
        }
        return walkingIterator2;
    }

    protected boolean stepsEqual(WalkingIterator walkingIterator, WalkingIterator walkingIterator2, int n) {
        AxesWalker axesWalker = walkingIterator.getFirstWalker();
        AxesWalker axesWalker2 = walkingIterator2.getFirstWalker();
        int n2 = 0;
        while (n2 < n) {
            if (null == axesWalker || null == axesWalker2) {
                return false;
            }
            if (!axesWalker.deepEquals(axesWalker2)) {
                return false;
            }
            axesWalker = axesWalker.getNextWalker();
            axesWalker2 = axesWalker2.getNextWalker();
            ++n2;
        }
        RedundentExprEliminator.assertion(null != axesWalker || null != axesWalker2, "Total match is incorrect!");
        return true;
    }

    protected MultistepExprHolder createMultistepExprList(Vector vector) {
        MultistepExprHolder multistepExprHolder = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            LocPathIterator locPathIterator;
            int n3;
            ExpressionOwner expressionOwner = (ExpressionOwner)vector.elementAt(n2);
            if (null != expressionOwner && (n3 = this.countSteps(locPathIterator = (LocPathIterator)expressionOwner.getExpression())) > 1) {
                multistepExprHolder = null == multistepExprHolder ? new MultistepExprHolder(expressionOwner, n3, null) : multistepExprHolder.addInSortedOrder(expressionOwner, n3);
            }
            ++n2;
        }
        if (null == multistepExprHolder || multistepExprHolder.getLength() <= 1) {
            return null;
        }
        return multistepExprHolder;
    }

    protected int findAndEliminateRedundant(int n, int n2, ExpressionOwner expressionOwner, ElemTemplateElement elemTemplateElement, Vector vector) throws DOMException {
        Serializable serializable;
        Expression expression;
        Object object;
        MultistepExprHolder multistepExprHolder = null;
        MultistepExprHolder multistepExprHolder2 = null;
        int n3 = 0;
        int n4 = vector.size();
        Expression expression2 = expressionOwner.getExpression();
        if (DEBUG) {
            this.assertIsLocPathIterator(expression2, expressionOwner);
        }
        boolean bl = vector == this.m_absPaths;
        LocPathIterator locPathIterator = (LocPathIterator)expression2;
        int n5 = this.countSteps(locPathIterator);
        int n6 = n;
        while (n6 < n4) {
            boolean bl2;
            object = (ExpressionOwner)vector.elementAt(n6);
            if (null != object && (bl2 = (expression = object.getExpression()).deepEquals(locPathIterator))) {
                serializable = (LocPathIterator)expression;
                if (null == multistepExprHolder) {
                    multistepExprHolder2 = multistepExprHolder = new MultistepExprHolder(expressionOwner, n5, null);
                    ++n3;
                }
                multistepExprHolder2 = multistepExprHolder2.m_next = new MultistepExprHolder((ExpressionOwner)object, n5, null);
                vector.setElementAt(null, n6);
                ++n3;
            }
            ++n6;
        }
        if (0 == n3 && bl) {
            multistepExprHolder = new MultistepExprHolder(expressionOwner, n5, null);
            ++n3;
        }
        if (null != multistepExprHolder) {
            object = bl ? elemTemplateElement : this.findCommonAncestor(multistepExprHolder);
            expression = (LocPathIterator)multistepExprHolder.m_exprOwner.getExpression();
            ElemVariable elemVariable = this.createPsuedoVarDecl((ElemTemplateElement)object, (LocPathIterator)expression, bl);
            if (DIAGNOSE_MULTISTEPLIST) {
                System.err.println("Created var: " + elemVariable.getName() + (bl ? "(Global)" : ""));
            }
            serializable = elemVariable.getName();
            while (null != multistepExprHolder) {
                ExpressionOwner expressionOwner2 = multistepExprHolder.m_exprOwner;
                if (DIAGNOSE_MULTISTEPLIST) {
                    this.diagnoseLineNumber(expressionOwner2.getExpression());
                }
                this.changeToVarRef((QName)serializable, expressionOwner2, vector, (ElemTemplateElement)object);
                multistepExprHolder = multistepExprHolder.m_next;
            }
            vector.setElementAt(elemVariable.getSelect(), n2);
        }
        return n3;
    }

    protected int oldFindAndEliminateRedundant(int n, int n2, ExpressionOwner expressionOwner, ElemTemplateElement elemTemplateElement, Vector vector) throws DOMException {
        Object object;
        QName qName = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = vector.size();
        Expression expression = expressionOwner.getExpression();
        if (DEBUG) {
            this.assertIsLocPathIterator(expression, expressionOwner);
        }
        boolean bl2 = vector == this.m_absPaths;
        LocPathIterator locPathIterator = (LocPathIterator)expression;
        int n5 = n;
        while (n5 < n4) {
            Expression expression2;
            boolean bl3;
            object = (ExpressionOwner)vector.elementAt(n5);
            if (null != object && (bl3 = (expression2 = object.getExpression()).deepEquals(locPathIterator))) {
                LocPathIterator locPathIterator2 = (LocPathIterator)expression2;
                if (!bl) {
                    bl = true;
                    ElemVariable elemVariable = this.createPsuedoVarDecl(elemTemplateElement, locPathIterator, bl2);
                    if (null == elemVariable) {
                        return 0;
                    }
                    qName = elemVariable.getName();
                    this.changeToVarRef(qName, expressionOwner, vector, elemTemplateElement);
                    vector.setElementAt(elemVariable.getSelect(), n2);
                    ++n3;
                }
                this.changeToVarRef(qName, (ExpressionOwner)object, vector, elemTemplateElement);
                vector.setElementAt(null, n5);
                ++n3;
            }
            ++n5;
        }
        if (0 == n3 && vector == this.m_absPaths) {
            object = this.createPsuedoVarDecl(elemTemplateElement, locPathIterator, true);
            if (null == object) {
                return 0;
            }
            qName = ((ElemVariable)object).getName();
            this.changeToVarRef(qName, expressionOwner, vector, elemTemplateElement);
            vector.setElementAt(((ElemVariable)object).getSelect(), n2);
            ++n3;
        }
        return n3;
    }

    protected int countSteps(LocPathIterator locPathIterator) {
        if (locPathIterator instanceof WalkingIterator) {
            WalkingIterator walkingIterator = (WalkingIterator)locPathIterator;
            AxesWalker axesWalker = walkingIterator.getFirstWalker();
            int n = 0;
            while (null != axesWalker) {
                ++n;
                axesWalker = axesWalker.getNextWalker();
            }
            return n;
        }
        return 1;
    }

    protected void changeToVarRef(QName qName, ExpressionOwner expressionOwner, Vector vector, ElemTemplateElement elemTemplateElement) {
        Variable variable = vector == this.m_absPaths ? new VariableSafeAbsRef() : new Variable();
        variable.setQName(qName);
        if (vector == this.m_absPaths) {
            StylesheetRoot stylesheetRoot = (StylesheetRoot)elemTemplateElement;
            Vector vector2 = stylesheetRoot.getVariablesAndParamsComposed();
            variable.setIndex(vector2.size() - 1);
            variable.setIsGlobal(true);
        }
        expressionOwner.setExpression(variable);
    }

    protected ElemVariable createPsuedoVarDecl(ElemTemplateElement elemTemplateElement, LocPathIterator locPathIterator, boolean bl) throws DOMException {
        QName qName = new QName(PSUEDOVARNAMESPACE, "#" + m_uniquePsuedoVarID);
        ++m_uniquePsuedoVarID;
        if (bl) {
            return this.createGlobalPsuedoVarDecl(qName, (StylesheetRoot)elemTemplateElement, locPathIterator);
        }
        return this.createLocalPsuedoVarDecl(qName, elemTemplateElement, locPathIterator);
    }

    protected ElemVariable createGlobalPsuedoVarDecl(QName qName, StylesheetRoot stylesheetRoot, LocPathIterator locPathIterator) throws DOMException {
        ElemVariable elemVariable = new ElemVariable();
        elemVariable.setIsTopLevel(true);
        XPath xPath = new XPath(locPathIterator);
        elemVariable.setSelect(xPath);
        elemVariable.setName(qName);
        Vector vector = stylesheetRoot.getVariablesAndParamsComposed();
        elemVariable.setIndex(vector.size());
        vector.addElement(elemVariable);
        return elemVariable;
    }

    protected ElemVariable createLocalPsuedoVarDecl(QName qName, ElemTemplateElement elemTemplateElement, LocPathIterator locPathIterator) throws DOMException {
        ElemVariablePsuedo elemVariablePsuedo = new ElemVariablePsuedo();
        XPath xPath = new XPath(locPathIterator);
        ((ElemVariable)elemVariablePsuedo).setSelect(xPath);
        elemVariablePsuedo.setName(qName);
        ElemVariable elemVariable = this.addVarDeclToElem(elemTemplateElement, locPathIterator, elemVariablePsuedo);
        locPathIterator.exprSetParent(elemVariable);
        return elemVariable;
    }

    /*
     * Unable to fully structure code
     */
    protected ElemVariable addVarDeclToElem(ElemTemplateElement var1_1, LocPathIterator var2_2, ElemVariable var3_3) throws DOMException {
        block4: {
            var4_4 = var1_1.getFirstChildElem();
            var2_2.callVisitors(null, this.m_varNameCollector);
            if (this.m_varNameCollector.getVarCount() > 0) {
                var5_5 = this.getElemFromExpression(var2_2);
                var6_6 = this.getPrevVariableElem(var5_5);
                while (null != var6_6) {
                    if (this.m_varNameCollector.doesOccur(var6_6.getName())) {
                        var1_1 = var6_6.getParentElem();
                        var4_4 = var6_6.getNextSiblingElem();
                        break;
                    }
                    var6_6 = this.getPrevVariableElem(var6_6);
                }
            }
            if (null == var4_4 || 41 != var4_4.getXSLToken()) break block4;
            if (!this.isParam(var2_2)) ** GOTO lbl-1000
            return null;
            while (null == (var4_4 = var4_4.getNextSiblingElem()) || 41 == var4_4.getXSLToken()) lbl-1000:
            // 2 sources

            {
                if (null != var4_4) continue;
            }
        }
        var1_1.insertBefore(var3_3, var4_4);
        this.m_varNameCollector.reset();
        return var3_3;
    }

    protected boolean isParam(ExpressionNode expressionNode) {
        while (null != expressionNode) {
            if (expressionNode instanceof ElemTemplateElement) break;
            expressionNode = expressionNode.exprGetParent();
        }
        if (null != expressionNode) {
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)expressionNode;
            while (null != elemTemplateElement) {
                int n = elemTemplateElement.getXSLToken();
                switch (n) {
                    case 41: {
                        return true;
                    }
                    case 19: 
                    case 25: {
                        return false;
                    }
                }
                elemTemplateElement = elemTemplateElement.getParentElem();
            }
        }
        return false;
    }

    protected ElemVariable getPrevVariableElem(ElemTemplateElement elemTemplateElement) {
        while (null != (elemTemplateElement = this.getPrevElementWithinContext(elemTemplateElement))) {
            int n = elemTemplateElement.getXSLToken();
            if (73 != n && 41 != n) continue;
            return (ElemVariable)elemTemplateElement;
        }
        return null;
    }

    protected ElemTemplateElement getPrevElementWithinContext(ElemTemplateElement elemTemplateElement) {
        int n;
        ElemTemplateElement elemTemplateElement2 = elemTemplateElement.getPreviousSiblingElem();
        if (null == elemTemplateElement2) {
            elemTemplateElement2 = elemTemplateElement.getParentElem();
        }
        if (null != elemTemplateElement2 && (28 == (n = elemTemplateElement2.getXSLToken()) || 19 == n || 25 == n)) {
            elemTemplateElement2 = null;
        }
        return elemTemplateElement2;
    }

    protected ElemTemplateElement getElemFromExpression(Expression expression) {
        ExpressionNode expressionNode = expression.exprGetParent();
        while (null != expressionNode) {
            if (expressionNode instanceof ElemTemplateElement) {
                return (ElemTemplateElement)expressionNode;
            }
            expressionNode = expressionNode.exprGetParent();
        }
        throw new RuntimeException(XSLMessages.createMessage("ER_ASSERT_NO_TEMPLATE_PARENT", null));
    }

    public boolean isAbsolute(LocPathIterator locPathIterator) {
        boolean bl;
        int n = locPathIterator.getAnalysisBits();
        boolean bl2 = bl = WalkerFactory.isSet(n, 0x8000000) || WalkerFactory.isSet(n, 0x20000000);
        if (bl) {
            bl = this.m_absPathChecker.checkAbsolute(locPathIterator);
        }
        return bl;
    }

    public boolean visitLocationPath(ExpressionOwner expressionOwner, LocPathIterator locPathIterator) {
        FilterExprWalker filterExprWalker;
        Expression expression;
        WalkingIterator walkingIterator;
        AxesWalker axesWalker;
        if (locPathIterator instanceof SelfIteratorNoPredicate) {
            return true;
        }
        if (locPathIterator instanceof WalkingIterator && (axesWalker = (walkingIterator = (WalkingIterator)locPathIterator).getFirstWalker()) instanceof FilterExprWalker && null == axesWalker.getNextWalker() && (expression = (filterExprWalker = (FilterExprWalker)axesWalker).getInnerExpression()) instanceof Variable) {
            return true;
        }
        if (this.isAbsolute(locPathIterator) && null != this.m_absPaths) {
            if (DEBUG) {
                RedundentExprEliminator.validateNewAddition(this.m_absPaths, expressionOwner, locPathIterator);
            }
            this.m_absPaths.addElement(expressionOwner);
        } else if (this.m_isSameContext && null != this.m_paths) {
            if (DEBUG) {
                RedundentExprEliminator.validateNewAddition(this.m_paths, expressionOwner, locPathIterator);
            }
            this.m_paths.addElement(expressionOwner);
        }
        return true;
    }

    public boolean visitPredicate(ExpressionOwner expressionOwner, Expression expression) {
        boolean bl = this.m_isSameContext;
        this.m_isSameContext = false;
        expression.callVisitors(expressionOwner, this);
        this.m_isSameContext = bl;
        return false;
    }

    boolean visitTopLevelInstruction(ElemTemplateElement elemTemplateElement) {
        int n = elemTemplateElement.getXSLToken();
        switch (n) {
            case 19: {
                return this.visitInstruction(elemTemplateElement);
            }
        }
        return true;
    }

    boolean visitInstruction(ElemTemplateElement elemTemplateElement) {
        int n = elemTemplateElement.getXSLToken();
        switch (n) {
            case 17: 
            case 19: 
            case 28: {
                Serializable serializable;
                if (n == 28) {
                    serializable = (ElemForEach)elemTemplateElement;
                    Expression expression = ((ElemForEach)serializable).getSelect();
                    expression.callVisitors((ExpressionOwner)((Object)serializable), this);
                }
                serializable = this.m_paths;
                this.m_paths = new Vector();
                elemTemplateElement.callChildVisitors(this, false);
                this.eleminateRedundentLocals(elemTemplateElement);
                this.m_paths = serializable;
                return false;
            }
            case 35: 
            case 64: {
                boolean bl = this.m_isSameContext;
                this.m_isSameContext = false;
                elemTemplateElement.callChildVisitors(this);
                this.m_isSameContext = bl;
                return false;
            }
        }
        return true;
    }

    protected void diagnoseNumPaths(Vector vector, int n, int n2) {
        if (n > 0) {
            if (vector == this.m_paths) {
                System.err.println("Eliminated " + n + " total paths!");
                System.err.println("Consolodated " + n2 + " redundent paths!");
            } else {
                System.err.println("Eliminated " + n + " total global paths!");
                System.err.println("Consolodated " + n2 + " redundent global paths!");
            }
        }
    }

    private final void assertIsLocPathIterator(Expression expression, ExpressionOwner expressionOwner) throws RuntimeException {
        if (!(expression instanceof LocPathIterator)) {
            String string = expression instanceof Variable ? "Programmer's assertion: expr1 not an iterator: " + ((Variable)expression).getQName() : "Programmer's assertion: expr1 not an iterator: " + expression.getClass().getName();
            throw new RuntimeException(string + ", " + expressionOwner.getClass().getName() + " " + expression.exprGetParent());
        }
    }

    private static void validateNewAddition(Vector vector, ExpressionOwner expressionOwner, LocPathIterator locPathIterator) throws RuntimeException {
        RedundentExprEliminator.assertion(expressionOwner.getExpression() == locPathIterator, "owner.getExpression() != path!!!");
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ExpressionOwner expressionOwner2 = (ExpressionOwner)vector.elementAt(n2);
            RedundentExprEliminator.assertion(expressionOwner2 != expressionOwner, "duplicate owner on the list!!!");
            RedundentExprEliminator.assertion(expressionOwner2.getExpression() != locPathIterator, "duplicate expression on the list!!!");
            ++n2;
        }
    }

    protected static void assertion(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(XSLMessages.createMessage("ER_ASSERT_REDUNDENT_EXPR_ELIMINATOR", new Object[]{string}));
        }
    }

    class MultistepExprHolder
    implements Cloneable {
        ExpressionOwner m_exprOwner;
        final int m_stepCount;
        MultistepExprHolder m_next;

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        MultistepExprHolder(ExpressionOwner expressionOwner, int n, MultistepExprHolder multistepExprHolder) {
            this.m_exprOwner = expressionOwner;
            RedundentExprEliminator.assertion(null != this.m_exprOwner, "exprOwner can not be null!");
            this.m_stepCount = n;
            this.m_next = multistepExprHolder;
        }

        MultistepExprHolder addInSortedOrder(ExpressionOwner expressionOwner, int n) {
            MultistepExprHolder multistepExprHolder = this;
            MultistepExprHolder multistepExprHolder2 = this;
            MultistepExprHolder multistepExprHolder3 = null;
            while (null != multistepExprHolder2) {
                if (n >= multistepExprHolder2.m_stepCount) {
                    MultistepExprHolder multistepExprHolder4 = new MultistepExprHolder(expressionOwner, n, multistepExprHolder2);
                    if (null == multistepExprHolder3) {
                        multistepExprHolder = multistepExprHolder4;
                    } else {
                        multistepExprHolder3.m_next = multistepExprHolder4;
                    }
                    return multistepExprHolder;
                }
                multistepExprHolder3 = multistepExprHolder2;
                multistepExprHolder2 = multistepExprHolder2.m_next;
            }
            multistepExprHolder3.m_next = new MultistepExprHolder(expressionOwner, n, null);
            return multistepExprHolder;
        }

        MultistepExprHolder unlink(MultistepExprHolder multistepExprHolder) {
            MultistepExprHolder multistepExprHolder2 = this;
            MultistepExprHolder multistepExprHolder3 = this;
            MultistepExprHolder multistepExprHolder4 = null;
            while (null != multistepExprHolder3) {
                if (multistepExprHolder3 == multistepExprHolder) {
                    if (null == multistepExprHolder4) {
                        multistepExprHolder2 = multistepExprHolder3.m_next;
                    } else {
                        multistepExprHolder4.m_next = multistepExprHolder3.m_next;
                    }
                    multistepExprHolder3.m_next = null;
                    return multistepExprHolder2;
                }
                multistepExprHolder4 = multistepExprHolder3;
                multistepExprHolder3 = multistepExprHolder3.m_next;
            }
            RedundentExprEliminator.assertion(false, "unlink failed!!!");
            return null;
        }

        int getLength() {
            int n = 0;
            MultistepExprHolder multistepExprHolder = this;
            while (null != multistepExprHolder) {
                ++n;
                multistepExprHolder = multistepExprHolder.m_next;
            }
            return n;
        }

        protected void diagnose() {
            System.err.print("Found multistep iterators: " + this.getLength() + "  ");
            MultistepExprHolder multistepExprHolder = this;
            while (null != multistepExprHolder) {
                System.err.print("" + multistepExprHolder.m_stepCount);
                multistepExprHolder = multistepExprHolder.m_next;
                if (null == multistepExprHolder) continue;
                System.err.print(", ");
            }
            System.err.println();
        }
    }
}

