/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xalan.transformer.CountersTable;
import org.apache.xalan.transformer.DecimalToRoman;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.StringBufferPool;
import org.apache.xml.utils.res.XResourceBundle;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemNumber
extends ElemTemplateElement {
    private XPath m_countMatchPattern = null;
    private XPath m_fromMatchPattern = null;
    private int m_level = 1;
    private XPath m_valueExpr = null;
    private AVT m_format_avt = null;
    private AVT m_lang_avt = null;
    private AVT m_lettervalue_avt = null;
    private AVT m_groupingSeparator_avt = null;
    private AVT m_groupingSize_avt = null;
    private static final DecimalToRoman[] m_romanConvertTable = new DecimalToRoman[]{new DecimalToRoman(1000L, "M", 900L, "CM"), new DecimalToRoman(500L, "D", 400L, "CD"), new DecimalToRoman(100L, "C", 90L, "XC"), new DecimalToRoman(50L, "L", 40L, "XL"), new DecimalToRoman(10L, "X", 9L, "IX"), new DecimalToRoman(5L, "V", 4L, "IV"), new DecimalToRoman(1L, "I", 1L, "I")};
    private static char[] m_alphaCountTable = null;

    public void setCount(XPath xPath) {
        this.m_countMatchPattern = xPath;
    }

    public XPath getCount() {
        return this.m_countMatchPattern;
    }

    public void setFrom(XPath xPath) {
        this.m_fromMatchPattern = xPath;
    }

    public XPath getFrom() {
        return this.m_fromMatchPattern;
    }

    public void setLevel(int n) {
        this.m_level = n;
    }

    public int getLevel() {
        return this.m_level;
    }

    public void setValue(XPath xPath) {
        this.m_valueExpr = xPath;
    }

    public XPath getValue() {
        return this.m_valueExpr;
    }

    public void setFormat(AVT aVT) {
        this.m_format_avt = aVT;
    }

    public AVT getFormat() {
        return this.m_format_avt;
    }

    public void setLang(AVT aVT) {
        this.m_lang_avt = aVT;
    }

    public AVT getLang() {
        return this.m_lang_avt;
    }

    public void setLetterValue(AVT aVT) {
        this.m_lettervalue_avt = aVT;
    }

    public AVT getLetterValue() {
        return this.m_lettervalue_avt;
    }

    public void setGroupingSeparator(AVT aVT) {
        this.m_groupingSeparator_avt = aVT;
    }

    public AVT getGroupingSeparator() {
        return this.m_groupingSeparator_avt;
    }

    public void setGroupingSize(AVT aVT) {
        this.m_groupingSize_avt = aVT;
    }

    public AVT getGroupingSize() {
        return this.m_groupingSize_avt;
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        StylesheetRoot.ComposeState composeState = stylesheetRoot.getComposeState();
        Vector vector = composeState.getVariableNames();
        if (null != this.m_countMatchPattern) {
            this.m_countMatchPattern.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_format_avt) {
            this.m_format_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_fromMatchPattern) {
            this.m_fromMatchPattern.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_groupingSeparator_avt) {
            this.m_groupingSeparator_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_groupingSize_avt) {
            this.m_groupingSize_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_lang_avt) {
            this.m_lang_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_lettervalue_avt) {
            this.m_lettervalue_avt.fixupVariables(vector, composeState.getGlobalsSize());
        }
        if (null != this.m_valueExpr) {
            this.m_valueExpr.fixupVariables(vector, composeState.getGlobalsSize());
        }
    }

    public int getXSLToken() {
        return 35;
    }

    public String getNodeName() {
        return "number";
    }

    public void execute(TransformerImpl transformerImpl) throws TransformerException {
        if (TransformerImpl.S_DEBUG) {
            transformerImpl.getTraceManager().fireTraceEvent(this);
        }
        int n = transformerImpl.getXPathContext().getCurrentNode();
        String string = this.getCountString(transformerImpl, n);
        try {
            try {
                transformerImpl.getResultTreeHandler().characters(string.toCharArray(), 0, string.length());
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
            Object var6_4 = null;
            if (TransformerImpl.S_DEBUG) {
                transformerImpl.getTraceManager().fireTraceEndEvent(this);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (TransformerImpl.S_DEBUG) {
                transformerImpl.getTraceManager().fireTraceEndEvent(this);
            }
            throw throwable;
        }
    }

    public ElemTemplateElement appendChild(ElemTemplateElement elemTemplateElement) {
        this.error("ER_CANNOT_ADD", new Object[]{elemTemplateElement.getNodeName(), this.getNodeName()});
        return null;
    }

    int findAncestor(XPathContext xPathContext, XPath xPath, XPath xPath2, int n, ElemNumber elemNumber) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        while (-1 != n) {
            if (null != xPath && xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY || null != xPath2 && xPath2.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) break;
            n = dTM.getParent(n);
        }
        return n;
    }

    private int findPrecedingOrAncestorOrSelf(XPathContext xPathContext, XPath xPath, XPath xPath2, int n, ElemNumber elemNumber) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n);
        while (-1 != n) {
            if (null != xPath && xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) {
                n = -1;
                break;
            }
            if (null != xPath2 && xPath2.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) break;
            int n2 = dTM.getPreviousSibling(n);
            if (-1 == n2) {
                n = dTM.getParent(n);
                continue;
            }
            n = dTM.getLastChild(n2);
            if (n != -1) continue;
            n = n2;
        }
        return n;
    }

    XPath getCountMatchPattern(XPathContext xPathContext, int n) throws TransformerException {
        XPath xPath = this.m_countMatchPattern;
        DTM dTM = xPathContext.getDTM(n);
        if (null == xPath) {
            switch (dTM.getNodeType(n)) {
                case 1: {
                    MyPrefixResolver myPrefixResolver = dTM.getNamespaceURI(n) == null ? new MyPrefixResolver(dTM.getNode(n), dTM, n, false) : new MyPrefixResolver(dTM.getNode(n), dTM, n, true);
                    xPath = new XPath(dTM.getNodeName(n), this, myPrefixResolver, 1, xPathContext.getErrorListener());
                    break;
                }
                case 2: {
                    xPath = new XPath("@" + dTM.getNodeName(n), this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 3: 
                case 4: {
                    xPath = new XPath("text()", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 8: {
                    xPath = new XPath("comment()", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 9: {
                    xPath = new XPath("/", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                case 7: {
                    xPath = new XPath("pi(" + dTM.getNodeName(n) + ")", this, this, 1, xPathContext.getErrorListener());
                    break;
                }
                default: {
                    xPath = null;
                }
            }
        }
        return xPath;
    }

    String getCountString(TransformerImpl transformerImpl, int n) throws TransformerException {
        long[] lArray = null;
        XPathContext xPathContext = transformerImpl.getXPathContext();
        CountersTable countersTable = transformerImpl.getCountersTable();
        if (null != this.m_valueExpr) {
            XObject xObject = this.m_valueExpr.execute(xPathContext, n, (PrefixResolver)this);
            long l = (long)Math.floor(xObject.num() + 0.5);
            lArray = new long[]{l};
        } else if (3 == this.m_level) {
            lArray = new long[]{countersTable.countNode(xPathContext, this, n)};
        } else {
            NodeVector nodeVector = this.getMatchingAncestors(xPathContext, n, 1 == this.m_level);
            int n2 = nodeVector.size() - 1;
            if (n2 >= 0) {
                lArray = new long[n2 + 1];
                int n3 = n2;
                while (n3 >= 0) {
                    int n4 = nodeVector.elementAt(n3);
                    lArray[n2 - n3] = countersTable.countNode(xPathContext, this, n4);
                    --n3;
                }
            }
        }
        return null != lArray ? this.formatNumberList(transformerImpl, lArray, n) : "";
    }

    /*
     * Unable to fully structure code
     */
    public int getPreviousNode(XPathContext var1_1, int var2_2) throws TransformerException {
        block7: {
            var3_3 = this.getCountMatchPattern(var1_1, var2_2);
            var4_4 = var1_1.getDTM(var2_2);
            if (3 != this.m_level) ** GOTO lbl-1000
            var5_5 = this.m_fromMatchPattern;
            while (-1 != var2_2) {
                var6_6 = var4_4.getPreviousSibling(var2_2);
                if (-1 == var6_6) {
                    var6_6 = var4_4.getParent(var2_2);
                    if (-1 != var6_6 && (null != var5_5 && var5_5.getMatchScore(var1_1, var6_6) != -Infinity || var4_4.getNodeType(var6_6) == 9)) {
                        var2_2 = -1;
                        break block7;
                    }
                } else {
                    var7_7 = var6_6;
                    while (-1 != var7_7) {
                        var7_7 = var4_4.getLastChild(var6_6);
                        if (-1 == var7_7) continue;
                        var6_6 = var7_7;
                    }
                }
                if (-1 == (var2_2 = var6_6) || null != var3_3 && var3_3.getMatchScore(var1_1, var2_2) == -Infinity) {
                    continue;
                }
                break block7;
            }
            break block7;
            while (-1 == (var2_2 = var4_4.getPreviousSibling(var2_2)) || null != var3_3 && var3_3.getMatchScore(var1_1, var2_2) == -Infinity) lbl-1000:
            // 2 sources

            {
                if (-1 != var2_2) continue;
            }
        }
        return var2_2;
    }

    public int getTargetNode(XPathContext xPathContext, int n) throws TransformerException {
        int n2 = -1;
        XPath xPath = this.getCountMatchPattern(xPathContext, n);
        n2 = 3 == this.m_level ? this.findPrecedingOrAncestorOrSelf(xPathContext, this.m_fromMatchPattern, xPath, n, this) : this.findAncestor(xPathContext, this.m_fromMatchPattern, xPath, n, this);
        return n2;
    }

    NodeVector getMatchingAncestors(XPathContext xPathContext, int n, boolean bl) throws TransformerException {
        NodeSetDTM nodeSetDTM = new NodeSetDTM(xPathContext.getDTMManager());
        XPath xPath = this.getCountMatchPattern(xPathContext, n);
        DTM dTM = xPathContext.getDTM(n);
        while (-1 != n) {
            if (null != this.m_fromMatchPattern && this.m_fromMatchPattern.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY && !bl) break;
            if (null == xPath) {
                System.out.println("Programmers error! countMatchPattern should never be null!");
            }
            if (xPath.getMatchScore(xPathContext, n) != Double.NEGATIVE_INFINITY) {
                nodeSetDTM.addElement(n);
                if (bl) break;
            }
            n = dTM.getParent(n);
        }
        return nodeSetDTM;
    }

    Locale getLocale(TransformerImpl transformerImpl, int n) throws TransformerException {
        Locale locale = null;
        if (null != this.m_lang_avt) {
            XPathContext xPathContext = transformerImpl.getXPathContext();
            String string = this.m_lang_avt.evaluate(xPathContext, n, this);
            if (null != string && null == (locale = new Locale(string.toUpperCase(), ""))) {
                transformerImpl.getMsgMgr().warn(this, null, xPathContext.getDTM(n).getNode(n), "WG_LOCALE_NOT_FOUND", new Object[]{string});
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private DecimalFormat getNumberFormatter(TransformerImpl transformerImpl, int n) throws TransformerException {
        String string;
        String string2;
        Locale locale = (Locale)this.getLocale(transformerImpl, n).clone();
        DecimalFormat decimalFormat = null;
        String string3 = string2 = null != this.m_groupingSeparator_avt ? this.m_groupingSeparator_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
        if (string2 != null && !this.m_groupingSeparator_avt.isSimple() && string2.length() != 1) {
            transformerImpl.getMsgMgr().warn(this, "WG_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{"name", this.m_groupingSeparator_avt.getName()});
        }
        String string4 = string = null != this.m_groupingSize_avt ? this.m_groupingSize_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
        if (null != string2 && null != string && string2.length() > 0) {
            try {
                decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                decimalFormat.setGroupingSize(Integer.valueOf(string));
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                decimalFormatSymbols.setGroupingSeparator(string2.charAt(0));
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                ((NumberFormat)decimalFormat).setGroupingUsed(true);
            }
            catch (NumberFormatException numberFormatException) {
                ((NumberFormat)decimalFormat).setGroupingUsed(false);
            }
        }
        return decimalFormat;
    }

    String formatNumberList(TransformerImpl transformerImpl, long[] lArray, int n) throws TransformerException {
        String string;
        FastStringBuffer fastStringBuffer = StringBufferPool.get();
        try {
            String string2;
            String string3;
            int n2 = lArray.length;
            int n3 = 1;
            char c = '1';
            String string4 = null;
            String string5 = null;
            String string6 = ".";
            boolean bl = true;
            String string7 = string3 = null != this.m_format_avt ? this.m_format_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
            if (null == string3) {
                string3 = "1";
            }
            NumberFormatStringTokenizer numberFormatStringTokenizer = new NumberFormatStringTokenizer(string3);
            int n4 = 0;
            while (n4 < n2) {
                if (numberFormatStringTokenizer.hasMoreTokens()) {
                    string2 = numberFormatStringTokenizer.nextToken();
                    if (Character.isLetterOrDigit(string2.charAt(string2.length() - 1))) {
                        n3 = string2.length();
                        c = string2.charAt(n3 - 1);
                    } else if (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                        string5 = string2;
                        while (numberFormatStringTokenizer.nextIsSep()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string5 = string5 + string2;
                        }
                        if (!bl) {
                            string6 = string5;
                        }
                        string2 = numberFormatStringTokenizer.nextToken();
                        n3 = string2.length();
                        c = string2.charAt(n3 - 1);
                    } else {
                        string4 = string2;
                        while (numberFormatStringTokenizer.hasMoreTokens()) {
                            string2 = numberFormatStringTokenizer.nextToken();
                            string4 = string4 + string2;
                        }
                    }
                }
                if (null != string5 && bl) {
                    fastStringBuffer.append(string5);
                } else if (null != string6 && !bl) {
                    fastStringBuffer.append(string6);
                }
                this.getFormattedNumber(transformerImpl, n, c, n3, lArray[n4], fastStringBuffer);
                bl = false;
                ++n4;
            }
            while (numberFormatStringTokenizer.isLetterOrDigitAhead()) {
                numberFormatStringTokenizer.nextToken();
            }
            if (string4 != null) {
                fastStringBuffer.append(string4);
            }
            while (numberFormatStringTokenizer.hasMoreTokens()) {
                string2 = numberFormatStringTokenizer.nextToken();
                fastStringBuffer.append(string2);
            }
            string = fastStringBuffer.toString();
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            StringBufferPool.free(fastStringBuffer);
            throw throwable;
        }
        StringBufferPool.free(fastStringBuffer);
        return string;
    }

    private void getFormattedNumber(TransformerImpl transformerImpl, int n, char c, int n2, long l, FastStringBuffer fastStringBuffer) throws TransformerException {
        String string = this.m_lettervalue_avt != null ? this.m_lettervalue_avt.evaluate(transformerImpl.getXPathContext(), n, this) : null;
        switch (c) {
            case 'A': {
                if (m_alphaCountTable == null) {
                    XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformerImpl, n));
                    char[] cArray = (char[])xResourceBundle.getObject("alphabet");
                    m_alphaCountTable = cArray;
                }
                this.int2alphaCount(l, m_alphaCountTable, fastStringBuffer);
                break;
            }
            case 'a': {
                Object object;
                if (m_alphaCountTable == null) {
                    object = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", this.getLocale(transformerImpl, n));
                    char[] cArray = (char[])((ResourceBundle)object).getObject("alphabet");
                    m_alphaCountTable = cArray;
                }
                object = StringBufferPool.get();
                try {
                    this.int2alphaCount(l, m_alphaCountTable, (FastStringBuffer)object);
                    fastStringBuffer.append(((FastStringBuffer)object).toString().toLowerCase(this.getLocale(transformerImpl, n)));
                    Object var12_12 = null;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    StringBufferPool.free((FastStringBuffer)object);
                    throw throwable;
                }
                StringBufferPool.free((FastStringBuffer)object);
                break;
            }
            case 'I': {
                fastStringBuffer.append(this.long2roman(l, true));
                break;
            }
            case 'i': {
                fastStringBuffer.append(this.long2roman(l, true).toLowerCase(this.getLocale(transformerImpl, n)));
                break;
            }
            case '\u3042': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HA"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u3044': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "HI"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a2': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "A"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u30a4': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ja", "JP", "I"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                fastStringBuffer.append(this.int2singlealphaCount(l, (char[])xResourceBundle.getObject("alphabet")));
                break;
            }
            case '\u4e00': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "CN"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u58f9': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("zh", "TW"));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0e51': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("th", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u05d0': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("he", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u10d0': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("ka", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u03b1': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("el", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            case '\u0430': {
                XResourceBundle xResourceBundle = XResourceBundle.loadResourceBundle("org.apache.xml.utils.res.XResources", new Locale("cy", ""));
                if (string != null && string.equals("traditional")) {
                    fastStringBuffer.append(this.tradAlphaCount(l, xResourceBundle));
                    break;
                }
                this.int2alphaCount(l, (char[])xResourceBundle.getObject("alphabet"), fastStringBuffer);
                break;
            }
            default: {
                DecimalFormat decimalFormat = this.getNumberFormatter(transformerImpl, n);
                String string2 = decimalFormat == null ? String.valueOf(0) : decimalFormat.format(0L);
                String string3 = decimalFormat == null ? String.valueOf(l) : decimalFormat.format(l);
                int n3 = n2 - string3.length();
                int n4 = 0;
                while (n4 < n3) {
                    fastStringBuffer.append(string2);
                    ++n4;
                }
                fastStringBuffer.append(string3);
            }
        }
    }

    String getZeroString() {
        return "0";
    }

    protected String int2singlealphaCount(long l, char[] cArray) {
        int n = cArray.length;
        if (l > (long)n) {
            return this.getZeroString();
        }
        return new Character(cArray[(int)l - 1]).toString();
    }

    protected void int2alphaCount(long l, char[] cArray, FastStringBuffer fastStringBuffer) {
        int n = cArray.length;
        char[] cArray2 = new char[cArray.length];
        int n2 = 0;
        while (n2 < cArray.length - 1) {
            cArray2[n2 + 1] = cArray[n2];
            ++n2;
        }
        cArray2[0] = cArray[n2];
        char[] cArray3 = new char[100];
        int n3 = cArray3.length - 1;
        int n4 = 1;
        long l2 = 0L;
        while ((n4 = (int)(l + (l2 = n4 == 0 || l2 != 0L && n4 == n - 1 ? (long)(n - 1) : 0L)) % n) != 0 || (l /= (long)n) != 0L) {
            cArray3[n3--] = cArray2[n4];
            if (l > 0L) continue;
        }
        fastStringBuffer.append(cArray3, n3 + 1, cArray3.length - n3 - 1);
    }

    protected String tradAlphaCount(long l, XResourceBundle xResourceBundle) {
        int n;
        char[] cArray;
        if (l > Long.MAX_VALUE) {
            this.error("ER_NUMBER_TOO_BIG");
            return "#error";
        }
        char[] cArray2 = null;
        int n2 = 1;
        char[] cArray3 = new char[100];
        int n3 = 0;
        int[] nArray = (int[])xResourceBundle.getObject("numberGroups");
        String[] stringArray = (String[])xResourceBundle.getObject("tables");
        String string = xResourceBundle.getString("numbering");
        if (string.equals("multiplicative-additive")) {
            String string2 = xResourceBundle.getString("multiplierOrder");
            long[] lArray = (long[])xResourceBundle.getObject("multiplier");
            cArray = (char[])xResourceBundle.getObject("zero");
            n = 0;
            while (n < lArray.length && l < lArray[n]) {
                ++n;
            }
            while (n < lArray.length) {
                if (l < lArray[n]) {
                    if (cArray.length == 0) {
                        ++n;
                    } else {
                        if (cArray3[n3 - 1] != cArray[0]) {
                            cArray3[n3++] = cArray[0];
                        }
                        ++n;
                    }
                } else if (l >= lArray[n]) {
                    long l2 = l / lArray[n];
                    l %= lArray[n];
                    for (int i = 0; i < nArray.length; ++i) {
                        n2 = 1;
                        if (l2 / (long)nArray[i] <= 0L) {
                            continue;
                        }
                        char[] cArray4 = (char[])xResourceBundle.getObject(stringArray[i]);
                        cArray2 = new char[cArray4.length + 1];
                        int n4 = 0;
                        while (n4 < cArray4.length) {
                            cArray2[n4 + 1] = cArray4[n4];
                            ++n4;
                        }
                        cArray2[0] = cArray4[n4 - 1];
                        n2 = (int)l2 / nArray[i];
                        if (n2 == 0 && l2 == 0L) break;
                        char c = ((char[])xResourceBundle.getObject("multiplierChar"))[n];
                        if (n2 < cArray2.length) {
                            if (string2.equals("precedes")) {
                                cArray3[n3++] = c;
                                cArray3[n3++] = cArray2[n2];
                                break;
                            }
                            if (n2 != 1 || n != lArray.length - 1) {
                                cArray3[n3++] = cArray2[n2];
                            }
                            cArray3[n3++] = c;
                            break;
                        }
                        return "#error";
                    }
                    ++n;
                }
                if (n < lArray.length) continue;
            }
        }
        int n5 = 0;
        while (n5 < nArray.length) {
            if (l / (long)nArray[n5] <= 0L) {
                ++n5;
                continue;
            }
            cArray = (char[])xResourceBundle.getObject(stringArray[n5]);
            cArray2 = new char[cArray.length + 1];
            n = 0;
            while (n < cArray.length) {
                cArray2[n + 1] = cArray[n];
                ++n;
            }
            cArray2[0] = cArray[n - 1];
            n2 = (int)l / nArray[n5];
            if (n2 == 0 && (l %= (long)nArray[n5]) == 0L) break;
            if (n2 >= cArray2.length) {
                return "#error";
            }
            cArray3[n3++] = cArray2[n2];
            ++n5;
        }
        return new String(cArray3, 0, n3);
    }

    protected String long2roman(long l, boolean bl) {
        if (l <= 0L) {
            return this.getZeroString();
        }
        String string = "";
        int n = 0;
        if (l <= 3999L) {
            while (true) {
                if (l >= ElemNumber.m_romanConvertTable[n].m_postValue) {
                    string = string + ElemNumber.m_romanConvertTable[n].m_postLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_postValue;
                    continue;
                }
                if (bl && l >= ElemNumber.m_romanConvertTable[n].m_preValue) {
                    string = string + ElemNumber.m_romanConvertTable[n].m_preLetter;
                    l -= ElemNumber.m_romanConvertTable[n].m_preValue;
                }
                ++n;
                if (l <= 0L) break;
            }
        } else {
            string = "#error";
        }
        return string;
    }

    public void callChildVisitors(XSLTVisitor xSLTVisitor, boolean bl) {
        if (bl) {
            if (null != this.m_countMatchPattern) {
                this.m_countMatchPattern.getExpression().callVisitors(this.m_countMatchPattern, xSLTVisitor);
            }
            if (null != this.m_fromMatchPattern) {
                this.m_fromMatchPattern.getExpression().callVisitors(this.m_fromMatchPattern, xSLTVisitor);
            }
            if (null != this.m_valueExpr) {
                this.m_valueExpr.getExpression().callVisitors(this.m_valueExpr, xSLTVisitor);
            }
            if (null != this.m_format_avt) {
                this.m_format_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_groupingSeparator_avt) {
                this.m_groupingSeparator_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_groupingSize_avt) {
                this.m_groupingSize_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_lang_avt) {
                this.m_lang_avt.callVisitors(xSLTVisitor);
            }
            if (null != this.m_lettervalue_avt) {
                this.m_lettervalue_avt.callVisitors(xSLTVisitor);
            }
        }
        super.callChildVisitors(xSLTVisitor, bl);
    }

    class NumberFormatStringTokenizer {
        private int currentPosition;
        private int maxPosition;
        private String str;

        public NumberFormatStringTokenizer(String string) {
            this.str = string;
            this.maxPosition = string.length();
        }

        public void reset() {
            this.currentPosition = 0;
        }

        public String nextToken() {
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            int n = this.currentPosition;
            while (this.currentPosition < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            if (n == this.currentPosition && !Character.isLetterOrDigit(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            return this.str.substring(n, this.currentPosition);
        }

        public boolean isLetterOrDigitAhead() {
            int n = this.currentPosition;
            while (n < this.maxPosition) {
                if (Character.isLetterOrDigit(this.str.charAt(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public boolean nextIsSep() {
            return !Character.isLetterOrDigit(this.str.charAt(this.currentPosition));
        }

        public boolean hasMoreTokens() {
            return this.currentPosition < this.maxPosition;
        }

        public int countTokens() {
            int n = 0;
            int n2 = this.currentPosition;
            while (n2 < this.maxPosition) {
                int n3 = n2;
                while (n2 < this.maxPosition && Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                if (n3 == n2 && !Character.isLetterOrDigit(this.str.charAt(n2))) {
                    ++n2;
                }
                ++n;
            }
            return n;
        }
    }

    private class MyPrefixResolver
    implements PrefixResolver {
        DTM dtm;
        int handle;
        boolean handleNullPrefix;

        public MyPrefixResolver(Node node, DTM dTM, int n, boolean bl) {
            this.dtm = dTM;
            this.handle = n;
            this.handleNullPrefix = bl;
        }

        public String getNamespaceForPrefix(String string) {
            return this.dtm.getNamespaceURI(this.handle);
        }

        public String getNamespaceForPrefix(String string, Node node) {
            return this.getNamespaceForPrefix(string);
        }

        public String getBaseIdentifier() {
            return ElemNumber.this.getBaseIdentifier();
        }

        public boolean handlesNullPrefixes() {
            return this.handleNullPrefix;
        }
    }
}

