/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.SAXException;

public class SerializerUtils {
    public static void addAttribute(SerializationHandler serializationHandler, int n) throws TransformerException {
        TransformerImpl transformerImpl = (TransformerImpl)serializationHandler.getTransformer();
        DTM dTM = transformerImpl.getXPathContext().getDTM(n);
        if (SerializerUtils.isDefinedNSDecl(serializationHandler, n, dTM)) {
            return;
        }
        String string = dTM.getNamespaceURI(n);
        if (string == null) {
            string = "";
        }
        try {
            serializationHandler.addAttribute(string, dTM.getLocalName(n), dTM.getNodeName(n), "CDATA", dTM.getNodeValue(n));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public static void addAttributes(SerializationHandler serializationHandler, int n) throws TransformerException {
        TransformerImpl transformerImpl = (TransformerImpl)serializationHandler.getTransformer();
        DTM dTM = transformerImpl.getXPathContext().getDTM(n);
        int n2 = dTM.getFirstAttribute(n);
        while (-1 != n2) {
            SerializerUtils.addAttribute(serializationHandler, n2);
            n2 = dTM.getNextAttribute(n2);
        }
    }

    public static void outputResultTreeFragment(SerializationHandler serializationHandler, XObject xObject, XPathContext xPathContext) throws SAXException {
        int n = xObject.rtf();
        DTM dTM = xPathContext.getDTM(n);
        if (null != dTM) {
            int n2 = dTM.getFirstChild(n);
            while (-1 != n2) {
                serializationHandler.flushPending();
                if (dTM.getNamespaceURI(n2) == null) {
                    serializationHandler.startPrefixMapping("", "");
                }
                dTM.dispatchToEvents(n2, serializationHandler);
                n2 = dTM.getNextSibling(n2);
            }
        }
    }

    public static void processNSDecls(SerializationHandler serializationHandler, int n, int n2, DTM dTM) throws TransformerException {
        try {
            if (n2 == 1) {
                int n3 = dTM.getFirstNamespaceNode(n, true);
                while (-1 != n3) {
                    String string = dTM.getNodeNameX(n3);
                    String string2 = serializationHandler.getNamespaceURIFromPrefix(string);
                    String string3 = dTM.getNodeValue(n3);
                    if (!string3.equalsIgnoreCase(string2)) {
                        serializationHandler.startPrefixMapping(string, string3, false);
                    }
                    n3 = dTM.getNextNamespaceNode(n, n3, true);
                }
            } else if (n2 == 13) {
                String string = dTM.getNodeNameX(n);
                String string4 = serializationHandler.getNamespaceURIFromPrefix(string);
                String string5 = dTM.getNodeValue(n);
                if (!string5.equalsIgnoreCase(string4)) {
                    serializationHandler.startPrefixMapping(string, string5, false);
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public static boolean isDefinedNSDecl(SerializationHandler serializationHandler, int n, DTM dTM) {
        String string;
        String string2;
        return 13 == dTM.getNodeType(n) && null != (string2 = serializationHandler.getNamespaceURIFromPrefix(string = dTM.getNodeNameX(n))) && string2.equals(dTM.getStringValue(n));
    }

    public static void ensureNamespaceDeclDeclared(SerializationHandler serializationHandler, DTM dTM, int n) throws SAXException {
        String string;
        NamespaceMappings namespaceMappings;
        String string2 = dTM.getNodeValue(n);
        String string3 = dTM.getNodeNameX(n);
        if (!(string2 == null || string2.length() <= 0 || null == string3 || (namespaceMappings = serializationHandler.getNamespaceMappings()) == null || null != (string = namespaceMappings.lookupNamespace(string3)) && string.equals(string2))) {
            serializationHandler.startPrefixMapping(string3, string2, false);
        }
    }
}

