/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.PooledConnection;
import org.apache.xalan.res.XSLMessages;

public class DefaultConnectionPool
implements ConnectionPool {
    private Driver m_Driver = null;
    private static final boolean DEBUG = false;
    private String m_driver = new String("");
    private String m_url = new String("");
    private int m_PoolMinSize = 1;
    private Properties m_ConnectionProtocol = new Properties();
    private Vector m_pool = new Vector();
    private boolean m_IsActive = false;
    static /* synthetic */ Class class$java$lang$Thread;

    public boolean isEnabled() {
        return this.m_IsActive;
    }

    public void setDriver(String string) {
        this.m_driver = string;
    }

    public void setURL(String string) {
        this.m_url = string;
    }

    public void freeUnused() {
        int n = 0;
        while (n < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (!pooledConnection.inUse()) {
                pooledConnection.close();
            }
            ++n;
        }
    }

    public boolean hasActiveConnections() {
        return this.m_pool.size() > 0;
    }

    public void setPassword(String string) {
        ((Hashtable)this.m_ConnectionProtocol).put("password", string);
    }

    public void setUser(String string) {
        ((Hashtable)this.m_ConnectionProtocol).put("user", string);
    }

    public void setProtocol(Properties properties) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Hashtable)this.m_ConnectionProtocol).put(string, properties.getProperty(string));
        }
    }

    public void setMinConnections(int n) {
        this.m_PoolMinSize = n;
    }

    public boolean testConnection() {
        try {
            Connection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            this.releaseConnection(connection);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized Connection getConnection() throws IllegalArgumentException, SQLException {
        PooledConnection pooledConnection = null;
        if (this.m_pool.size() < this.m_PoolMinSize) {
            this.initializePool();
        }
        int n = 0;
        while (n < this.m_pool.size()) {
            pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (!pooledConnection.inUse()) {
                pooledConnection.setInUse(true);
                return pooledConnection.getConnection();
            }
            ++n;
        }
        Connection connection = this.createConnection();
        pooledConnection = new PooledConnection(connection);
        pooledConnection.setInUse(true);
        this.m_pool.addElement(pooledConnection);
        return pooledConnection.getConnection();
    }

    public synchronized void releaseConnection(Connection connection) throws SQLException {
        int n = 0;
        while (n < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (pooledConnection.getConnection() == connection) {
                if (!this.isEnabled()) {
                    connection.close();
                    this.m_pool.removeElementAt(n);
                    break;
                }
                pooledConnection.setInUse(false);
                break;
            }
            ++n;
        }
    }

    public synchronized void releaseConnectionOnError(Connection connection) throws SQLException {
        int n = 0;
        while (n < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (pooledConnection.getConnection() == connection) {
                connection.close();
                this.m_pool.removeElementAt(n);
                break;
            }
            ++n;
        }
    }

    private Connection createConnection() throws SQLException {
        Connection connection = null;
        connection = this.m_Driver.connect(this.m_url, this.m_ConnectionProtocol);
        return connection;
    }

    public synchronized void initializePool() throws IllegalArgumentException, SQLException {
        Object object;
        Object object2;
        if (this.m_driver == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NO_DRIVER_NAME_SPECIFIED", null));
        }
        if (this.m_url == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_NO_URL_SPECIFIED", null));
        }
        if (this.m_PoolMinSize < 1) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_POOLSIZE_LESS_THAN_ONE", null));
        }
        try {
            object2 = null;
            try {
                object = (class$java$lang$Thread == null ? (class$java$lang$Thread = DefaultConnectionPool.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
                ClassLoader classLoader = (ClassLoader)((Method)object).invoke((Object)Thread.currentThread(), null);
                object2 = classLoader.loadClass(this.m_driver);
            }
            catch (Exception exception) {
                object2 = Class.forName(this.m_driver);
            }
            if (object2 == null) {
                object2 = Class.forName(this.m_driver);
            }
            this.m_Driver = (Driver)((Class)object2).newInstance();
            DriverManager.registerDriver(this.m_Driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_INVALID_DRIVER_NAME", null));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_INVALID_DRIVER_NAME", null));
        }
        if (!this.m_IsActive) {
            return;
        }
        do {
            if ((object2 = this.createConnection()) == null) continue;
            object = new PooledConnection((Connection)object2);
            this.addConnection((PooledConnection)object);
        } while (this.m_pool.size() < this.m_PoolMinSize);
    }

    private void addConnection(PooledConnection pooledConnection) {
        this.m_pool.addElement(pooledConnection);
    }

    protected void finalize() throws Throwable {
        int n = 0;
        while (n < this.m_pool.size()) {
            PooledConnection pooledConnection = (PooledConnection)this.m_pool.elementAt(n);
            if (!pooledConnection.inUse()) {
                pooledConnection.close();
            } else {
                try {
                    Thread.sleep(30000L);
                    pooledConnection.close();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n;
        }
        super.finalize();
    }

    public void setPoolEnabled(boolean bl) {
        this.m_IsActive = bl;
        if (!bl) {
            this.freeUnused();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

