/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;

public class ExsltDatetime {
    static final String dt = "yyyy-MM-dd'T'HH:mm:ss";
    static final String d = "yyyy-MM-dd";
    static final String gym = "yyyy-MM";
    static final String gy = "yyyy";
    static final String gmd = "--MM-dd";
    static final String gm = "--MM--";
    static final String gd = "---dd";
    static final String t = "HH:mm:ss";
    static final String EMPTY_STR = "";

    public static String dateTime() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dt);
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.format(date));
        int n = calendar.get(15) + calendar.get(16);
        if (n == 0) {
            stringBuffer.append("Z");
        } else {
            int n2 = n / 3600000;
            int n3 = n % 3600000;
            char c = n2 < 0 ? (char)'-' : '+';
            stringBuffer.append(c + ExsltDatetime.formatDigits(n2) + ':' + ExsltDatetime.formatDigits(n3));
        }
        return stringBuffer.toString();
    }

    private static String formatDigits(int n) {
        String string = String.valueOf(Math.abs(n));
        return string.length() == 1 ? '0' + string : string;
    }

    public static String date(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string3 == null || string4 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d};
        String string5 = d;
        Date date = ExsltDatetime.testFormats(string3, stringArray2);
        if (date == null) {
            return EMPTY_STR;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
        simpleDateFormat.setLenient(false);
        String string6 = simpleDateFormat.format(date);
        if (string6.length() == 0) {
            return EMPTY_STR;
        }
        return string2 + string6 + string4;
    }

    public static String date() {
        String string = ExsltDatetime.dateTime().toString();
        String string2 = string.substring(0, string.indexOf("T"));
        String string3 = string.substring(ExsltDatetime.getZoneStart(string));
        return string2 + string3;
    }

    public static String time(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string2 == null || string3 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d};
        String string4 = t;
        Date date = ExsltDatetime.testFormats(string2, stringArray2);
        if (date == null) {
            return EMPTY_STR;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
        String string5 = simpleDateFormat.format(date);
        return string5 + string3;
    }

    public static String time() {
        String string = ExsltDatetime.dateTime().toString();
        String string2 = string.substring(string.indexOf("T") + 1);
        String string3 = string.substring(ExsltDatetime.getZoneStart(string));
        return string2 + string3;
    }

    public static double year(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        boolean bl = stringArray[0].length() == 0;
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gy};
        double d = ExsltDatetime.getNumber(string2, stringArray2, 1);
        if (bl || d == Double.NaN) {
            return d;
        }
        return -d;
    }

    public static double year() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static double monthInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm, gmd};
        return ExsltDatetime.getNumber(string2, stringArray2, 2);
    }

    public static double monthInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2);
    }

    public static double weekInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 3);
    }

    public static double weekInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(3);
    }

    public static double dayInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 6);
    }

    public static double dayInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(6);
    }

    public static double dayInMonth(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        String[] stringArray2 = new String[]{dt, d, gmd, gd};
        double d = ExsltDatetime.getNumber(string2, stringArray2, 5);
        return d;
    }

    public static double dayInMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    public static double dayOfWeekInMonth(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 8);
    }

    public static double dayOfWeekInMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(8);
    }

    public static double dayInWeek(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, d};
        return ExsltDatetime.getNumber(string2, stringArray2, 7);
    }

    public static double dayInWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(7);
    }

    public static double hourInDay(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, t};
        return ExsltDatetime.getNumber(string2, stringArray2, 11);
    }

    public static double hourInDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    public static double minuteInHour(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, t};
        return ExsltDatetime.getNumber(string2, stringArray2, 12);
    }

    public static double minuteInHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(12);
    }

    public static double secondInMinute(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return Double.NaN;
        }
        String[] stringArray2 = new String[]{dt, t};
        return ExsltDatetime.getNumber(string2, stringArray2, 13);
    }

    public static double secondInMinute() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(13);
    }

    public static XObject leapYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d, gym, gy};
        double d = ExsltDatetime.getNumber(string2, stringArray2, 1);
        if (d == Double.NaN) {
            return new XNumber(Double.NaN);
        }
        int n = (int)d;
        return new XBoolean(n % 400 == 0 || n % 100 != 0 && n % 4 == 0);
    }

    public static boolean leapYear() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        return n % 400 == 0 || n % 100 != 0 && n % 4 == 0;
    }

    public static String monthName(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm};
        String string3 = "MMMM";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String monthName() {
        Calendar calendar = Calendar.getInstance();
        String string = "MMMM";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    public static String monthAbbreviation(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm};
        String string3 = "MMM";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String monthAbbreviation() {
        String string = "MMM";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    public static String dayName(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d};
        String string3 = "EEEE";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String dayName() {
        String string = "EEEE";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    public static String dayAbbreviation(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return EMPTY_STR;
        }
        String[] stringArray2 = new String[]{dt, d};
        String string3 = "EEE";
        return ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3);
    }

    public static String dayAbbreviation() {
        String string = "EEE";
        return ExsltDatetime.getNameOrAbbrev(string);
    }

    private static String[] getEraDatetimeZone(String string) {
        int n;
        String string2 = EMPTY_STR;
        String string3 = string;
        String string4 = EMPTY_STR;
        if (string.charAt(0) == '-' && !string.startsWith("--")) {
            string2 = "-";
            string3 = string.substring(1);
        }
        if ((n = ExsltDatetime.getZoneStart(string3)) > 0) {
            string4 = string3.substring(n);
            string3 = string3.substring(0, n);
        } else if (n == -2) {
            string4 = null;
        }
        return new String[]{string2, string3, string4};
    }

    private static int getZoneStart(String string) {
        if (string.indexOf("Z") == string.length() - 1) {
            return string.length() - 1;
        }
        if (string.length() >= 6 && string.charAt(string.length() - 3) == ':' && (string.charAt(string.length() - 6) == '+' || string.charAt(string.length() - 6) == '-')) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string.substring(string.length() - 5));
                return string.length() - 6;
            }
            catch (ParseException parseException) {
                System.out.println("ParseException " + parseException.getErrorOffset());
                return -2;
            }
        }
        return -1;
    }

    private static Date testFormats(String string, String[] stringArray) throws ParseException {
        int n = 0;
        while (n < stringArray.length) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[n]);
                simpleDateFormat.setLenient(false);
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                ++n;
            }
        }
        return null;
    }

    private static double getNumber(String string, String[] stringArray, int n) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        Date date = ExsltDatetime.testFormats(string, stringArray);
        if (date == null) {
            return Double.NaN;
        }
        calendar.setTime(date);
        return calendar.get(n);
    }

    private static String getNameOrAbbrev(String string, String[] stringArray, String string2) throws ParseException {
        int n = 0;
        while (n < stringArray.length) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[n]);
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string);
                simpleDateFormat.applyPattern(string2);
                return simpleDateFormat.format(date);
            }
            catch (ParseException parseException) {
                ++n;
            }
        }
        return EMPTY_STR;
    }

    private static String getNameOrAbbrev(String string) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    /*
     * Unable to fully structure code
     */
    public static String formatDate(String var0, String var1_1) {
        if (var0.endsWith("Z") || var0.endsWith("z")) {
            var5_2 = TimeZone.getTimeZone("GMT");
            var0 = var0.substring(0, var0.length() - 1) + "GMT";
            var6_3 = "z";
        } else if (var0.length() >= 6 && var0.charAt(var0.length() - 3) == ':' && (var0.charAt(var0.length() - 6) == '+' || var0.charAt(var0.length() - 6) == '-')) {
            var7_4 = var0.substring(var0.length() - 6);
            var5_2 = "+00:00".equals(var7_4) != false || "-00:00".equals(var7_4) != false ? TimeZone.getTimeZone("GMT") : TimeZone.getTimeZone("GMT" + (String)var7_4);
            var6_3 = "z";
            var0 = var0.substring(0, var0.length() - 6) + "GMT" + (String)var7_4;
        } else {
            var5_2 = TimeZone.getDefault();
            var6_3 = "";
        }
        var7_4 = new String[]{"yyyy-MM-dd'T'HH:mm:ss" + var6_3, "yyyy-MM-dd", "yyyy-MM", "yyyy"};
        try {
            var8_5 = new SimpleDateFormat("HH:mm:ss" + var6_3);
            var8_5.setLenient(false);
            var9_8 = var8_5.parse(var0);
            var10_17 = new SimpleDateFormat(ExsltDatetime.strip("GyMdDEFwW", var1_1));
            var10_17.setTimeZone(var5_2);
            return var10_17.format(var9_8);
        }
        catch (ParseException var8_6) {
            var8_7 = 0;
            ** while (var8_7 < var7_4.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                var9_10 = new SimpleDateFormat(var7_4[var8_7]);
                var9_10.setLenient(false);
                var10_18 = var9_10.parse(var0);
                var11_22 = new SimpleDateFormat(var1_1);
                var11_22.setTimeZone(var5_2);
                return var11_22.format(var10_18);
            }
            catch (ParseException var9_9) {
                ++var8_7;
            }
            continue;
        }
lbl35:
        // 1 sources

        try {
            var9_11 = new SimpleDateFormat("--MM-dd");
            var9_11.setLenient(false);
            var10_19 = var9_11.parse(var0);
            var11_23 = new SimpleDateFormat(ExsltDatetime.strip("Gy", var1_1));
            var11_23.setTimeZone(var5_2);
            return var11_23.format(var10_19);
        }
        catch (ParseException var9_12) {
            try {
                var9_13 = new SimpleDateFormat("--MM--");
                var9_13.setLenient(false);
                var10_20 = var9_13.parse(var0);
                var11_24 = new SimpleDateFormat(ExsltDatetime.strip("Gy", var1_1));
                var11_24.setTimeZone(var5_2);
                return var11_24.format(var10_20);
            }
            catch (ParseException var9_14) {
                try {
                    var9_15 = new SimpleDateFormat("---dd");
                    var9_15.setLenient(false);
                    var10_21 = var9_15.parse(var0);
                    var11_25 = new SimpleDateFormat(ExsltDatetime.strip("GyM", var1_1));
                    var11_25.setTimeZone(var5_2);
                    return var11_25.format(var10_21);
                }
                catch (ParseException var9_16) {
                    return "";
                }
            }
        }
    }

    private static String strip(String string, String string2) {
        boolean bl = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (c == '\'') {
                int n2 = string2.indexOf(39, n + 1);
                if (n2 == -1) {
                    n2 = string2.length();
                }
                stringBuffer.append(string2.substring(n, n2));
                n = n2++;
                continue;
            }
            if (string.indexOf(c) > -1) {
                ++n;
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }
}

