/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.internal.VersionHelper;
import javax.naming.spi.ContinuationContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.Resolver;

public class NamingManager {
    private static ObjectFactoryBuilder factory_builder = null;
    private static Hashtable factories = new Hashtable(11);
    private static boolean debug = true;
    private static VersionHelper helper = VersionHelper.getVersionHelper();
    private static final String defaultPkgPrefix = "com.sun.jndi.url";
    static InitialContextFactoryBuilder initctx_factory_builder = null;

    NamingManager() {
    }

    static Object createObjectFromFactories(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        String string = null;
        if (hashtable == null || (string = (String)hashtable.get("java.naming.factory.object")) == null) {
            try {
                string = helper.getJndiProperty(1);
            }
            catch (SecurityException securityException) {}
        }
        if (string == null) {
            return null;
        }
        ObjectFactory objectFactory = null;
        Object object2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (object2 == null && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                objectFactory = (ObjectFactory)helper.loadClass(string2).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        return object2;
    }

    static ObjectFactory findObjectFactoryFromReference(Reference reference, String string) throws Exception {
        String string2;
        ObjectFactory objectFactory = null;
        objectFactory = (ObjectFactory)factories.get(string);
        if (objectFactory != null) {
            return objectFactory;
        }
        try {
            objectFactory = (ObjectFactory)helper.loadClass(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (objectFactory == null && (string2 = reference.getFactoryClassLocation()) != null) {
            objectFactory = NamingManager.loadFactoryFromURL(string, string2);
        }
        if (objectFactory != null) {
            factories.put(string, objectFactory);
        }
        return objectFactory;
    }

    static Context getContext(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        Object object2;
        if (object instanceof Context) {
            return (Context)object;
        }
        try {
            object2 = NamingManager.getObjectInstance(object, name, context, hashtable);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
        return object2 instanceof Context ? (Context)object2 : null;
    }

    public static Context getContinuationContext(CannotProceedException cannotProceedException) throws NamingException {
        ContinuationContext continuationContext = new ContinuationContext(cannotProceedException);
        return continuationContext.getTargetContext();
    }

    static InitialContextFactory getDefaultInitialContextFactory(Hashtable hashtable) throws NamingException {
        InitialContextFactory initialContextFactory = null;
        String string = null;
        if (hashtable == null || (string = (String)hashtable.get("java.naming.factory.initial")) == null) {
            try {
                string = helper.getJndiProperty(0);
            }
            catch (SecurityException securityException) {}
        }
        if (string == null) {
            NoInitialContextException noInitialContextException = new NoInitialContextException("Need to specify class name in environment or system property: java.naming.factory.initial");
            throw noInitialContextException;
        }
        try {
            initialContextFactory = (InitialContextFactory)helper.loadClass(string).newInstance();
        }
        catch (Exception exception) {
            NoInitialContextException noInitialContextException = new NoInitialContextException("Cannot instantiate class: " + string);
            noInitialContextException.setRootCause(exception);
            throw noInitialContextException;
        }
        return initialContextFactory;
    }

    public static Context getInitialContext(Hashtable hashtable) throws NamingException {
        InitialContextFactory initialContextFactory = null;
        InitialContextFactoryBuilder initialContextFactoryBuilder = NamingManager.getInitialContextFactoryBuilder();
        initialContextFactory = initialContextFactoryBuilder != null ? initialContextFactoryBuilder.createInitialContextFactory(hashtable) : NamingManager.getDefaultInitialContextFactory(hashtable);
        return initialContextFactory.getInitialContext(hashtable);
    }

    static synchronized InitialContextFactoryBuilder getInitialContextFactoryBuilder() {
        return initctx_factory_builder;
    }

    static synchronized ObjectFactoryBuilder getObjectFactoryBuilder() {
        return factory_builder;
    }

    public static Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        String[] stringArray;
        String string;
        String string2;
        ObjectFactoryBuilder objectFactoryBuilder = NamingManager.getObjectFactoryBuilder();
        if (objectFactoryBuilder != null) {
            ObjectFactory objectFactory = objectFactoryBuilder.createObjectFactory(object, hashtable);
            return objectFactory.getObjectInstance(object, name, context, hashtable);
        }
        Reference reference = null;
        if (object instanceof Reference) {
            reference = (Reference)object;
        } else if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (reference != null && (string2 = reference.getFactoryClassName()) != null) {
            ObjectFactory objectFactory = NamingManager.findObjectFactoryFromReference(reference, string2);
            if (objectFactory != null) {
                return objectFactory.getObjectInstance(reference, name, context, hashtable);
            }
            return object;
        }
        Object object2 = null;
        if (object instanceof String && (string = NamingManager.getURLScheme((String)(stringArray = (String[])object))) != null && (object2 = NamingManager.getURLObject(string, object, hashtable)) != null) {
            return object2;
        }
        if (object instanceof String[]) {
            stringArray = (String[])object;
            int n = 0;
            while (n < stringArray.length) {
                String string3 = NamingManager.getURLScheme(stringArray[n]);
                if (string3 != null && (object2 = NamingManager.getURLObject(string3, object, hashtable)) != null) {
                    return object2;
                }
                ++n;
            }
        }
        if ((object2 = NamingManager.createObjectFromFactories(object, name, context, hashtable)) == null) {
            return object;
        }
        return object2;
    }

    private static String getPkgPrefixes(Hashtable hashtable) {
        String string = null;
        if (hashtable != null) {
            string = (String)hashtable.get("java.naming.factory.url.pkgs");
        }
        if (string == null) {
            try {
                string = helper.getJndiProperty(2);
            }
            catch (SecurityException securityException) {}
        }
        string = string != null ? String.valueOf(string) + ":com.sun.jndi.url" : defaultPkgPrefix;
        return string;
    }

    static Resolver getResolver(Object object, Name name, Context context, Hashtable hashtable) throws NamingException {
        Object object2;
        if (object instanceof Resolver) {
            return (Resolver)object;
        }
        try {
            object2 = NamingManager.getObjectInstance(object, name, context, hashtable);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
        return object2 instanceof Resolver ? (Resolver)object2 : null;
    }

    public static Context getURLContext(String string, Hashtable hashtable) throws NamingException {
        Object object = NamingManager.getURLObject(string, null, hashtable);
        if (object instanceof Context) {
            return (Context)object;
        }
        return null;
    }

    private static Object getURLObject(String string, Object object, Hashtable hashtable) throws NamingException {
        Object object2;
        ObjectFactory objectFactory = null;
        String string2 = String.valueOf(string) + "URLContextFactory";
        String string3 = NamingManager.getPkgPrefixes(hashtable);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
        while (objectFactory == null && stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken().trim();
            String string4 = String.valueOf(object2) + "." + string + "." + string2;
            objectFactory = (ObjectFactory)factories.get(string4);
            if (objectFactory != null) continue;
            try {
                objectFactory = (ObjectFactory)helper.loadClass(string4).newInstance();
                factories.put(string4, objectFactory);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                NamingException namingException = new NamingException("Cannot get URL Context for " + string);
                namingException.setRootCause(illegalAccessException);
                throw namingException;
            }
            catch (InstantiationException instantiationException) {
                NamingException namingException = new NamingException("Cannot get URL Context for " + string);
                namingException.setRootCause(instantiationException);
                throw namingException;
            }
            catch (Exception exception) {}
        }
        if (objectFactory == null) {
            return null;
        }
        try {
            object2 = objectFactory.getObjectInstance(object, null, null, hashtable);
        }
        catch (Exception exception) {
            if (!(exception instanceof NamingException)) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(exception);
                throw namingException;
            }
            throw (NamingException)exception;
        }
        return object2;
    }

    static String getURLScheme(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            return string.substring(0, n);
        }
        return null;
    }

    public static synchronized boolean hasInitialContextFactoryBuilder() {
        return initctx_factory_builder != null;
    }

    private static ObjectFactory loadFactoryFromURL(String string, String string2) throws Exception {
        try {
            Class clazz = helper.loadClass(string, string2);
            ObjectFactory objectFactory = (ObjectFactory)clazz.newInstance();
            factories.put(string, objectFactory);
            return objectFactory;
        }
        catch (MalformedURLException malformedURLException) {
            if (debug) {
                System.err.println("MalformedURLException when loading factory from URL: " + string2);
            }
            throw malformedURLException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug) {
                System.err.println("ClassNotFoundException when loading factory from URL: " + string);
            }
            throw classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (debug) {
                System.err.println("IllegalAccessException when loading factory from URL: " + string);
            }
            throw illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            if (debug) {
                System.err.println("InstantiationException when loading factory from URL: " + string);
            }
            throw instantiationException;
        }
    }

    public static synchronized void setInitialContextFactoryBuilder(InitialContextFactoryBuilder initialContextFactoryBuilder) throws NamingException {
        if (initctx_factory_builder != null) {
            throw new IllegalStateException("InitialContextFactoryBuilder already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        initctx_factory_builder = initialContextFactoryBuilder;
    }

    public static synchronized void setObjectFactoryBuilder(ObjectFactoryBuilder objectFactoryBuilder) throws NamingException {
        if (factory_builder != null) {
            throw new IllegalStateException("ObjectFactoryBuilder already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory_builder = objectFactoryBuilder;
    }
}

