/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.internal.VersionHelper;
import javax.naming.spi.NamingManager;

public class InitialContext
implements Context {
    private static VersionHelper helper = VersionHelper.getVersionHelper();
    protected Hashtable myProps = null;
    protected Context defaultInitCtx = null;
    protected boolean gotDefault = false;

    public InitialContext() throws NamingException {
        this(null);
    }

    public InitialContext(Hashtable hashtable) throws NamingException {
        if (hashtable != null) {
            this.myProps = (Hashtable)hashtable.clone();
        }
        if (hashtable == null || hashtable.get("java.naming.factory.initial") == null) {
            try {
                if (helper.getJndiProperty(0) == null) {
                    return;
                }
            }
            catch (SecurityException securityException) {
                return;
            }
        }
        this.getDefaultInitCtx();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myProps == null) {
            this.myProps = new Hashtable();
        }
        this.myProps.put(string, object);
        return this.getDefaultInitCtx().addToEnvironment(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).bind(string, object);
    }

    public void bind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, object);
    }

    public void close() throws NamingException {
        this.myProps = null;
        if (this.defaultInitCtx != null) {
            this.defaultInitCtx.close();
            this.defaultInitCtx = null;
        }
        this.gotDefault = false;
    }

    public String composeName(String string, String string2) throws NamingException {
        return string;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return (Name)name.clone();
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).createSubcontext(string);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).destroySubcontext(string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        if (this.defaultInitCtx == null) {
            throw new NoInitialContextException();
        }
        return this.defaultInitCtx;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.getDefaultInitCtx().getEnvironment();
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).getNameParser(string);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    protected Context getURLOrDefaultInitCtx(String string) throws NamingException {
        Context context;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        String string2 = InitialContext.getURLScheme(string);
        if (string2 != null && (context = NamingManager.getURLContext(string2, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        Context context;
        String string;
        String string2;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        if (name.size() > 0 && (string2 = InitialContext.getURLScheme(string = name.get(0))) != null && (context = NamingManager.getURLContext(string2, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    private static String getURLScheme(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            return string.substring(0, n);
        }
        return null;
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).list(string);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).listBindings(string);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    public Object lookup(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookup(string);
    }

    public Object lookup(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.getURLOrDefaultInitCtx(string).lookupLink(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rebind(string, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myProps != null) {
            this.myProps.remove(string);
        }
        return this.getDefaultInitCtx().removeFromEnvironment(string);
    }

    public void rename(String string, String string2) throws NamingException {
        this.getURLOrDefaultInitCtx(string).rename(string, string2);
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rename(name, name2);
    }

    public void unbind(String string) throws NamingException {
        this.getURLOrDefaultInitCtx(string).unbind(string);
    }

    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }
}

