/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.url.ldap.ldapURLContext;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;

public final class ldapURLContextFactory
implements ObjectFactory {
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null) {
            return new ldapURLContext(hashtable);
        }
        if (object instanceof String) {
            return ldapURLContextFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return ldapURLContextFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new IllegalArgumentException("ldapURLContextFactory.getObjectInstance: argument must be an LDAP URL String or array of them");
    }

    private static DirContext getUsingURL(String string, Hashtable hashtable) throws NamingException {
        if (!string.startsWith("ldap://")) {
            throw new ConfigurationException("Unsupported URL scheme: " + string);
        }
        int n = string.indexOf("://") + 3;
        int n2 = string.indexOf(58, n);
        int n3 = string.indexOf(47, n);
        int n4 = string.indexOf(63, n);
        String string2 = n3 < 0 ? "" : (n4 < 0 ? string.substring(n3 + 1) : string.substring(n3 + 1, n4));
        LdapCtx ldapCtx = null;
        if (n2 >= 0 && (n2 < n3 || n3 < 0)) {
            String string3 = string.substring(n, n2);
            int n5 = n3 < 0 ? string.length() : n3;
            int n6 = Integer.parseInt(string.substring(n2 + 1, n5));
            ldapCtx = new LdapCtx(string2, string3, n6, null, null, hashtable);
        } else {
            String string4 = n3 < 0 ? string.substring(n) : string.substring(n, n3);
            ldapCtx = new LdapCtx(string2, string4, 0, null, null, hashtable);
        }
        return ldapCtx;
    }

    static ResolveResult getUsingURLIgnoreRootDN(String string, Hashtable hashtable) throws NamingException {
        if (!string.startsWith("ldap://")) {
            throw new ConfigurationException("Unsupported URL scheme: " + string);
        }
        int n = string.indexOf("://") + 3;
        int n2 = string.indexOf(58, n);
        int n3 = string.indexOf(47, n);
        int n4 = string.indexOf(63, n);
        String string2 = n3 < 0 ? "" : (n4 < 0 ? string.substring(n3 + 1) : string.substring(n3 + 1, n4));
        LdapCtx ldapCtx = null;
        if (n2 >= 0 && (n2 < n3 || n3 < 0)) {
            String string3 = string.substring(n, n2);
            int n5 = n3 < 0 ? string.length() : n3;
            int n6 = Integer.parseInt(string.substring(n2 + 1, n5));
            ldapCtx = new LdapCtx("", string3, n6, null, null, hashtable);
        } else {
            String string4 = n3 < 0 ? string.substring(n) : string.substring(n, n3);
            ldapCtx = new LdapCtx("", string4, 0, null, null, hashtable);
        }
        return new ResolveResult((Object)ldapCtx, string2);
    }

    private static DirContext getUsingURLs(String[] stringArray, Hashtable hashtable) throws NamingException {
        NamingException namingException = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                return ldapURLContextFactory.getUsingURL(stringArray[n], hashtable);
            }
            catch (NamingException namingException2) {
                namingException = namingException2;
                ++n;
            }
        }
        throw namingException;
    }
}

