/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit;

import com.sun.jndi.toolkit.DirSearch;
import com.sun.jndi.toolkit.HierarchicalName;
import com.sun.jndi.toolkit.HierarchicalNameParser;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;

public class HierMemDirCtx
implements DirContext {
    private static final boolean debug = false;
    protected Hashtable myEnv;
    protected Hashtable bindings;
    static NameParser myParser;
    protected Attributes attrs;
    protected boolean ignoreCase = false;

    public HierMemDirCtx() {
        this.Initialize();
    }

    public HierMemDirCtx(Hashtable hashtable, boolean bl) {
        this.myEnv = this.myEnv != null ? (Hashtable)hashtable.clone() : null;
        this.ignoreCase = bl;
        this.Initialize();
    }

    public HierMemDirCtx(boolean bl) {
        this(null, bl);
    }

    private void Initialize() {
        this.attrs = new BasicAttributes(this.ignoreCase);
        myParser = new HierarchicalNameParser();
        this.bindings = new Hashtable();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(11, 0.75f);
        }
        return this.myEnv.put(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(myParser.parse(string), object);
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.bind(myParser.parse(string), object, attributes);
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(this.getInternalName(name));
        hierMemDirCtx.doBind(this.getLeafName(name), object);
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.bind(name, object);
        this.modifyAttributes(name, 1, attributes);
    }

    protected Name canonizeName(Name name) throws NamingException {
        Name name2 = name;
        if (!(name instanceof HierarchicalName)) {
            name2 = new HierarchicalName();
            int n = name.size();
            int n2 = 0;
            while (n2 < n) {
                name2.add(n2, name.get(n2));
                ++n2;
            }
        }
        return name2;
    }

    public void close() throws NamingException {
        this.myEnv = null;
        this.bindings = null;
        this.attrs = null;
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name = this.canonizeName(name);
        name2 = this.canonizeName(name2);
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    protected HierMemDirCtx createNewCtx() throws NamingException {
        return new HierMemDirCtx(this.myEnv, this.ignoreCase);
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(myParser.parse(string));
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        return this.createSubcontext(myParser.parse(string), attributes);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(this.getInternalName(name));
        return hierMemDirCtx.doCreateSubcontext(this.getLeafName(name), attributes);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(myParser.parse(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(this.getInternalName(name));
        hierMemDirCtx.doDestroySubcontext(this.getLeafName(name));
    }

    protected void doBind(Name name, Object object) throws NamingException {
        if (this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        if (!(object instanceof HierMemDirCtx)) {
            throw new SchemaViolationException("This context only supports binding objects of it's own kind");
        }
        this.bindings.put(name, object);
    }

    protected DirContext doCreateSubcontext(Name name, Attributes attributes) throws NamingException {
        if (this.bindings.get(name = this.canonizeName(name)) != null) {
            throw new NameAlreadyBoundException("an object with that name already exists");
        }
        HierMemDirCtx hierMemDirCtx = this.createNewCtx();
        this.bindings.put(name, hierMemDirCtx);
        if (attributes != null) {
            hierMemDirCtx.modifyAttributes("", 1, attributes);
        }
        return hierMemDirCtx;
    }

    protected void doDestroySubcontext(Name name) throws NamingException {
        name = this.canonizeName(name);
        this.bindings.remove(name);
    }

    protected Attributes doGetAttributes() throws NamingException {
        return (Attributes)this.attrs.clone();
    }

    protected Attributes doGetAttributes(String[] stringArray) throws NamingException {
        if (stringArray == null) {
            return this.doGetAttributes();
        }
        BasicAttributes basicAttributes = new BasicAttributes(this.ignoreCase);
        Attribute attribute = null;
        int n = 0;
        while (n < Array.getLength(stringArray)) {
            attribute = this.attrs.get(stringArray[n]);
            if (attribute != null) {
                basicAttributes.put(attribute);
            }
            ++n;
        }
        return basicAttributes;
    }

    protected NamingEnumeration doList() throws NamingException {
        return new FlatNames(this.bindings.keys());
    }

    protected NamingEnumeration doListBindings() throws NamingException {
        return new FlatBindings(this.bindings.keys());
    }

    protected void doModifyAttributes(ModificationItem[] modificationItemArray) throws NamingException {
        int n = 0;
        while (n < modificationItemArray.length) {
            ModificationItem modificationItem = modificationItemArray[n];
            switch (modificationItem.getModificationOp()) {
                case 1: {
                    if (this.attrs.get(modificationItem.getAttribute().getID()) == null) {
                        this.attrs.put(modificationItem.getAttribute());
                        break;
                    }
                    AttributeModificationException attributeModificationException = new AttributeModificationException("attribute already exists");
                    ModificationItem[] modificationItemArray2 = new ModificationItem[modificationItemArray.length - n];
                    System.arraycopy(modificationItemArray, n, modificationItemArray2, 0, modificationItemArray2.length);
                    attributeModificationException.setUnexecutedModifications(modificationItemArray2);
                    throw attributeModificationException;
                }
                case 2: {
                    this.attrs.put(modificationItem.getAttribute());
                    break;
                }
                case 3: {
                    this.attrs.remove(modificationItem.getAttribute().getID());
                    break;
                }
                default: {
                    throw new AttributeModificationException("Unknown mod_op");
                }
            }
            ++n;
        }
    }

    protected void doRebind(Name name, Object object) throws NamingException {
        if (!(object instanceof HierMemDirCtx)) {
            throw new SchemaViolationException("This context only supports binding objects of it's own kind");
        }
        this.bindings.put(name, object);
    }

    protected void doRename(Name name, Name name2) throws NamingException {
        name = this.canonizeName(name);
        if (this.bindings.get(name2 = this.canonizeName(name2)) != null) {
            throw new NameAlreadyBoundException(String.valueOf(String.valueOf(name2)) + " is already bound");
        }
        Object v = this.bindings.remove(name);
        if (v == null) {
            throw new NameNotFoundException(String.valueOf(String.valueOf(name)) + " not bound");
        }
        this.bindings.put(name2, v);
    }

    protected void doUnbind(Name name) throws NamingException {
        this.bindings.remove(name);
    }

    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes(myParser.parse(string));
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        return this.getAttributes(myParser.parse(string), stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(name);
        return hierMemDirCtx.doGetAttributes();
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(name);
        return hierMemDirCtx.doGetAttributes(stringArray);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.myEnv;
    }

    protected Name getInternalName(Name name) throws NamingException {
        return name.getPrefix(name.size() - 1);
    }

    protected Name getLeafName(Name name) throws NamingException {
        return name.getSuffix(name.size() - 1);
    }

    public NameParser getNameParser(String string) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return myParser;
    }

    public DirContext getSchema(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(myParser.parse(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(name);
        return hierMemDirCtx.doList();
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(myParser.parse(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(name);
        return hierMemDirCtx.doListBindings();
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(myParser.parse(string));
    }

    public Object lookup(Name name) throws NamingException {
        Object object = null;
        name = this.canonizeName(name);
        switch (name.size()) {
            case 0: {
                object = this;
                break;
            }
            case 1: {
                object = this.bindings.get(name);
                break;
            }
            default: {
                HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.bindings.get(name.getPrefix(1));
                object = hierMemDirCtx == null ? null : hierMemDirCtx.lookup(name.getSuffix(1));
            }
        }
        if (object == null) {
            throw new NameNotFoundException(name.toString());
        }
        return object;
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(myParser.parse(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(myParser.parse(string), n, attributes);
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(myParser.parse(string), modificationItemArray);
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        if (attributes == null || attributes.size() == 0) {
            throw new IllegalArgumentException("Cannot modify without an attribute");
        }
        NamingEnumeration namingEnumeration = attributes.getAll();
        ModificationItem[] modificationItemArray = new ModificationItem[attributes.size()];
        int n2 = 0;
        while (n2 < modificationItemArray.length && namingEnumeration.hasMoreElements()) {
            modificationItemArray[n2] = new ModificationItem(n, (Attribute)namingEnumeration.next());
            ++n2;
        }
        this.modifyAttributes(name, modificationItemArray);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(name);
        hierMemDirCtx.doModifyAttributes(modificationItemArray);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(myParser.parse(string), object);
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.rebind(myParser.parse(string), object, attributes);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot rebind empty name");
        }
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(this.getInternalName(name));
        hierMemDirCtx.doRebind(this.getLeafName(name), object);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.rebind(name, object);
        this.modifyAttributes(name, 1, attributes);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename(myParser.parse(string), myParser.parse(string2));
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name2.isEmpty() || name.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (this.getInternalName(name2).equals(this.getInternalName(name))) {
            throw new InvalidNameException("Cannot rename across contexts");
        }
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(this.getInternalName(name2));
        hierMemDirCtx.doRename(name, name2);
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        return this.search(myParser.parse(string), string2, searchControls);
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search(myParser.parse(string), string2, objectArray, searchControls);
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        return this.search(myParser.parse(string), attributes);
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return this.search(myParser.parse(string), attributes, stringArray);
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        DirContext dirContext = (DirContext)this.lookup(name);
        return DirSearch.search(dirContext, string, searchControls);
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        DirContext dirContext = (DirContext)this.lookup(name);
        return DirSearch.search(dirContext, string, objectArray, searchControls);
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        DirContext dirContext = (DirContext)this.lookup(name);
        return DirSearch.search(dirContext, attributes);
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        DirContext dirContext = (DirContext)this.lookup(name);
        return DirSearch.search(dirContext, attributes, stringArray);
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void setNameParser(NameParser nameParser) {
        myParser = nameParser;
    }

    public void unbind(String string) throws NamingException {
        this.unbind(myParser.parse(string));
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        HierMemDirCtx hierMemDirCtx = (HierMemDirCtx)this.lookup(this.getInternalName(name));
        hierMemDirCtx.doUnbind(this.getLeafName(name));
    }

    class FlatNames
    implements NamingEnumeration {
        Enumeration names;

        FlatNames(Enumeration enumeration) {
            this.names = enumeration;
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            Name name = (Name)this.names.nextElement();
            String string = HierMemDirCtx.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name.toString(), string);
        }
    }

    class FlatBindings
    implements NamingEnumeration {
        Enumeration names;

        FlatBindings(Enumeration enumeration) {
            this.names = enumeration;
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            Name name = (Name)this.names.nextElement();
            return new Binding(name.toString(), HierMemDirCtx.this.bindings.get(name));
        }
    }
}

