/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.CLObjectInputStream;
import com.sun.jndi.ldap.LdapCtxFactory;
import com.sun.jndi.misc.BASE64Decoder;
import com.sun.jndi.misc.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.SchemaViolationException;

final class Obj {
    static final String[] JAVA_ATTRIBUTES = new String[]{"objectClass", "javaSerializedData", "javaClassName", "javaFactory", "javaCodeBase", "javaReferenceAddress", "javaRemoteLocation"};
    static final int OBJECT_CLASS = 0;
    static final int SERIALIZED_DATA = 1;
    static final int CLASSNAME = 2;
    static final int FACTORY = 3;
    static final int CODEBASE = 4;
    static final int REF_ADDR = 5;
    static final int REMOTE_LOC = 6;
    static final String[] JAVA_OBJECT_CLASSES = new String[]{"javaContainer", "javaObject", "javaNamingReference", "javaSerializedObject", "javaRemoteObject"};
    static final int STRUCTURAL = 0;
    static final int BASE_OBJECT = 1;
    static final int REF_OBJECT = 2;
    static final int SER_OBJECT = 3;
    static final int REMOTE_OBJECT = 4;
    private static Class remoteClass = null;

    static {
        try {
            remoteClass = Class.forName("java.rmi.Remote");
        }
        catch (Exception exception) {}
    }

    Obj() {
    }

    static Object decodeObject(Attributes attributes) throws NamingException {
        Attribute attribute = attributes.get(JAVA_ATTRIBUTES[4]);
        String string = attribute != null ? (String)attribute.get() : null;
        try {
            attribute = attributes.get(JAVA_ATTRIBUTES[1]);
            if (attribute != null) {
                ClassLoader classLoader = string != null ? LdapCtxFactory.helper.getURLClassLoader(string) : null;
                return Obj.deserializeObject((byte[])attribute.get(), classLoader);
            }
            attribute = attributes.get(JAVA_ATTRIBUTES[6]);
            if (attribute != null) {
                return Obj.decodeRmiObject((String)attribute.get(), string);
            }
            return Obj.decodeReference(attributes, string);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    private static Reference decodeReference(Attributes attributes, String string) throws NamingException, IOException {
        if (attributes == null) {
            return null;
        }
        String string2 = null;
        Attribute attribute = attributes.get(JAVA_ATTRIBUTES[2]);
        if (attribute == null) {
            throw new InvalidAttributesException(String.valueOf(JAVA_ATTRIBUTES[2]) + " attribute is required");
        }
        String string3 = (String)attribute.get();
        attribute = attributes.get(JAVA_ATTRIBUTES[3]);
        if (attribute != null) {
            string2 = (String)attribute.get();
        }
        Reference reference = new Reference(string3, string2, string);
        attribute = attributes.get(JAVA_ATTRIBUTES[5]);
        if (attribute != null) {
            BASE64Decoder bASE64Decoder = null;
            ClassLoader classLoader = string != null ? LdapCtxFactory.helper.getURLClassLoader(string) : null;
            NamingEnumeration namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                int n;
                int n2;
                String string4 = (String)namingEnumeration.next();
                if (string4.length() == 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "empty attribute value");
                }
                char c = string4.charAt(0);
                int n3 = string4.indexOf(c, n2 = 1);
                if (n3 < 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "separator '" + c + "'" + "not found");
                }
                String string5 = string4.substring(n2, n3);
                if (string5 == null) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "empty RefAddr position");
                }
                try {
                    n = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "RefAddr position not an integer");
                }
                n2 = n3 + 1;
                n3 = string4.indexOf(c, n2);
                if (n3 < 0) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "RefAddr type not found");
                }
                String string6 = string4.substring(n2, n3);
                if (string6 == null) {
                    throw new InvalidAttributeValueException("malformed " + JAVA_ATTRIBUTES[5] + " attribute - " + "empty RefAddr type");
                }
                n2 = n3 + 1;
                if (n2 == string4.length()) {
                    reference.add(n, new StringRefAddr(string6, null));
                    continue;
                }
                if (string4.charAt(n2) == c) {
                    ++n2;
                    if (bASE64Decoder == null) {
                        bASE64Decoder = new BASE64Decoder();
                    }
                    RefAddr refAddr = (RefAddr)Obj.deserializeObject(bASE64Decoder.decodeBuffer(string4.substring(n2)), classLoader);
                    reference.add(n, refAddr);
                    continue;
                }
                reference.add(n, new StringRefAddr(string6, string4.substring(n2)));
            }
        }
        return reference;
    }

    private static Object decodeRmiObject(String string, String string2) throws NamingException {
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserializeObject(byte[] byArray, ClassLoader classLoader) throws NamingException {
        try {
            Object object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = classLoader == null ? new ObjectInputStream(byteArrayInputStream) : new CLObjectInputStream(byteArrayInputStream, classLoader);
            try {
                try {
                    object = objectInputStream.readObject();
                    Object var6_7 = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NamingException namingException = new NamingException();
                    namingException.setRootCause(classNotFoundException);
                    throw namingException;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                objectInputStream.close();
                throw throwable;
            }
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }

    static Attributes determineBindAttrs(char c, Object object, Attributes attributes, boolean bl) throws NamingException {
        Attribute attribute;
        if (attributes == null && object instanceof DirContext) {
            bl = true;
            attributes = ((DirContext)object).getAttributes("");
        }
        if (attributes == null || attributes.size() == 0) {
            attributes = new BasicAttributes(true);
            bl = true;
            attribute = new BasicAttribute("objectClass", "top");
        } else {
            attribute = attributes.get("objectClass");
            if (attribute == null && !attributes.isCaseIgnored()) {
                attribute = attributes.get("objectclass");
            }
            if (attribute == null) {
                attribute = new BasicAttribute("objectClass", "top");
            } else if (!bl) {
                attribute = (Attribute)attribute.clone();
            }
        }
        attributes = Obj.encodeObject(c, object, attributes, attribute, bl);
        return attributes;
    }

    private static Attributes encodeObject(char c, Object object, Attributes attributes, Attribute attribute, boolean bl) throws NamingException {
        boolean bl2;
        boolean bl3 = bl2 = attribute.size() == 0 || attribute.size() == 1 && attribute.contains("top");
        if (bl2) {
            attribute.add(JAVA_OBJECT_CLASSES[0]);
        }
        if (object instanceof Referenceable) {
            attribute.add(JAVA_OBJECT_CLASSES[1]);
            attribute.add(JAVA_OBJECT_CLASSES[2]);
            if (!bl) {
                attributes = (Attributes)attributes.clone();
            }
            attributes.put(attribute);
            return Obj.encodeReference(c, ((Referenceable)object).getReference(), attributes);
        }
        if (object instanceof Reference) {
            attribute.add(JAVA_OBJECT_CLASSES[1]);
            attribute.add(JAVA_OBJECT_CLASSES[2]);
            if (!bl) {
                attributes = (Attributes)attributes.clone();
            }
            attributes.put(attribute);
            return Obj.encodeReference(c, (Reference)object, attributes);
        }
        if (remoteClass != null && remoteClass.isInstance(object)) {
            if (!bl) {
                attributes = (Attributes)attributes.clone();
            }
            if (attributes.get(JAVA_ATTRIBUTES[6]) == null) {
                throw new SchemaViolationException("need 'javaRemoteLocation' attribute when binding Remote");
            }
            attribute.add(JAVA_OBJECT_CLASSES[1]);
            attribute.add(JAVA_OBJECT_CLASSES[4]);
            attributes.put(attribute);
            if (attributes.get(JAVA_ATTRIBUTES[2]) == null) {
                attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[2], object.getClass().getName()));
            }
        } else if (object instanceof Serializable) {
            attribute.add(JAVA_OBJECT_CLASSES[1]);
            attribute.add(JAVA_OBJECT_CLASSES[3]);
            if (!bl) {
                attributes = (Attributes)attributes.clone();
            }
            attributes.put(attribute);
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[2], object.getClass().getName()));
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[1], Obj.serializeObject(object)));
        } else if (!(object instanceof DirContext)) {
            throw new IllegalArgumentException("can only bind Referenceable, Remote, Serializable, DirContext");
        }
        return attributes;
    }

    private static Attributes encodeReference(char c, Reference reference, Attributes attributes) throws NamingException {
        int n;
        if (reference == null) {
            return attributes;
        }
        String string = reference.getClassName();
        if (string != null) {
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[2], string));
        }
        if ((string = reference.getFactoryClassName()) != null) {
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[3], string));
        }
        if ((string = reference.getFactoryClassLocation()) != null) {
            attributes.put(new BasicAttribute(JAVA_ATTRIBUTES[4], string));
        }
        if ((n = reference.size()) > 0) {
            BasicAttribute basicAttribute = new BasicAttribute(JAVA_ATTRIBUTES[5]);
            BASE64Encoder bASE64Encoder = null;
            int n2 = 0;
            while (n2 < n) {
                RefAddr refAddr = reference.get(n2);
                if (refAddr instanceof StringRefAddr) {
                    basicAttribute.add("" + c + n2 + c + refAddr.getType() + c + refAddr.getContent());
                } else {
                    if (bASE64Encoder == null) {
                        bASE64Encoder = new BASE64Encoder();
                    }
                    basicAttribute.add("" + c + n2 + c + refAddr.getType() + c + c + bASE64Encoder.encodeBuffer(Obj.serializeObject(refAddr)));
                }
                ++n2;
            }
            attributes.put(basicAttribute);
        }
        return attributes;
    }

    private static byte[] serializeObject(Object object) throws NamingException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(iOException);
            throw namingException;
        }
    }
}

