/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.net.MalformedURLException;
import javax.naming.NamingException;

public final class LdapURL {
    private String url = null;
    private String scheme = null;
    private String host = null;
    private int port = -1;
    private String DN = null;
    private String attributes = null;
    private String scope = null;
    private String filter = null;
    private String extensions = null;

    public LdapURL(String string) throws NamingException {
        int n;
        int n2;
        this.url = string;
        int n3 = string.indexOf("://");
        if (n3 <= -1) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(new MalformedURLException());
            throw namingException;
        }
        this.scheme = string.substring(0, n3);
        int n4 = string.indexOf(47, n3 += 3);
        int n5 = string.indexOf(58, n3);
        if (n4 < 0) {
            if (n5 < 0) {
                this.host = string.substring(n3);
            } else {
                this.host = string.substring(n3, n5);
                this.port = Integer.parseInt(string.substring(n5 + 1));
            }
            return;
        }
        if (n5 < 0) {
            this.host = string.substring(n3, n4);
        } else {
            this.host = string.substring(n3, n5);
            this.port = Integer.parseInt(string.substring(n5 + 1, n4));
        }
        int n6 = string.indexOf(63, n4);
        this.DN = n6 < 0 ? string.substring(n4 + 1) : string.substring(n4 + 1, n6);
        if (this.DN != null && this.DN.length() > 0) {
            this.DN = LdapURL.decodeMIME(this.DN);
        }
        if (n6 < 0) {
            return;
        }
        int n7 = string.indexOf(63, n6 + 1);
        if (n7 < 0) {
            this.attributes = string.substring(n6 + 1);
            return;
        }
        if (n7 != n6 + 1) {
            this.attributes = string.substring(n6 + 1, n7);
        }
        if ((n2 = string.indexOf(63, n7 + 1)) < 0) {
            this.scope = string.substring(n7 + 1);
            return;
        }
        if (n2 != n7 + 1) {
            this.scope = string.substring(n7 + 1, n2);
        }
        if ((n = string.indexOf(63, n2 + 1)) < 0) {
            this.filter = string.substring(n2 + 1);
        } else if (n != n2 + 1) {
            this.filter = string.substring(n2 + 1, n);
        }
        if (this.filter != null && this.filter.length() > 0) {
            this.filter = LdapURL.decodeMIME(this.filter);
        }
        if (n != -1) {
            this.extensions = string.substring(n + 1);
        }
        if (this.extensions != null && this.extensions.length() > 0) {
            this.extensions = LdapURL.decodeMIME(this.extensions);
        }
    }

    private static String decodeMIME(String string) throws NamingException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '%') {
                ++n2;
                try {
                    stringBuffer.append((char)Integer.parseInt(string.substring(n2, n2 + 2), 16));
                }
                catch (NumberFormatException numberFormatException) {
                    NamingException namingException = new NamingException();
                    namingException.setRootCause(new MalformedURLException());
                    throw namingException;
                }
                ++n2;
            } else {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getDN() {
        return this.DN;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getScope() {
        return this.scope;
    }

    public String toString() {
        return this.url;
    }
}

