/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapCtxFactory;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.toolkit.Continuation;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.spi.NamingManager;

class LdapSearchEnumeration
extends LdapNamingEnumeration {
    Name startName = null;
    LdapCtx.SearchArgs searchArgs = null;
    private String startRelHome = "";

    LdapSearchEnumeration(LdapCtx ldapCtx, LdapResult ldapResult, String string, LdapCtx.SearchArgs searchArgs, Continuation continuation) throws NamingException {
        super(ldapCtx, ldapResult, searchArgs.name, continuation);
        if (string != null) {
            this.startName = LdapCtx.parser.parse(string);
            Name name = LdapCtx.parser.parse(ldapCtx.currentDN);
            Name name2 = this.startName.getSuffix(name.size());
            this.startRelHome = name2.toString();
        }
        this.searchArgs = searchArgs;
    }

    public void appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        this.startName = null;
        super.appendUnprocessedReferrals(ldapReferralException);
    }

    protected NameClassPair createItem(String string, Attributes attributes) throws NamingException {
        String string2;
        String string3;
        Name name;
        Name name2;
        Object object = null;
        boolean bl = true;
        try {
            name2 = LdapCtx.parser.parse(string);
            if (this.startName != null && name2.startsWith(this.startName)) {
                name = name2.getSuffix(this.startName.size());
                string3 = name.toString();
                string2 = LdapCtx.concatNames(string3, this.startRelHome);
            } else {
                bl = false;
                string2 = string3 = this.makeLDAPURL(string);
            }
        }
        catch (NamingException namingException) {
            bl = false;
            string2 = string3 = this.makeLDAPURL(string);
        }
        name2 = new CompositeName();
        if (!string3.equals("")) {
            ((CompositeName)name2).add(string3);
        }
        name = new CompositeName();
        if (!string2.equals("")) {
            ((CompositeName)name).add(string2);
        }
        this.homeCtx.setParents(attributes, name);
        if (this.searchArgs.cons.getReturningObjFlag()) {
            object = attributes.get(Obj.JAVA_ATTRIBUTES[2]) != null ? Obj.decodeObject(attributes) : LdapCtxFactory.getLdapObjectInstance(this.homeCtx, string, attributes);
            String[] stringArray = this.searchArgs.reqAttrs;
            if (this.searchArgs.reqAttrs != null) {
                BasicAttributes basicAttributes = new BasicAttributes(true);
                int n = 0;
                while (n < stringArray.length) {
                    basicAttributes.put(stringArray[n], null);
                    ++n;
                }
                int n2 = 0;
                while (n2 < Obj.JAVA_ATTRIBUTES.length) {
                    if (basicAttributes.get(Obj.JAVA_ATTRIBUTES[n2]) == null) {
                        attributes.remove(Obj.JAVA_ATTRIBUTES[n2]);
                    }
                    ++n2;
                }
            }
            try {
                object = NamingManager.getObjectInstance(object, name2, bl ? this.homeCtx : null, this.homeCtx.envprops);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        return new SearchResult(((CompositeName)name2).toString(), object, attributes, bl);
    }

    protected LdapNamingEnumeration getReferredResults(LdapReferralContext ldapReferralContext) throws NamingException {
        return (LdapSearchEnumeration)ldapReferralContext.search(this.searchArgs.name, this.searchArgs.filter, this.searchArgs.cons);
    }

    private String makeLDAPURL(String string) {
        return "ldap://" + (this.homeCtx.hostname != null ? this.homeCtx.hostname : "localhost") + ":" + (this.homeCtx.port_number != 0 ? this.homeCtx.port_number : 389) + "/" + string;
    }

    protected void update(LdapNamingEnumeration ldapNamingEnumeration) {
        super.update(ldapNamingEnumeration);
        LdapSearchEnumeration ldapSearchEnumeration = (LdapSearchEnumeration)ldapNamingEnumeration;
        this.startName = ldapSearchEnumeration.startName;
    }
}

