/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapSchemaCtx;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;

final class LdapSchemaParser {
    private static final boolean debug = false;
    static final String OBJECTCLASSDESC_ATTR_ID = "objectClasses";
    static final String ATTRIBUTEDESC_ATTR_ID = "attributeTypes";
    static final String SYNTAXDESC_ATTR_ID = "ldapSyntaxes";
    static final String MATCHRULEDESC_ATTR_ID = "matchingRules";
    static final String OBJECTCLASS_DEFINITION_NAME = "ClassDefinition";
    private static final String[] CLASS_DEF_ATTRS = new String[]{"objectclass", "ClassDefinition"};
    static final String ATTRIBUTE_DEFINITION_NAME = "AttributeDefinition";
    private static final String[] ATTR_DEF_ATTRS = new String[]{"objectclass", "AttributeDefinition"};
    static final String SYNTAX_DEFINITION_NAME = "SyntaxDefinition";
    private static final String[] SYNTAX_DEF_ATTRS = new String[]{"objectclass", "SyntaxDefinition"};
    static final String MATCHRULE_DEFINITION_NAME = "MatchingRule";
    private static final String[] MATCHRULE_DEF_ATTRS = new String[]{"objectclass", "MatchingRule"};
    private static final char SINGLE_QUOTE = '\'';
    private static final char WHSP = ' ';
    private static final char OID_LIST_BEGIN = '(';
    private static final char OID_LIST_END = ')';
    private static final char OID_SEPARATOR = '$';
    private static final String NUMERICOID_ID = "NUMERICOID";
    private static final String NAME_ID = "NAME";
    private static final String DESC_ID = "DESC";
    private static final String OBSOLETE_ID = "OBSOLETE";
    private static final String SUP_ID = "SUP";
    private static final String ABSTRACT_ID = "ABSTRACT";
    private static final String STRUCTURAL_ID = "STRUCTURAL";
    private static final String AUXILARY_ID = "AUXILIARY";
    private static final String MUST_ID = "MUST";
    private static final String MAY_ID = "MAY";
    private static final String EQUALITY_ID = "EQUALITY";
    private static final String ORDERING_ID = "ORDERING";
    private static final String SUBSTR_ID = "SUBSTR";
    private static final String SYNTAX_ID = "SYNTAX";
    private static final String SINGLE_VAL_ID = "SINGLE-VALUE";
    private static final String COLLECTIVE_ID = "COLLECTIVE";
    private static final String NO_USER_MOD_ID = "NO-USER-MODIFICATION";
    private static final String USAGE_ID = "USAGE";
    private static final String SCHEMA_TRUE_VALUE = "true";
    protected static String currentName = null;
    private boolean netscapeBug;

    LdapSchemaParser(boolean bl) {
        this.netscapeBug = bl;
    }

    static final void LDAP2JNDISchema(Attributes attributes, LdapSchemaCtx ldapSchemaCtx) throws NamingException {
        Attribute attribute = null;
        Attribute attribute2 = null;
        Attribute attribute3 = null;
        Attribute attribute4 = null;
        attribute = attributes.get(OBJECTCLASSDESC_ATTR_ID);
        if (attribute != null) {
            LdapSchemaParser.objectDescs2ClassDefs(attribute, ldapSchemaCtx);
        }
        if ((attribute2 = attributes.get(ATTRIBUTEDESC_ATTR_ID)) != null) {
            LdapSchemaParser.attrDescs2AttrDefs(attribute2, ldapSchemaCtx);
        }
        if ((attribute3 = attributes.get(SYNTAXDESC_ATTR_ID)) != null) {
            LdapSchemaParser.syntaxDescs2SyntaxDefs(attribute3, ldapSchemaCtx);
        }
        if ((attribute4 = attributes.get(MATCHRULEDESC_ATTR_ID)) != null) {
            LdapSchemaParser.matchRuleDescs2MatchRuleDefs(attribute4, ldapSchemaCtx);
        }
    }

    private final String attrDef2AttrDesc(Attributes attributes) throws NamingException {
        StringBuffer stringBuffer = new StringBuffer("( ");
        Attribute attribute = null;
        attribute = attributes.get(NUMERICOID_ID);
        if (attribute == null) {
            throw new ConfigurationException("Attribute type doesn'thave a numeric OID");
        }
        stringBuffer.append(this.writeNumericOID(attribute));
        attribute = attributes.get(NAME_ID);
        if (attribute != null) {
            stringBuffer.append(this.writeQDescrs(attribute));
        }
        if ((attribute = attributes.get(DESC_ID)) != null) {
            stringBuffer.append(this.writeQDString(attribute));
        }
        if ((attribute = attributes.get(OBSOLETE_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(SUP_ID)) != null) {
            stringBuffer.append(this.writeWOID(attribute));
        }
        if ((attribute = attributes.get(EQUALITY_ID)) != null) {
            stringBuffer.append(this.writeWOID(attribute));
        }
        if ((attribute = attributes.get(ORDERING_ID)) != null) {
            stringBuffer.append(this.writeWOID(attribute));
        }
        if ((attribute = attributes.get(SUBSTR_ID)) != null) {
            stringBuffer.append(this.writeWOID(attribute));
        }
        if ((attribute = attributes.get(SYNTAX_ID)) != null) {
            stringBuffer.append(this.writeWOID(attribute));
        }
        if ((attribute = attributes.get(SINGLE_VAL_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(COLLECTIVE_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(NO_USER_MOD_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(USAGE_ID)) != null) {
            stringBuffer.append(this.writeQDString(attribute));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static final DirContext attrDescs2AttrDefs(Attribute attribute, LdapSchemaCtx ldapSchemaCtx) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(ATTR_DEF_ATTRS[0], ATTR_DEF_ATTRS[1]);
        LdapSchemaCtx ldapSchemaCtx2 = ldapSchemaCtx.setup(3, ATTRIBUTE_DEFINITION_NAME, basicAttributes);
        NamingEnumeration namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            String string = (String)namingEnumeration.next();
            try {
                Attributes attributes = LdapSchemaParser.desc2Def(string);
                ldapSchemaCtx2.setup(currentName, attributes, string);
            }
            catch (NamingException namingException) {}
        }
        return ldapSchemaCtx2;
    }

    private final String classDef2ObjectDesc(Attributes attributes) throws NamingException {
        StringBuffer stringBuffer = new StringBuffer("( ");
        Attribute attribute = null;
        attribute = attributes.get(NUMERICOID_ID);
        if (attribute == null) {
            throw new ConfigurationException("Class definition doesn'thave a numeric OID");
        }
        stringBuffer.append(this.writeNumericOID(attribute));
        attribute = attributes.get(NAME_ID);
        if (attribute != null) {
            stringBuffer.append(this.writeQDescrs(attribute));
        }
        if ((attribute = attributes.get(DESC_ID)) != null) {
            stringBuffer.append(this.writeQDString(attribute));
        }
        if ((attribute = attributes.get(OBSOLETE_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(SUP_ID)) != null) {
            stringBuffer.append(this.writeOIDs(attribute));
        }
        if ((attribute = attributes.get(ABSTRACT_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(STRUCTURAL_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(AUXILARY_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(MUST_ID)) != null) {
            stringBuffer.append(this.writeOIDs(attribute));
        }
        if ((attribute = attributes.get(MAY_ID)) != null) {
            stringBuffer.append(this.writeOIDs(attribute));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static final Attributes desc2Def(String string) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        Attribute attribute = null;
        int[] nArray = new int[]{2};
        boolean bl = true;
        attribute = LdapSchemaParser.readNumericOID(string, nArray);
        basicAttributes.put(attribute);
        LdapSchemaParser.skipWhitespace(string, nArray);
        while (bl) {
            attribute = LdapSchemaParser.readNextTag(string, nArray);
            basicAttributes.put(attribute);
            LdapSchemaParser.skipWhitespace(string, nArray);
            if (nArray[0] < string.length() - 1) continue;
            bl = false;
        }
        return basicAttributes;
    }

    private static final int findTrailingWhitespace(String string, int n) {
        int n2 = n;
        while (n2 > 0) {
            if (string.charAt(n2) != ' ') {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    private final String matchRuleDef2MatchRuleDesc(Attributes attributes) throws NamingException {
        StringBuffer stringBuffer = new StringBuffer("( ");
        Attribute attribute = null;
        attribute = attributes.get(NUMERICOID_ID);
        if (attribute == null) {
            throw new ConfigurationException("Attribute type doesn'thave a numeric OID");
        }
        stringBuffer.append(this.writeNumericOID(attribute));
        attribute = attributes.get(NAME_ID);
        if (attribute != null) {
            stringBuffer.append(this.writeQDescrs(attribute));
        }
        if ((attribute = attributes.get(DESC_ID)) != null) {
            stringBuffer.append(this.writeQDString(attribute));
        }
        if ((attribute = attributes.get(OBSOLETE_ID)) != null) {
            stringBuffer.append(this.writeBoolean(attribute));
        }
        if ((attribute = attributes.get(SYNTAX_ID)) == null) {
            throw new ConfigurationException("Attribute type doesn'thave a syntax OID");
        }
        stringBuffer.append(this.writeWOID(attribute));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static final DirContext matchRuleDescs2MatchRuleDefs(Attribute attribute, LdapSchemaCtx ldapSchemaCtx) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(MATCHRULE_DEF_ATTRS[0], MATCHRULE_DEF_ATTRS[1]);
        LdapSchemaCtx ldapSchemaCtx2 = ldapSchemaCtx.setup(5, MATCHRULE_DEFINITION_NAME, basicAttributes);
        NamingEnumeration namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            String string = (String)namingEnumeration.next();
            try {
                Attributes attributes = LdapSchemaParser.desc2Def(string);
                ldapSchemaCtx2.setup(currentName, attributes, string);
            }
            catch (NamingException namingException) {}
        }
        return ldapSchemaCtx2;
    }

    private static final DirContext objectDescs2ClassDefs(Attribute attribute, LdapSchemaCtx ldapSchemaCtx) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(CLASS_DEF_ATTRS[0], CLASS_DEF_ATTRS[1]);
        LdapSchemaCtx ldapSchemaCtx2 = ldapSchemaCtx.setup(2, OBJECTCLASS_DEFINITION_NAME, basicAttributes);
        NamingEnumeration namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            String string = (String)namingEnumeration.next();
            try {
                Attributes attributes = LdapSchemaParser.desc2Def(string);
                ldapSchemaCtx2.setup(currentName, attributes, string);
            }
            catch (NamingException namingException) {}
        }
        return ldapSchemaCtx2;
    }

    private static final Attribute readNextTag(String string, int[] nArray) throws NamingException {
        BasicAttribute basicAttribute = null;
        String string2 = null;
        String[] stringArray = null;
        LdapSchemaParser.skipWhitespace(string, nArray);
        string2 = string.substring(nArray[0], string.indexOf(32, nArray[0]));
        stringArray = LdapSchemaParser.readTag(string2, string, nArray);
        if (stringArray.length < 0) {
            throw new InvalidAttributeValueException("no values for attribute \"" + string2 + "\"");
        }
        basicAttribute = new BasicAttribute(string2, stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            basicAttribute.add(stringArray[n]);
            ++n;
        }
        return basicAttribute;
    }

    private static final Attribute readNumericOID(String string, int[] nArray) throws NamingException {
        String string2 = null;
        LdapSchemaParser.skipWhitespace(string, nArray);
        int n = nArray[0];
        int n2 = string.indexOf(32, n);
        if (n2 == -1 || n2 - n < 1) {
            throw new InvalidAttributeValueException("no numericoid found: " + string);
        }
        string2 = string.substring(n, n2);
        currentName = string2.toLowerCase();
        nArray[0] = nArray[0] + string2.length();
        return new BasicAttribute(NUMERICOID_ID, string2);
    }

    private static final String[] readOIDs(String string, int[] nArray) throws NamingException {
        int n;
        LdapSchemaParser.skipWhitespace(string, nArray);
        if (string.charAt(nArray[0]) != '(') {
            return LdapSchemaParser.readWOID(string, nArray);
        }
        String string2 = null;
        Vector<String> vector = new Vector<String>(5);
        nArray[0] = nArray[0] + 1;
        LdapSchemaParser.skipWhitespace(string, nArray);
        int n2 = nArray[0];
        int n3 = string.indexOf(41, n2);
        int n4 = string.indexOf(36, n2);
        if (n3 == -1) {
            throw new InvalidAttributeValueException("oidlist has no end mark: " + string);
        }
        if (n4 == -1 || n3 < n4) {
            n4 = n3;
        }
        while (n4 < n3 && n4 > 0) {
            n = LdapSchemaParser.findTrailingWhitespace(string, n4 - 1);
            string2 = string.substring(n2, n);
            vector.addElement(string2);
            nArray[0] = n4 + 1;
            LdapSchemaParser.skipWhitespace(string, nArray);
            n2 = nArray[0];
            n4 = string.indexOf(36, n2);
        }
        n = LdapSchemaParser.findTrailingWhitespace(string, n3 - 1);
        string2 = string.substring(n2, n);
        vector.addElement(string2);
        nArray[0] = n3 + 1;
        String[] stringArray = new String[vector.size()];
        int n5 = 0;
        while (n5 < stringArray.length) {
            stringArray[n5] = (String)vector.elementAt(n5);
            ++n5;
        }
        return stringArray;
    }

    private static final String[] readQDString(String string, int[] nArray) throws NamingException {
        int n = string.indexOf(39, nArray[0]) + 1;
        int n2 = string.indexOf(39, n);
        if (n == -1 || n2 == -1 || n == n2) {
            throw new InvalidAttributeIdentifierException("malformed QDString: " + string);
        }
        if (string.charAt(n - 1) != '\'') {
            throw new InvalidAttributeIdentifierException("qdstring has no end mark: " + string);
        }
        nArray[0] = n2 + 1;
        return new String[]{string.substring(n, n2)};
    }

    /*
     * Unable to fully structure code
     */
    private static final String[] readQDescrList(String var0, int[] var1_1) throws NamingException {
        var4_2 = new Vector<String>(5);
        var1_1[0] = var1_1[0] + 1;
        LdapSchemaParser.skipWhitespace(var0, var1_1);
        var2_3 = var1_1[0];
        var3_4 = var0.indexOf(41, var2_3);
        if (var3_4 != -1) ** GOTO lbl12
        throw new InvalidAttributeValueException("oidlist has no end mark: " + var0);
lbl-1000:
        // 1 sources

        {
            var5_5 = LdapSchemaParser.readQDString(var0, var1_1);
            var4_2.addElement(var5_5[0]);
            LdapSchemaParser.skipWhitespace(var0, var1_1);
            var2_3 = var1_1[0];
lbl12:
            // 2 sources

            ** while (var2_3 < var3_4)
        }
lbl13:
        // 1 sources

        var1_1[0] = var3_4 + 1;
        var5_5 = new String[var4_2.size()];
        var6_6 = 0;
        while (var6_6 < var5_5.length) {
            var5_5[var6_6] = (String)var4_2.elementAt(var6_6);
            ++var6_6;
        }
        return var5_5;
    }

    private static final String[] readQDescrs(String string, int[] nArray) throws NamingException {
        LdapSchemaParser.skipWhitespace(string, nArray);
        switch (string.charAt(nArray[0])) {
            case '(': {
                return LdapSchemaParser.readQDescrList(string, nArray);
            }
            case '\'': {
                return LdapSchemaParser.readQDString(string, nArray);
            }
        }
        throw new InvalidAttributeValueException("unexpected oids string: " + string);
    }

    private static final String[] readTag(String string, String string2, int[] nArray) throws NamingException {
        nArray[0] = nArray[0] + string.length();
        LdapSchemaParser.skipWhitespace(string2, nArray);
        if (string.equals(NAME_ID)) {
            String[] stringArray = LdapSchemaParser.readQDescrs(string2, nArray);
            currentName = stringArray[0].toLowerCase();
            return stringArray;
        }
        if (string.equals(DESC_ID)) {
            return LdapSchemaParser.readQDString(string2, nArray);
        }
        if (string.equals(EQUALITY_ID) || string.equals(ORDERING_ID) || string.equals(SUBSTR_ID) || string.equals(SYNTAX_ID)) {
            return LdapSchemaParser.readWOID(string2, nArray);
        }
        if (string.equals(OBSOLETE_ID) || string.equals(ABSTRACT_ID) || string.equals(STRUCTURAL_ID) || string.equals(AUXILARY_ID) || string.equals(SINGLE_VAL_ID) || string.equals(COLLECTIVE_ID) || string.equals(NO_USER_MOD_ID)) {
            return new String[]{SCHEMA_TRUE_VALUE};
        }
        if (string.equals(SUP_ID) || string.equals(MUST_ID) || string.equals(MAY_ID) || string.equals(USAGE_ID)) {
            return LdapSchemaParser.readOIDs(string2, nArray);
        }
        throw new InvalidAttributeIdentifierException("LdapSchemaParser: unkown tag: " + string);
    }

    private static final String[] readWOID(String string, int[] nArray) throws NamingException {
        LdapSchemaParser.skipWhitespace(string, nArray);
        if (string.charAt(nArray[0]) == '\'') {
            return LdapSchemaParser.readQDString(string, nArray);
        }
        int n = nArray[0];
        int n2 = string.indexOf(32, n);
        if (n2 == -1 || n == n2) {
            throw new InvalidAttributeIdentifierException("malformed OID: " + string);
        }
        nArray[0] = n2 + 1;
        return new String[]{string.substring(n, n2)};
    }

    private static final void skipWhitespace(String string, int[] nArray) {
        int n = nArray[0];
        while (n < string.length()) {
            if (string.charAt(n) != ' ') {
                nArray[0] = n;
                return;
            }
            ++n;
        }
    }

    final Attribute stringifyAttrDesc(Attributes attributes) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(ATTRIBUTEDESC_ATTR_ID);
        basicAttribute.add(this.attrDef2AttrDesc(attributes));
        return basicAttribute;
    }

    final Attribute stringifyMatchRuleDesc(Attributes attributes) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(MATCHRULEDESC_ATTR_ID);
        basicAttribute.add(this.matchRuleDef2MatchRuleDesc(attributes));
        return basicAttribute;
    }

    final Attribute stringifyObjDesc(Attributes attributes) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(OBJECTCLASSDESC_ATTR_ID);
        basicAttribute.add(this.classDef2ObjectDesc(attributes));
        return basicAttribute;
    }

    final Attribute stringifySyntaxDesc(Attributes attributes) throws NamingException {
        BasicAttribute basicAttribute = new BasicAttribute(SYNTAXDESC_ATTR_ID);
        basicAttribute.add(this.syntaxDef2SyntaxDesc(attributes));
        return basicAttribute;
    }

    private final String syntaxDef2SyntaxDesc(Attributes attributes) throws NamingException {
        StringBuffer stringBuffer = new StringBuffer("( ");
        Attribute attribute = null;
        attribute = attributes.get(NUMERICOID_ID);
        if (attribute == null) {
            throw new ConfigurationException("Attribute type doesn'thave a numeric OID");
        }
        stringBuffer.append(this.writeNumericOID(attribute));
        attribute = attributes.get(DESC_ID);
        if (attribute != null) {
            stringBuffer.append(this.writeQDString(attribute));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static final DirContext syntaxDescs2SyntaxDefs(Attribute attribute, LdapSchemaCtx ldapSchemaCtx) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(SYNTAX_DEF_ATTRS[0], SYNTAX_DEF_ATTRS[1]);
        LdapSchemaCtx ldapSchemaCtx2 = ldapSchemaCtx.setup(4, SYNTAX_DEFINITION_NAME, basicAttributes);
        NamingEnumeration namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            String string = (String)namingEnumeration.next();
            try {
                Attributes attributes = LdapSchemaParser.desc2Def(string);
                ldapSchemaCtx2.setup(currentName, attributes, string);
            }
            catch (NamingException namingException) {}
        }
        return ldapSchemaCtx2;
    }

    private final String writeBoolean(Attribute attribute) throws NamingException {
        return String.valueOf(new String(attribute.getID())) + ' ';
    }

    private final String writeNumericOID(Attribute attribute) throws NamingException {
        if (attribute.size() != 1) {
            throw new InvalidAttributeValueException("A class definition must have exactly one numeric OID");
        }
        return String.valueOf((String)attribute.get()) + ' ';
    }

    private final String writeOIDs(Attribute attribute) throws NamingException {
        switch (attribute.size()) {
            case 0: {
                throw new InvalidAttributeValueException(String.valueOf(attribute.getID()) + "has no values");
            }
            case 1: {
                if (this.netscapeBug) break;
                return this.writeWOID(attribute);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(attribute.getID());
        stringBuffer.append(' ');
        stringBuffer.append('(');
        NamingEnumeration namingEnumeration = attribute.getAll();
        stringBuffer.append(' ');
        stringBuffer.append(namingEnumeration.next());
        while (namingEnumeration.hasMore()) {
            stringBuffer.append(' ');
            stringBuffer.append('$');
            stringBuffer.append(' ');
            stringBuffer.append((String)namingEnumeration.next());
        }
        stringBuffer.append(' ');
        stringBuffer.append(')');
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }

    private final String writeQDString(Attribute attribute) throws NamingException {
        if (attribute.size() != 1) {
            throw new InvalidAttributeValueException(String.valueOf(attribute.getID()) + " must have exactly one value");
        }
        return String.valueOf(attribute.getID()) + ' ' + '\'' + attribute.get() + '\'' + ' ';
    }

    private final String writeQDescrs(Attribute attribute) throws NamingException {
        switch (attribute.size()) {
            case 0: {
                throw new InvalidAttributeValueException(String.valueOf(attribute.getID()) + "has no values");
            }
            case 1: {
                return this.writeQDString(attribute);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(attribute.getID());
        stringBuffer.append(' ');
        stringBuffer.append('(');
        NamingEnumeration namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            stringBuffer.append(' ');
            stringBuffer.append('\'');
            stringBuffer.append((String)namingEnumeration.next());
            stringBuffer.append('\'');
            stringBuffer.append(' ');
        }
        stringBuffer.append(')');
        stringBuffer.append(' ');
        return stringBuffer.toString();
    }

    private final String writeWOID(Attribute attribute) throws NamingException {
        if (this.netscapeBug) {
            return this.writeQDString(attribute);
        }
        return new String(String.valueOf(attribute.getID()) + ' ' + attribute.get() + ' ');
    }
}

