/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapSchemaParser;
import com.sun.jndi.toolkit.HierMemDirCtx;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;

final class LdapSchemaCtx
extends HierMemDirCtx {
    private static final boolean debug = false;
    private static final int LEAF = 0;
    private static final int SCHEMA_ROOT = 1;
    static final int OBJECTCLASS_ROOT = 2;
    static final int ATTRIBUTE_ROOT = 3;
    static final int SYNTAX_ROOT = 4;
    static final int MATCHRULE_ROOT = 5;
    private SchemaInfo info = null;
    private boolean setupMode = true;
    private String stringRepr = null;
    private int objectType;

    private LdapSchemaCtx(int n, Hashtable hashtable, LdapCtx ldapCtx, LdapSchemaParser ldapSchemaParser) {
        super(hashtable, true);
        this.objectType = n;
        this.info = new SchemaInfo();
        this.info.root = this;
        this.info.originatingEntry = ldapCtx;
        this.info.parser = ldapSchemaParser;
    }

    private LdapSchemaCtx(Hashtable hashtable, LdapCtx ldapCtx, LdapSchemaParser ldapSchemaParser) {
        this(1, hashtable, ldapCtx, ldapSchemaParser);
    }

    private final String addServerSchema(Attributes attributes) throws NamingException {
        Attribute attribute;
        switch (this.objectType) {
            case 2: {
                attribute = this.info.parser.stringifyObjDesc(attributes);
                break;
            }
            case 3: {
                attribute = this.info.parser.stringifyAttrDesc(attributes);
                break;
            }
            case 4: {
                attribute = this.info.parser.stringifySyntaxDesc(attributes);
                break;
            }
            case 5: {
                attribute = this.info.parser.stringifyMatchRuleDesc(attributes);
                break;
            }
            case 1: {
                throw new SchemaViolationException("Cannot create new entry under schema root");
            }
            default: {
                throw new SchemaViolationException("Cannot create child of schema object");
            }
        }
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(attribute);
        this.info.originatingEntry.modifyAttributes("", 1, (Attributes)basicAttributes);
        return (String)attribute.get();
    }

    public final void bind(Name name, Object object, Attributes attributes) throws NamingException {
        String string = null;
        if (!this.setupMode) {
            if (object != null) {
                throw new IllegalArgumentException("obj must be null");
            }
            string = this.addServerSchema(attributes);
        }
        LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)super.doCreateSubcontext(name, attributes);
        ldapSchemaCtx.stringRepr = string;
    }

    protected final HierMemDirCtx createNewCtx() {
        LdapSchemaCtx ldapSchemaCtx = new LdapSchemaCtx(0, this.myEnv, this.info.originatingEntry, this.info.parser);
        ldapSchemaCtx.setInfo(this.info);
        return ldapSchemaCtx;
    }

    static DirContext createSchemaTree(Hashtable hashtable, LdapCtx ldapCtx, Attributes attributes) throws NamingException {
        LdapSchemaParser ldapSchemaParser = new LdapSchemaParser(ldapCtx.netscapeSchemaBug);
        LdapSchemaCtx ldapSchemaCtx = new LdapSchemaCtx(hashtable, ldapCtx, ldapSchemaParser);
        LdapSchemaParser.LDAP2JNDISchema(attributes, ldapSchemaCtx);
        return ldapSchemaCtx;
    }

    private final void deleteServerSchema(String string) throws NamingException {
        String string2;
        switch (this.objectType) {
            case 2: {
                string2 = "objectClasses";
                break;
            }
            case 3: {
                string2 = "attributeTypes";
                break;
            }
            case 4: {
                string2 = "ldapSyntaxes";
                break;
            }
            case 5: {
                string2 = "matchingRules";
                break;
            }
            case 1: {
                throw new SchemaViolationException("Cannot create new entry under schema root");
            }
            default: {
                throw new SchemaViolationException("Cannot create child of schema object");
            }
        }
        BasicAttributes basicAttributes = new BasicAttributes(string2, string, true);
        this.info.originatingEntry.modifyAttributes("", 3, (Attributes)basicAttributes);
    }

    protected final void doBind(Name name, Object object) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot bind arbitrary object; use createSubcontext()");
        }
        super.doBind(name, object);
    }

    protected final DirContext doCreateSubcontext(Name name, Attributes attributes) throws NamingException {
        String string = null;
        if (attributes == null || attributes.size() == 0) {
            throw new SchemaViolationException("Must supply attributes describing schema");
        }
        if (!this.setupMode) {
            string = this.addServerSchema(attributes);
        }
        LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)super.doCreateSubcontext(name, attributes);
        ldapSchemaCtx.stringRepr = string;
        return ldapSchemaCtx;
    }

    protected final void doDestroySubcontext(Name name) throws NamingException {
        if (!this.setupMode) {
            try {
                LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)this.lookup(name);
                this.deleteServerSchema(ldapSchemaCtx.stringRepr);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
        }
        super.doDestroySubcontext(name);
    }

    protected final void doModifyAttributes(ModificationItem[] modificationItemArray) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot modify a schema object");
        }
        super.doModifyAttributes(modificationItemArray);
    }

    protected final void doRebind(Name name, Object object) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot bind arbitrary object; use createSubcontext()");
        }
        super.doRebind(name, object);
    }

    protected final void doRename(Name name, Name name2) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot rename a schema object");
        }
        this.doRename(name, name2);
    }

    protected final void doUnbind(Name name) throws NamingException {
        if (!this.setupMode) {
            try {
                LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)this.lookup(name);
                this.deleteServerSchema(ldapSchemaCtx.stringRepr);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
        }
        super.doUnbind(name);
    }

    public final void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        try {
            this.lookup(name);
            throw new SchemaViolationException("Cannot replace existing schema object");
        }
        catch (NameNotFoundException nameNotFoundException) {
            this.bind(name, object, attributes);
            return;
        }
    }

    private final void setInfo(SchemaInfo schemaInfo) {
        this.info = schemaInfo;
    }

    final LdapSchemaCtx setup(int n, String string, Attributes attributes) throws NamingException {
        try {
            this.setupMode = true;
            LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)super.doCreateSubcontext(new CompositeName(string), attributes);
            ldapSchemaCtx.objectType = n;
            ldapSchemaCtx.setupMode = false;
            LdapSchemaCtx ldapSchemaCtx2 = ldapSchemaCtx;
            Object var6_6 = null;
            this.setupMode = false;
            return ldapSchemaCtx2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setupMode = false;
            throw throwable;
        }
    }

    final LdapSchemaCtx setup(String string, Attributes attributes, String string2) throws NamingException {
        try {
            this.setupMode = true;
            LdapSchemaCtx ldapSchemaCtx = (LdapSchemaCtx)super.doCreateSubcontext(new CompositeName(string), attributes);
            ldapSchemaCtx.setupMode = false;
            ldapSchemaCtx.stringRepr = string2;
            LdapSchemaCtx ldapSchemaCtx2 = ldapSchemaCtx;
            Object var6_6 = null;
            this.setupMode = false;
            return ldapSchemaCtx2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.setupMode = false;
            throw throwable;
        }
    }

    private static final class SchemaInfo {
        LdapSchemaCtx root;
        LdapCtx originatingEntry;
        LdapSchemaParser parser;

        SchemaInfo() {
        }
    }
}

