/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapReferralContext;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ReferralException;

public final class LdapReferralException
extends ReferralException {
    private int handleReferrals = 2;
    private Vector referrals = null;
    private int nextReferral = 0;
    private Hashtable envprops = null;
    private String nextName = null;
    private boolean foundEntry = false;
    private boolean continuationRef = false;
    private boolean skipThisReferral = false;
    LdapReferralException nextRefEx = null;
    private int hopCount = 1;

    LdapReferralException() {
    }

    LdapReferralException(String string) {
        super(string);
    }

    LdapReferralException(Name name, Object object, Name name2) {
        this.setResolvedName(name);
        this.setResolvedObj(object);
        this.setRemainingName(name2);
    }

    LdapReferralException(Name name, Object object, Name name2, String string, Hashtable hashtable, String string2) {
        super(string);
        this.setResolvedName(name);
        this.setResolvedObj(object);
        this.setRemainingName(name2);
        this.envprops = hashtable;
        this.nextName = string2;
    }

    LdapReferralException appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        if (ldapReferralException == null) {
            if (this.foundEntry || this.nextReferral >= this.referrals.size()) {
                return this.nextRefEx;
            }
            return this;
        }
        if (!ldapReferralException.hasMoreReferrals()) {
            return this;
        }
        if (!this.foundEntry && this.nextReferral < this.referrals.size()) {
            if (this.nextRefEx == null) {
                this.nextRefEx = ldapReferralException;
            } else {
                ldapReferralException.nextRefEx = this.nextRefEx;
                this.nextRefEx = ldapReferralException;
            }
            return this;
        }
        if (this.nextRefEx != null) {
            ldapReferralException.nextRefEx = this.nextRefEx;
        }
        return ldapReferralException;
    }

    int getHandleReferrals() {
        return this.handleReferrals;
    }

    int getHopCount() {
        return this.hopCount;
    }

    String getNextReferral() throws ReferralException {
        if (!this.foundEntry && this.referrals != null && this.nextReferral < this.referrals.size()) {
            return (String)this.referrals.elementAt(this.nextReferral++);
        }
        if (this.nextRefEx != null) {
            throw this.nextRefEx;
        }
        return null;
    }

    public Context getReferralContext() throws NamingException {
        LdapReferralContext ldapReferralContext = new LdapReferralContext(this, this.envprops, this.nextName, this.skipThisReferral);
        ldapReferralContext.setHopCount(this.hopCount + 1);
        if (this.skipThisReferral) {
            this.skipThisReferral = false;
        }
        return ldapReferralContext;
    }

    public Context getReferralContext(Hashtable hashtable) throws NamingException {
        LdapReferralContext ldapReferralContext = new LdapReferralContext(this, hashtable, this.nextName, this.skipThisReferral);
        ldapReferralContext.setHopCount(this.hopCount + 1);
        if (this.skipThisReferral) {
            this.skipThisReferral = false;
        }
        return ldapReferralContext;
    }

    public Object getReferralInfo() {
        if (this.referrals != null && this.nextReferral < this.referrals.size()) {
            return this.referrals.elementAt(this.nextReferral);
        }
        return null;
    }

    boolean hasMoreReferrals() {
        if (this.foundEntry) {
            return this.nextRefEx != null;
        }
        return this.nextReferral < this.referrals.size() || this.nextRefEx != null;
    }

    boolean isContinuationReference() {
        return this.continuationRef;
    }

    boolean isNameResolved() {
        return this.foundEntry;
    }

    void setHandleReferrals(int n) {
        this.handleReferrals = n;
    }

    void setHopCount(int n) {
        this.hopCount = n;
    }

    void setNameResolved(boolean bl) {
        this.foundEntry = bl;
    }

    void setReferralInfo(Vector vector, boolean bl) {
        this.referrals = vector;
        this.continuationRef = bl;
    }

    public boolean skipReferral() {
        this.skipThisReferral = true;
        if (this.foundEntry) {
            return this.nextRefEx != null;
        }
        return this.nextReferral + 1 < this.referrals.size() || this.nextRefEx != null;
    }
}

