/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.ReferralEnumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.spi.NamingManager;

final class LdapReferralContext
implements DirContext {
    private DirContext refCtx = null;
    private String urlName = null;
    private String urlAttrs = null;
    private String urlScope = null;
    private String urlFilter = null;
    private String urlExtns = null;
    private LdapReferralException refEx = null;
    private boolean skipThisReferral = false;
    private int hopCount = 1;
    private NamingException previousEx = null;

    LdapReferralContext(LdapReferralException ldapReferralException, Hashtable hashtable, String string, boolean bl) throws NamingException {
        Object object;
        String string2;
        this.refEx = ldapReferralException;
        while (true) {
            int n = this.refEx.getHandleReferrals();
            try {
                string2 = this.refEx.getNextReferral();
                if (string2 == null) {
                    throw (NamingException)this.previousEx.fillInStackTrace();
                }
            }
            catch (LdapReferralException ldapReferralException2) {
                if (n == 2) {
                    throw ldapReferralException2;
                }
                this.refEx = ldapReferralException2;
                continue;
            }
            this.skipThisReferral = bl;
            if (this.skipThisReferral) {
                return;
            }
            LdapURL ldapURL = new LdapURL(string2);
            this.urlName = ldapURL.getDN();
            this.urlAttrs = ldapURL.getAttributes();
            this.urlScope = ldapURL.getScope();
            this.urlFilter = ldapURL.getFilter();
            this.urlExtns = ldapURL.getExtensions();
            this.urlName = this.urlName == null ? string : "";
            try {
                object = NamingManager.getObjectInstance(string2, null, null, hashtable);
            }
            catch (NamingException namingException) {
                if (n == 2) {
                    throw namingException;
                }
                this.previousEx = namingException;
                continue;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
            break;
        }
        if (!(object instanceof DirContext)) {
            NotContextException notContextException = new NotContextException("Cannot create context for: " + string2);
            notContextException.setRemainingName(new CompositeName().add(string));
            throw notContextException;
        }
        this.refCtx = (DirContext)object;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.addToEnvironment(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind_aux(this.overrideName(string), object);
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.bind_aux(this.overrideName(string), object, attributes);
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind_aux(this.overrideName(name), object);
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.bind_aux(this.overrideName(name), object, attributes);
    }

    private void bind_aux(Name name, Object object) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.bind(name, object);
    }

    private void bind_aux(Name name, Object object, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.bind(name, object, attributes);
    }

    public void close() throws NamingException {
        if (this.refCtx != null) {
            this.refCtx.close();
            this.refCtx = null;
        }
        this.refEx = null;
    }

    public String composeName(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException("LdapCtx.composeName should never throw ReferralException.");
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException("LdapCtx.composeName should never throw ReferralException.");
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext_aux(this.overrideName(string));
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        return this.createSubcontext_aux(this.overrideName(string), attributes);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext_aux(this.overrideName(name));
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return this.createSubcontext_aux(this.overrideName(name), attributes);
    }

    private Context createSubcontext_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.createSubcontext(name);
    }

    private DirContext createSubcontext_aux(Name name, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.createSubcontext(name, attributes);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext_aux(this.overrideName(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext_aux(this.overrideName(name));
    }

    private void destroySubcontext_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.destroySubcontext(name);
    }

    byte[] extension(String string, byte[] byArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            return ((LdapCtx)this.refCtx).extension(string, byArray);
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && this.refEx.hasMoreReferrals()) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes_aux(this.overrideName(string));
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        return this.getAttributes_aux(this.overrideName(string), stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes_aux(this.overrideName(name));
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes_aux(this.overrideName(name), stringArray);
    }

    private Attributes getAttributes_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getAttributes(name);
    }

    private Attributes getAttributes_aux(Name name, String[] stringArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getAttributes(name, stringArray);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getEnvironment();
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser_aux(this.overrideName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser_aux(this.overrideName(name));
    }

    private NameParser getNameParser_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getNameParser(name);
    }

    public DirContext getSchema(String string) throws NamingException {
        return this.getSchema_aux(this.overrideName(string));
    }

    public DirContext getSchema(Name name) throws NamingException {
        return this.getSchema_aux(this.overrideName(name));
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        return this.getSchemaClassDefinition_aux(this.overrideName(string));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition_aux(this.overrideName(name));
    }

    private DirContext getSchemaClassDefinition_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getSchemaClassDefinition(name);
    }

    private DirContext getSchema_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.getSchema(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list_aux(this.overrideName(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list_aux(this.overrideName(name));
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings_aux(this.overrideName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings_aux(this.overrideName(name));
    }

    private NamingEnumeration listBindings_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration namingEnumeration = this.refCtx.listBindings(name);
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && this.refEx.hasMoreReferrals()) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    private NamingEnumeration list_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration namingEnumeration = this.refCtx.list(name);
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && this.refEx.hasMoreReferrals()) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup_aux(this.overrideName(string));
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup_aux(this.overrideName(name));
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink_aux(this.overrideName(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink_aux(this.overrideName(name));
    }

    private Object lookupLink_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.lookupLink(name);
    }

    private Object lookup_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.lookup(name);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes_aux(this.overrideName(string), n, attributes);
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes_aux(this.overrideName(string), modificationItemArray);
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes_aux(this.overrideName(name), n, attributes);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes_aux(this.overrideName(name), modificationItemArray);
    }

    private void modifyAttributes_aux(Name name, int n, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.modifyAttributes(name, n, attributes);
    }

    private void modifyAttributes_aux(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.modifyAttributes(name, modificationItemArray);
    }

    private Name overrideName(String string) throws InvalidNameException {
        return this.urlName == null ? new CompositeName(string) : (this.urlName.equals("") ? new CompositeName() : new CompositeName().add(this.urlName));
    }

    private Name overrideName(Name name) throws InvalidNameException {
        return this.urlName == null ? name : (this.urlName.equals("") ? new CompositeName() : new CompositeName().add(this.urlName));
    }

    private SearchControls overrideScope(SearchControls searchControls) {
        if (this.urlScope != null) {
            SearchControls searchControls2 = new SearchControls(searchControls.getSearchScope(), searchControls.getCountLimit(), searchControls.getTimeLimit(), searchControls.getReturningAttributes(), searchControls.getReturningObjFlag(), searchControls.getDerefLinkFlag());
            if (this.urlScope.equals("base")) {
                searchControls2.setSearchScope(0);
            } else if (this.urlScope.equals("one")) {
                searchControls2.setSearchScope(1);
            } else if (this.urlScope.equals("sub")) {
                searchControls2.setSearchScope(2);
            }
            return searchControls2;
        }
        return searchControls;
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind_aux(this.overrideName(string), object);
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.rebind_aux(this.overrideName(string), object, attributes);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind_aux(this.overrideName(name), object);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.rebind_aux(this.overrideName(name), object, attributes);
    }

    private void rebind_aux(Name name, Object object) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rebind(name, object);
    }

    private void rebind_aux(Name name, Object object, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rebind(name, object, attributes);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        return this.refCtx.removeFromEnvironment(string);
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename_aux(this.overrideName(string), new CompositeName(string2));
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename_aux(this.overrideName(name), name2);
    }

    private void rename_aux(Name name, Name name2) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.rename(name, name2);
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        return this.search_aux(this.overrideName(string), string2, this.overrideScope(searchControls));
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search_aux(this.overrideName(string), string2, objectArray, this.overrideScope(searchControls));
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        return this.search_aux(this.overrideName(string), attributes);
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return this.search_aux(this.overrideName(string), attributes, stringArray);
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        return this.search_aux(this.overrideName(name), string, this.overrideScope(searchControls));
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search_aux(this.overrideName(name), string, objectArray, this.overrideScope(searchControls));
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        return this.search_aux(this.overrideName(name), attributes);
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        return this.search_aux(this.overrideName(name), attributes, stringArray);
    }

    private NamingEnumeration search_aux(Name name, String string, SearchControls searchControls) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration namingEnumeration = this.refCtx.search(name, string, searchControls);
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && this.refEx.hasMoreReferrals()) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    private NamingEnumeration search_aux(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            if (this.urlScope != null && this.urlScope.equals("base")) {
                searchControls.setSearchScope(0);
            }
            NamingEnumeration namingEnumeration = this.refCtx.search(name, string, objectArray, searchControls);
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && this.refEx.hasMoreReferrals()) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    private NamingEnumeration search_aux(Name name, Attributes attributes) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration namingEnumeration = this.refCtx.search(name, attributes);
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && this.refEx.hasMoreReferrals()) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    private NamingEnumeration search_aux(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        try {
            NamingEnumeration namingEnumeration = this.refCtx.search(name, attributes, stringArray);
            this.refEx.setNameResolved(true);
            ((ReferralEnumeration)namingEnumeration).appendUnprocessedReferrals(this.refEx);
            return namingEnumeration;
        }
        catch (LdapReferralException ldapReferralException) {
            ldapReferralException.appendUnprocessedReferrals(this.refEx);
            throw (NamingException)ldapReferralException.fillInStackTrace();
        }
        catch (NamingException namingException) {
            if (this.refEx != null && this.refEx.hasMoreReferrals()) {
                throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
            }
            throw namingException;
        }
    }

    void setHopCount(int n) {
        this.hopCount = n;
        if (this.refCtx != null && this.refCtx instanceof LdapCtx) {
            ((LdapCtx)this.refCtx).setHopCount(n);
        }
    }

    public void unbind(String string) throws NamingException {
        this.unbind_aux(this.overrideName(string));
    }

    public void unbind(Name name) throws NamingException {
        this.unbind_aux(this.overrideName(name));
    }

    private void unbind_aux(Name name) throws NamingException {
        if (this.skipThisReferral) {
            throw (NamingException)this.refEx.appendUnprocessedReferrals(null).fillInStackTrace();
        }
        this.refCtx.unbind(name);
    }
}

