/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapCtxFactory;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.ReferralEnumeration;
import com.sun.jndi.toolkit.Continuation;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

class LdapNamingEnumeration
implements NamingEnumeration,
ReferralEnumeration {
    protected boolean cleaned = false;
    LdapResult res;
    LdapClient enumClnt;
    Name listArg;
    Continuation cont;
    Vector entries = null;
    int limit = 0;
    int posn = 0;
    LdapCtx homeCtx;
    LdapReferralException refEx = null;
    LimitExceededException limitEx = null;
    PartialResultException partialRes = null;

    LdapNamingEnumeration(LdapCtx ldapCtx, LdapResult ldapResult, Name name, Continuation continuation) throws NamingException {
        if (ldapResult.status != 0 && ldapResult.status != 4 && ldapResult.status != 3 && ldapResult.status != 11 && ldapResult.status != 10 && ldapResult.status != 9) {
            NamingException namingException = new NamingException(LdapCtx.extractLdapError(ldapResult));
            throw continuation.fillInException(namingException);
        }
        this.res = ldapResult;
        this.entries = ldapResult.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.listArg = name;
        this.cont = continuation;
        if (ldapResult.refEx != null) {
            this.refEx = ldapResult.refEx;
        }
        this.homeCtx = ldapCtx;
        ldapCtx.incEnumCount();
        this.enumClnt = ldapCtx.clnt;
    }

    public void appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        this.refEx = ldapReferralException.appendUnprocessedReferrals(this.refEx);
    }

    protected void cleanup() {
        if (this.cleaned) {
            return;
        }
        if (this.enumClnt != null) {
            this.enumClnt.clearSearchReply(this.res);
        }
        this.enumClnt = null;
        this.cleaned = true;
        if (this.homeCtx != null) {
            this.homeCtx.decEnumCount();
        }
    }

    protected NameClassPair createItem(String string, Attributes attributes) throws NamingException {
        String string2 = null;
        Attribute attribute = attributes.get(Obj.JAVA_ATTRIBUTES[2]);
        string2 = attribute != null ? (String)attribute.get() : LdapCtxFactory.getObjectClassName(attributes);
        CompositeName compositeName = new CompositeName();
        compositeName.add(this.getAtom(string));
        return new NameClassPair(compositeName.toString(), string2);
    }

    protected void finalize() {
        this.cleanup();
    }

    protected String getAtom(String string) {
        try {
            Name name = LdapCtx.parser.parse(string);
            return name.get(name.size() - 1);
        }
        catch (NamingException namingException) {
            return string;
        }
    }

    private void getNextBatch() throws NamingException {
        this.res = this.homeCtx.getSearchReply(this.enumClnt, this.res);
        if (this.res == null) {
            this.posn = 0;
            this.limit = 0;
            return;
        }
        this.entries = this.res.entries;
        this.limit = this.entries == null ? 0 : this.entries.size();
        this.posn = 0;
        if (this.res.status != 0 || this.res.status == 0 && this.res.referrals != null) {
            try {
                this.homeCtx.processReturnCode(this.res, this.listArg);
            }
            catch (LimitExceededException limitExceededException) {
                this.setLimitExceededException(limitExceededException);
            }
            catch (PartialResultException partialResultException) {
                this.setPartialResultException(partialResultException);
            }
        }
        if (this.res.refEx != null) {
            this.refEx = this.res.refEx;
        }
    }

    protected LdapNamingEnumeration getReferredResults(LdapReferralContext ldapReferralContext) throws NamingException {
        return (LdapNamingEnumeration)ldapReferralContext.list(this.listArg);
    }

    public boolean hasMore() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn < this.limit) {
            return true;
        }
        if (this.limitEx != null) {
            this.cleanup();
            throw this.limitEx;
        }
        if (this.partialRes != null) {
            this.cleanup();
            throw this.partialRes;
        }
        try {
            return this.hasMoreReferrals();
        }
        catch (NamingException namingException) {
            this.cleanup();
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException namingException) {
            this.cleanup();
            return false;
        }
    }

    protected boolean hasMoreReferrals() throws NamingException {
        if (this.refEx != null && this.refEx.hasMoreReferrals()) {
            if (this.homeCtx.handleReferrals == 2) {
                throw (NamingException)this.refEx.fillInStackTrace();
            }
            LdapReferralContext ldapReferralContext = (LdapReferralContext)this.refEx.getReferralContext();
            try {
                this.update(this.getReferredResults(ldapReferralContext));
            }
            finally {
                Object var3_2 = null;
                ldapReferralContext.close();
            }
            return this.hasMore();
        }
        this.cleanup();
        return false;
    }

    public Object next() throws NamingException {
        try {
            return this.nextAux();
        }
        catch (NamingException namingException) {
            this.cleanup();
            throw this.cont.fillInException(namingException);
        }
    }

    private Object nextAux() throws NamingException {
        if (this.posn == this.limit) {
            this.getNextBatch();
        }
        if (this.posn >= this.limit) {
            this.cleanup();
            throw new NoSuchElementException("invalid enumeration handle");
        }
        LdapEntry ldapEntry = (LdapEntry)this.entries.elementAt(this.posn++);
        return this.createItem(ldapEntry.DN, ldapEntry.attributes);
    }

    public Object nextElement() {
        try {
            return this.nextAux();
        }
        catch (NamingException namingException) {
            this.cleanup();
            return null;
        }
    }

    void setLimitExceededException(LimitExceededException limitExceededException) {
        this.limitEx = limitExceededException;
    }

    void setPartialResultException(PartialResultException partialResultException) {
        this.partialRes = partialResultException;
    }

    protected void update(LdapNamingEnumeration ldapNamingEnumeration) {
        this.homeCtx.decEnumCount();
        this.homeCtx = ldapNamingEnumeration.homeCtx;
        this.enumClnt = ldapNamingEnumeration.enumClnt;
        ldapNamingEnumeration.homeCtx = null;
        this.posn = ldapNamingEnumeration.posn;
        this.limit = ldapNamingEnumeration.limit;
        this.res = ldapNamingEnumeration.res;
        this.entries = ldapNamingEnumeration.entries;
        this.refEx = ldapNamingEnumeration.refEx;
        this.listArg = ldapNamingEnumeration.listArg;
    }
}

