/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.toolkit.VersionHelper;
import com.sun.jndi.url.ldap.ldapURLContextFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public final class LdapCtxFactory
implements ObjectFactory,
InitialContextFactory {
    static VersionHelper helper = VersionHelper.getVersionHelper();
    private Hashtable myProperties = null;
    public static final String ADDRESS_TYPE = "URL";
    static /* synthetic */ Class class$javax$naming$directory$DirContext;
    static /* synthetic */ Class class$com$sun$jndi$ldap$LdapCtxFactory;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected LdapCtx createCtx(String string, Hashtable hashtable) throws NamingException {
        String string2 = null;
        String string3 = null;
        Object var5_5 = null;
        try {
            String string4;
            int n;
            String string5;
            if (hashtable != null) {
                string2 = (String)hashtable.get("java.naming.provider.url");
                string3 = (String)hashtable.get("java.naming.security.principal");
                var5_5 = hashtable.get("java.naming.security.credentials");
                if (var5_5 != null && !(var5_5 instanceof String) && !(var5_5 instanceof byte[])) {
                    throw new IllegalArgumentException("Illegal type for java.naming.security.credentials property.");
                }
            }
            if (string2 == null) {
                try {
                    string2 = helper.getJndiProperty(0);
                }
                catch (SecurityException securityException) {}
            }
            if (string2 == null) {
                string5 = "localhost";
                n = 389;
                string4 = "";
            } else {
                LdapURL ldapURL = new LdapURL(string2);
                String string6 = ldapURL.getScheme();
                if (string6 == null) {
                    throw new ConfigurationException("URL scheme is missing");
                }
                if (!string6.equals("ldap")) {
                    throw new ConfigurationException("URL scheme '" + string6 + "'is unsupported");
                }
                n = ldapURL.getPort();
                if (n == -1) {
                    n = 0;
                }
                string4 = ldapURL.getDN();
                string5 = ldapURL.getHost();
            }
            if (string4 != null) {
                string = string != null && !string.equals("") ? String.valueOf(string) + "," + string4 : string4;
            }
            return new LdapCtx(string, string5, n, string3, var5_5, hashtable);
        }
        catch (LdapReferralException ldapReferralException) {
            if (ldapReferralException.getHandleReferrals() == 2) {
                throw ldapReferralException;
            }
            return (LdapCtx)ldapReferralException.getReferralContext();
        }
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        return this.createCtx("", hashtable);
    }

    static Object getLdapObjectInstance(LdapCtx ldapCtx, String string, Attributes attributes) throws NamingException {
        String string2 = LdapCtxFactory.getObjectClassName(attributes);
        return new LdapCtx(ldapCtx, string, string2);
    }

    static String getObjectClassName(Attributes attributes) {
        return (class$javax$naming$directory$DirContext != null ? class$javax$naming$directory$DirContext : (class$javax$naming$directory$DirContext = LdapCtxFactory.class$("javax.naming.directory.DirContext"))).getName();
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (!LdapCtxFactory.isLdapRef(object)) {
            return null;
        }
        ldapURLContextFactory ldapURLContextFactory2 = new ldapURLContextFactory();
        String[] stringArray = LdapCtxFactory.getURLs((Reference)object);
        return ldapURLContextFactory2.getObjectInstance(stringArray, name, context, hashtable);
    }

    private static String[] getURLs(Reference reference) throws NamingException {
        String[] stringArray;
        int n = 0;
        String[] stringArray2 = new String[reference.size()];
        Enumeration enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!(stringArray instanceof StringRefAddr) || !stringArray.getType().equals(ADDRESS_TYPE)) continue;
            stringArray2[n++] = (String)stringArray.getContent();
        }
        if (n == 0) {
            throw new ConfigurationException("Reference contains no valid addresses");
        }
        if (n == reference.size()) {
            return stringArray2;
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }

    private static boolean isLdapRef(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        String string = (class$com$sun$jndi$ldap$LdapCtxFactory != null ? class$com$sun$jndi$ldap$LdapCtxFactory : (class$com$sun$jndi$ldap$LdapCtxFactory = LdapCtxFactory.class$("com.sun.jndi.ldap.LdapCtxFactory"))).getName();
        Reference reference = (Reference)object;
        return string.equals(reference.getFactoryClassName());
    }
}

