/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapBindingEnumeration;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapCtxFactory;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapNameParser;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.LdapSchemaCtx;
import com.sun.jndi.ldap.LdapSearchEnumeration;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.toolkit.ComponentDirContext;
import com.sun.jndi.toolkit.Continuation;
import com.sun.jndi.toolkit.SearchFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.NamingManager;

public final class LdapCtx
extends ComponentDirContext {
    static NameParser parser = new LdapNameParser();
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final String DEFAULT_HOST = "localhost";
    int port_number;
    String hostname = null;
    private static final boolean debug = false;
    private Object passwd = null;
    private String user = null;
    LdapClient clnt = null;
    String currentDN = "";
    private String url = null;
    Hashtable envprops = null;
    String[][] controls = null;
    String secProtocol = null;
    String socketFactory = null;
    Object trace = null;
    boolean netscapeSchemaBug = false;
    private boolean parentIsLdapCtx = false;
    static final int DEFAULT_REFERRAL_LIMIT = 10;
    private static final String REFERRAL_LIMIT = "java.naming.ldap.referral.limit";
    int referralHopLimit = 10;
    int hopCount = 1;
    private Hashtable schemaTrees = null;
    static final boolean DEFAULT_DELETE_RDN = true;
    static final boolean DEFAULT_TYPES_ONLY = false;
    static final int DEFAULT_DEREF_ALIASES = 3;
    static final int DEFAULT_LDAP_VERSION = 32;
    static final int DEFAULT_BATCH_SIZE = 1;
    static final int DEFAULT_REFERRAL_MODE = 3;
    static final char DEFAULT_REF_SEPARATOR = '#';
    int batchSize = 1;
    int handleReferrals = 3;
    int ldapVersion = 32;
    boolean deleteRDN = true;
    boolean typesOnly = false;
    int derefAliases = 3;
    char addrEncodingSeparator = (char)35;
    static final boolean DEFAULT_NETSCAPE_SCHEMA = false;
    static final String DEFAULT_SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    String authMechanism = null;
    String binaryAttrs = null;
    private static final String VERSION = "java.naming.ldap.version";
    private static final String BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";
    private static final String CONTROLS = "java.naming.ldap.control.generic";
    private static final String MANAGE_REFERRAL = "java.naming.ldap.control.manageReferral";
    private static final String DELETE_RDN = "java.naming.ldap.deleteRDN";
    private static final String DEREF_ALIASES = "java.naming.ldap.derefAliases";
    private static final String TYPES_ONLY = "java.naming.ldap.typesOnly";
    private static final String REF_SEPARATOR = "java.naming.ldap.ref.separator";
    private static final String SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    private static final String TRACE_BER = "com.sun.naming.ldap.trace.ber";
    private static final String NETSCAPE_SCHEMA_BUG = "com.sun.naming.netscape.schemaBugs";
    private int enumCount = 0;
    private boolean closeRequested = false;

    public LdapCtx(LdapCtx ldapCtx, String string, String string2) throws NamingException {
        this.hostname = ldapCtx.hostname;
        this.port_number = ldapCtx.port_number;
        this.user = ldapCtx.user;
        this.passwd = ldapCtx.passwd;
        this.currentDN = string;
        this.clnt = ldapCtx.clnt;
        this.clnt.incRefCount();
        this.envprops = ldapCtx.envprops;
        this.schemaTrees = ldapCtx.schemaTrees;
        this.parentIsLdapCtx = string == null || string.equals(ldapCtx.currentDN) ? ldapCtx.parentIsLdapCtx : true;
        this.initEnv();
    }

    public LdapCtx(String string) throws NamingException {
        this(string, DEFAULT_HOST, 389);
    }

    public LdapCtx(String string, String string2) throws NamingException {
        this(string, string2, 389);
    }

    public LdapCtx(String string, String string2, int n) throws NamingException {
        this.hostname = string2;
        this.port_number = n;
        this.currentDN = string;
        this.schemaTrees = new Hashtable(11, 0.75f);
        this.initEnv();
        this.connect();
    }

    public LdapCtx(String string, String string2, int n, String string3, Object object, Hashtable hashtable) throws NamingException {
        this.hostname = string2;
        this.port_number = n;
        this.user = string3 == null && hashtable != null ? (String)hashtable.get("java.naming.security.principal") : string3;
        this.passwd = object == null && hashtable != null ? hashtable.get("java.naming.security.credentials") : object;
        this.currentDN = string;
        this.envprops = hashtable;
        this.schemaTrees = new Hashtable(11, 0.75f);
        this.initEnv();
        this.connect();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (object == null) {
            return this.removeFromEnvironment(string);
        }
        if (string.equals(REF_SEPARATOR)) {
            this.setRefSeparator((String)object);
        } else if (string.equals(TYPES_ONLY)) {
            this.setTypesOnly((String)object);
        } else if (string.equals(DELETE_RDN)) {
            this.setDeleteRDN((String)object);
        } else if (string.equals(DEREF_ALIASES)) {
            this.setDerefAliases((String)object);
        } else if (string.equals("java.naming.batchsize")) {
            this.setBatchSize((String)object);
        } else if (string.equals(REFERRAL_LIMIT)) {
            this.setReferralLimit((String)object);
        } else if (string.equals(TRACE_BER)) {
            this.setTrace(object);
        } else if (string.equals(NETSCAPE_SCHEMA_BUG)) {
            this.setNetscapeBug((String)object);
        } else if (string.equals("java.naming.referral")) {
            this.setReferralMode((String)object);
            this.closeConnection();
        } else if (string.equals(VERSION)) {
            this.setProtocolVersion((String)object);
            this.closeConnection();
        } else if (string.equals(BINARY_ATTRIBUTES)) {
            this.binaryAttrs = (String)object;
            this.closeConnection();
        } else if (string.equals(CONTROLS)) {
            this.updateGenericControl((String[])object);
            this.closeConnection();
        } else if (string.equals(MANAGE_REFERRAL)) {
            this.updateReferralControl((String)object);
            this.closeConnection();
        } else if (string.equals(SOCKET_FACTORY)) {
            this.socketFactory = (String)object;
            this.closeConnection();
        } else if (string.equals("java.naming.security.protocol")) {
            this.secProtocol = (String)object;
            this.setSocketFactory(this.socketFactory);
            this.closeConnection();
        } else if (string.equals("java.naming.security.authentication")) {
            this.setAuthMechanism((String)object);
            this.closeConnection();
        } else if (string.equals("java.naming.security.principal")) {
            this.user = (String)object;
            this.setAuthMechanism(this.authMechanism);
            this.closeConnection();
        } else if (string.equals("java.naming.security.credentials")) {
            this.passwd = object;
            this.closeConnection();
        }
        this.envprops = this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
        return this.envprops.put(string, object);
    }

    private void adjustDeleteStatus(String string, LdapResult ldapResult) {
        block3: {
            if (ldapResult.status != 32 || ldapResult.matchedDN == null) break block3;
            try {
                Name name = parser.parse(string);
                Name name2 = parser.parse(ldapResult.matchedDN);
                if (name.size() - name2.size() == 1) {
                    ldapResult.status = 0;
                }
            }
            catch (NamingException namingException) {}
        }
    }

    private DirContext buildSchemaTree(String string) throws NamingException {
        SearchControls searchControls = new SearchControls(0, 0L, 0, null, true, false);
        Name name = new CompositeName().add(string);
        NamingEnumeration namingEnumeration = this.c_search(name, "(objectClass=subschema)", searchControls, false, new Continuation());
        if (!namingEnumeration.hasMore()) {
            throw new OperationNotSupportedException("Cannot get schema from subschemasubentry: " + string);
        }
        SearchResult searchResult = (SearchResult)namingEnumeration.next();
        Object object = searchResult.getObject();
        if (!(object instanceof LdapCtx)) {
            throw new NamingException("Cannot get schema object as LdapCtx: " + string);
        }
        LdapCtx ldapCtx = (LdapCtx)object;
        Attributes attributes = searchResult.getAttributes();
        DirContext dirContext = LdapSchemaCtx.createSchemaTree(this.envprops, ldapCtx, attributes);
        return dirContext;
    }

    protected void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        this.c_bind(name, object, null, continuation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_bind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            if (object == null) {
                if (attributes == null) {
                    throw new IllegalArgumentException("cannot bind null object with no attributes");
                }
            } else {
                attributes = Obj.determineBindAttrs(this.addrEncodingSeparator, object, attributes, false);
            }
            String string = this.fullyQualifiedName(name);
            LdapEntry ldapEntry = new LdapEntry(string, attributes);
            LdapResult ldapResult = this.clnt.add(ldapEntry);
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var8_15;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        ldapReferralContext.bind(name, object, attributes);
                        var8_15 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var8_15 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var8_15 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        return this.c_createSubcontext(name, null, continuation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DirContext c_createSubcontext(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            Object object;
            this.ensureOpen();
            if (attributes == null) {
                object = new BasicAttribute(Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_OBJECT_CLASSES[0]);
                object.add("top");
                attributes = new BasicAttributes(true);
                attributes.put((Attribute)object);
            }
            object = this.fullyQualifiedName(name);
            LdapEntry ldapEntry = new LdapEntry((String)object, attributes);
            LdapResult ldapResult = this.clnt.add(ldapEntry);
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
                return null;
            }
            return (LdapCtx)LdapCtxFactory.getLdapObjectInstance(this, (String)object, attributes);
        }
        catch (LdapReferralException ldapReferralException) {
            DirContext dirContext;
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var8_14;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        dirContext = ldapReferralContext.createSubcontext(name, attributes);
                        var8_14 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var8_14 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var8_14 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return dirContext;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_destroySubcontext(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            String string = this.fullyQualifiedName(name);
            LdapResult ldapResult = this.clnt.delete(string);
            this.adjustDeleteStatus(string, ldapResult);
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var6_11;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        ldapReferralContext.destroySubcontext(name);
                        var6_11 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var6_11 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var6_11 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected Attributes c_getAttributes(Name name, Continuation continuation) throws NamingException {
        return this.c_getAttributes(name, null, continuation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Attributes c_getAttributes(Name name, String[] stringArray, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        searchControls.setReturningAttributes(stringArray);
        try {
            LdapResult ldapResult = this.doSearchOnce(name, "(objectClass=*)", searchControls, true);
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
            }
            if (ldapResult.entries != null && ldapResult.entries.size() == 1) {
                LdapEntry ldapEntry = (LdapEntry)ldapResult.entries.elementAt(0);
                this.setParents(ldapEntry.attributes, name);
                return ldapEntry.attributes;
            }
            return new BasicAttributes(true);
        }
        catch (LdapReferralException ldapReferralException) {
            Attributes attributes;
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var9_11;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        attributes = ldapReferralContext.getAttributes(name, stringArray);
                        var9_11 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var9_11 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return attributes;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return parser;
    }

    protected DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            return this.getSchemaTree(name);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            DirContext dirContext;
            Object object;
            Attribute attribute = this.getAttributes(name).get("objectclass");
            if (attribute == null || attribute.size() == 0) {
                throw new NameNotFoundException(String.valueOf(this.currentDN) + " has no objectClass associated with it");
            }
            String string = (String)attribute.get();
            if (string.equalsIgnoreCase("top") && attribute.size() > 1) {
                attribute.remove(string);
                string = (String)attribute.get();
            }
            if (!((object = (dirContext = this.getSchema(name)).lookup("ClassDefinition/" + string)) instanceof DirContext)) {
                throw new NameNotFoundException("Can't find a class definition for " + this.currentDN);
            }
            return (DirContext)object;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NamingEnumeration c_list(Name name, Continuation continuation) throws NamingException {
        SearchControls searchControls = new SearchControls();
        String[] stringArray = new String[]{Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_ATTRIBUTES[2]};
        searchControls.setReturningAttributes(stringArray);
        searchControls.setReturningObjFlag(true);
        continuation.setError((Object)this, name);
        LdapResult ldapResult = null;
        try {
            ldapResult = this.doSearch(name, "(objectClass=*)", searchControls, true);
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
            }
            return new LdapNamingEnumeration(this, ldapResult, name, continuation);
        }
        catch (LdapReferralException ldapReferralException) {
            NamingEnumeration namingEnumeration;
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var10_14;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        namingEnumeration = ldapReferralContext.list(name);
                        var10_14 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var10_14 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var10_14 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return namingEnumeration;
        }
        catch (LimitExceededException limitExceededException) {
            LdapNamingEnumeration ldapNamingEnumeration = new LdapNamingEnumeration(this, ldapResult, name, continuation);
            ldapNamingEnumeration.setLimitExceededException((LimitExceededException)continuation.fillInException(limitExceededException));
            return ldapNamingEnumeration;
        }
        catch (PartialResultException partialResultException) {
            LdapNamingEnumeration ldapNamingEnumeration = new LdapNamingEnumeration(this, ldapResult, name, continuation);
            ldapNamingEnumeration.setPartialResultException((PartialResultException)continuation.fillInException(partialResultException));
            return ldapNamingEnumeration;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NamingEnumeration c_listBindings(Name name, Continuation continuation) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(Obj.JAVA_ATTRIBUTES);
        searchControls.setReturningObjFlag(true);
        continuation.setError((Object)this, name);
        LdapResult ldapResult = null;
        try {
            ldapResult = this.doSearch(name, "(objectClass=*)", searchControls, true);
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
            }
            return new LdapBindingEnumeration(this, ldapResult, name, continuation);
        }
        catch (LdapReferralException ldapReferralException) {
            NamingEnumeration namingEnumeration;
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var9_13;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        namingEnumeration = ldapReferralContext.listBindings(name);
                        var9_13 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var9_13 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var9_13 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return namingEnumeration;
        }
        catch (LimitExceededException limitExceededException) {
            LdapBindingEnumeration ldapBindingEnumeration = new LdapBindingEnumeration(this, ldapResult, name, continuation);
            ldapBindingEnumeration.setLimitExceededException((LimitExceededException)continuation.fillInException(limitExceededException));
            return ldapBindingEnumeration;
        }
        catch (PartialResultException partialResultException) {
            LdapBindingEnumeration ldapBindingEnumeration = new LdapBindingEnumeration(this, ldapResult, name, continuation);
            ldapBindingEnumeration.setPartialResultException((PartialResultException)continuation.fillInException(partialResultException));
            return ldapBindingEnumeration;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object c_lookup(Name name, Continuation continuation) throws NamingException {
        Object object;
        Object object2;
        continuation.setError((Object)this, name);
        try {
            Attributes attributes;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(Obj.JAVA_ATTRIBUTES);
            searchControls.setReturningObjFlag(true);
            object2 = this.doSearchOnce(name, "(objectClass=*)", searchControls, true);
            if (((LdapResult)object2).status != 0) {
                this.processReturnCode((LdapResult)object2, name);
            }
            if (((LdapResult)object2).entries == null || ((LdapResult)object2).entries.size() != 1) {
                attributes = new BasicAttributes(true);
            } else {
                LdapEntry ldapEntry = (LdapEntry)((LdapResult)object2).entries.elementAt(0);
                attributes = ldapEntry.attributes;
            }
            object = attributes.get(Obj.JAVA_ATTRIBUTES[2]) != null ? Obj.decodeObject(attributes) : LdapCtxFactory.getLdapObjectInstance(this, this.fullyQualifiedName(name), attributes);
        }
        catch (LdapReferralException ldapReferralException) {
            Object object3;
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var8_16;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        object3 = ldapReferralContext.lookup(name);
                        var8_16 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var8_16 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var8_16 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return object3;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
        try {
            return NamingManager.getObjectInstance(object, name, this, this.envprops);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
        catch (Exception exception) {
            object2 = new NamingException("problem generating object using object factory");
            ((NamingException)object2).setRootCause(exception);
            throw continuation.fillInException((NamingException)object2);
        }
    }

    protected Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_modifyAttributes(Name name, int n, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            if (attributes == null) return;
            if (attributes.size() == 0) {
                return;
            }
            String string = this.fullyQualifiedName(name);
            int n2 = LdapCtx.convertToLdapModCode(n);
            int[] nArray = new int[attributes.size()];
            Attribute[] attributeArray = new BasicAttribute[attributes.size()];
            NamingEnumeration namingEnumeration = attributes.getAll();
            int n3 = 0;
            while (true) {
                if (n3 >= nArray.length || !namingEnumeration.hasMore()) {
                    LdapResult ldapResult = this.clnt.modify(string, nArray, attributeArray);
                    if (ldapResult.status == 0) return;
                    this.processReturnCode(ldapResult, name);
                    return;
                }
                nArray[n3] = n2;
                attributeArray[n3] = (Attribute)namingEnumeration.next();
                ++n3;
            }
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var8_16;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        ldapReferralContext.modifyAttributes(name, n, attributes);
                        var8_16 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var8_16 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var8_16 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_modifyAttributes(Name name, ModificationItem[] modificationItemArray, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            if (modificationItemArray == null) return;
            if (modificationItemArray.length == 0) {
                return;
            }
            String string = this.fullyQualifiedName(name);
            int[] nArray = new int[modificationItemArray.length];
            Attribute[] attributeArray = new BasicAttribute[modificationItemArray.length];
            int n = 0;
            while (true) {
                Object object;
                if (n >= nArray.length) {
                    object = this.clnt.modify(string, nArray, attributeArray);
                    if (((LdapResult)object).status == 0) return;
                    this.processReturnCode((LdapResult)object, name);
                    return;
                }
                object = modificationItemArray[n];
                nArray[n] = LdapCtx.convertToLdapModCode(((ModificationItem)object).getModificationOp());
                attributeArray[n] = ((ModificationItem)object).getAttribute();
                ++n;
            }
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var7_15;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        ldapReferralContext.modifyAttributes(name, modificationItemArray);
                        var7_15 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var7_15 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var7_15 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        this.c_rebind(name, object, null, continuation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_rebind(Name name, Object object, Attributes attributes, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            Object object2;
            Attributes attributes2 = null;
            boolean bl = false;
            try {
                attributes2 = this.getAttributes(name);
            }
            catch (NameNotFoundException nameNotFoundException) {}
            if (attributes2 == null) {
                this.c_bind(name, object, attributes, continuation);
                return;
            }
            if (attributes == null && object instanceof DirContext) {
                bl = true;
                attributes = ((DirContext)object).getAttributes("");
            }
            Attributes attributes3 = (Attributes)attributes2.clone();
            if (attributes == null) {
                int n;
                object2 = attributes2.get(Obj.JAVA_ATTRIBUTES[0]);
                if (object2 != null) {
                    object2 = (Attribute)object2.clone();
                    n = 0;
                    while (n < Obj.JAVA_OBJECT_CLASSES.length) {
                        object2.remove(Obj.JAVA_OBJECT_CLASSES[n].toLowerCase());
                        object2.remove(Obj.JAVA_OBJECT_CLASSES[n]);
                        ++n;
                    }
                }
                n = 1;
                while (true) {
                    if (n >= Obj.JAVA_ATTRIBUTES.length) {
                        bl = true;
                        attributes = attributes2;
                        break;
                    }
                    attributes2.remove(Obj.JAVA_ATTRIBUTES[n]);
                    ++n;
                }
            }
            if (object != null) {
                attributes = Obj.determineBindAttrs(this.addrEncodingSeparator, object, attributes, bl);
            }
            object2 = this.fullyQualifiedName(name);
            LdapResult ldapResult = this.clnt.delete((String)object2);
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, name);
                return;
            }
            LdapEntry ldapEntry = new LdapEntry((String)object2, attributes);
            ldapResult = this.clnt.add(ldapEntry);
            if (ldapResult.status == 0) return;
            this.clnt.add(new LdapEntry((String)object2, attributes3));
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var8_16;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        ldapReferralContext.rebind(name, object, attributes);
                        var8_16 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var8_16 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var8_16 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_rename(Name name, Name name2, Continuation continuation) throws NamingException {
        String string = null;
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            Name name3 = parser.parse(name.get(0));
            Name name4 = parser.parse(name2.get(0));
            Name name5 = name3.getPrefix(name3.size() - 1);
            Name name6 = name4.getPrefix(name4.size() - 1);
            if (!name5.equals(name6)) {
                if (!this.clnt.ldapv3) {
                    throw new InvalidNameException("LDAPv2 doesn't support changing the parent as a result of a rename");
                }
                string = this.fullyQualifiedName(name6.toString());
            }
            String string2 = name4.get(name4.size() - 1);
            LdapResult ldapResult = this.clnt.moddn(this.fullyQualifiedName(name), string2, this.deleteRDN, string);
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var13_17;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        ldapReferralContext.rename(name, name2);
                        var13_17 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var13_17 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var13_17 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected NamingEnumeration c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        return this.c_search(name, string, searchControls, true, continuation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NamingEnumeration c_search(Name name, String string, SearchControls searchControls, boolean bl, Continuation continuation) throws NamingException {
        String[] stringArray;
        LdapResult ldapResult = null;
        String[] stringArray2 = new String[2];
        if (searchControls == null) {
            searchControls = new SearchControls();
        }
        String[] stringArray3 = searchControls.getReturningAttributes();
        if (searchControls.getReturningObjFlag() && stringArray3 != null) {
            stringArray = new String[stringArray3.length + Obj.JAVA_ATTRIBUTES.length];
            System.arraycopy(stringArray3, 0, stringArray, 0, stringArray3.length);
            System.arraycopy(Obj.JAVA_ATTRIBUTES, 0, stringArray, stringArray3.length, Obj.JAVA_ATTRIBUTES.length);
            searchControls.setReturningAttributes(stringArray);
        }
        stringArray = new SearchArgs(name, string, searchControls, stringArray3);
        continuation.setError((Object)this, name);
        try {
            if (LdapCtx.searchToCompare(name, string, searchControls, stringArray2)) {
                ldapResult = this.compare(name, stringArray2[0], stringArray2[1]);
                if (ldapResult.compareToSearchResult()) return new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), (SearchArgs)stringArray, continuation);
                this.processReturnCode(ldapResult, name);
                return new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), (SearchArgs)stringArray, continuation);
            }
            ldapResult = this.doSearch(name, string, searchControls, bl);
            this.processReturnCode(ldapResult, name);
            return new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), (SearchArgs)stringArray, continuation);
        }
        catch (LdapReferralException ldapReferralException) {
            NamingEnumeration namingEnumeration;
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var14_20;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        namingEnumeration = ldapReferralContext.search(name, string, searchControls);
                        var14_20 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var14_20 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var14_20 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return namingEnumeration;
        }
        catch (LimitExceededException limitExceededException) {
            LdapSearchEnumeration ldapSearchEnumeration = new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), (SearchArgs)stringArray, continuation);
            ldapSearchEnumeration.setLimitExceededException(limitExceededException);
            return ldapSearchEnumeration;
        }
        catch (PartialResultException partialResultException) {
            LdapSearchEnumeration ldapSearchEnumeration = new LdapSearchEnumeration(this, ldapResult, this.fullyQualifiedName(name), (SearchArgs)stringArray, continuation);
            ldapSearchEnumeration.setPartialResultException(partialResultException);
            return ldapSearchEnumeration;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected NamingEnumeration c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        String string2;
        try {
            string2 = SearchFilter.format(string, objectArray);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        return this.c_search(name, string2, searchControls, continuation);
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        return this.c_search(name, attributes, null, continuation);
    }

    protected NamingEnumeration c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        String string;
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        try {
            string = SearchFilter.format(attributes);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        return this.c_search(name, string, searchControls, continuation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void c_unbind(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            this.ensureOpen();
            String string = this.fullyQualifiedName(name);
            LdapResult ldapResult = this.clnt.delete(string);
            this.adjustDeleteStatus(string, ldapResult);
            if (ldapResult.status == 0) return;
            this.processReturnCode(ldapResult, name);
            return;
        }
        catch (LdapReferralException ldapReferralException) {
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw continuation.fillInException(ldapReferralException);
            }
            while (true) {
                Object var6_11;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        ldapReferralContext.unbind(name);
                        var6_11 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var6_11 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var6_11 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw continuation.fillInException(communicationException);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    public synchronized void close() throws NamingException {
        if (this.enumCount > 0) {
            this.closeRequested = true;
            return;
        }
        this.closeConnection();
    }

    private void closeConnection() {
        if (this.clnt != null) {
            this.clnt.close();
            this.clnt = null;
        }
    }

    private LdapResult compare(Name name, String string, String string2) throws IOException, NamingException {
        this.ensureOpen();
        String string3 = name.isEmpty() ? "" : name.get(0);
        return this.clnt.compare(string3, string, string2);
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        int n = name2.size() - 1;
        if (name.isEmpty() || name2.isEmpty() || name.get(0).equals("") || name2.get(n).equals("")) {
            return super.composeName(name, name2);
        }
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        if (this.parentIsLdapCtx) {
            String string = LdapCtx.concatNames(name3.get(n + 1), name3.get(n));
            name3.remove(n + 1);
            name3.remove(n);
            name3.add(n, string);
        }
        return name3;
    }

    static String concatNames(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        return String.valueOf(string) + "," + string2;
    }

    private void connect() throws NamingException {
        try {
            this.clnt = new LdapClient(this.hostname != null ? this.hostname : DEFAULT_HOST, this.port_number != 0 ? this.port_number : 389, this.user, this.passwd, this.ldapVersion, this.authMechanism, this.controls, this.socketFactory, this.trace);
            LdapResult ldapResult = this.clnt.getResult();
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult);
            }
            if (this.binaryAttrs != null) {
                this.clnt.setBinaryAttributes(this.binaryAttrs);
            }
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw ldapReferralException;
            }
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    private static int convertToLdapModCode(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid modification code");
    }

    synchronized void decEnumCount() {
        block2: {
            --this.enumCount;
            if (this.enumCount != 0 || !this.closeRequested) break block2;
            try {
                this.close();
            }
            catch (NamingException namingException) {}
        }
    }

    protected LdapResult doSearch(Name name, String string, SearchControls searchControls, boolean bl) throws NamingException {
        this.ensureOpen();
        try {
            int n;
            switch (searchControls.getSearchScope()) {
                case 0: {
                    n = 0;
                    break;
                }
                default: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                }
            }
            String[] stringArray = searchControls.getReturningAttributes();
            if (stringArray != null && stringArray.length == 0) {
                stringArray = new String[]{""};
            }
            String string2 = bl ? this.fullyQualifiedName(name) : (name.isEmpty() ? "" : name.get(0));
            int n2 = searchControls.getTimeLimit();
            int n3 = 0;
            if (n2 > 0) {
                n3 = n2 / 1000 + 1;
            }
            LdapResult ldapResult = this.clnt.search(string2, n, this.derefAliases, (int)searchControls.getCountLimit(), n3, searchControls.getReturningObjFlag() ? false : this.typesOnly, stringArray, string, this.batchSize);
            return ldapResult;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    private LdapResult doSearchOnce(Name name, String string, SearchControls searchControls, boolean bl) throws NamingException {
        LdapResult ldapResult = this.doSearch(name, string, searchControls, bl);
        this.clnt.clearSearchReply(ldapResult);
        return ldapResult;
    }

    private void ensureOpen() throws NamingException {
        if (this.clnt == null) {
            this.connect();
        }
    }

    byte[] extension(String string) throws NamingException {
        return this.extension(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] extension(String string, byte[] byArray) throws NamingException {
        this.ensureOpen();
        try {
            if (string == null) {
                throw new IllegalArgumentException("Extension identifier required");
            }
            LdapResult ldapResult = this.clnt.extension(string, byArray);
            if (ldapResult.status != 0) {
                this.processReturnCode(ldapResult, new CompositeName());
            }
            return ldapResult.extensionResponse;
        }
        catch (LdapReferralException ldapReferralException) {
            byte[] byArray2;
            LdapReferralContext ldapReferralContext;
            if (this.handleReferrals == 2) {
                throw ldapReferralException;
            }
            while (true) {
                Object var7_9;
                LdapReferralException ldapReferralException2;
                ldapReferralContext = (LdapReferralContext)ldapReferralException2.getReferralContext();
                try {
                    try {
                        byArray2 = ldapReferralContext.extension(string, byArray);
                        var7_9 = null;
                        break;
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        var7_9 = null;
                        ldapReferralContext.close();
                    }
                }
                catch (Throwable throwable) {
                    var7_9 = null;
                    ldapReferralContext.close();
                    throw throwable;
                }
            }
            ldapReferralContext.close();
            return byArray2;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    protected static String extractLdapError(LdapResult ldapResult) {
        String string = "[LDAP: error code " + ldapResult.status;
        if (ldapResult.errorMessage != null && ldapResult.errorMessage.length() != 0) {
            string = String.valueOf(string) + " - " + ldapResult.errorMessage + "]";
        } else {
            try {
                if (LdapClient.ldap_error_message[ldapResult.status] != null) {
                    string = String.valueOf(string) + " - " + LdapClient.ldap_error_message[ldapResult.status] + "]";
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                string = String.valueOf(string) + "]";
            }
        }
        return string;
    }

    private static final Vector extractURLs(String string) {
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(10, n)) >= 0) {
            ++n;
            ++n2;
        }
        Vector<String> vector = new Vector<String>(n2);
        boolean bl = false;
        n = string.indexOf(10);
        int n3 = n + 1;
        while ((n = string.indexOf(10, n3)) >= 0) {
            vector.addElement(string.substring(n3, n));
            n3 = n + 1;
        }
        vector.addElement(string.substring(n3));
        return vector;
    }

    private static boolean filterToAssertion(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        stringArray[0] = stringTokenizer.nextToken();
        stringArray[1] = stringTokenizer.nextToken();
        if (stringArray[1].equals("*")) {
            return false;
        }
        StringTokenizer stringTokenizer2 = null;
        stringTokenizer2 = new StringTokenizer(stringArray[0], "()&|!=~><*", true);
        if (stringTokenizer2.countTokens() != 1) {
            return false;
        }
        stringTokenizer2 = new StringTokenizer(stringArray[1], "()&|!=~><*", true);
        return stringTokenizer2.countTokens() == 1;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {}
    }

    private String fullyQualifiedName(String string) {
        return LdapCtx.concatNames(string, this.currentDN);
    }

    private String fullyQualifiedName(Name name) {
        return name.isEmpty() ? this.currentDN : this.fullyQualifiedName(name.get(0));
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
    }

    private String getSchemaEntry(Name name, boolean bl) throws NamingException {
        NamingEnumeration namingEnumeration = null;
        SearchControls searchControls = new SearchControls(0, 0L, 0, new String[]{"subschemasubentry"}, true, false);
        this.ensureOpen();
        try {
            namingEnumeration = this.c_search(name, "objectclass=*", searchControls, bl, new Continuation());
        }
        catch (NamingException namingException) {
            if (!this.clnt.ldapv3 && this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Cannot get schema information from server");
            }
            throw namingException;
        }
        if (!namingEnumeration.hasMoreElements()) {
            throw new ConfigurationException("Asking for schema of nonexistent entry: " + name);
        }
        SearchResult searchResult = (SearchResult)namingEnumeration.next();
        Attribute attribute = searchResult.getAttributes().get("subschemasubentry");
        if (attribute == null || attribute.size() < 0) {
            if (this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Server does not have a subschemasubentry in root DSE");
            }
            return this.getSchemaEntry(new CompositeName(), false);
        }
        String string = (String)attribute.get();
        return string;
    }

    private DirContext getSchemaTree(Name name) throws NamingException {
        String string = this.getSchemaEntry(name, true);
        DirContext dirContext = (DirContext)this.schemaTrees.get(string);
        if (dirContext == null) {
            dirContext = this.buildSchemaTree(string);
            this.schemaTrees.put(string, dirContext);
        }
        return dirContext;
    }

    LdapResult getSearchReply(LdapClient ldapClient, LdapResult ldapResult) throws NamingException {
        if (this.clnt != ldapClient) {
            throw new CommunicationException("Context's connection changed; unable to continue enumeration");
        }
        try {
            return ldapClient.getSearchReply(this.batchSize, ldapResult);
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    String getURL() {
        if (this.url == null) {
            StringBuffer stringBuffer = new StringBuffer("ldap://:/");
            stringBuffer.insert(9, this.currentDN);
            stringBuffer.insert(8, Integer.toString(this.port_number != 0 ? this.port_number : 389));
            stringBuffer.insert(7, this.hostname != null ? this.hostname : DEFAULT_HOST);
            this.url = stringBuffer.toString();
        }
        return this.url;
    }

    synchronized void incEnumCount() {
        ++this.enumCount;
    }

    private void initEnv() throws NamingException {
        if (this.envprops != null) {
            this.setBatchSize((String)this.envprops.get("java.naming.batchsize"));
            this.setReferralMode((String)this.envprops.get("java.naming.referral"));
            this.setRefSeparator((String)this.envprops.get(REF_SEPARATOR));
            this.setDeleteRDN((String)this.envprops.get(DELETE_RDN));
            this.setTypesOnly((String)this.envprops.get(TYPES_ONLY));
            this.setDerefAliases((String)this.envprops.get(DEREF_ALIASES));
            this.setReferralLimit((String)this.envprops.get(REFERRAL_LIMIT));
            this.setTrace(this.envprops.get(TRACE_BER));
            this.setNetscapeBug((String)this.envprops.get(NETSCAPE_SCHEMA_BUG));
            this.setProtocolVersion((String)this.envprops.get(VERSION));
            this.setManageControls((String[])this.envprops.get(CONTROLS), (String)this.envprops.get(MANAGE_REFERRAL));
            this.secProtocol = (String)this.envprops.get("java.naming.security.protocol");
            this.socketFactory = (String)this.envprops.get(SOCKET_FACTORY);
            this.binaryAttrs = (String)this.envprops.get(BINARY_ATTRIBUTES);
            this.authMechanism = (String)this.envprops.get("java.naming.security.authentication");
        } else if (this.handleReferrals == 3) {
            this.updateReferralControl("true");
        }
        this.setAuthMechanism(this.authMechanism);
        this.setSocketFactory(this.socketFactory);
    }

    protected void processReturnCode(LdapResult ldapResult) throws NamingException {
        this.processReturnCode(ldapResult, null, this, null, this.envprops, null);
    }

    void processReturnCode(LdapResult ldapResult, Name name) throws NamingException {
        this.processReturnCode(ldapResult, new CompositeName().add(this.currentDN), this, name, this.envprops, this.fullyQualifiedName(name));
    }

    protected void processReturnCode(LdapResult ldapResult, Name name, Object object, Name name2, Hashtable hashtable, String string) throws NamingException {
        NamingException namingException;
        String string2 = null;
        LdapReferralException ldapReferralException = null;
        string2 = LdapCtx.extractLdapError(ldapResult);
        switch (ldapResult.status) {
            case 0: {
                if (ldapResult.referrals != null) {
                    if (this.handleReferrals == 3) {
                        namingException = new PartialResultException(string2);
                        break;
                    }
                    int n = ldapResult.referrals.size();
                    LdapReferralException ldapReferralException2 = null;
                    LdapReferralException ldapReferralException3 = null;
                    int n2 = 0;
                    while (n2 < n) {
                        ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string);
                        ldapReferralException.setReferralInfo((Vector)ldapResult.referrals.elementAt(n2), true);
                        ldapReferralException.setHandleReferrals(this.handleReferrals);
                        if (this.hopCount > 1) {
                            ldapReferralException.setHopCount(this.hopCount);
                        }
                        if (ldapReferralException2 == null) {
                            ldapReferralException2 = ldapReferralException3 = ldapReferralException;
                        } else {
                            ldapReferralException3.nextRefEx = ldapReferralException;
                            ldapReferralException3 = ldapReferralException;
                        }
                        ++n2;
                    }
                    ldapResult.referrals = null;
                    if (ldapResult.refEx == null) {
                        ldapResult.refEx = ldapReferralException2;
                    } else {
                        ldapReferralException3 = ldapResult.refEx;
                        while (ldapReferralException3.nextRefEx != null) {
                            ldapReferralException3 = ldapReferralException3.nextRefEx;
                        }
                        ldapReferralException3.nextRefEx = ldapReferralException2;
                    }
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                        limitExceededException.setRootCause(ldapReferralException);
                        throw limitExceededException;
                    }
                }
                return;
            }
            case 10: {
                if (this.handleReferrals == 3) {
                    namingException = new PartialResultException(string2);
                    break;
                }
                ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string);
                ldapReferralException.setReferralInfo((Vector)ldapResult.referrals.elementAt(0), false);
                ldapReferralException.setHandleReferrals(this.handleReferrals);
                if (this.hopCount > 1) {
                    ldapReferralException.setHopCount(this.hopCount);
                }
                if (this.hopCount > this.referralHopLimit) {
                    LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                    limitExceededException.setRootCause(ldapReferralException);
                    namingException = limitExceededException;
                    break;
                }
                namingException = ldapReferralException;
                break;
            }
            case 9: {
                if (this.handleReferrals == 3) {
                    namingException = new PartialResultException(string2);
                    break;
                }
                if (ldapResult.errorMessage == null || ldapResult.errorMessage == "") {
                    namingException = new PartialResultException(string2);
                    break;
                }
                ldapResult.referrals = LdapCtx.extractURLs(ldapResult.errorMessage);
                ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string);
                ldapReferralException.setHandleReferrals(this.handleReferrals);
                if (this.hopCount > 1) {
                    ldapReferralException.setHopCount(this.hopCount);
                }
                if ((ldapResult.entries == null || ldapResult.entries.size() == 0) && ldapResult.referrals.size() == 1) {
                    ldapReferralException.setReferralInfo(ldapResult.referrals, false);
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                        limitExceededException.setRootCause(ldapReferralException);
                        namingException = limitExceededException;
                        break;
                    }
                    namingException = ldapReferralException;
                    break;
                }
                ldapReferralException.setReferralInfo(ldapResult.referrals, true);
                ldapResult.refEx = ldapReferralException;
                return;
            }
            case 36: {
                namingException = new NamingException(string2);
                break;
            }
            case 33: {
                namingException = new NamingException(string2);
                break;
            }
            case 20: {
                namingException = new AttributeInUseException(string2);
                break;
            }
            case 7: {
                namingException = new AuthenticationNotSupportedException(string2);
                break;
            }
            case 19: {
                namingException = new InvalidSearchControlsException(string2);
                break;
            }
            case 68: {
                namingException = new NameAlreadyBoundException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 48: 
            case 49: {
                namingException = new AuthenticationException(string2);
                break;
            }
            case 18: {
                namingException = new InvalidSearchFilterException(string2);
                break;
            }
            case 50: {
                namingException = new NoPermissionException(string2);
                break;
            }
            case 21: {
                namingException = new InvalidAttributeValueException(string2);
                break;
            }
            case 34: 
            case 64: {
                if (name2 != null) {
                    namingException = new InvalidNameException(String.valueOf(name2.toString()) + ": " + string2);
                    break;
                }
                namingException = new InvalidNameException(string2);
                break;
            }
            case 54: {
                namingException = new NamingException(string2);
                break;
            }
            case 16: {
                namingException = new NoSuchAttributeException(string2);
                break;
            }
            case 32: {
                namingException = new NameNotFoundException(string2);
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                namingException = new SchemaViolationException(string2);
                break;
            }
            case 66: {
                namingException = new ContextNotEmptyException(string2);
                break;
            }
            case 1: {
                namingException = new NamingException(string2);
                break;
            }
            case 80: {
                namingException = new NamingException(string2);
                break;
            }
            case 2: {
                namingException = new CommunicationException(string2);
                break;
            }
            case 4: {
                namingException = new SizeLimitExceededException(string2);
                break;
            }
            case 3: {
                namingException = new TimeLimitExceededException(string2);
                break;
            }
            case 12: {
                namingException = new OperationNotSupportedException(string2);
                break;
            }
            case 51: 
            case 52: {
                namingException = new ServiceUnavailableException(string2);
                break;
            }
            case 17: {
                namingException = new InvalidAttributeIdentifierException(string2);
                break;
            }
            case 53: {
                namingException = new OperationNotSupportedException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 35: {
                namingException = new NamingException(string2);
                break;
            }
            case 11: {
                namingException = new LimitExceededException(string2);
                break;
            }
            default: {
                namingException = new NamingException(string2);
            }
        }
        namingException.setResolvedName(name);
        namingException.setResolvedObj(object);
        namingException.setRemainingName(name2);
        throw namingException;
    }

    private void removeControl(boolean bl) {
        if (this.controls == null) {
            return;
        }
        int n = 0;
        while (n < this.controls.length) {
            String[] stringArray = this.controls[n];
            if (bl && stringArray[0].equals("2.16.840.1.113730.3.4.2") || !bl && !stringArray[0].equals("2.16.840.1.113730.3.4.2")) {
                int n2 = this.controls.length;
                String[][] stringArray2 = new String[n2 - 1][];
                if (n != 0) {
                    System.arraycopy(this.controls, 0, stringArray2, 0, n);
                }
                if (n < n2 - 1) {
                    System.arraycopy(this.controls, n + 1, stringArray2, n, n2 - n - 1);
                }
                this.controls = stringArray2;
            }
            ++n;
        }
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (string.equals(REF_SEPARATOR)) {
            this.addrEncodingSeparator = (char)35;
        } else if (string.equals(TYPES_ONLY)) {
            this.typesOnly = false;
        } else if (string.equals(DELETE_RDN)) {
            this.deleteRDN = true;
        } else if (string.equals(DEREF_ALIASES)) {
            this.derefAliases = 3;
        } else if (string.equals("java.naming.batchsize")) {
            this.batchSize = 1;
        } else if (string.equals(REFERRAL_LIMIT)) {
            this.referralHopLimit = 10;
        } else if (string.equals(TRACE_BER)) {
            this.trace = null;
        } else if (string.equals(NETSCAPE_SCHEMA_BUG)) {
            this.netscapeSchemaBug = false;
        } else if (string.equals("java.naming.referral")) {
            this.setReferralMode(null);
            this.closeConnection();
        } else if (string.equals(VERSION)) {
            this.ldapVersion = 32;
            this.closeConnection();
        } else if (string.equals(BINARY_ATTRIBUTES)) {
            this.binaryAttrs = null;
            this.closeConnection();
        } else if (string.equals(CONTROLS)) {
            this.removeControl(false);
            this.closeConnection();
        } else if (string.equals(MANAGE_REFERRAL)) {
            this.removeControl(true);
            this.closeConnection();
        } else if (string.equals(SOCKET_FACTORY)) {
            this.setSocketFactory(null);
            this.closeConnection();
        } else if (string.equals("java.naming.security.protocol")) {
            this.secProtocol = null;
            this.setSocketFactory(this.socketFactory);
            this.closeConnection();
        } else if (string.equals("java.naming.security.authentication")) {
            this.setAuthMechanism(null);
            this.closeConnection();
        } else if (string.equals("java.naming.security.principal")) {
            this.user = null;
            this.setAuthMechanism(this.authMechanism);
            this.closeConnection();
        } else if (string.equals("java.naming.security.credentials")) {
            this.passwd = null;
            this.closeConnection();
        }
        if (this.envprops == null || this.envprops.get(string) == null) {
            return null;
        }
        this.envprops = (Hashtable)this.envprops.clone();
        return this.envprops.remove(string);
    }

    private static boolean searchToCompare(Name name, String string, SearchControls searchControls, String[] stringArray) {
        if (searchControls.getSearchScope() != 0) {
            return false;
        }
        if (searchControls.getDerefLinkFlag()) {
            return false;
        }
        String[] stringArray2 = searchControls.getReturningAttributes();
        if (stringArray2 != null && stringArray2.length != 0) {
            return false;
        }
        return LdapCtx.filterToAssertion(string, stringArray);
    }

    private final void setAuthMechanism(String string) throws NamingException {
        this.authMechanism = string;
        if (this.authMechanism != null) {
            if (!(this.authMechanism.equalsIgnoreCase("CRAM-MD5") || this.authMechanism.equalsIgnoreCase("none") || this.authMechanism.equalsIgnoreCase("simple"))) {
                throw new AuthenticationNotSupportedException("Unsupported value for java.naming.security.authentication property.");
            }
        } else {
            this.authMechanism = this.passwd == null ? "none" : "CRAM-MD5";
        }
    }

    private void setBatchSize(String string) {
        this.batchSize = string != null ? Integer.parseInt(string) : 1;
    }

    private void setDeleteRDN(String string) {
        this.deleteRDN = string == null || !string.equalsIgnoreCase("false");
    }

    final void setDerefAliases(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("never")) {
                this.derefAliases = 0;
            } else if (string.equalsIgnoreCase("searching")) {
                this.derefAliases = 1;
            } else if (string.equalsIgnoreCase("finding")) {
                this.derefAliases = 2;
            } else if (string.equalsIgnoreCase("always")) {
                this.derefAliases = 3;
            } else {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.derefAliases property.");
            }
        }
    }

    void setHopCount(int n) {
        this.hopCount = n;
    }

    private void setManageControls(String[] stringArray, String string) {
        String[] stringArray2 = null;
        boolean bl = false;
        if (this.handleReferrals == 3 && string != null && string.equalsIgnoreCase("true")) {
            stringArray2 = new String[]{"2.16.840.1.113730.3.4.2", "false"};
        }
        if (stringArray != null) {
            if (stringArray2 != null) {
                this.controls = new String[2][];
                this.controls[0] = stringArray;
                this.controls[1] = stringArray2;
            } else {
                this.controls = new String[1][];
                this.controls[0] = stringArray;
            }
        } else if (stringArray2 != null) {
            this.controls = new String[1][];
            this.controls[0] = stringArray2;
        }
    }

    private final void setNetscapeBug(String string) {
        this.netscapeSchemaBug = "true".equalsIgnoreCase(string);
    }

    void setParents(Attributes attributes, Name name) throws NamingException {
        NamingEnumeration namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            LdapAttribute ldapAttribute = (LdapAttribute)namingEnumeration.next();
            ldapAttribute.setParent(this, name);
        }
    }

    private void setProtocolVersion(String string) {
        this.ldapVersion = string != null ? Integer.parseInt(string) : 32;
    }

    private final void setRefSeparator(String string) throws NamingException {
        this.addrEncodingSeparator = string != null && string.length() > 0 ? string.charAt(0) : (char)35;
    }

    private final void setReferralLimit(String string) {
        if (string != null) {
            this.referralHopLimit = Integer.parseInt(string);
            if (this.referralHopLimit == 0) {
                this.referralHopLimit = Integer.MAX_VALUE;
            }
        } else {
            this.referralHopLimit = 10;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setReferralMode(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("follow")) {
                this.handleReferrals = 1;
            } else if (string.equalsIgnoreCase("throw")) {
                this.handleReferrals = 2;
            } else {
                if (!string.equalsIgnoreCase("ignore")) throw new IllegalArgumentException("Illegal value for java.naming.referral property.");
                this.handleReferrals = 3;
            }
        } else {
            this.handleReferrals = 3;
        }
        if (this.handleReferrals != 3) return;
        this.updateReferralControl("true");
    }

    private final void setSocketFactory(String string) {
        this.socketFactory = string;
        if (this.secProtocol != null && this.secProtocol.equalsIgnoreCase("ssl") && this.socketFactory == null) {
            this.socketFactory = DEFAULT_SSL_FACTORY;
        }
    }

    private final void setTrace(Object object) {
        if (object != null) {
            this.trace = object;
        }
    }

    private void setTypesOnly(String string) {
        this.typesOnly = string != null && string.equalsIgnoreCase("true");
    }

    private void updateGenericControl(String[] stringArray) {
        Object var2_2 = null;
        if (this.controls == null) {
            this.controls = new String[1][];
            this.controls[0] = stringArray;
        } else {
            int n = this.controls.length;
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray2 = this.controls[n2];
                if (!stringArray2[0].equals("2.16.840.1.113730.3.4.2")) {
                    this.controls[n2] = stringArray;
                    return;
                }
                ++n2;
            }
            String[][] stringArray3 = new String[n + 1][];
            System.arraycopy(this.controls, 0, stringArray3, 0, n);
            stringArray3[n] = stringArray;
            this.controls = stringArray3;
        }
    }

    private void updateReferralControl(String string) {
        String[] stringArray = null;
        if (this.handleReferrals != 3 || string == null || !string.equalsIgnoreCase("true")) {
            this.removeControl(true);
            return;
        }
        stringArray = new String[]{"2.16.840.1.113730.3.4.2", "false"};
        if (this.controls == null) {
            this.controls = new String[1][];
            this.controls[0] = stringArray;
        } else {
            int n = this.controls.length;
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray2 = this.controls[n2];
                if (stringArray2[0].equals("2.16.840.1.113730.3.4.2")) {
                    this.controls[n2] = stringArray;
                    return;
                }
                ++n2;
            }
            String[][] stringArray3 = new String[n + 1][];
            System.arraycopy(this.controls, 0, stringArray3, 0, n);
            stringArray3[n] = stringArray;
            this.controls = stringArray3;
        }
    }

    class SearchArgs {
        Name name;
        String filter;
        SearchControls cons;
        String[] reqAttrs;

        SearchArgs(Name name, String string, SearchControls searchControls, String[] stringArray) {
            this.name = name;
            this.filter = string;
            this.cons = searchControls;
            this.reqAttrs = stringArray;
        }
    }
}

