/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapBinding;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.Obj;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;

final class LdapClient {
    static final boolean caseIgnore = true;
    boolean ldapv3;
    private LdapBinding ldb;
    private int referenceCount;
    private Hashtable binaryAttributes = null;
    private LdapResult answer = null;
    private String[][] controls = null;
    private static final int debug = 0;
    static final int SCOPE_BASE_OBJECT = 0;
    static final int SCOPE_ONE_LEVEL = 1;
    static final int SCOPE_SUBTREE = 2;
    static final int ADD = 0;
    static final int DELETE = 1;
    static final int REPLACE = 2;
    static final int LDAP_VERSION3_VERSION2 = 32;
    static final int LDAP_VERSION2 = 2;
    static final int LDAP_VERSION3 = 3;
    static final int LDAP_VERSION = 3;
    static final int LDAP_REF_FOLLOW = 1;
    static final int LDAP_REF_THROW = 2;
    static final int LDAP_REF_IGNORE = 3;
    static final String LDAP_URL = "ldap://";
    static final String LDAPS_URL = "ldaps://";
    static final int LDAP_FILTER_AND = 160;
    static final int LDAP_FILTER_OR = 161;
    static final int LDAP_FILTER_NOT = 162;
    static final int LDAP_FILTER_EQUALITY = 163;
    static final int LDAP_FILTER_SUBSTRINGS = 164;
    static final int LDAP_FILTER_GE = 165;
    static final int LDAP_FILTER_LE = 166;
    static final int LDAP_FILTER_PRESENT = 135;
    static final int LDAP_FILTER_APPROX = 168;
    static final int LDAP_FILTER_EXT = 169;
    static final int LDAP_FILTER_EXT_RULE = 129;
    static final int LDAP_FILTER_EXT_TYPE = 130;
    static final int LDAP_FILTER_EXT_VAL = 131;
    static final int LDAP_FILTER_EXT_DN = 132;
    static final int LBER_BOOLEAN = 1;
    static final int LBER_INTEGER = 2;
    static final int LBER_BITSTRING = 3;
    static final int LBER_OCTETSTRING = 4;
    static final int LBER_NULL = 5;
    static final int LBER_ENUMERATED = 10;
    static final int LBER_SEQUENCE = 48;
    static final int LBER_SET = 49;
    static final int LDAP_SUBSTRING_INITIAL = 128;
    static final int LDAP_SUBSTRING_ANY = 129;
    static final int LDAP_SUBSTRING_FINAL = 130;
    static final int LDAP_SUPERIOR_DN = 128;
    static final int LDAP_REQ_BIND = 96;
    static final int LDAP_REQ_UNBIND = 66;
    static final int LDAP_REQ_SEARCH = 99;
    static final int LDAP_REQ_MODIFY = 102;
    static final int LDAP_REQ_ADD = 104;
    static final int LDAP_REQ_DELETE = 74;
    static final int LDAP_REQ_MODRDN = 108;
    static final int LDAP_REQ_COMPARE = 110;
    static final int LDAP_REQ_ABANDON = 80;
    static final int LDAP_REQ_EXTENSION = 119;
    static final int LDAP_REP_BIND = 97;
    static final int LDAP_REP_SEARCH = 100;
    static final int LDAP_REP_SEARCH_REF = 115;
    static final int LDAP_REP_RESULT = 101;
    static final int LDAP_REP_MODIFY = 103;
    static final int LDAP_REP_ADD = 105;
    static final int LDAP_REP_DELETE = 107;
    static final int LDAP_REP_MODRDN = 109;
    static final int LDAP_REP_COMPARE = 111;
    static final int LDAP_REP_EXTENSION = 120;
    static final int LDAP_REP_REFERRAL = 163;
    static final int LDAP_REP_EXT_OID = 138;
    static final int LDAP_REP_EXT_VAL = 139;
    static final int LDAP_CONTROLS = 160;
    static final String LDAP_CONTROL_MANAGE_DSA_IT = "2.16.840.1.113730.3.4.2";
    static final String LDAP_CONTROL_PREFERRED_LANG = "1.3.6.1.4.1.1466.20035";
    static final String LDAP_CONTROL_PAGED_RESULTS = "1.2.840.113556.1.4.319";
    static final String LDAP_CONTROL_SERVER_SORT_REQ = "1.2.840.113556.1.4.473";
    static final String LDAP_CONTROL_SERVER_SORT_RES = "1.2.840.113556.1.4.474";
    static final int LDAP_SUCCESS = 0;
    static final int LDAP_OPERATIONS_ERROR = 1;
    static final int LDAP_PROTOCOL_ERROR = 2;
    static final int LDAP_TIME_LIMIT_EXCEEDED = 3;
    static final int LDAP_SIZE_LIMIT_EXCEEDED = 4;
    static final int LDAP_COMPARE_FALSE = 5;
    static final int LDAP_COMPARE_TRUE = 6;
    static final int LDAP_AUTH_METHOD_NOT_SUPPORTED = 7;
    static final int LDAP_STRONG_AUTH_REQUIRED = 8;
    static final int LDAP_PARTIAL_RESULTS = 9;
    static final int LDAP_REFERRAL = 10;
    static final int LDAP_ADMIN_LIMIT_EXCEEDED = 11;
    static final int LDAP_UNAVAILABLE_CRITICAL_EXTENSION = 12;
    static final int LDAP_CONFIDENTIALITY_REQUIRED = 13;
    static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    static final int LDAP_NO_SUCH_ATTRIBUTE = 16;
    static final int LDAP_UNDEFINED_ATTRIBUTE_TYPE = 17;
    static final int LDAP_INAPPROPRIATE_MATCHING = 18;
    static final int LDAP_CONSTRAINT_VIOLATION = 19;
    static final int LDAP_ATTRIBUTE_OR_VALUE_EXISTS = 20;
    static final int LDAP_INVALID_ATTRIBUTE_SYNTAX = 21;
    static final int LDAP_NO_SUCH_OBJECT = 32;
    static final int LDAP_ALIAS_PROBLEM = 33;
    static final int LDAP_INVALID_DN_SYNTAX = 34;
    static final int LDAP_IS_LEAF = 35;
    static final int LDAP_ALIAS_DEREFERENCING_PROBLEM = 36;
    static final int LDAP_INAPPROPRIATE_AUTHENTICATION = 48;
    static final int LDAP_INVALID_CREDENTIALS = 49;
    static final int LDAP_INSUFFICIENT_ACCESS_RIGHTS = 50;
    static final int LDAP_BUSY = 51;
    static final int LDAP_UNAVAILABLE = 52;
    static final int LDAP_UNWILLING_TO_PERFORM = 53;
    static final int LDAP_LOOP_DETECT = 54;
    static final int LDAP_NAMING_VIOLATION = 64;
    static final int LDAP_OBJECT_CLASS_VIOLATION = 65;
    static final int LDAP_NOT_ALLOWED_ON_NON_LEAF = 66;
    static final int LDAP_NOT_ALLOWED_ON_RDN = 67;
    static final int LDAP_ENTRY_ALREADY_EXISTS = 68;
    static final int LDAP_OBJECT_CLASS_MODS_PROHIBITED = 69;
    static final int LDAP_AFFECTS_MULTIPLE_DSAS = 71;
    static final int LDAP_OTHER = 80;
    static final String[] ldap_error_message = new String[]{"Success", "Operations Error", "Protocol Error", "Timelimit Exceeded", "Sizelimit Exceeded", "Compare False", "Compare True", "Authentication Method Not Supported", "Strong Authentication Required", null, "Referral", "Administrative Limit Exceeded", "Unavailable Critical Extension", "Confidentiality Required", "SASL Bind In Progress", null, "No Such Attribute", "Undefined Attribute Type", "Inappropriate Matching", "Constraint Violation", "Attribute Or Value Exists", "Invalid Attribute Syntax", null, null, null, null, null, null, null, null, null, null, "No Such Object", "Alias Problem", "Invalid DN Syntax", null, "Alias Dereferencing Problem", null, null, null, null, null, null, null, null, null, null, null, "Inappropriate Authentication", "Invalid Credentials", "Insufficient Access Rights", "Busy", "Unavailable", "Unwilling To Perform", "Loop Detect", null, null, null, null, null, null, null, null, null, "Naming Violation", "Object Class Violation", "Not Allowed On Non-leaf", "Not Allowed On RDN", "Entry Already Exists", "Object Class Modifications Prohibited", null, "Affects Multiple DSAs", null, null, null, null, null, null, null, null, "Other", null, null, null, null, null, null, null, null, null, null};
    private static final boolean dbg = false;
    private static int dbgIndent = 0;

    LdapClient(String string, int n, String string2, Object object, int n2, String string3, String[][] stringArray, String string4, Object object2) throws IOException, NamingException {
        this.ldb = new LdapBinding(string, n, string2, object, n2, string3, string4, object2);
        if (this.ldb != null && this.ldb.bailout != null) {
            throw this.ldb.bailout;
        }
        this.answer = this.ldb.getResult();
        this.ldapv3 = this.ldb.version == 3;
        this.referenceCount = 1;
        this.controls = stringArray;
    }

    LdapResult add(LdapEntry ldapEntry) throws IOException, NamingException {
        Object object;
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (ldapEntry == null || ldapEntry.DN == null) {
            return ldapResult;
        }
        Ber ber = new Ber();
        ber.init();
        int n = this.ldb.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(n);
        ber.beginSeq(104);
        ber.encodeString(ldapEntry.DN, this.ldapv3);
        ber.beginSeq(48);
        NamingEnumeration namingEnumeration = ldapEntry.attributes.getAll();
        while (namingEnumeration.hasMore()) {
            object = (Attribute)namingEnumeration.next();
            if (LdapClient.hasNoValue((Attribute)object)) {
                throw new InvalidAttributeValueException("'" + object.getID() + "' has no values.");
            }
            this.encodeAttribute(ber, (Attribute)object);
        }
        ber.endSeq();
        ber.endSeq();
        this.encodeControls(ber);
        ber.endSeq();
        this.ldb.writeReq(ber, n);
        while (true) {
            if ((object = this.ldb.readReply(n)) != null) {
                ((Ber)object).parseSeq(null);
                ((Ber)object).parseInt();
                if (((Ber)object).parseByte() != 105) {
                    return ldapResult;
                }
                ((Ber)object).parseLength();
                this.parseResult((Ber)object, ldapResult);
                this.ldb.destroyReq(n);
                return ldapResult;
            }
            try {
                Ber ber2 = ber;
                synchronized (ber2) {
                    ber.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP add operation");
            }
        }
    }

    void clearSearchReply(LdapResult ldapResult) {
        if (ldapResult != null) {
            this.ldb.destroyReq(ldapResult.msgId);
        }
    }

    synchronized void close() {
        --this.referenceCount;
        if (this.referenceCount <= 0 && this.ldb != null) {
            this.ldb.cleanup();
            this.ldb = null;
        }
    }

    LdapResult compare(String string, String string2, String string3) throws IOException, NamingException {
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || string2 == null || string3 == null) {
            return ldapResult;
        }
        Ber ber = new Ber();
        ber.init();
        int n = this.ldb.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(n);
        ber.beginSeq(110);
        ber.encodeString(string, this.ldapv3);
        ber.beginSeq(48);
        ber.encodeString(string2, this.ldapv3);
        ber.encodeString(string3, this.ldapv3);
        ber.endSeq();
        ber.endSeq();
        this.encodeControls(ber);
        ber.endSeq();
        this.ldb.writeReq(ber, n);
        while (true) {
            Ber ber2;
            if ((ber2 = this.ldb.readReply(n)) != null) {
                ber2.parseSeq(null);
                ber2.parseInt();
                if (ber2.parseByte() != 111) {
                    return ldapResult;
                }
                ber2.parseLength();
                this.parseResult(ber2, ldapResult);
                this.ldb.destroyReq(n);
                return ldapResult;
            }
            try {
                Ber ber3 = ber;
                synchronized (ber3) {
                    ber.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP compare operation");
            }
        }
    }

    LdapResult delete(String string) throws IOException, NamingException {
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null) {
            return ldapResult;
        }
        Ber ber = new Ber();
        ber.init();
        int n = this.ldb.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(n);
        ber.encodeString(string, 74, this.ldapv3);
        this.encodeControls(ber);
        ber.endSeq();
        this.ldb.writeReq(ber, n);
        while (true) {
            Ber ber2;
            if ((ber2 = this.ldb.readReply(n)) != null) {
                ber2.parseSeq(null);
                ber2.parseInt();
                if (ber2.parseByte() != 107) {
                    return ldapResult;
                }
                ber2.parseLength();
                this.parseResult(ber2, ldapResult);
                this.ldb.destroyReq(n);
                return ldapResult;
            }
            try {
                Ber ber3 = ber;
                synchronized (ber3) {
                    ber.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP delete operation");
            }
        }
    }

    private static void dprint(String string, byte[] byArray) {
        LdapClient.dprint(string, byArray, 0, byArray.length);
    }

    private static void dprint(String string, byte[] byArray, int n, int n2) {
        String string2 = "  ";
        int n3 = dbgIndent;
        while (n3-- > 0) {
            string2 = String.valueOf(string2) + "  ";
        }
        string2 = String.valueOf(string2) + string;
        System.err.print(string2);
        int n4 = n;
        while (n4 < n2) {
            System.err.print((char)byArray[n4]);
            ++n4;
        }
        System.err.println();
    }

    private void encodeAttribute(Ber ber, Attribute attribute) throws IOException, NamingException {
        ber.beginSeq(48);
        ber.encodeString(attribute.getID(), this.ldapv3);
        ber.beginSeq(49);
        NamingEnumeration namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            Object object = namingEnumeration.next();
            if (object instanceof String) {
                ber.encodeString((String)object, this.ldapv3);
                continue;
            }
            if (object instanceof byte[]) {
                ber.encodeOctetString((byte[])object, 4);
                continue;
            }
            if (object == null) continue;
            throw new InvalidAttributeValueException("Malformed '" + attribute.getID() + "' attribute value");
        }
        ber.endSeq();
        ber.endSeq();
    }

    private void encodeComplexFilter(Ber ber, byte[] byArray, int n, int[] nArray, int n2) throws IOException, NamingException {
        nArray[0] = nArray[0] + 1;
        ber.beginSeq(n);
        int[] nArray2 = LdapClient.findRightParen(byArray, nArray, n2);
        this.encodeFilterList(ber, byArray, nArray2[0], nArray2[1]);
        ber.endSeq();
    }

    private void encodeControls(Ber ber) throws IOException {
        if (!this.ldapv3 || this.controls == null || this.controls.length == 0) {
            return;
        }
        ber.beginSeq(160);
        int n = 0;
        while (n < this.controls.length && this.controls[n].length > 0) {
            ber.beginSeq(48);
            ber.encodeString(this.controls[n][0]);
            if (this.controls[n].length > 1 && this.controls[n][1] != null && this.controls[n][1].equalsIgnoreCase("true")) {
                ber.encodeBoolean(true);
            }
            if (this.controls[n].length > 2 && this.controls[n][2] != null) {
                try {
                    int n2 = this.controls[n][2].length();
                    byte[] byArray = new byte[n2 / 2];
                    int n3 = 0;
                    while (n3 < n2) {
                        byArray[n3 / 2] = (byte)Integer.parseInt(this.controls[n][2].substring(n3, n3 + 2), 16);
                        n3 += 2;
                    }
                    ber.encodeOctetString(byArray, 4);
                }
                catch (Exception exception) {
                    throw new Ber.EncodeException("Bad control value");
                }
            }
            ber.endSeq();
            ++n;
        }
        ber.endSeq();
    }

    private void encodeExtensibleMatch(Ber ber, byte[] byArray, int n, int n2, int n3, int n4) throws IOException, NamingException {
        boolean bl = false;
        ber.beginSeq(169);
        int n5 = LdapClient.indexOf(byArray, ':', n, n2);
        if (n5 >= 0) {
            int n6;
            int n7 = LdapClient.indexOf(byArray, ":dn", n5, n2);
            if (n7 >= 0) {
                bl = true;
            }
            if ((n6 = LdapClient.indexOf(byArray, ':', n5 + 1, n2)) >= 0 || n7 == -1) {
                if (n7 == n5) {
                    ber.encodeOctetString(byArray, 129, n6 + 1, n2);
                } else if (n7 == n6 && n7 >= 0) {
                    ber.encodeOctetString(byArray, 129, n5 + 1, n6);
                } else {
                    ber.encodeOctetString(byArray, 129, n5 + 1, n2);
                }
            }
            if (n5 > 0) {
                ber.encodeOctetString(byArray, 130, n, n5);
            }
        } else {
            ber.encodeOctetString(byArray, 130, n, n2);
        }
        ber.encodeOctetString(LdapClient.unescapeFilterValue(byArray, n3, n4), 131);
        if (bl) {
            ber.encodeBoolean(true, 132);
        }
        ber.endSeq();
    }

    private void encodeFilter(Ber ber, byte[] byArray, int n, int n2) throws IOException, NamingException {
        if (n2 - n <= 0) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        int n3 = 0;
        int[] nArray = new int[]{n};
        while (nArray[0] < n2) {
            block0 : switch (byArray[nArray[0]]) {
                case 40: {
                    nArray[0] = nArray[0] + 1;
                    ++n3;
                    switch (byArray[nArray[0]]) {
                        case 38: {
                            this.encodeComplexFilter(ber, byArray, 160, nArray, n2);
                            --n3;
                            break block0;
                        }
                        case 124: {
                            this.encodeComplexFilter(ber, byArray, 161, nArray, n2);
                            --n3;
                            break block0;
                        }
                        case 33: {
                            this.encodeComplexFilter(ber, byArray, 162, nArray, n2);
                            --n3;
                            break block0;
                        }
                    }
                    int n4 = 1;
                    boolean bl = false;
                    int n5 = nArray[0];
                    while (n5 < n2 && n4 > 0) {
                        if (!bl) {
                            if (byArray[n5] == 40) {
                                ++n4;
                            } else if (byArray[n5] == 41) {
                                --n4;
                            }
                        }
                        bl = byArray[n5] == 92 && !bl;
                        if (n4 <= 0) continue;
                        ++n5;
                    }
                    if (n4 != 0) {
                        throw new InvalidSearchFilterException("Unbalanced parenthesis");
                    }
                    this.encodeSimpleFilter(ber, byArray, nArray[0], n5);
                    nArray[0] = n5;
                    --n3;
                    break;
                }
                case 41: {
                    ber.endSeq();
                    nArray[0] = nArray[0] + 1;
                    --n3;
                    break;
                }
                case 32: {
                    nArray[0] = nArray[0] + 1;
                    break;
                }
                default: {
                    this.encodeSimpleFilter(ber, byArray, nArray[0], n2);
                    nArray[0] = n2;
                    break;
                }
            }
            nArray[0] = nArray[0] + 1;
        }
        if (n3 > 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
    }

    private void encodeFilterList(Ber ber, byte[] byArray, int n, int n2) throws IOException, NamingException {
        int[] nArray = new int[]{n};
        while (nArray[0] < n2) {
            if (!Character.isSpaceChar((char)byArray[nArray[0]]) && byArray[nArray[0]] != 40) {
                int[] nArray2 = LdapClient.findRightParen(byArray, nArray, n2);
                int n3 = nArray2[1] - nArray2[0];
                byte[] byArray2 = new byte[n3 + 2];
                System.arraycopy(byArray, nArray2[0], byArray2, 1, n3);
                byArray2[0] = 40;
                byArray2[n3 + 1] = 41;
                this.encodeFilter(ber, byArray2, 0, byArray2.length);
            }
            nArray[0] = nArray[0] + 1;
        }
    }

    private void encodeFilterString(Ber ber, String string) throws IOException, NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidSearchFilterException("Empty filter");
        }
        byte[] byArray = this.ldapv3 ? string.getBytes("UTF8") : string.getBytes("8859_1");
        int n = byArray.length;
        try {
            this.encodeFilter(ber, byArray, 0, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void encodeSimpleFilter(Ber ber, byte[] byArray, int n, int n2) throws IOException, NamingException {
        int n3;
        int n4;
        int n5 = LdapClient.indexOf(byArray, '=', n, n2);
        if (n5 == -1) {
            throw new InvalidSearchFilterException("Missing 'equals'");
        }
        int n6 = n5 + 1;
        int n7 = n2;
        int n8 = n;
        switch (byArray[n5 - 1]) {
            case 60: {
                n4 = 166;
                n3 = n5 - 1;
                break;
            }
            case 62: {
                n4 = 165;
                n3 = n5 - 1;
                break;
            }
            case 126: {
                n4 = 168;
                n3 = n5 - 1;
                break;
            }
            case 58: {
                n4 = 169;
                n3 = n5 - 1;
                break;
            }
            default: {
                n3 = n5;
                if (LdapClient.findUnescaped(byArray, '*', n6, n7) == -1) {
                    n4 = 163;
                    break;
                }
                if (byArray[n6] == 42 && n6 == n7 - 1) {
                    n4 = 135;
                    break;
                }
                this.encodeSubstringFilter(ber, byArray, n8, n3, n6, n7);
                return;
            }
        }
        if (n4 == 135) {
            ber.encodeOctetString(byArray, n4, n8, n3 - n8);
        } else if (n4 == 169) {
            this.encodeExtensibleMatch(ber, byArray, n8, n3, n6, n7);
        } else {
            ber.beginSeq(n4);
            ber.encodeOctetString(byArray, 4, n8, n3 - n8);
            ber.encodeOctetString(LdapClient.unescapeFilterValue(byArray, n6, n7), 4);
            ber.endSeq();
        }
    }

    private void encodeSubstringFilter(Ber ber, byte[] byArray, int n, int n2, int n3, int n4) throws IOException, NamingException {
        int n5;
        ber.beginSeq(164);
        ber.encodeOctetString(byArray, 4, n, n2 - n);
        ber.beginSeq(48);
        int n6 = n3;
        while ((n5 = LdapClient.findUnescaped(byArray, '*', n6, n4)) != -1) {
            if (n6 == n3) {
                if (n6 < n5) {
                    ber.encodeOctetString(LdapClient.unescapeFilterValue(byArray, n6, n5), 128);
                }
            } else if (n6 < n5) {
                ber.encodeOctetString(LdapClient.unescapeFilterValue(byArray, n6, n5), 129);
            }
            n6 = n5 + 1;
        }
        if (n6 < n4) {
            ber.encodeOctetString(LdapClient.unescapeFilterValue(byArray, n6, n4), 130);
        }
        ber.endSeq();
        ber.endSeq();
    }

    LdapResult extension(String string, byte[] byArray) throws IOException, NamingException {
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null) {
            return ldapResult;
        }
        Ber ber = new Ber();
        ber.init();
        int n = this.ldb.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(n);
        ber.beginSeq(119);
        ber.encodeString(string, 132, this.ldapv3);
        if (byArray != null) {
            ber.encodeOctetString(byArray, 133);
        }
        ber.endSeq();
        this.encodeControls(ber);
        ber.endSeq();
        this.ldb.writeReq(ber, n);
        while (true) {
            Ber ber2;
            if ((ber2 = this.ldb.readReply(n)) != null) {
                ber2.parseSeq(null);
                ber2.parseInt();
                if (ber2.parseByte() != 120) {
                    return ldapResult;
                }
                ber2.parseLength();
                this.parseResult(ber2, ldapResult);
                if (ber2.bytesLeft() > 0) {
                    if (ber2.peekByte() == 138) {
                        ldapResult.extensionId = ber2.parseString();
                    }
                    if (ber2.peekByte() == 139) {
                        ldapResult.extensionResponse = ber2.parseOctetString(139, null);
                    }
                }
                this.ldb.destroyReq(n);
                return ldapResult;
            }
            try {
                Ber ber3 = ber;
                synchronized (ber3) {
                    ber.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP extended operation");
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    private static int[] findRightParen(byte[] byArray, int[] nArray, int n) throws IOException, NamingException {
        int n2 = 1;
        boolean bl = false;
        int n3 = nArray[0];
        while (n3 < n && n2 > 0) {
            if (!bl) {
                if (byArray[n3] == 40) {
                    ++n2;
                } else if (byArray[n3] == 41) {
                    --n2;
                }
            }
            bl = byArray[n3] == 92 && !bl;
            if (n2 <= 0) continue;
            ++n3;
        }
        if (n2 != 0) {
            throw new InvalidSearchFilterException("Unbalanced parenthesis");
        }
        int[] nArray2 = new int[]{nArray[0], n3};
        nArray[0] = n3 + 1;
        return nArray2;
    }

    private static int findUnescaped(byte[] byArray, char c, int n, int n2) {
        while (n < n2) {
            int n3 = LdapClient.indexOf(byArray, c, n, n2);
            if (n3 == n || n3 == -1 || byArray[n3 - 1] != 92) {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    LdapResult getResult() {
        return this.answer;
    }

    LdapResult getSearchReply(int n, LdapResult ldapResult) throws IOException, NamingException {
        int n2 = ldapResult.msgId;
        int n3 = 0;
        LdapRequest ldapRequest = this.ldb.findLdapRequest(n2);
        if (ldapRequest == null) {
            return null;
        }
        Ber ber = ldapRequest.ber;
        if (n == 0) {
            n = Integer.MAX_VALUE;
        }
        if (ldapResult.entries != null) {
            ldapResult.entries.setSize(0);
        } else {
            ldapResult.entries = new Vector(n == Integer.MAX_VALUE ? 32 : n);
        }
        while (n3 < n) {
            Ber ber2 = this.ldb.readReply(n2);
            if (ber2 != null) {
                Cloneable cloneable;
                ber2.parseSeq(null);
                ber2.parseInt();
                int n4 = ber2.parseSeq(null);
                if (n4 == 100) {
                    cloneable = new BasicAttributes(true);
                    String string = ber2.parseString(this.ldapv3);
                    LdapEntry ldapEntry = new LdapEntry(string, (Attributes)cloneable);
                    ber2.parseSeq(null);
                    while (ber2.bytesLeft() > 0) {
                        Attribute attribute = this.parseAttribute(ber2);
                        cloneable.put(attribute);
                    }
                    ldapResult.entries.addElement(ldapEntry);
                    ++n3;
                    continue;
                }
                if (n4 == 115 && this.ldapv3) {
                    cloneable = new Vector(4);
                    while (ber2.bytesLeft() > 0) {
                        ((Vector)cloneable).addElement(ber2.parseString(this.ldapv3));
                    }
                    if (ldapResult.referrals == null) {
                        ldapResult.referrals = new Vector(4);
                    }
                    ldapResult.referrals.addElement(cloneable);
                    continue;
                }
                if (n4 != 101) continue;
                this.parseResult(ber2, ldapResult);
                this.ldb.destroyReq(n2);
                return ldapResult;
            }
            try {
                Ber ber3 = ber;
                synchronized (ber3) {
                    ber.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP search operation");
            }
        }
        return ldapResult;
    }

    private static boolean hasNoValue(Attribute attribute) throws NamingException {
        return attribute.size() == 0 || attribute.size() == 1 && attribute.get() == null;
    }

    private static int hexchar2int(byte by) {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 65 + 10;
        }
        if (by >= 97 && by <= 102) {
            return by - 97 + 10;
        }
        return -1;
    }

    synchronized void incRefCount() {
        ++this.referenceCount;
    }

    private static int indexOf(byte[] byArray, char c, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (byArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static int indexOf(byte[] byArray, String string, int n, int n2) {
        int n3 = LdapClient.indexOf(byArray, string.charAt(0), n, n2);
        if (n3 >= 0) {
            int n4 = 1;
            while (n4 < string.length()) {
                if (byArray[n3 + n4] != string.charAt(n4)) {
                    return -1;
                }
                ++n4;
            }
        }
        return n3;
    }

    private boolean knownBinaryAttribute(Attribute attribute) {
        String string = attribute.getID().toLowerCase();
        return string.indexOf(";binary") != -1 || string.equals("userpassword") || string.equalsIgnoreCase(Obj.JAVA_ATTRIBUTES[1]) || string.equals("javaserializedobject") || string.equals("jpegphoto") || string.equals("audio") || string.equals("thumbnailphoto") || string.equals("thumbnaillogo") || string.equals("usercertificate") || string.equals("cacertificate") || string.equals("certificaterevocationlist") || string.equals("authorityrevocationlist") || string.equals("crosscertificatepair") || string.equals("photo") || string.equals("personalsignature") || string.equals("x500uniqueidentifier") || this.binaryAttributes != null && this.binaryAttributes.containsKey(string);
    }

    LdapResult moddn(String string, String string2, boolean bl, String string3) throws IOException, NamingException {
        boolean bl2 = string3 != null && string3.length() > 0;
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || string2 == null) {
            return ldapResult;
        }
        Ber ber = new Ber();
        ber.init();
        int n = this.ldb.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(n);
        ber.beginSeq(108);
        ber.encodeString(string, this.ldapv3);
        ber.encodeString(string2, this.ldapv3);
        ber.encodeBoolean(bl);
        if (this.ldapv3 && bl2) {
            ber.encodeString(string3, 128, this.ldapv3);
        }
        ber.endSeq();
        this.encodeControls(ber);
        ber.endSeq();
        this.ldb.writeReq(ber, n);
        while (true) {
            Ber ber2;
            if ((ber2 = this.ldb.readReply(n)) != null) {
                ber2.parseSeq(null);
                ber2.parseInt();
                if (ber2.parseByte() != 109) {
                    return ldapResult;
                }
                ber2.parseLength();
                this.parseResult(ber2, ldapResult);
                this.ldb.destroyReq(n);
                return ldapResult;
            }
            try {
                Ber ber3 = ber;
                synchronized (ber3) {
                    ber.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP modifyDN operation");
            }
        }
    }

    LdapResult modify(String string, int[] nArray, Attribute[] attributeArray) throws IOException, NamingException {
        LdapResult ldapResult = new LdapResult();
        ldapResult.status = 1;
        if (string == null || string.length() == 0 || nArray.length != attributeArray.length) {
            return ldapResult;
        }
        Ber ber = new Ber();
        ber.init();
        int n = this.ldb.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(n);
        ber.beginSeq(102);
        ber.encodeString(string, this.ldapv3);
        ber.beginSeq(48);
        int n2 = 0;
        while (n2 < nArray.length) {
            ber.beginSeq(48);
            ber.encodeInt(nArray[n2], 10);
            if (nArray[n2] == 0 && LdapClient.hasNoValue(attributeArray[n2])) {
                throw new InvalidAttributeValueException("'" + attributeArray[n2].getID() + "' has no values.");
            }
            this.encodeAttribute(ber, attributeArray[n2]);
            ber.endSeq();
            ++n2;
        }
        ber.endSeq();
        ber.endSeq();
        this.encodeControls(ber);
        ber.endSeq();
        this.ldb.writeReq(ber, n);
        while (true) {
            Ber ber2;
            if ((ber2 = this.ldb.readReply(n)) != null) {
                ber2.parseSeq(null);
                ber2.parseInt();
                if (ber2.parseByte() != 103) {
                    return ldapResult;
                }
                ber2.parseLength();
                this.parseResult(ber2, ldapResult);
                this.ldb.destroyReq(n);
                return ldapResult;
            }
            try {
                Ber ber3 = ber;
                synchronized (ber3) {
                    ber.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP modify operation");
            }
        }
    }

    private Attribute parseAttribute(Ber ber) throws IOException {
        int[] nArray = new int[1];
        int n = ber.parseSeq(null);
        LdapAttribute ldapAttribute = new LdapAttribute(ber.parseString(this.ldapv3));
        n = ber.parseSeq(nArray);
        if (n == 49) {
            for (int i = nArray[0]; ber.bytesLeft() > 0 && i > 0; i -= this.parseAttributeValue(ber, ldapAttribute)) {
                try {
                    continue;
                }
                catch (IOException iOException) {
                    ber.seek(i);
                    break;
                }
            }
        } else {
            ber.seek(nArray[0]);
        }
        return ldapAttribute;
    }

    private int parseAttributeValue(Ber ber, Attribute attribute) throws IOException {
        int[] nArray = new int[1];
        if (this.knownBinaryAttribute(attribute)) {
            attribute.add(ber.parseOctetString(ber.peekByte(), nArray));
        } else {
            attribute.add(ber.parseString(nArray, this.ldapv3));
        }
        return nArray[0];
    }

    private void parseResult(Ber ber, LdapResult ldapResult) throws IOException {
        ldapResult.status = ber.parseEnumeration();
        ldapResult.matchedDN = ber.parseString(this.ldapv3);
        ldapResult.errorMessage = ber.parseString(this.ldapv3);
        if (this.ldapv3 && ber.bytesLeft() > 0 && ber.parseSeq(null) == 163) {
            Vector<String> vector = new Vector<String>(4);
            while (ber.bytesLeft() > 0) {
                vector.addElement(ber.parseString(this.ldapv3));
            }
            if (ldapResult.referrals == null) {
                ldapResult.referrals = new Vector(4);
            }
            ldapResult.referrals.addElement(vector);
        }
    }

    LdapResult search(String string, int n, int n2, int n3, int n4, boolean bl, String[] stringArray, String string2, int n5) throws IOException, NamingException {
        LdapResult ldapResult = new LdapResult();
        Ber ber = new Ber();
        ber.init();
        int n6 = this.ldb.getMsgId();
        ber.beginSeq(48);
        ber.encodeInt(n6);
        ber.beginSeq(99);
        ber.encodeString(string == null ? "" : string, this.ldapv3);
        ber.encodeInt(n, 10);
        ber.encodeInt(n2, 10);
        ber.encodeInt(n3);
        ber.encodeInt(n4);
        ber.encodeBoolean(bl);
        this.encodeFilterString(ber, string2);
        ber.beginSeq(48);
        ber.encodeStringArray(stringArray, this.ldapv3);
        ber.endSeq();
        ber.endSeq();
        this.encodeControls(ber);
        ber.endSeq();
        this.ldb.writeReq(ber, n6);
        ldapResult.msgId = n6;
        ldapResult.status = 0;
        ldapResult = this.getSearchReply(n5, ldapResult);
        return ldapResult;
    }

    void setBinaryAttributes(String string) {
        this.binaryAttributes = new Hashtable(11, 0.75f);
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            this.binaryAttributes.put(stringTokenizer.nextToken(), Boolean.TRUE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] unescapeFilterValue(byte[] byArray, int n, int n2) throws NamingException {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n2 - n;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            byte by = byArray[n5];
            if (bl) {
                int n6 = LdapClient.hexchar2int(by);
                if (n6 < 0) {
                    if (!bl2) throw new InvalidSearchFilterException("invalid escape sequence: " + byArray);
                    bl = false;
                    byArray2[n4++] = by;
                } else if (bl2) {
                    byArray2[n4] = (byte)(n6 << 4);
                    bl2 = false;
                } else {
                    int n7 = n4++;
                    byArray2[n7] = (byte)(byArray2[n7] | (byte)n6);
                    bl = false;
                }
            } else if (by != 92) {
                byArray2[n4++] = by;
                bl = false;
            } else {
                bl = true;
                bl2 = true;
            }
            ++n5;
        }
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray2, 0, byArray3, 0, n4);
        return byArray3;
    }
}

