/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.LdapResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;

final class LdapBinding
extends Thread {
    private static final boolean debug = false;
    private static final int dump = 0;
    private String host;
    private int port;
    private String name;
    int version;
    private boolean skippedBind = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    private BufferedInputStream inStream;
    private BufferedOutputStream outStream;
    private Socket sock;
    private int msgId = 0;
    NamingException bailout = null;
    private LdapRequest pendingRequests = null;
    private LdapResult res = null;
    private static final int MD5_BLOCKSIZE = 64;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * Unable to fully structure code
     */
    LdapBinding(String var1_1, int var2_2, String var3_3, Object var4_4, int var5_5, String var6_6, String var7_7, Object var8_8) throws IOException {
        super();
        this.host = var1_1;
        this.port = var2_2;
        this.name = var3_3;
        if (var8_8 != null && var8_8 instanceof OutputStream) {
            this.traceFile = (OutputStream)var8_8;
            this.traceTagIn = "<- " + var1_1 + ":" + var2_2 + "\n\n";
            this.traceTagOut = "-> " + var1_1 + ":" + var2_2 + "\n\n";
        }
        this.version = var5_5 == 32 ? 3 : var5_5;
        try {
            if (var7_7 != null) {
                var9_9 = Class.forName(var7_7);
                var10_18 = var9_9.getMethod("getDefault", new Class[0]);
                var11_21 = var10_18.invoke(null, new Object[0]);
                var12_23 = var9_9.getMethod("createSocket", new Class[]{LdapBinding.class$java$lang$String != null ? LdapBinding.class$java$lang$String : (LdapBinding.class$java$lang$String = LdapBinding.class$("java.lang.String")), Integer.TYPE});
                this.sock = (Socket)var12_23.invoke(var11_21, new Object[]{var1_1, new Integer(var2_2)});
            } else {
                this.sock = new Socket(var1_1, var2_2);
            }
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException var9_10) {
            var10_19 = var9_10.getTargetException();
            var11_22 = new CommunicationException(String.valueOf(var1_1) + ":" + var2_2);
            var11_22.setRootCause(var10_19);
            this.kickoff(var11_22);
            return;
        }
        catch (Exception var9_11) {
            var10_20 = new CommunicationException(String.valueOf(var1_1) + ":" + var2_2);
            var10_20.setRootCause(var9_11);
            this.kickoff(var10_20);
            return;
        }
        if (var6_6.equalsIgnoreCase("CRAM-MD5")) {
            try {
                this.res = this.ldapBind(var3_3, null, var6_6);
            }
            catch (IOException var9_12) {
                var10_18 = new CommunicationException("cram-md5: " + var1_1 + ":" + var2_2);
                var10_18.setRootCause(var9_12);
                this.kickoff((NamingException)var10_18);
                return;
            }
        }
        if (var6_6.equalsIgnoreCase("none")) {
            if (var5_5 == 2 || var5_5 == 32 || var5_5 != 3) {
                try {
                    this.res = this.ldapBind(null, var4_4, var6_6);
                }
                catch (IOException var9_13) {
                    var10_18 = new CommunicationException("anonymous: " + var1_1 + ":" + var2_2);
                    var10_18.setRootCause(var9_13);
                    this.kickoff((NamingException)var10_18);
                    return;
                }
            } else {
                this.skippedBind = true;
                this.res = new LdapResult();
                this.res.status = 0;
            }
        } else {
            try {
                this.res = this.ldapBind(var3_3, var4_4, var6_6);
            }
            catch (IOException var9_14) {
                var10_18 = new CommunicationException("simple: " + var1_1 + ":" + var2_2);
                var10_18.setRootCause(var9_14);
                this.kickoff((NamingException)var10_18);
                return;
            }
        }
        if (this.res.status != 0) {
            if (this.res.status == 2 && var5_5 == 32) {
                try {
                    if (!var6_6.equalsIgnoreCase("none") && !var6_6.equalsIgnoreCase("simple")) ** GOTO lbl98
                    this.res = null;
                    this.version = 2;
                    this.res = this.ldapBind(var3_3, var4_4, var6_6);
                }
                catch (IOException var9_15) {
                    var10_18 = new CommunicationException(String.valueOf(var6_6) + ":" + var1_1 + ":" + var2_2);
                    var10_18.setRootCause(var9_15);
                    this.kickoff((NamingException)var10_18);
                    return;
                }
            } else if (this.res.status == 14) {
                try {
                    var9_9 = this.processChallenge(this.res, var4_4, var6_6);
                    this.res = this.ldapBind(var3_3, String.valueOf(var3_3) + " " + (String)var9_9, var6_6);
                }
                catch (IOException var9_16) {
                    var10_18 = new CommunicationException("challenge:" + var1_1 + ":" + var2_2);
                    var10_18.setRootCause(var9_16);
                    this.kickoff((NamingException)var10_18);
                    return;
                }
                catch (AuthenticationNotSupportedException var9_17) {
                    this.kickoff(var9_17);
                    return;
                }
            }
lbl98:
            // 5 sources

            if (this.res.status != 0 && this.res.status == 32) {
                this.kickoff(new AuthenticationException("[LDAP: No Such Object]"));
                return;
            }
        }
        this.kickoff(null);
    }

    /*
     * Unable to fully structure code
     */
    private String HMAC_MD5(byte[] var1_1, byte[] var2_2) throws NoSuchAlgorithmException {
        var3_3 = MessageDigest.getInstance("MD5");
        if (var1_1.length > 64) {
            var1_1 = var3_3.digest(var1_1);
        }
        var4_4 = new byte[64];
        var5_5 = new byte[64];
        var7_6 = 0;
        ** GOTO lbl16
        {
            var4_4[var7_6] = var1_1[var7_6];
            var5_5[var7_6] = var1_1[var7_6];
            ++var7_6;
            do {
                if (var7_6 < var1_1.length) continue block0;
                var4_4[var7_6] = 0;
                var5_5[var7_6] = 0;
                ++var7_6;
lbl16:
                // 2 sources

            } while (var7_6 < 64);
        }
        var7_6 = 0;
        while (var7_6 < 64) {
            v0 = var7_6;
            var4_4[v0] = (byte)(var4_4[v0] ^ 54);
            v1 = var7_6++;
            var5_5[v1] = (byte)(var5_5[v1] ^ 92);
        }
        var3_3.update(var4_4);
        var3_3.update(var2_2);
        var6_7 = var3_3.digest();
        var3_3.update(var5_5);
        var3_3.update(var6_7);
        var6_7 = var3_3.digest();
        var8_8 = new StringBuffer();
        var7_6 = 0;
        while (var7_6 < var6_7.length) {
            if ((var6_7[var7_6] & 255) < 16) {
                var8_8.append("0" + Integer.toHexString(var6_7[var7_6] & 255));
            } else {
                var8_8.append(Integer.toHexString(var6_7[var7_6] & 255));
            }
            ++var7_6;
        }
        return var8_8.toString();
    }

    private synchronized void abandonOutstandingReqs() {
        LdapRequest ldapRequest = this.pendingRequests;
        Object var2_2 = null;
        while (ldapRequest != null) {
            this.abandonReq(ldapRequest.msgId);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    void abandonReq(int n) {
        LdapRequest ldapRequest = this.findLdapRequest(n);
        if (ldapRequest == null) {
            return;
        }
        Ber ber = new Ber(256);
        ber.init();
        int n2 = ++this.msgId;
        try {
            ber.beginSeq(48);
            ber.encodeInt(n2);
            ber.beginSeq(80);
            ber.encodeInt(n);
            ber.endSeq();
            ber.endSeq();
            if (this.traceFile != null) {
                ber.dumpBER(this.traceFile, this.traceTagOut, ber.getBuf(), ber.getDataOffset(), ber.getDataLen());
            }
            this.outStream.write(ber.getBuf(), ber.getDataOffset(), ber.getDataLen());
            this.outStream.flush();
            this.destroyReq(n);
        }
        catch (IOException iOException) {}
    }

    synchronized void addLdapRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cleanup() {
        if (this.sock == null) return;
        try {
            this.abandonOutstandingReqs();
            this.ldapUnbind();
        }
        finally {
            var2_1 = null;
            try {
                this.outStream.flush();
                this.sock.close();
            }
            catch (IOException var3_3) {}
            var3_3 = this.pendingRequests;
            ** while (var3_3 != null)
        }
lbl-1000:
        // 1 sources

        {
            var4_5 = var3_3.ber;
            synchronized (var4_5) {
                var3_3.ber.notify();
                var3_3.ber = null;
            }
            var3_3 = var3_3.next;
            continue;
        }
lbl25:
        // 1 sources

        this.sock = null;
    }

    synchronized void destroyReq(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        LdapRequest ldapRequest2 = null;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                if (ldapRequest2 != null) {
                    ldapRequest2.next = ldapRequest.next;
                } else {
                    this.pendingRequests = ldapRequest.next;
                }
                ldapRequest.next = null;
            }
            ldapRequest2 = ldapRequest;
            ldapRequest = ldapRequest.next;
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    synchronized LdapRequest findLdapRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized int getMsgId() {
        return ++this.msgId;
    }

    LdapResult getResult() {
        return this.res;
    }

    private void kickoff(NamingException namingException) {
        this.bailout = namingException;
        this.setDaemon(true);
        this.start();
    }

    private synchronized LdapResult ldapBind(String string, Object object, String string2) throws IOException {
        Ber ber = new Ber(1024);
        ber.init();
        int n = ++this.msgId;
        boolean bl = this.version == 3;
        LdapResult ldapResult = new LdapResult();
        ber.beginSeq(48);
        ber.encodeInt(n);
        ber.beginSeq(96);
        ber.encodeInt(this.version);
        ber.encodeString(string, bl);
        if (string2.equalsIgnoreCase("CRAM-MD5") && bl) {
            ber.beginSeq(163);
            ber.encodeString(string2);
            if (object != null) {
                ber.encodeString((String)object);
            }
            ber.endSeq();
        } else {
            ber.encodeString((String)object, 128, false);
        }
        ber.endSeq();
        ber.endSeq();
        byte[] byArray = new byte[2048];
        if (this.traceFile != null) {
            ber.dumpBER(this.traceFile, this.traceTagOut);
        }
        this.outStream.write(ber.getBuf(), 0, ber.getDataLen());
        this.outStream.flush();
        int n2 = this.inStream.read(byArray);
        if (n2 > 1) {
            Ber ber2 = new Ber(byArray, n2, 0);
            if (this.traceFile != null) {
                ber2.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n2);
            }
            ber2.parseSeq(null);
            if (n != ber2.parseInt()) {
                ldapResult.status = 1;
                return ldapResult;
            }
            if (ber2.parseByte() != 97) {
                ldapResult.status = 1;
                return ldapResult;
            }
            ber2.parseLength();
            ldapResult.status = ber2.parseEnumeration();
            ldapResult.matchedDN = ber2.parseString(bl);
            ldapResult.errorMessage = ber2.parseString(bl);
            if (bl && ber2.bytesLeft() > 0 && ber2.peekByte() == 163) {
                ber2.parseSeq(null);
                Vector<String> vector = new Vector<String>(4);
                while (ber2.bytesLeft() > 0) {
                    vector.addElement(ber2.parseString(bl));
                }
                if (ldapResult.referrals == null) {
                    ldapResult.referrals = new Vector(4);
                }
                ldapResult.referrals.addElement(vector);
            }
            if (bl && ber2.bytesLeft() > 0 && ber2.peekByte() == 135) {
                ldapResult.serverCreds = ber2.parseOctetString(135, null);
            }
            return ldapResult;
        }
        ldapResult.status = 2;
        return ldapResult;
    }

    synchronized void ldapUnbind() {
        if (this.skippedBind) {
            return;
        }
        Ber ber = new Ber(256);
        ber.init();
        int n = ++this.msgId;
        try {
            ber.beginSeq(48);
            ber.encodeInt(n);
            ber.encodeByte(66);
            ber.encodeByte(0);
            ber.endSeq();
            if (this.traceFile != null) {
                ber.dumpBER(this.traceFile, this.traceTagOut, ber.getBuf(), ber.getDataOffset(), ber.getDataLen());
            }
            this.outStream.write(ber.getBuf(), ber.getDataOffset(), ber.getDataLen());
            this.outStream.flush();
        }
        catch (IOException iOException) {}
    }

    private String processChallenge(LdapResult ldapResult, Object object, String string) throws IOException, AuthenticationNotSupportedException {
        boolean bl;
        boolean bl2 = bl = this.version == 3;
        if (string.equalsIgnoreCase("CRAM-MD5")) {
            try {
                if (object instanceof String) {
                    if (bl) {
                        return this.HMAC_MD5(((String)object).getBytes("UTF8"), ldapResult.serverCreds);
                    }
                    return this.HMAC_MD5(((String)object).getBytes("8859_1"), ldapResult.serverCreds);
                }
                return this.HMAC_MD5((byte[])object, ldapResult.serverCreds);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new AuthenticationNotSupportedException("MD5 algorithm not available");
            }
        }
        throw new AuthenticationNotSupportedException("Unsupported mechanism: " + string);
    }

    Ber readReply(int n) throws IOException, ServiceUnavailableException {
        LdapRequest ldapRequest = this.findLdapRequest(n);
        if (ldapRequest == null) {
            if (this.sock == null) {
                throw new ServiceUnavailableException(String.valueOf(this.host) + ":" + this.port);
            }
            return null;
        }
        Ber ber = ldapRequest.getReplyBer();
        if (ber == null && this.sock == null) {
            throw new ServiceUnavailableException(String.valueOf(this.host) + ":" + this.port);
        }
        return ber;
    }

    public void run() {
        if (this.bailout != null) {
            this.cleanup();
            return;
        }
        int[] nArray = new int[1];
        int n = 0;
        try {
            try {
                while (true) {
                    int n2;
                    byte[] byArray = new byte[2048];
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = this.inStream.read(byArray, n3, 1);
                    if (n6 < 0) break;
                    if (byArray[n3++] != 48) continue;
                    n6 = this.inStream.read(byArray, n3, 1);
                    if (n6 < 0) break;
                    if (((n4 = byArray[n3++]) & 0x80) == 128) {
                        n5 = n4 & 0x7F;
                        n6 = 0;
                        n2 = 0;
                        while (n6 < n5) {
                            int n7 = this.inStream.read(byArray, n3 + n6, n5 - n6);
                            if (n7 < 0) {
                                n2 = 1;
                                break;
                            }
                            n6 += n7;
                        }
                        if (n2 != 0) break;
                        n4 = 0;
                        int n8 = 0;
                        while (n8 < n5) {
                            n4 = (n4 << 8) + (byArray[n3 + n8] & 0xFF);
                            ++n8;
                        }
                        n3 += n6;
                    }
                    if (n3 + (n2 = n4) > byArray.length) {
                        byte[] byArray2 = new byte[n3 + n2];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        byArray = byArray2;
                    }
                    while (n2 > 0) {
                        n6 = this.inStream.read(byArray, n3, n2);
                        if (n6 < 0) break;
                        n3 += n6;
                        n2 -= n6;
                    }
                    try {
                        Ber ber = new Ber(byArray, n3, 0);
                        if (this.traceFile != null) {
                            ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n3);
                        }
                        ber.parseSeq(null);
                        n = ber.parseInt();
                        ber.init();
                        LdapRequest ldapRequest = this.findLdapRequest(n);
                        if (ldapRequest == null) continue;
                        ldapRequest.addReplyBer(ber);
                        Ber ber2 = ldapRequest.ber;
                        synchronized (ber2) {
                            ldapRequest.ber.notify();
                            continue;
                        }
                    }
                    catch (Ber.DecodeException decodeException) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
            }
            Object var5_16 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var5_17 = null;
            this.cleanup();
            throw throwable;
        }
    }

    void writeReq(Ber ber, int n) throws IOException {
        LdapRequest ldapRequest = new LdapRequest();
        ldapRequest.ber = ber;
        ldapRequest.msgId = n;
        this.addLdapRequest(ldapRequest);
        if (this.traceFile != null) {
            ber.dumpBER(this.traceFile, this.traceTagOut, ber.getBuf(), ber.getDataOffset(), ber.getDataLen());
        }
        this.outStream.write(ber.getBuf(), ber.getDataOffset(), ber.getDataLen());
        this.outStream.flush();
    }
}

