/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.OID;
import com.sun.jndi.misc.HexDumpEncoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

final class Ber {
    Ber next;
    byte[] buf;
    int offset;
    int bufsize;
    int origOffset;
    int curSeqIndex;
    int[] seqOffset;
    static final int INITIAL_SEQUENCES = 16;
    static final int DEFAULT_BUFSIZE = 1024;
    static final int BUF_GROWTH_FACTOR = 8;
    static final int ASN_BOOLEAN = 1;
    static final int ASN_INTEGER = 2;
    static final int ASN_BIT_STRING = 3;
    static final int ASN_SIMPLE_STRING = 4;
    static final int ASN_OCTET_STR = 4;
    static final int ASN_NULL = 5;
    static final int ASN_OBJECT_ID = 6;
    static final int ASN_SEQUENCE = 16;
    static final int ASN_SET = 17;
    static final int ASN_PRIMITIVE = 0;
    static final int ASN_UNIVERSAL = 0;
    static final int ASN_CONSTRUCTOR = 32;
    static final int ASN_APPLICATION = 64;
    static final int ASN_CONTEXT = 128;
    static final int ASN_PRIVATE = 192;
    static final int ASN_ENUMERATED = 10;

    Ber() {
        this(1024);
    }

    Ber(int n) {
        this(new byte[n], n, 0);
    }

    Ber(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.bufsize = n;
        this.origOffset = n2;
        this.init();
    }

    void beginSeq(int n) {
        if (this.curSeqIndex >= this.seqOffset.length) {
            int[] nArray = new int[this.seqOffset.length * 2];
            int n2 = 0;
            while (n2 < this.seqOffset.length) {
                nArray[n2] = this.seqOffset[n2];
                ++n2;
            }
            this.seqOffset = nArray;
        }
        this.encodeByte(n);
        this.seqOffset[this.curSeqIndex] = this.offset;
        this.ensureFreeBytes(3);
        this.offset += 3;
        ++this.curSeqIndex;
    }

    int bytesLeft() {
        return this.bufsize - this.offset;
    }

    void deleteByte() {
        --this.offset;
    }

    public void dumpBER(OutputStream outputStream, String string) {
        this.dumpBER(outputStream, string, this.buf, 0, this.getDataLen());
    }

    public void dumpBER(OutputStream outputStream, String string, byte[] byArray, int n, int n2) {
        Object obj;
        try {
            Class<?> clazz = Class.forName("com.sun.jndi.misc.HexDumpEncoder");
            obj = clazz.newInstance();
        }
        catch (Exception exception) {
            System.out.println("com.sun.jndi.misc.HexDumpEncoder: class not found");
            return;
        }
        try {
            outputStream.write(10);
            outputStream.write(string.getBytes("UTF8"));
            ((HexDumpEncoder)obj).encodeBuffer(new ByteArrayInputStream(byArray, n, n2), outputStream);
            outputStream.write(10);
        }
        catch (IOException iOException) {
            try {
                outputStream.write("Ber.dumpBER(): error encountered\n".getBytes("UTF8"));
            }
            catch (IOException iOException2) {}
        }
    }

    public void dumpBER(byte[] byArray) {
        this.dumpBER(System.out, null, byArray, 0, byArray.length);
    }

    void encodeBoolean(boolean bl) {
        this.encodeBoolean(bl, 1);
    }

    void encodeBoolean(boolean bl, int n) {
        this.ensureFreeBytes(3);
        this.buf[this.offset++] = (byte)n;
        this.buf[this.offset++] = 1;
        this.buf[this.offset++] = bl ? -1 : 0;
    }

    void encodeByte(int n) {
        this.ensureFreeBytes(1);
        this.buf[this.offset++] = (byte)n;
    }

    void encodeInt(int n) {
        this.encodeInt(n, 2);
    }

    void encodeInt(int n, int n2) {
        int n3 = -8388608;
        int n4 = 4;
        while (((n & n3) == 0 || (n & n3) == n3) && n4 > 1) {
            --n4;
            n <<= 8;
        }
        this.encodeInt(n, n2, n4);
    }

    private void encodeInt(int n, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("BER encode error: INTEGER too long.");
        }
        this.ensureFreeBytes(2 + n3);
        this.buf[this.offset++] = (byte)n2;
        this.buf[this.offset++] = (byte)n3;
        int n4 = -16777216;
        while (n3-- > 0) {
            this.buf[this.offset++] = (byte)((n & n4) >> 24);
            n <<= 8;
        }
    }

    void encodeLength(int n) throws EncodeException {
        this.ensureFreeBytes(4);
        if (n < 128) {
            this.buf[this.offset++] = (byte)n;
        } else if (n <= 255) {
            this.buf[this.offset++] = -127;
            this.buf[this.offset++] = (byte)n;
        } else if (n <= 65535) {
            this.buf[this.offset++] = -126;
            this.buf[this.offset++] = (byte)(n >> 8);
            this.buf[this.offset++] = (byte)(n & 0xFF);
        } else if (n <= 0xFFFFFF) {
            this.buf[this.offset++] = -125;
            this.buf[this.offset++] = (byte)(n >> 16);
            this.buf[this.offset++] = (byte)(n >> 8);
            this.buf[this.offset++] = (byte)(n & 0xFF);
        } else {
            throw new EncodeException("string too long");
        }
    }

    void encodeNull() {
        this.encodeByte(5);
        this.encodeByte(0);
    }

    void encodeOID(OID oID) {
        this.ensureFreeBytes(1 + oID.num_subid);
        if (oID.num_subid == 2 && oID.getSubid(0) == 0 && oID.getSubid(1) == 0) {
            this.buf[this.offset++] = 6;
            this.buf[this.offset++] = (byte)(oID.num_subid - 1);
            this.buf[this.offset++] = 0;
            return;
        }
        this.buf[this.offset++] = 6;
        this.buf[this.offset++] = (byte)(oID.num_subid - 1);
        this.buf[this.offset++] = 43;
        oID.setCurrentSubid(2);
        int n = 2;
        while (n < oID.num_subid) {
            this.buf[this.offset++] = (byte)oID.getNextSubid();
            ++n;
        }
    }

    void encodeOctetString(byte[] byArray, int n) throws EncodeException {
        this.encodeOctetString(byArray, n, 0, byArray.length);
    }

    void encodeOctetString(byte[] byArray, int n, int n2) throws EncodeException {
        this.encodeOctetString(byArray, n, 0, n2);
    }

    void encodeOctetString(byte[] byArray, int n, int n2, int n3) throws EncodeException {
        this.encodeByte(n);
        this.encodeLength(n3);
        if (n3 > 0) {
            this.ensureFreeBytes(n3);
            System.arraycopy(byArray, n2, this.buf, this.offset, n3);
            this.offset += n3;
        }
    }

    void encodeString(String string) throws EncodeException {
        this.encodeString(string, 4, false);
    }

    void encodeString(String string, int n, boolean bl) throws EncodeException {
        int n2;
        this.encodeByte(n);
        int n3 = 0;
        byte[] byArray = null;
        if (string == null) {
            n2 = 0;
        } else {
            if (bl) {
                try {
                    byArray = string.getBytes("UTF8");
                    n2 = byArray.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new EncodeException("UTF8 not available on platform");
                }
            }
            try {
                byArray = string.getBytes("8859_1");
                n2 = byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new EncodeException("8859_1 not available on platform");
            }
        }
        this.encodeLength(n2);
        this.ensureFreeBytes(n2);
        while (n3 < n2) {
            this.buf[this.offset++] = byArray[n3++];
        }
    }

    void encodeString(String string, boolean bl) throws EncodeException {
        this.encodeString(string, 4, bl);
    }

    void encodeStringArray(String[] stringArray, boolean bl) throws EncodeException {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.encodeString(stringArray[n], bl);
            ++n;
        }
    }

    void endSeq() throws EncodeException {
        --this.curSeqIndex;
        if (this.curSeqIndex < 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        int n = this.seqOffset[this.curSeqIndex] + 3;
        int n2 = this.offset - n;
        if (n2 <= 127) {
            this.shiftSeqData(n, n2, -2);
            this.buf[this.seqOffset[this.curSeqIndex]] = (byte)n2;
        } else if (n2 <= 255) {
            this.shiftSeqData(n, n2, -1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -127;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)n2;
        } else if (n2 <= 65535) {
            this.buf[this.seqOffset[this.curSeqIndex]] = -126;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(n2 >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)n2;
        } else if (n2 <= 0xFFFFFF) {
            this.shiftSeqData(n, n2, 1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -125;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(n2 >> 16);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)(n2 >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 3] = (byte)n2;
        } else {
            throw new EncodeException("SEQUENCE too long");
        }
    }

    void ensureFreeBytes(int n) {
        if (this.bufsize - this.offset < n) {
            int n2 = this.bufsize * 8;
            if (n2 - this.offset < n) {
                n2 += n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, this.origOffset, byArray, 0, this.offset - this.origOffset);
            this.buf = byArray;
            this.bufsize = n2;
            this.offset -= this.origOffset;
            this.origOffset = 0;
        }
    }

    byte[] getBuf() {
        if (this.curSeqIndex != 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        return this.buf;
    }

    int getDataLen() {
        return this.offset - this.origOffset;
    }

    int getDataOffset() {
        return this.origOffset;
    }

    void init() {
        this.offset = this.origOffset;
        this.seqOffset = new int[16];
        this.curSeqIndex = 0;
    }

    int parseByte() throws DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new DecodeException("Insufficient data");
        }
        return this.buf[this.offset++] & 0xFF;
    }

    int parseEnumeration() throws DecodeException {
        return this.parseIntWithTag(10);
    }

    int parseInt() throws DecodeException {
        return this.parseIntWithTag(2);
    }

    int parseIntWithTag(int n) throws DecodeException {
        if (this.parseByte() != n) {
            throw new DecodeException("Encountered ASN.1 tag " + Integer.toString(this.buf[this.offset - 1] & 0xFF) + " (expected tag " + Integer.toString(n) + ")");
        }
        int n2 = this.parseLength();
        if (n2 > 4) {
            throw new DecodeException("INTEGER too long");
        }
        if (n2 > this.bufsize - this.offset) {
            throw new DecodeException("Insufficient data");
        }
        byte by = this.buf[this.offset++];
        int n3 = 0;
        n3 = by & 0x7F;
        int n4 = 1;
        while (n4 < n2) {
            n3 <<= 8;
            n3 |= this.buf[this.offset++] & 0xFF;
            ++n4;
        }
        if ((by & 0x80) == 128) {
            n3 = -n3;
        }
        return n3;
    }

    int parseLength() throws DecodeException {
        int n = this.parseByte();
        if ((n & 0x80) == 128) {
            if ((n &= 0x7F) == 0) {
                throw new DecodeException("Indefinite length not supported");
            }
            if (n > 4) {
                throw new DecodeException("encoding too long");
            }
            if (this.bufsize - this.offset < n) {
                throw new DecodeException("Insufficient data");
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 = (n2 << 8) + (this.buf[this.offset++] & 0xFF);
                ++n3;
            }
            return n2;
        }
        return n;
    }

    OID parseOID() throws DecodeException {
        OID oID = new OID();
        if (this.parseByte() != 6) {
            throw new DecodeException("Encountered ASN.1 tag " + Integer.toString(this.buf[this.offset - 1] & 0xFF) + " (expected tag 6)");
        }
        int n = this.parseLength();
        if (n > this.bufsize - this.offset) {
            throw new DecodeException("Insufficient data");
        }
        if (n == 0) {
            oID.addSubid(0);
            oID.addSubid(0);
            return oID;
        }
        byte by = this.buf[this.offset++];
        int n2 = by % 40;
        int n3 = (by - (byte)n2) / 40;
        oID.addSubid(n3);
        oID.addSubid(n2);
        --n;
        while (n > 0) {
            int n4 = 0;
            do {
                by = this.buf[this.offset++];
                --n;
                n4 = (n4 << 7) + (by & 0x7F);
            } while ((by & 0x80) == 128);
            oID.addSubid(n4);
        }
        if (this.bufsize - this.offset >= 2 && this.buf[this.offset] == 5) {
            this.offset += 2;
        }
        return oID;
    }

    byte[] parseOctetString(int n, int[] nArray) throws DecodeException {
        int n2 = this.offset;
        int n3 = this.parseByte();
        if (n3 != n) {
            throw new DecodeException("Encountered ASN.1 tag " + Integer.toString(n3) + " (expected tag " + Integer.toString(n) + ")");
        }
        int n4 = this.parseLength();
        if (n4 > this.bufsize - this.offset) {
            throw new DecodeException("Insufficient data");
        }
        byte[] byArray = new byte[n4];
        if (n4 > 0) {
            System.arraycopy(this.buf, this.offset, byArray, 0, n4);
            this.offset += n4;
        }
        if (nArray != null) {
            nArray[0] = this.offset - n2;
        }
        return byArray;
    }

    int parseSeq(int[] nArray) throws DecodeException {
        int n = this.parseByte();
        int n2 = this.parseLength();
        if (nArray != null) {
            nArray[0] = n2;
        }
        return n;
    }

    String parseString() throws DecodeException {
        return this.parseString(null, false);
    }

    String parseString(boolean bl) throws DecodeException {
        return this.parseString(null, bl);
    }

    String parseString(int[] nArray, boolean bl) throws DecodeException {
        String string;
        int n = this.offset;
        int n2 = this.parseByte();
        if (n2 != 4) {
            throw new DecodeException("Encountered ASN.1 tag " + Integer.toString(n2) + " (expected tag 4)");
        }
        int n3 = this.parseLength();
        if (n3 > this.bufsize - this.offset) {
            throw new DecodeException("Insufficient data");
        }
        if (n3 == 0) {
            string = "";
        } else {
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buf, this.offset, byArray, 0, n3);
            if (bl) {
                try {
                    string = new String(byArray, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new DecodeException("UTF8 not available on platform");
                }
            }
            try {
                string = new String(byArray, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new DecodeException("8859_1 not available on platform");
            }
            this.offset += n3;
        }
        if (nArray != null) {
            nArray[0] = this.offset - n;
        }
        return string;
    }

    int peekByte() throws DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new DecodeException("Insufficient data");
        }
        return this.buf[this.offset] & 0xFF;
    }

    void seek(int n) throws DecodeException {
        if (this.offset + n > this.bufsize || this.offset + n < 0) {
            throw new DecodeException("array index out of bounds");
        }
        this.offset += n;
    }

    void shiftSeqData(int n, int n2, int n3) {
        if (n3 > 0) {
            this.ensureFreeBytes(n3);
        }
        System.arraycopy(this.buf, n, this.buf, n + n3, n2);
        this.offset += n3;
    }

    static final class EncodeException
    extends IOException {
        EncodeException(String string) {
            super(string);
        }
    }

    static final class DecodeException
    extends IOException {
        DecodeException(String string) {
            super(string);
        }
    }
}

