/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soapimpl.java;

import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SOAPConnectorConfiguration;
import com.baan.owimpl.fw.ccf.SOAPConnectorContext;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.soap.java.ManagerException;
import java.io.File;
import java.io.FilenameFilter;

public class WSDLManager {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soapimpl$java$WSDLManager == null ? (class$com$ssaglobal$soapimpl$java$WSDLManager = WSDLManager.class$("com.ssaglobal.soapimpl.java.WSDLManager")) : class$com$ssaglobal$soapimpl$java$WSDLManager);
    private static String LOG_PREFIX = "WSDLManager: ";
    private String m_wsdlLocation = null;
    static /* synthetic */ Class class$com$ssaglobal$soapimpl$java$WSDLManager;

    WSDLManager() {
    }

    File getWSDLFile(String string) throws ManagerException {
        String string2 = this.getWSDLLocation();
        s_logger.flowMessage(LOG_PREFIX + "Get WSDL file for service '" + string + "'");
        String string3 = string2 + File.separator + string + ".wsdl";
        s_logger.flowMessage(LOG_PREFIX + "WSDL filename = '" + string3 + "'");
        File file2 = new File(string3);
        if (file2.canRead()) {
            return file2;
        }
        s_logger.errorMessage(LOG_PREFIX + "WSDL file:" + string3 + " cannot be read, or is missing from the specified location.");
        return null;
    }

    String getWSDLLocation() throws ManagerException {
        if (this.m_wsdlLocation == null) {
            s_logger.message(LOG_PREFIX + "Access CCF to obtain WSDL Location configured for this " + "system, user, app");
            try {
                SOAPConnectorConfiguration sOAPConnectorConfiguration = SOAPConnectorContext.getInstance().search();
                this.m_wsdlLocation = sOAPConnectorConfiguration.getWSDLDirectory();
            }
            catch (OWConfigurationException oWConfigurationException) {
                throw new ManagerException("Server.Configuration", "Cannot access the Central Configuration, check configuration.", oWConfigurationException, false);
            }
        }
        s_logger.message(LOG_PREFIX + "WSDL Location configured for this system, user, app = '" + this.m_wsdlLocation + "'");
        return this.m_wsdlLocation;
    }

    String[] getWebServices() throws ManagerException {
        String string = this.getWSDLLocation();
        File file2 = new File(string);
        if (!file2.isDirectory()) {
            throw new ManagerException("Server.Configuration", "The WSDL location " + file2.getAbsolutePath() + " does not exist or is not a directory.", false);
        }
        s_logger.flowMessage(LOG_PREFIX + "Read wsdlFiles from " + string);
        String[] stringArray = file2.list(new WSDLFilter());
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            stringArray2[n] = string2 = string2.substring(0, string2.lastIndexOf("."));
            s_logger.flowMessage(LOG_PREFIX + "Service Name = " + string2);
            ++n;
        }
        return stringArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class WSDLFilter
    implements FilenameFilter {
        private WSDLFilter() {
        }

        public boolean accept(File file2, String string) {
            File file3 = new File(file2, string);
            return file3.isFile() && string.toUpperCase().endsWith(".WSDL");
        }
    }
}

