/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soapimpl.java;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.soap.java.FaultException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;

public class SOAPUtil {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soapimpl$java$SOAPUtil == null ? (class$com$ssaglobal$soapimpl$java$SOAPUtil = SOAPUtil.class$("com.ssaglobal.soapimpl.java.SOAPUtil")) : class$com$ssaglobal$soapimpl$java$SOAPUtil);
    private static final String LOG_PREFIX = "SOAP-Util: ";
    private static final String UTF8 = "UTF-8";
    private static MessageFactory s_messageFactory = null;
    private static SOAPFactory s_soapFactory = null;
    private static Name s_fcVersionMismatch = null;
    private static Name s_fcVersionMismatchNoNamespace = null;
    private static Name s_fcMustUnderstand = null;
    private static Name s_fcClientBadContentType = null;
    private static Name s_fcClientHttpEncNotSupported = null;
    private static Name s_fcClientHttpMissingAction = null;
    private static Name s_fcClientHttpTransEncNotSupported = null;
    private static Name s_fcClientMimeHeaderNotSupported = null;
    private static Name s_fcClientMissingContentType = null;
    private static Name s_fcServerBde = null;
    private static Name s_fcServerParsing = null;
    private static Name s_fcServerUnknown = null;
    private static Name s_stackTraceTag = null;
    private static Name s_overridenMessageTag = null;
    private static Name s_misunderstoodTag = null;
    private static Name s_qnameName = null;
    static /* synthetic */ Class class$com$ssaglobal$soapimpl$java$SOAPUtil;

    private SOAPUtil() {
    }

    public static void logSoapMessage(String string, SOAPMessage sOAPMessage, ILogger iLogger) {
        if (iLogger == null) {
            iLogger = s_logger;
        }
        if (!iLogger.isFlowEnabled()) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
            String string2 = byteArrayOutputStream.toString(UTF8);
            iLogger.flowMessage(string + string2);
        }
        catch (Exception exception) {
            iLogger.flowMessage(string + "(COULD NOT LOG SOAPMESSAGE)");
            s_logger.errorException(exception);
        }
    }

    private static SOAPFactory getSoapFactory() throws SOAPException {
        if (s_soapFactory == null) {
            s_soapFactory = SOAPFactory.newInstance();
        }
        return s_soapFactory;
    }

    static Name createName(String string, String string2) throws SOAPException {
        SOAPFactory sOAPFactory = SOAPUtil.getSoapFactory();
        return sOAPFactory.createName(string, null, string2);
    }

    static Name createSoapEnvelopeName(String string) throws SOAPException {
        return SOAPUtil.createName(string, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    static Name fcVersionMismatch() throws SOAPException {
        if (s_fcVersionMismatch == null) {
            s_fcVersionMismatch = SOAPUtil.createSoapEnvelopeName("VersionMismatch");
        }
        return s_fcVersionMismatch;
    }

    static Name fcVersionMismatchNoNamespace() throws SOAPException {
        if (s_fcVersionMismatchNoNamespace == null) {
            s_fcVersionMismatchNoNamespace = SOAPUtil.createSoapEnvelopeName("VersionMismatch.NoNamespace");
        }
        return s_fcVersionMismatchNoNamespace;
    }

    static Name fcMustUnderstand() throws SOAPException {
        if (s_fcMustUnderstand == null) {
            s_fcMustUnderstand = SOAPUtil.createSoapEnvelopeName("MustUnderstand");
        }
        return s_fcMustUnderstand;
    }

    public static Name fcClientBadContentType() throws SOAPException {
        if (s_fcClientBadContentType == null) {
            s_fcClientBadContentType = SOAPUtil.createSoapEnvelopeName("ClientBadContentType");
        }
        return s_fcClientBadContentType;
    }

    public static Name fcClientHttpEncNotSupported() throws SOAPException {
        if (s_fcClientHttpEncNotSupported == null) {
            s_fcClientHttpEncNotSupported = SOAPUtil.createSoapEnvelopeName("Client.HttpContentEncodingHeaderNotSupported");
        }
        return s_fcClientHttpEncNotSupported;
    }

    public static Name fcClientHttpMissingAction() throws SOAPException {
        if (s_fcClientHttpMissingAction == null) {
            s_fcClientHttpMissingAction = SOAPUtil.createSoapEnvelopeName("Client.HttpMissingActionHeader");
        }
        return s_fcClientHttpMissingAction;
    }

    public static Name fcClientHttpTransEncNotSupported() throws SOAPException {
        if (s_fcClientHttpTransEncNotSupported == null) {
            s_fcClientHttpTransEncNotSupported = SOAPUtil.createSoapEnvelopeName("Client.HttpTransferEncodingHeaderNotSupported");
        }
        return s_fcClientHttpTransEncNotSupported;
    }

    public static Name fcClientMimeHeaderNotSupported() throws SOAPException {
        if (s_fcClientMimeHeaderNotSupported == null) {
            s_fcClientMimeHeaderNotSupported = SOAPUtil.createSoapEnvelopeName("Client.MimeHeaderNotSupported");
        }
        return s_fcClientMimeHeaderNotSupported;
    }

    public static Name fcClientMissingContentType() throws SOAPException {
        if (s_fcClientMissingContentType == null) {
            s_fcClientMissingContentType = SOAPUtil.createSoapEnvelopeName("Client.MissingContentType");
        }
        return s_fcClientMissingContentType;
    }

    static Name fcServerBde() throws SOAPException {
        if (s_fcServerBde == null) {
            s_fcServerBde = SOAPUtil.createSoapEnvelopeName("Server.BDE");
        }
        return s_fcServerBde;
    }

    public static Name fcServerParsing() throws SOAPException {
        if (s_fcServerParsing == null) {
            s_fcServerParsing = SOAPUtil.createSoapEnvelopeName("Server.Parsing");
        }
        return s_fcServerParsing;
    }

    public static Name fcServerUnknown() throws SOAPException {
        if (s_fcServerUnknown == null) {
            s_fcServerUnknown = SOAPUtil.createSoapEnvelopeName("Server.Unknown");
        }
        return s_fcServerUnknown;
    }

    private static MessageFactory getMessageFactory() throws SOAPException {
        if (s_messageFactory == null) {
            s_messageFactory = MessageFactory.newInstance();
        }
        return s_messageFactory;
    }

    public static SOAPMessage createSoapMessage() throws SOAPException {
        MessageFactory messageFactory = SOAPUtil.getMessageFactory();
        return messageFactory.createMessage();
    }

    public static SOAPMessage createSoapMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws SOAPException, IOException {
        s_logger.flowEntry("SOAP-Util: Enter SOAPServlet::createSOAPMessage");
        if (mimeHeaders == null || inputStream == null) {
            return SOAPUtil.createSoapMessage();
        }
        MessageFactory messageFactory = SOAPUtil.getMessageFactory();
        return messageFactory.createMessage(mimeHeaders, inputStream);
    }

    static FaultException newBodyProcessFaultException(Name name, String string, Throwable throwable, SOAPMessage sOAPMessage) throws SOAPException {
        FaultException faultException = SOAPUtil.newFaultException(name, string, throwable);
        faultException.addStackTraceToDetails(throwable);
        if (sOAPMessage != null) {
            faultException.addToFault(sOAPMessage);
        }
        return faultException;
    }

    public static FaultException newNonBodyFaultException(Name name, String string, Throwable throwable) throws SOAPException {
        FaultException faultException = SOAPUtil.newFaultException(name, string, throwable);
        faultException.removeDetail();
        faultException.addStackTraceToFault(throwable);
        return faultException;
    }

    static FaultException newNonBodyFaultException(Name name, String string, Throwable throwable, SOAPMessage sOAPMessage) throws SOAPException {
        FaultException faultException = SOAPUtil.newFaultException(name, string, throwable);
        faultException.removeDetail();
        faultException.addStackTraceToFault(throwable);
        if (sOAPMessage != null) {
            faultException.addToFault(sOAPMessage);
        }
        return faultException;
    }

    public static FaultException newFaultException(Name name, String string) throws SOAPException {
        FaultException faultException = new FaultException(name, string, "http://www.ssaglobal.com/OpenWorld/c4soap");
        faultException.removeDetail();
        return faultException;
    }

    private static FaultException newFaultException(Name name, String string, Throwable throwable) throws SOAPException {
        String string2;
        if (string == null) {
            string2 = throwable.toString();
        }
        string2 = string.startsWith("while") ? throwable.getClass().getName() + ' ' + string + ": " + throwable.getMessage() : string;
        FaultException faultException = new FaultException(name, string2, "http://www.ssaglobal.com/OpenWorld/c4soap");
        return faultException;
    }

    public static Name getStackTraceTag() throws SOAPException {
        if (s_stackTraceTag == null) {
            SOAPFactory sOAPFactory = SOAPUtil.getSoapFactory();
            s_stackTraceTag = sOAPFactory.createName("stackTrace", null, "http://www.ssaglobal.com/OpenWorld/c4soap");
        }
        return s_stackTraceTag;
    }

    public static Name getOverridenMessageTag() throws SOAPException {
        if (s_overridenMessageTag == null) {
            SOAPFactory sOAPFactory = SOAPUtil.getSoapFactory();
            s_overridenMessageTag = sOAPFactory.createName("overriddenMessage", null, "http://www.ssaglobal.com/OpenWorld/c4soap");
        }
        return s_overridenMessageTag;
    }

    static Name getMisunderstoodTag() throws SOAPException {
        if (s_misunderstoodTag == null) {
            SOAPFactory sOAPFactory = SOAPUtil.getSoapFactory();
            s_misunderstoodTag = sOAPFactory.createName("Misunderstood", null, "http://www.w3.org/2001/06/soap-faults");
        }
        return s_misunderstoodTag;
    }

    static Name getQnameName() throws SOAPException {
        if (s_qnameName == null) {
            SOAPFactory sOAPFactory = SOAPUtil.getSoapFactory();
            s_qnameName = sOAPFactory.createName("qname", null, null);
        }
        return s_qnameName;
    }

    static Iterator getChildSOAPElements(SOAPElement sOAPElement) {
        Iterator iterator = sOAPElement.getChildElements();
        return new SOAPElementIterator(iterator);
    }

    private static SOAPElement nextSOAPElement(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPElement)) continue;
            return (SOAPElement)e;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SOAPElementIterator
    implements Iterator {
        private final Iterator m_iterator;
        private SOAPElement m_next;

        SOAPElementIterator(Iterator iterator) {
            this.m_iterator = iterator;
            this.m_next = SOAPUtil.nextSOAPElement(iterator);
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() method not supported");
        }

        public Object next() {
            SOAPElement sOAPElement = this.m_next;
            this.m_next = SOAPUtil.nextSOAPElement(this.m_iterator);
            return sOAPElement;
        }

        public boolean hasNext() {
            return this.m_next != null;
        }
    }
}

