/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soapimpl.java;

import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserInfo;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.LicenseException;
import com.ssaglobal.soap.java.IBdeManager;
import com.ssaglobal.soap.java.IDispatcher;
import com.ssaglobal.soap.java.IUserSession;
import com.ssaglobal.soap.java.ManagerException;
import com.ssaglobal.soap.java.ManagerFactory;
import com.ssaglobal.soapimpl.java.BdeManager;
import com.ssaglobal.soapimpl.java.Dispatcher;
import com.ssaglobal.soapimpl.java.License;
import com.ssaglobal.soapimpl.java.UserSession;
import com.ssaglobal.soapimpl.java.WSDLManager;
import java.io.File;

public class ManagerFactoryImpl
extends ManagerFactory {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soapimpl$java$ManagerFactoryImpl == null ? (class$com$ssaglobal$soapimpl$java$ManagerFactoryImpl = ManagerFactoryImpl.class$("com.ssaglobal.soapimpl.java.ManagerFactoryImpl")) : class$com$ssaglobal$soapimpl$java$ManagerFactoryImpl);
    private static final String LOG_PREFIX = "SOAP-Factory: ";
    private static ManagerFactoryImpl s_ManagerFactory = null;
    private License m_license;
    private WSDLManager m_WSDLManager = null;
    static /* synthetic */ Class class$com$ssaglobal$soapimpl$java$ManagerFactoryImpl;

    private ManagerFactoryImpl() throws LicenseException, ManagerException {
        s_logger.message("SOAP-Factory: Obtain License");
        this.m_license = new License();
        this.m_license.createLicense();
        this.m_WSDLManager = new WSDLManager();
    }

    public static ManagerFactory getManagerFactory() throws ManagerException {
        s_logger.message("SOAP-Factory: Try to create the instance for the ManagerFactory");
        if (s_ManagerFactory == null) {
            try {
                s_ManagerFactory = new ManagerFactoryImpl();
            }
            catch (LicenseException licenseException) {
                throw new ManagerException("Server.License", "Could not obtain license", licenseException, false);
            }
            s_logger.message("SOAP-Factory: The instance for the ManagerFactory is created");
            return s_ManagerFactory;
        }
        s_logger.errorMessage("SOAP-Factory: The Instance for the ManagerFactory is already created, close the instance first");
        throw new ManagerException("Server.IllegalApiState", "The ManagerFactory needs to be closed before getting a new instance.", false);
    }

    public void close() {
        s_logger.message("SOAP-Factory: Close this ManagerFactory and Release the license");
        this.m_license.releaseLicense();
        s_ManagerFactory = null;
    }

    public String getLicenseInfo() throws ManagerException {
        return this.m_license.getLicenseInfo();
    }

    public IDispatcher createDispatcher() throws ManagerException {
        this.checkClosed();
        s_logger.message("SOAP-Factory: Return new Dispatcher");
        return new Dispatcher(this);
    }

    public IBdeManager createBdeManager(String string, IUserSession iUserSession) throws ManagerException {
        this.checkClosed();
        s_logger.message("SOAP-Factory: Return new Bde Manager");
        BdeManager bdeManager = new BdeManager(this.m_license);
        if (iUserSession != null) {
            ((UserSession)iUserSession).addManager(bdeManager);
        }
        bdeManager.initialize(string);
        return bdeManager;
    }

    public IBdeManager createBdeManager(String string) throws ManagerException {
        this.checkClosed();
        s_logger.message("SOAP-Factory: Return new Bde Manager");
        BdeManager bdeManager = new BdeManager(this.m_license);
        bdeManager.initialize(string);
        return bdeManager;
    }

    public IUserSession createUserSession(String string, String string2) {
        IUserInfo iUserInfo = BoiToolkit.getDefaultToolkit().createUserInfo();
        iUserInfo.setPassword(string2);
        iUserInfo.setUsername(string);
        return new UserSession(iUserInfo);
    }

    public File getWSDL(String string) throws ManagerException {
        this.checkClosed();
        return this.m_WSDLManager.getWSDLFile(string);
    }

    public String[] getWebServices() throws ManagerException {
        this.checkClosed();
        return this.m_WSDLManager.getWebServices();
    }

    public String getWsdlLocation() throws ManagerException {
        this.checkClosed();
        return this.m_WSDLManager.getWSDLLocation();
    }

    private void checkClosed() throws ManagerException {
        if (s_ManagerFactory == null) {
            throw new ManagerException("Server.IllegalApiState", "This manager factory is already closed", false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_SOAP_CONNECTOR1);
    }
}

