/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soapimpl.java;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseEvent;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.services.licensing.LicenseListener;
import com.ssaglobal.soap.about.SOAPConnectorComponentInfo;
import com.ssaglobal.soap.java.ManagerException;

public final class License
implements LicenseListener {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soapimpl$java$License == null ? (class$com$ssaglobal$soapimpl$java$License = License.class$("com.ssaglobal.soapimpl.java.License")) : class$com$ssaglobal$soapimpl$java$License);
    private static final String LOG_PREFIX = "SOAP-LIC: ";
    private ILicense iLic = null;
    private boolean m_validLicense = false;
    private SOAPConnectorComponentInfo m_product = new SOAPConnectorComponentInfo();
    static /* synthetic */ Class class$com$ssaglobal$soapimpl$java$License;

    void createLicense() throws LicenseException, ManagerException {
        s_logger.flowMessage("SOAP-LIC: Creating License for " + this.m_product.getComponentName());
        this.iLic = LicenseFactory.createServerLicense(7066, "Connector for SOAP");
        this.iLic.addLicenseListener(this);
        if (this.iLic.getDaysLeft() < 0) {
            s_logger.errorMessage("SOAP-LIC: The license for " + this.m_product.getComponentName() + " has expired: " + this.iLic.getMessage());
            throw new ManagerException("Server.License", this.iLic.getMessage(), false);
        }
        s_logger.message("SOAP-LIC: License Check successful! Host Name: " + this.iLic.getHostName() + " Expiration Date: " + this.iLic.getFormattedExpirationDate());
        this.m_validLicense = true;
    }

    String getLicenseInfo() throws ManagerException {
        this.checkLicense();
        String string = "Host Name: " + this.iLic.getHostName() + ", Expiration Date: " + this.iLic.getFormattedExpirationDate();
        return string;
    }

    void checkLicense() throws ManagerException {
        if (!this.m_validLicense) {
            throw new ManagerException("Server.License", "Could not obtain license for " + this.m_product.getComponentName(), false);
        }
        s_logger.message("SOAP-LIC: License checked and OK");
    }

    void releaseLicense() {
        if (this.iLic != null) {
            s_logger.message("SOAP-LIC: Releasing License.");
            this.iLic.release();
            this.iLic = null;
        }
    }

    public void licenseChanged(LicenseEvent licenseEvent) {
        ILicense iLicense = licenseEvent.getLicense();
        int n = licenseEvent.getReason();
        String string = licenseEvent.getMessage();
        try {
            String string2 = "";
            boolean bl = true;
            switch (n) {
                case 2: {
                    s_logger.message("SOAP-LIC: License Callback called, reason extended");
                    this.iLic = iLicense;
                    this.m_validLicense = true;
                    break;
                }
                case 4: {
                    s_logger.message("SOAP-LIC: License Callback called, reason confirm error");
                    this.iLic = iLicense;
                    this.m_validLicense = false;
                    break;
                }
                case 1: {
                    s_logger.message("SOAP-LIC: License Callback called, reason expired");
                    this.iLic = iLicense;
                    this.m_validLicense = false;
                }
            }
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

