/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soapimpl.java;

import com.ssaglobal.soap.java.FaultException;
import com.ssaglobal.soap.java.IBdeManager;
import com.ssaglobal.soap.java.IDispatcher;
import com.ssaglobal.soap.java.ManagerException;
import com.ssaglobal.soapimpl.java.ManagerFactoryImpl;
import com.ssaglobal.soapimpl.java.SOAPUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

class Dispatcher
implements IDispatcher {
    private final ManagerFactoryImpl m_managerFactory;
    static /* synthetic */ Class class$javax$xml$soap$SOAPException;
    static /* synthetic */ Class class$com$ssaglobal$soap$java$FaultException;

    Dispatcher(ManagerFactoryImpl managerFactoryImpl) {
        this.m_managerFactory = managerFactoryImpl;
    }

    public synchronized SOAPMessage dispatch(SOAPMessage sOAPMessage, String string) throws FaultException {
        try {
            return this.dispatchImpl(sOAPMessage, string);
        }
        catch (FaultException faultException) {
            throw faultException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            try {
                throw SOAPUtil.newNonBodyFaultException(SOAPUtil.fcServerUnknown(), "while dispatching SOAP request", throwable);
            }
            catch (SOAPException sOAPException) {
                throw new RuntimeException((class$javax$xml$soap$SOAPException == null ? (class$javax$xml$soap$SOAPException = Dispatcher.class$("javax.xml.soap.SOAPException")) : class$javax$xml$soap$SOAPException).getName() + " while trying to wrap a throwable in a " + (class$com$ssaglobal$soap$java$FaultException == null ? (class$com$ssaglobal$soap$java$FaultException = Dispatcher.class$("com.ssaglobal.soap.java.FaultException")) : class$com$ssaglobal$soap$java$FaultException).getName() + ": " + sOAPException.getMessage(), throwable);
            }
        }
    }

    private synchronized SOAPMessage dispatchImpl(SOAPMessage sOAPMessage, String string) throws FaultException, SOAPException {
        SOAPMessage sOAPMessage2 = null;
        this.checkSoapVersion(sOAPMessage);
        this.processSoapHeaders(sOAPMessage);
        try {
            IBdeManager iBdeManager = this.m_managerFactory.createBdeManager(string);
            sOAPMessage2 = iBdeManager.execute(sOAPMessage);
            iBdeManager.close();
        }
        catch (ManagerException managerException) {
            String string2 = managerException.getFaultcode();
            Name name = SOAPUtil.createSoapEnvelopeName(string2);
            if (managerException.isBodyRelated()) {
                throw SOAPUtil.newBodyProcessFaultException(name, managerException.getMessage(), managerException, sOAPMessage2);
            }
            throw SOAPUtil.newNonBodyFaultException(name, managerException.getMessage(), managerException, sOAPMessage2);
        }
        if (sOAPMessage2.getSOAPBody().hasFault()) {
            throw new FaultException(sOAPMessage2);
        }
        return sOAPMessage2;
    }

    private void checkSoapVersion(SOAPMessage sOAPMessage) throws FaultException, SOAPException {
        SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
        Name name = sOAPEnvelope.getElementName();
        String string = name.getURI();
        if (string == null) {
            throw SOAPUtil.newFaultException(SOAPUtil.fcVersionMismatchNoNamespace(), "No namespace set for SOAP Envelope tag");
        }
        if (!string.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            throw SOAPUtil.newFaultException(SOAPUtil.fcVersionMismatch(), "Wrong SOAP Envelope namespace. Only SOAP 1.1 is supported. Found: " + string + ", expected: " + "http://schemas.xmlsoap.org/soap/envelope/");
        }
    }

    private void processSoapHeaders(SOAPMessage sOAPMessage) throws FaultException, SOAPException {
        Name name;
        Object object;
        ArrayList<Name> arrayList = new ArrayList<Name>();
        SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
        if (sOAPHeader != null) {
            object = sOAPHeader.examineAllHeaderElements();
            while (object.hasNext()) {
                name = (SOAPHeaderElement)object.next();
                if (!name.getMustUnderstand()) continue;
                arrayList.add(name);
            }
        }
        if (arrayList.size() > 0) {
            object = SOAPUtil.newFaultException(SOAPUtil.fcMustUnderstand(), "Could not understand Header element(s)");
            name = SOAPUtil.getMisunderstoodTag();
            Name name2 = SOAPUtil.getQnameName();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator.next();
                Name name3 = sOAPHeaderElement.getElementName();
                SOAPHeaderElement sOAPHeaderElement2 = ((FaultException)object).addHeaderElement(name);
                String string = sOAPHeaderElement2.getElementName().getPrefix();
                String string2 = string + "Target";
                sOAPHeaderElement2.addNamespaceDeclaration(string2, name3.getURI());
                sOAPHeaderElement2.addAttribute(name2, string2 + ':' + name3.getLocalName());
            }
            throw object;
        }
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

