/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soapimpl.java;

import com.baan.b3.dom.Element;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.xml.util.DOMConverter;
import com.ssaglobal.soap.java.ManagerException;
import com.ssaglobal.soapimpl.java.SOAPUtil;
import java.util.Iterator;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;

public class BdeBodyProcessor {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soapimpl$java$BdeBodyProcessor == null ? (class$com$ssaglobal$soapimpl$java$BdeBodyProcessor = BdeBodyProcessor.class$("com.ssaglobal.soapimpl.java.BdeBodyProcessor")) : class$com$ssaglobal$soapimpl$java$BdeBodyProcessor);
    private static final String LOG_PREFIX = "SOAP: ";
    public static final String NAMESPACE = "http://www.ssaglobal.com/businessinterface/";
    private String m_namespace;
    private String m_methodName;
    private String m_dllName;
    private Element m_bdeElement;
    static /* synthetic */ Class class$com$ssaglobal$soapimpl$java$BdeBodyProcessor;

    BdeBodyProcessor(SOAPBody sOAPBody) throws ManagerException {
        this.processBDEBody(sOAPBody);
    }

    String getMethodName() {
        return this.m_methodName;
    }

    String getDLLName() {
        return this.m_dllName;
    }

    String getNamespace() {
        return this.m_namespace;
    }

    Element getBdeElement() {
        return this.m_bdeElement;
    }

    private void processBDEBody(SOAPBody sOAPBody) throws ManagerException {
        Iterator iterator = SOAPUtil.getChildSOAPElements((SOAPElement)sOAPBody);
        SOAPElement sOAPElement = this.fetchMethodElement(iterator);
        String string = sOAPElement.getElementName().getLocalName();
        s_logger.flowMessage("SOAP: Body Processing : Found methodName '" + string + "'");
        this.m_namespace = sOAPElement.getNamespaceURI();
        if (this.m_namespace == null) {
            throw new ManagerException("Client.MissingBdeNamespace", "Missing Namespace on BDE content", true);
        }
        s_logger.flowMessage("SOAP: Body Processing : Found namespace '" + this.m_namespace + "'");
        if (!this.m_namespace.startsWith(NAMESPACE)) {
            throw new ManagerException("Client.BadBdeNamespace", "Invalid Namespace on BDE content, found '" + this.m_namespace + "', expected namespace starting with '" + NAMESPACE + "'", true);
        }
        int n = this.m_namespace.lastIndexOf(47);
        String string2 = this.m_namespace.substring(n + 1);
        if (string2.length() == 0) {
            throw new ManagerException("Client.BadBdeNamespace", "Missing BDE Name in content namepace", true);
        }
        s_logger.flowMessage("SOAP: Body Processing : Found dll/bde '" + string2 + "'");
        this.m_dllName = string2;
        this.m_methodName = null;
        int n2 = string.indexOf("Request");
        if (n2 != -1) {
            this.m_methodName = string.substring(0, n2);
        }
        if (this.m_methodName == null || this.m_methodName.trim().length() == 0) {
            throw new ManagerException("Client.MissingBdeMethodName", "Cannot retrieve the Method Name from the Request. The method name is the starting tag of the request suffixed with the 'Request' keyword. For e.g.: 'ListRequest' is the start tag for a 'List' method. The current tag " + string + " does not match this pattern.", true);
        }
        this.fetchBdeElement(sOAPElement);
    }

    private SOAPElement fetchMethodElement(Iterator iterator) throws ManagerException {
        if (!iterator.hasNext()) {
            throw new ManagerException("Client.BodyEmpty", "The SOAP Body does not contain any child Elements. The SOAP body must contain '<Method>Request' tag as its first child.", true);
        }
        SOAPElement sOAPElement = (SOAPElement)iterator.next();
        if (iterator.hasNext()) {
            throw new ManagerException("Client.MultipleBodyElements", "The SOAP body contains more than one child element", true);
        }
        return sOAPElement;
    }

    private void fetchBdeElement(SOAPElement sOAPElement) throws ManagerException {
        DOMConverter dOMConverter = new DOMConverter(null);
        try {
            this.m_bdeElement = dOMConverter.w3cElementToOwElement((org.w3c.dom.Element)sOAPElement);
        }
        catch (Exception exception) {
            throw new ManagerException("Server.Parsing", exception, true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

