/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soap.java;

import com.ssaglobal.soapimpl.java.SOAPUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;

public class FaultException
extends Exception {
    private final SOAPMessage m_soapMessage;

    public FaultException(SOAPMessage sOAPMessage) throws SOAPException, IllegalArgumentException {
        this.m_soapMessage = sOAPMessage;
        if (!this.m_soapMessage.getSOAPBody().hasFault()) {
            throw new IllegalArgumentException("SOAP message must contain a Fault element");
        }
    }

    public FaultException(Name name, String string, String string2) throws SOAPException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("p_faultcode must not be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("p_faultstring must not be null or have length 0");
        }
        this.m_soapMessage = SOAPUtil.createSoapMessage();
        SOAPBody sOAPBody = this.m_soapMessage.getSOAPBody();
        SOAPFault sOAPFault = sOAPBody.addFault(name, string);
        if (string2 != null) {
            sOAPFault.setFaultActor(string2);
        }
    }

    public SOAPMessage getSoapMessage() {
        return this.m_soapMessage;
    }

    public void addStackTraceToDetails(Throwable throwable) throws SOAPException {
        String string = this.stackTraceToString(throwable);
        SOAPFault sOAPFault = this.m_soapMessage.getSOAPBody().getFault();
        Detail detail = sOAPFault.getDetail();
        if (detail == null) {
            detail = sOAPFault.addDetail();
        }
        Name name = SOAPUtil.getStackTraceTag();
        DetailEntry detailEntry = detail.addDetailEntry(name);
        detailEntry.addTextNode(string);
    }

    public void addStackTraceToFault(Throwable throwable) throws SOAPException {
        String string = this.stackTraceToString(throwable);
        SOAPFault sOAPFault = this.m_soapMessage.getSOAPBody().getFault();
        Name name = SOAPUtil.getStackTraceTag();
        SOAPElement sOAPElement = sOAPFault.addChildElement(name);
        sOAPElement.addTextNode(string);
    }

    public void addToFault(SOAPMessage sOAPMessage) throws SOAPException {
        if (sOAPMessage == null) {
            throw new IllegalArgumentException("p_overriddenMessage must not be null");
        }
        Name name = SOAPUtil.getOverridenMessageTag();
        SOAPFault sOAPFault = this.m_soapMessage.getSOAPBody().getFault();
        Iterator iterator = sOAPFault.getChildElements(name);
        if (iterator.hasNext()) {
            throw new IllegalStateException("This Fault already has an overriddenMessage sub element");
        }
        SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
        SOAPElement sOAPElement = sOAPFault.addChildElement(name);
        sOAPElement.addChildElement((SOAPElement)sOAPEnvelope);
    }

    private String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public void removeDetail() throws SOAPException {
        SOAPFault sOAPFault = this.m_soapMessage.getSOAPBody().getFault();
        Detail detail = sOAPFault.getDetail();
        if (detail == null) {
            return;
        }
        detail.detachNode();
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        SOAPHeader sOAPHeader = this.m_soapMessage.getSOAPHeader();
        return sOAPHeader.addHeaderElement(name);
    }
}

