/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soap.http.diagnostics;

import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.ccf.SOAPConnectorConfiguration;
import com.baan.owimpl.fw.ccf.SOAPConnectorContext;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.soap.http.diagnostics.ICheck;
import java.io.File;

public class WSDLDirectoryCheck
implements ICheck {
    private final String NOT_FOUND = "Error getting information from the Central Configuration Store. See the OpenWorld log files for details.";
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soap$http$diagnostics$WSDLDirectoryCheck == null ? (class$com$ssaglobal$soap$http$diagnostics$WSDLDirectoryCheck = WSDLDirectoryCheck.class$("com.ssaglobal.soap.http.diagnostics.WSDLDirectoryCheck")) : class$com$ssaglobal$soap$http$diagnostics$WSDLDirectoryCheck);
    private static String LOG_PREFIX = "SOAP-Diags: ";
    private String m_message;
    static /* synthetic */ Class class$com$ssaglobal$soap$http$diagnostics$WSDLDirectoryCheck;

    public boolean check() {
        try {
            SOAPConnectorConfiguration sOAPConnectorConfiguration = SOAPConnectorContext.getInstance().search();
            String string = sOAPConnectorConfiguration.getWSDLDirectory();
            if (string == null || string.length() == 0) {
                this.m_message = "Location for WSDL Files not defined. This information can be defined in the WSDL Directory property under the Connector for SOAP tab in the Central Configuration Console.";
                return false;
            }
            File file2 = new File(string);
            if (!file2.exists()) {
                this.m_message = "Location for WSDL Files '" + string + "' does not exist. This information is defined in the WSDL Directory property under the Connector for SOAP tab in the Central Configuration Console.";
                return false;
            }
            this.m_message = "Location for WSDL Files is: '" + string + "'";
        }
        catch (OWConfigurationException oWConfigurationException) {
            s_logger.errorException(oWConfigurationException);
            this.m_message = "Error getting information from the Central Configuration Store. See the OpenWorld log files for details.";
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            this.m_message = "Error getting information from the Central Configuration Store. See the OpenWorld log files for details.";
            return false;
        }
        return true;
    }

    public String getMessage() {
        return this.m_message;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

