/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soap.http.diagnostics;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.soap.http.diagnostics.ICheck;
import com.ssaglobal.soap.http.diagnostics.SOAPConnectorVersionCheck;
import java.lang.reflect.Method;

public class ConnectorForJavaVersionCheck
implements ICheck {
    private final String NOT_FOUND = "Cannot get Version information, the Connector for Java is probably not installed correctly or is not found in classpath. See the OpenWorld log files for details.";
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soap$http$diagnostics$ConnectorForJavaVersionCheck == null ? (class$com$ssaglobal$soap$http$diagnostics$ConnectorForJavaVersionCheck = ConnectorForJavaVersionCheck.class$("com.ssaglobal.soap.http.diagnostics.ConnectorForJavaVersionCheck")) : class$com$ssaglobal$soap$http$diagnostics$ConnectorForJavaVersionCheck);
    private static String LOG_PREFIX = "SOAP-Diags: ";
    private double m_c4JVersion;
    private String m_message;
    static /* synthetic */ Class class$com$ssaglobal$soap$http$diagnostics$ConnectorForJavaVersionCheck;

    public boolean check() {
        try {
            Class<?> clazz = Class.forName("com.baan.b3impl.about.AdapterComponentInfo");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getVersion", null);
            String string = (String)method.invoke(obj, null);
            this.m_message = "Version: " + string;
            this.m_c4JVersion = Double.parseDouble(string);
            SOAPConnectorVersionCheck sOAPConnectorVersionCheck = new SOAPConnectorVersionCheck();
            double d = sOAPConnectorVersionCheck.getVersion();
            if (this.m_c4JVersion < d) {
                this.m_message = "Version mismatch. Connector for SOAP version: " + d + " Connector for Java version: " + this.m_c4JVersion + ". See the OpenWorld log files for details.";
                s_logger.errorMessage("Version mismatch. Connector for SOAP version: " + d + " Connector for Java version: " + this.m_c4JVersion + " Connector for SOAP and Connector for Java should have identical versions for optimal performance and compatibility reasons.");
                return false;
            }
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            this.m_message = "Cannot get Version information, the Connector for Java is probably not installed correctly or is not found in classpath. See the OpenWorld log files for details.";
            return false;
        }
        return true;
    }

    public String getMessage() {
        return this.m_message;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

