/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soap.http;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.soap.java.IDispatcher;
import com.ssaglobal.soap.java.ManagerException;
import com.ssaglobal.soap.java.ManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;

public class ServletContextHandler
implements ServletContextListener {
    private static final String LOG_PREFIX = "SOAP-Servlet: ";
    private static final String SCA_MANAGER_FACTORY = (class$com$ssaglobal$soap$http$ServletContextHandler == null ? (class$com$ssaglobal$soap$http$ServletContextHandler = ServletContextHandler.class$("com.ssaglobal.soap.http.ServletContextHandler")) : class$com$ssaglobal$soap$http$ServletContextHandler).getPackage().getName() + ".managerFactory";
    private static final String SCA_DISPATCHER = (class$com$ssaglobal$soap$http$ServletContextHandler == null ? (class$com$ssaglobal$soap$http$ServletContextHandler = ServletContextHandler.class$("com.ssaglobal.soap.http.ServletContextHandler")) : class$com$ssaglobal$soap$http$ServletContextHandler).getPackage().getName() + ".dispatcher";
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soap$http$ServletContextHandler == null ? (class$com$ssaglobal$soap$http$ServletContextHandler = ServletContextHandler.class$("com.ssaglobal.soap.http.ServletContextHandler")) : class$com$ssaglobal$soap$http$ServletContextHandler);
    static /* synthetic */ Class class$com$ssaglobal$soap$http$ServletContextHandler;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void contextDestroyed(ServletContextEvent servletContextEvent) {
        ManagerFactory managerFactory;
        ServletContext servletContext = servletContextEvent.getServletContext();
        IDispatcher iDispatcher = (IDispatcher)servletContext.getAttribute(SCA_DISPATCHER);
        if (iDispatcher != null) {
            iDispatcher.close();
            servletContext.removeAttribute(SCA_DISPATCHER);
        }
        if ((managerFactory = (ManagerFactory)servletContext.getAttribute(SCA_MANAGER_FACTORY)) == null) return;
        try {
            try {
                managerFactory.close();
            }
            catch (ManagerException managerException) {
                s_logger.errorMessage("Could not close SOAP ManagerFactory");
                s_logger.errorException(managerException);
                Object var7_6 = null;
                servletContext.removeAttribute(SCA_MANAGER_FACTORY);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            servletContext.removeAttribute(SCA_MANAGER_FACTORY);
            throw throwable;
        }
        servletContext.removeAttribute(SCA_MANAGER_FACTORY);
    }

    static synchronized ManagerFactory getManagerFactory(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        ManagerFactory managerFactory = (ManagerFactory)servletContext.getAttribute(SCA_MANAGER_FACTORY);
        if (managerFactory == null) {
            ServletContextHandler.createDispatcherCumAnnex(servletContext);
            managerFactory = (ManagerFactory)servletContext.getAttribute(SCA_MANAGER_FACTORY);
        }
        return managerFactory;
    }

    static synchronized IDispatcher getDispatcher(ServletConfig servletConfig) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        IDispatcher iDispatcher = (IDispatcher)servletContext.getAttribute(SCA_DISPATCHER);
        if (iDispatcher == null) {
            ServletContextHandler.createDispatcherCumAnnex(servletContext);
            iDispatcher = (IDispatcher)servletContext.getAttribute(SCA_DISPATCHER);
        }
        return iDispatcher;
    }

    private static synchronized void createDispatcherCumAnnex(ServletContext servletContext) throws ServletException {
        ManagerFactory managerFactory = null;
        IDispatcher iDispatcher = null;
        try {
            managerFactory = ManagerFactory.getManagerFactory();
            iDispatcher = managerFactory.createDispatcher();
        }
        catch (ManagerException managerException) {
            if (managerFactory != null) {
                try {
                    managerFactory.close();
                }
                catch (ManagerException managerException2) {
                    s_logger.errorMessage("Cannot close SOAP Manager");
                    s_logger.errorException(managerException2);
                }
            }
            throw ServletContextHandler.newServletException("Cannot create SOAP Dispatcher", managerException);
        }
        servletContext.setAttribute(SCA_MANAGER_FACTORY, (Object)managerFactory);
        servletContext.setAttribute(SCA_DISPATCHER, (Object)iDispatcher);
    }

    private static ServletException newServletException(String string, Throwable throwable) {
        s_logger.errorMessage(string);
        s_logger.errorException(throwable);
        return new ServletException(string, throwable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

