/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.soap.http;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.soap.http.ServletContextHandler;
import com.ssaglobal.soap.java.FaultException;
import com.ssaglobal.soap.java.IDispatcher;
import com.ssaglobal.soap.java.ManagerException;
import com.ssaglobal.soap.java.ManagerFactory;
import com.ssaglobal.soapimpl.java.SOAPUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SOAPServlet
extends HttpServlet {
    private static final String LOG_PREFIX = "SOAP-Servlet: ";
    private static final String UTF8 = "UTF-8";
    private static final String SUB_CONTEXT = "services";
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$soap$http$SOAPServlet == null ? (class$com$ssaglobal$soap$http$SOAPServlet = SOAPServlet.class$("com.ssaglobal.soap.http.SOAPServlet")) : class$com$ssaglobal$soap$http$SOAPServlet);
    private ManagerFactory m_managerFactory = null;
    private IDispatcher m_dispatcher = null;
    private static final String HH_C_ENC = "Content-Encoding";
    private static final String HH_TRANS_ENC = "Transfer-Encoding";
    private static final String MH_VERSION = "MIME-Version";
    private static final String MH_C_TYPE = "Content-Type";
    private static final String MH_C_TRANS_ENC = "Content-Transfer-Encoding";
    private static final String MH_C_ID = "Content-ID";
    private static final String SH_ACTION = "SOAPAction";
    private static final String MT_TEXT_XML = "text/xml";
    private static final String MT_MULTIPART_RELATED = "multipart/related";
    private static final String MTP_TYPE = "type";
    static /* synthetic */ Class class$com$ssaglobal$soap$http$SOAPServlet;

    private static ServletException newServletException(String string, Throwable throwable) {
        s_logger.errorMessage(string);
        s_logger.errorException(throwable);
        return new ServletException(string, throwable);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.m_managerFactory = ServletContextHandler.getManagerFactory(servletConfig);
        this.m_dispatcher = ServletContextHandler.getDispatcher(servletConfig);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getContextPath();
        String string2 = httpServletRequest.getPathInfo();
        String string3 = httpServletRequest.getQueryString();
        s_logger.flowEntry("SOAP-Servlet: ContextPath = " + string);
        s_logger.flowEntry("SOAP-Servlet: PathInfo = " + string2);
        s_logger.flowEntry("SOAP-Servlet: Query String = " + string3);
        if (string3 == null) {
            httpServletResponse.sendRedirect(string + "/wrongurl.jsp");
            return;
        }
        if (string3.equalsIgnoreCase("wsdl")) {
            s_logger.flowMessage("SOAP-Servlet: Request = Wsdl");
            String string4 = string2.substring(1);
            s_logger.flowMessage("SOAP-Servlet: wsdlFileName = " + string4);
            PrintWriter printWriter = httpServletResponse.getWriter();
            File file2 = null;
            try {
                file2 = this.m_managerFactory.getWSDL(string4);
            }
            catch (ManagerException managerException) {
                httpServletResponse.sendError(500, "Could not retrieve WSDL for webservice " + string4 + ": " + managerException);
                return;
            }
            if (file2 != null) {
                int n;
                httpServletResponse.setContentType(MT_TEXT_XML);
                FileInputStream fileInputStream = new FileInputStream(file2);
                while ((n = fileInputStream.read()) != -1) {
                    printWriter.write(n);
                }
                fileInputStream.close();
                printWriter.close();
                printWriter.flush();
            } else {
                httpServletResponse.sendError(404, "WSDL for webservice " + string4 + " not found.");
            }
        } else if (string3.equalsIgnoreCase("list")) {
            s_logger.flowMessage("SOAP-Servlet: Request = List");
            this.listWebServices(string, httpServletResponse);
        } else {
            httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/wrongurl.jsp");
        }
    }

    private void listWebServices(String string, HttpServletResponse httpServletResponse) throws IOException {
        String[] stringArray;
        String string2 = null;
        try {
            stringArray = (String[])this.m_managerFactory;
            string2 = stringArray.getWsdlLocation();
        }
        catch (ManagerException managerException) {
            httpServletResponse.sendError(500, "Could not retrieve WSDL Location: " + managerException);
            return;
        }
        stringArray = null;
        try {
            stringArray = this.m_managerFactory.getWebServices();
        }
        catch (ManagerException managerException) {
            httpServletResponse.sendError(500, "Could not retrieve a list of deployed web services: " + managerException);
            return;
        }
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
        printWriter.println("\t\"DTD/xhtml1-strict.dtd\">");
        printWriter.println();
        printWriter.println("<html xmlns='http://www.w3.org/1999/xhtml'>");
        printWriter.println("\t<head>");
        printWriter.println("\t\t<title>SSA Global</title>");
        printWriter.println("\t\t<link href='" + string + "/images/wwwstyle.css' TYPE='text/css' REL='stylesheet' />");
        printWriter.println("\t</head>");
        printWriter.println("\t<body>");
        printWriter.println("\t\t<table>");
        printWriter.println("\t\t\t<tbody>");
        printWriter.println("\t\t\t\t<tr class='logobox'>");
        printWriter.println("\t\t\t\t\t<td>");
        printWriter.println("\t\t\t\t\t\t<a href='http://www.ssaglobal.com/'>");
        printWriter.println("\t\t\t\t\t\t\t<img class='logo' src='" + string + "/images/ssalogo.gif' />");
        printWriter.println("\t\t\t\t\t\t</a>");
        printWriter.println("\t\t\t\t\t</td>");
        printWriter.println("\t\t\t\t</tr>");
        printWriter.println("\t\t\t\t<tr class='topnavbox'>");
        printWriter.println("\t\t\t\t\t<td class='topnavcell'>");
        printWriter.println("\t\t\t\t\t\tWeb Services Toolkit");
        printWriter.println("\t\t\t\t\t</td>");
        printWriter.println("\t\t\t\t</tr>");
        printWriter.println("\t\t\t\t<tr>");
        printWriter.println("\t\t\t\t\t<td class='detail1'>");
        printWriter.println("\t\t\t\t\t\t<div class='productname1'>Available Webservices</div>");
        printWriter.println("\t\t\t\t\t\tWSDL files are read from " + string2 + "<br />");
        printWriter.println("\t\t\t\t\t\t<br />");
        if (stringArray.length < 1) {
            printWriter.print("\t\t\t\t\t\tThere are no deployed web services.");
        } else {
            printWriter.print("\t\t\t\t\t\tThe following web services are available:");
        }
        printWriter.println("\t\t\t\t\t\t<ul>");
        int n = 0;
        while (n < stringArray.length) {
            printWriter.println("\t\t\t\t\t\t\t<li>" + stringArray[n] + " (<a href=\"" + string + "/" + SUB_CONTEXT + "/" + stringArray[n] + "?wsdl\">WSDL</a>)</li>");
            ++n;
        }
        printWriter.println("\t\t\t\t\t\t</ul>");
        printWriter.println("\t\t\t\t\t</td>");
        printWriter.println("\t\t\t\t</tr>");
        printWriter.println("\t\t\t\t<tr class='footerbox'>");
        printWriter.println("\t\t\t\t\t<td class='footertext'>");
        printWriter.println("\t\t\t\t\t\tCopyright 2005 SSA Global Technologies, Inc. all rights reserved.");
        printWriter.println("\t\t\t\t\t</td>");
        printWriter.println("\t\t\t\t</tr>");
        printWriter.println("\t\t\t</tbody>");
        printWriter.println("\t\t</table>");
        printWriter.println("\t</body>");
        printWriter.println("</html>");
        printWriter.flush();
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl = false;
        try {
            s_logger.message("SOAP-Servlet: Enter SOAPServlet::Post");
            this.doPostImpl(httpServletRequest, httpServletResponse);
            s_logger.flowExit("SOAP-Servlet: Exit SOAP Servlet");
        }
        catch (FaultException faultException) {
            SOAPMessage sOAPMessage = faultException.getSoapMessage();
            SOAPServlet.sendFaultSoapResponse(sOAPMessage, httpServletResponse);
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            try {
                FaultException faultException = SOAPUtil.newNonBodyFaultException(SOAPUtil.fcServerUnknown(), "while processing HTTP request", throwable);
                SOAPMessage sOAPMessage = faultException.getSoapMessage();
                SOAPServlet.sendFaultSoapResponse(sOAPMessage, httpServletResponse);
            }
            catch (SOAPException sOAPException) {
                httpServletResponse.sendError(500);
            }
        }
    }

    private void doPostImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FaultException, SOAPException, IOException, ServletException {
        MimeHeaders mimeHeaders = SOAPServlet.validateContentType(httpServletRequest);
        String string = SOAPServlet.getBusComponent(httpServletRequest);
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        SOAPMessage sOAPMessage = SOAPUtil.createSoapMessage(mimeHeaders, (InputStream)servletInputStream);
        SOAPUtil.logSoapMessage("Received SOAP message:\n", sOAPMessage, s_logger);
        SOAPMessage sOAPMessage2 = this.m_dispatcher.dispatch(sOAPMessage, string);
        SOAPServlet.sendOkaySoapResponse(sOAPMessage2, httpServletResponse);
    }

    private static MimeHeaders validateContentType(HttpServletRequest httpServletRequest) throws FaultException, SOAPException {
        String string;
        if (httpServletRequest.getHeader(HH_C_ENC) != null) {
            throw SOAPUtil.newFaultException(SOAPUtil.fcClientHttpEncNotSupported(), "Content-Encoding HTTP header not supported");
        }
        if (httpServletRequest.getHeader(HH_TRANS_ENC) != null) {
            throw SOAPUtil.newFaultException(SOAPUtil.fcClientHttpTransEncNotSupported(), "Transfer-Encoding HTTP header not supported");
        }
        if (httpServletRequest.getHeader(SH_ACTION) == null) {
            throw SOAPUtil.newFaultException(SOAPUtil.fcClientHttpMissingAction(), "SOAPAction HTTP header missing; not a SOAP 1.1 message");
        }
        String string2 = httpServletRequest.getContentType();
        if (string2 == null) {
            throw SOAPUtil.newFaultException(SOAPUtil.fcClientMissingContentType(), "Content-Type header missing");
        }
        ContentType contentType = null;
        try {
            contentType = new ContentType(string2);
        }
        catch (ParseException parseException) {
            throw SOAPUtil.newNonBodyFaultException(SOAPUtil.fcServerParsing(), "Could not parseContent-Type HTTP header", parseException);
        }
        String string3 = contentType.getBaseType();
        if (string3.equals(MT_MULTIPART_RELATED)) {
            string = contentType.getParameter(MTP_TYPE);
            if (string == null) {
                throw SOAPUtil.newFaultException(SOAPUtil.fcClientBadContentType(), "type parameter is missing in a multipart/related MIME-type; no root type set");
            }
            if (!string.equals(MT_TEXT_XML)) {
                throw SOAPUtil.newFaultException(SOAPUtil.fcClientBadContentType(), "Unrecognised root type; type parameter of a multipart/related MIME-type does not have the value text/xml");
            }
            if (httpServletRequest.getHeader(MH_VERSION) != null) {
                throw SOAPUtil.newFaultException(SOAPUtil.fcClientMimeHeaderNotSupported(), "MIME-Version MIME header not supported for multipart/related content-type");
            }
            if (httpServletRequest.getHeader(MH_C_ID) != null) {
                throw SOAPUtil.newFaultException(SOAPUtil.fcClientMimeHeaderNotSupported(), "Content-ID MIME header not supported for multipart/related content-type");
            }
            if (httpServletRequest.getHeader(MH_C_TRANS_ENC) != null) {
                throw SOAPUtil.newFaultException(SOAPUtil.fcClientMimeHeaderNotSupported(), "Content-Transfer-Encoding MIME header not supported for multipart/related content-type");
            }
        } else if (!contentType.getBaseType().equals(MT_TEXT_XML)) {
            throw SOAPUtil.newFaultException(SOAPUtil.fcClientBadContentType(), "Content-Type header has unsupported value; only values text/xml and multipart/related are supported");
        }
        string = new MimeHeaders();
        string.addHeader(MH_C_TYPE, string2);
        return string;
    }

    private static String getBusComponent(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getPathInfo();
        String string2 = null;
        if (string != null && (string2 = string.substring(1)).length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private static void sendOkaySoapResponse(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) throws SOAPException, IOException, ServletException {
        httpServletResponse.setStatus(200);
        SOAPServlet.sendSoapResponse(sOAPMessage, httpServletResponse);
    }

    private static void sendFaultSoapResponse(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            httpServletResponse.setStatus(500);
            SOAPServlet.sendSoapResponse(sOAPMessage, httpServletResponse);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Throwable throwable) {
            throw SOAPServlet.newServletException(throwable.getClass().getName() + " while sending SOAP fault response", throwable);
        }
    }

    private static void sendSoapResponse(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) throws SOAPException, IOException, ServletException {
        SOAPUtil.logSoapMessage("Sending SOAP message:\n", sOAPMessage, s_logger);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        sOAPMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)UTF8);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            sOAPMessage.writeTo((OutputStream)servletOutputStream);
            servletOutputStream.flush();
            servletOutputStream.close();
            s_logger.message("SOAP-Servlet: SOAP Message written to OutputStream");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throw SOAPServlet.newServletException(throwable.getClass().getName() + " while sending SOAP response", throwable);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_SOAP_CONNECTOR1);
    }
}

