/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.xml;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.xml.util.DOMConverter;
import com.ssaglobal.bdeserver.BdeServerRuntimeException;
import com.ssaglobal.bdeserver.FilterReceiver;
import com.ssaglobal.bdeserver.IReceiver;
import com.ssaglobal.bdeserver.IStringBdeListener;
import com.ssaglobal.bdeserver.StringResultException;
import com.ssaglobal.bdeserver.impl.BufferedStringReceiver;
import com.ssaglobal.bdeserver.xml.ElementResultException;
import com.ssaglobal.bdeserver.xml.IElementListener;
import org.w3c.dom.Element;

public class ElementReceiver
extends FilterReceiver
implements IReceiver {
    private BufferedStringReceiver m_bdeReceiver;
    private IElementListener m_elementListener;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeserver.xml", "ElementReceiver");
    private static final String LOG_PREFIX = "BDE SERVER xml ElementReceiver: ";

    public ElementReceiver(IElementListener iElementListener, String string) {
        if (iElementListener == null) {
            throw new IllegalArgumentException("IElementListener must not be null");
        }
        this.m_elementListener = iElementListener;
        BdeListener bdeListener = new BdeListener();
        this.m_bdeReceiver = new BufferedStringReceiver(bdeListener, string);
        this.setDelegate(this.m_bdeReceiver);
    }

    private class BdeListener
    implements IStringBdeListener {
        private BdeListener() {
        }

        public String dispatch(String string, String string2, String string3) throws StringResultException, BdeServerRuntimeException {
            Element element = this.makeBDECall(string, string2, string3);
            if (element == null) {
                s_logger.errorMessage("BDE SERVER xml ElementReceiver: BDE Server implementation returned invalid (null) Response for synchronous call");
                throw new BdeServerRuntimeException("BDE Server implementation returned invalid (null) Response for synchronous call");
            }
            s_logger.flowMessage("BDE SERVER xml ElementReceiver: Convert response DOM2 -> String");
            DOMConverter dOMConverter = new DOMConverter(null);
            return dOMConverter.w3cElement2String(element);
        }

        public void onEvent(String string, String string2) throws StringResultException, BdeServerRuntimeException {
            s_logger.message("BDE SERVER xml ElementReceiver: Mapping incoming event to 'onEvent' BDE Method call");
            Element element = this.makeBDECall(string2, "onEvent", string);
            if (element != null) {
                s_logger.message("BDE SERVER xml ElementReceiver: onEvent call returned an response, assuming warnings");
            }
        }

        public Element makeBDECall(String string, String string2, String string3) throws StringResultException, BdeServerRuntimeException {
            try {
                DOMConverter dOMConverter = new DOMConverter(null);
                s_logger.flowMessage("BDE SERVER xml ElementReceiver: Convert request String -> DOM2");
                Element element = dOMConverter.stringToW3cElement(string3);
                s_logger.flowMessage("BDE SERVER xml ElementReceiver: Invoking dispatch method");
                Element element2 = ElementReceiver.this.m_elementListener.dispatch(string, string2, element);
                return element2;
            }
            catch (ElementResultException elementResultException) {
                throw elementResultException.getStringResultException();
            }
            catch (Exception exception) {
                throw new BdeServerRuntimeException(exception.toString());
            }
        }
    }
}

