/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.impl;

import com.baan.b3.server.IParameter;
import com.baan.b3.server.ServerActivationCallBack;
import com.baan.b3.server.ServerException;
import com.baan.b3.server.ServerLicenseException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.bdeimpl.generic.ErrorEvent;
import com.ssaglobal.bdeserver.BdeServerRuntimeException;
import com.ssaglobal.bdeserver.IAuthenticationListener;
import com.ssaglobal.bdeserver.IReceiver;
import com.ssaglobal.bdeserver.IReceiverControlListener;
import com.ssaglobal.bdeserver.LicenseException;
import com.ssaglobal.bdeserver.ReceiverException;
import com.ssaglobal.bdeserver.StringResultException;
import com.ssaglobal.bdeserver.impl.DefaultControlListener;
import com.ssaglobal.bdeserver.impl.DummyAuthenticationListener;
import com.ssaglobal.bdeserver.impl.EventServerRuntime;
import com.ssaglobal.bdeserver.impl.IStringEventListener;
import com.ssaglobal.bdeserver.impl.IStringSyncListener;
import com.ssaglobal.bdeserver.impl.StringListenerThread;

public final class StringReceiver
implements IReceiver {
    private static final int S_STOPPED = 0;
    private static final int S_RUNNING = 1;
    private static final int S_PAUSING = 2;
    private static final int S_PAUSED = 3;
    private static final int S_STOPPING = 4;
    private static final int S_CORRUPT = 5;
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$bdeserver$impl$StringReceiver == null ? (class$com$ssaglobal$bdeserver$impl$StringReceiver = StringReceiver.class$("com.ssaglobal.bdeserver.impl.StringReceiver")) : class$com$ssaglobal$bdeserver$impl$StringReceiver);
    private static final String LOG_PREFIX = "BDE SERVER: ";
    private static int s_lastReceiverId = 0;
    private final int m_receiverId = StringReceiver.getNextReceiverId();
    private final Object m_stateLock = new Object();
    private final Object m_eventLock = new Object();
    private final ServerRuntimeStopper m_stopper = new ServerRuntimeStopper();
    private int m_state = 0;
    private String m_stopResult = null;
    private static ThreadLocal m_localCloseFlag = new ThreadLocal();
    private String m_busComponentName = null;
    private int m_activationCallbackPortNr = -1;
    private int m_licenseId = -1;
    private boolean m_licenseOverride = false;
    private String m_licenseServerName = "BdeReceiver";
    private boolean m_isConcurrencyAllowed = false;
    private IAuthenticationListener m_authListener = DummyAuthenticationListener.getInstance();
    private IReceiverControlListener m_controlListener = DefaultControlListener.getInstance();
    private IStringSyncListener m_syncListener = null;
    private IStringEventListener m_eventListener = null;
    private EventServerRuntime m_runtime = null;
    private int m_connectionId = -1;
    private int m_nrEventsInProcess = 0;
    private String m_backendReference = null;
    private static final String EVENT_FUNCTION_NAME2 = "onEvent";
    private static final String EVENT_LIBRARY_NAME = "com.ssa.ta.event.EventManager";
    private static final String EVENT_FUNCTION_NAME = "publish";
    static /* synthetic */ Class class$com$ssaglobal$bdeserver$impl$StringReceiver;

    private StringReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringReceiver(IStringSyncListener iStringSyncListener, IStringEventListener iStringEventListener, String string) {
        if (iStringSyncListener == null) {
            s_logger.errorMessage("BDE SERVER: IStringSyncListener is null ");
        }
        if (iStringEventListener == null) {
            s_logger.errorMessage("BDE SERVER: IStringEventListener is null ");
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkIsStateAtLeastPaused();
            this.m_syncListener = iStringSyncListener;
            this.m_eventListener = iStringEventListener;
        }
        this.setBusComponent(string);
    }

    private static synchronized int getNextReceiverId() {
        return ++s_lastReceiverId;
    }

    public String toString() {
        return "Event Receiver " + this.m_receiverId;
    }

    public Object getStateLock() {
        return this.m_stateLock;
    }

    private void changeState(int n) {
        this.m_state = n;
        this.m_stateLock.notifyAll();
    }

    private void waitForStateChange() {
        try {
            this.m_stateLock.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    private long waitForStateChange(long l) {
        long l2 = System.currentTimeMillis();
        try {
            this.m_stateLock.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis() - l2;
        return l3;
    }

    public String startAndGiveReference() {
        this.start(true);
        return this.m_backendReference;
    }

    public void start() {
        this.start(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(boolean bl) {
        Object object = this.m_stateLock;
        synchronized (object) {
            block2 : switch (this.m_state) {
                case 1: {
                    return;
                }
                case 4: {
                    while (this.m_state != 0) {
                        this.waitForStateChange();
                        switch (this.m_state) {
                            case 1: {
                                return;
                            }
                            case 2: 
                            case 3: {
                                break block2;
                            }
                            case 0: 
                            case 4: {
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Cannot start receiver when it is in the '" + StringReceiver.stateToString(this.m_state) + "' state.");
                            }
                        }
                    }
                }
                case 0: {
                    this.startServerRuntime(bl);
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot start receiver when it is in the '" + StringReceiver.stateToString(this.m_state) + "' state.");
                }
            }
            this.changeState(1);
        }
    }

    private void startServerRuntime(boolean bl) {
        s_logger.flowMessage("BDE SERVER: Receiver startServerRuntime");
        try {
            this.m_runtime = new EventServerRuntime(this, this.m_licenseId, this.m_licenseServerName, this.m_licenseOverride, this.m_authListener);
        }
        catch (ServerLicenseException serverLicenseException) {
            throw new LicenseException("The receiver could not obtain a license: " + serverLicenseException.getMessage(), serverLicenseException);
        }
        ServerActivationCallBack serverActivationCallBack = null;
        if (this.m_activationCallbackPortNr == -1) {
            if (bl) {
                serverActivationCallBack = ServerActivationCallBack.getActivationCallBackPROG();
                this.m_connectionId = this.m_runtime.startActivationComponent(this.m_busComponentName, serverActivationCallBack);
                this.m_backendReference = serverActivationCallBack.getBackendReference();
            } else {
                this.m_connectionId = this.m_runtime.startComponent(this.m_busComponentName);
            }
        } else {
            serverActivationCallBack = ServerActivationCallBack.getActivationCallBackASM();
            serverActivationCallBack.setASMPortNr(this.m_activationCallbackPortNr);
            this.m_connectionId = this.m_runtime.startActivationComponent(this.m_busComponentName, serverActivationCallBack);
        }
        if (this.m_connectionId < 0) {
            this.m_runtime = null;
            throw new ReceiverException("Could not start bus component '" + this.m_busComponentName + "', see the log file for details");
        }
    }

    public void pause() {
        this.pauseAndWait(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseAndWait(long l) {
        Object object = this.m_stateLock;
        synchronized (object) {
            switch (this.m_state) {
                case 1: {
                    if (this.m_nrEventsInProcess == 0) {
                        this.changeState(3);
                        return true;
                    }
                    this.changeState(2);
                }
                case 2: 
                case 4: {
                    break;
                }
                case 0: 
                case 3: {
                    return true;
                }
                default: {
                    throw new IllegalStateException("Cannot pause receiver when it is in the '" + StringReceiver.stateToString(this.m_state) + "' state.");
                }
            }
            if (l < 0L) {
                return false;
            }
            long l2 = l;
            while (l2 >= 0L) {
                long l3 = this.waitForStateChange(l2);
                if (l > 0L && (l2 -= l3) == 0L) {
                    l2 = -1L;
                }
                switch (this.m_state) {
                    case 1: {
                        throw new ReceiverException("Receiver was restarted by another thread while waiting for '" + StringReceiver.stateToString(3) + "' state");
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 0: 
                    case 3: {
                        return true;
                    }
                    default: {
                        throw new IllegalStateException("Receiver entered the '" + StringReceiver.stateToString(this.m_state) + "' state; it can no longer be paused.");
                    }
                }
            }
            return this.m_state == 3 || this.m_state == 0;
        }
    }

    public void stop() {
        this.stopAndWait(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAndWait(long l) {
        s_logger.flowMessage("BDE SERVER: Set Receiver in stopAndWait");
        boolean bl = false;
        Object object = this.m_stateLock;
        synchronized (object) {
            switch (this.m_state) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    this.changeState(4);
                }
                case 4: {
                    break;
                }
                case 0: {
                    return true;
                }
                default: {
                    throw new IllegalStateException("Cannot stop receiver when it is in the '" + StringReceiver.stateToString(this.m_state) + "' state.");
                }
            }
            if (bl) {
                if (l == 0L) {
                    this.m_stopper.run();
                } else {
                    Thread thread = new Thread((Runnable)this.m_stopper, this.toString() + " stopper thread");
                    thread.start();
                }
            }
            if (l <= 0L) {
                return false;
            }
            long l2 = l;
            while (l2 >= 0L) {
                long l3 = this.waitForStateChange(l2);
                if (l > 0L && (l2 -= l3) == 0L) {
                    l2 = -1L;
                }
                switch (this.m_state) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new ReceiverException("Receiver was restarted by another thread while waiting for '" + StringReceiver.stateToString(0) + "' state");
                    }
                    case 4: {
                        break;
                    }
                    case 0: {
                        return true;
                    }
                    case 5: {
                        throw new ReceiverException(this.m_stopResult);
                    }
                    default: {
                        throw new IllegalStateException("Receiver entered the '" + StringReceiver.stateToString(this.m_state) + "' state; it can no longer be stopped.");
                    }
                }
            }
            return this.m_state == 0;
        }
    }

    public boolean isRunning() {
        Object object = this.m_stateLock;
        synchronized (object) {
            switch (this.m_state) {
                case 1: 
                case 2: 
                case 4: {
                    return true;
                }
                case 0: 
                case 3: 
                case 5: {
                    return false;
                }
            }
            throw new IllegalStateException("Receiver has entered illegal state '" + StringReceiver.stateToString(this.m_state) + "'");
        }
    }

    public boolean isPaused() {
        return this.m_state == 3;
    }

    public boolean isStopped() {
        return this.m_state == 0;
    }

    public void waitForStopped() {
        this.waitForStopped(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForStopped(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            long l2 = l;
            while (l2 >= 0L) {
                switch (this.m_state) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 0: {
                        return true;
                    }
                    case 5: {
                        throw new ReceiverException(this.m_stopResult);
                    }
                    default: {
                        throw new IllegalStateException("Receiver entered the '" + StringReceiver.stateToString(this.m_state) + "' state; it can no longer be stopped.");
                    }
                }
                long l3 = this.waitForStateChange(l2);
                if (l <= 0L || (l2 -= l3) != 0L) continue;
                l2 = -1L;
            }
            return false;
        }
    }

    private void checkState(int n) {
        if (this.m_state != n) {
            throw new IllegalStateException("IReceiver object was in '" + StringReceiver.stateToString(this.m_state) + "' state, expected '" + StringReceiver.stateToString(n) + "' state.");
        }
    }

    private void checkIsStateAtLeastPaused() {
        if (this.m_state != 0 && this.m_state != 3) {
            throw new IllegalStateException("IReceiver object was in '" + StringReceiver.stateToString(this.m_state) + "' state, expected '" + StringReceiver.stateToString(0) + "' or '" + StringReceiver.stateToString(3) + " state.");
        }
    }

    private static String stateToString(int n) {
        switch (n) {
            case 0: {
                return "STOPPED";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "PAUSING";
            }
            case 3: {
                return "PAUSED";
            }
            case 4: {
                return "STOPPING";
            }
            case 5: {
                return "CORRUPT";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivationCallbackPortNr(int n) {
        if (n < -1 || n > 65535 || n == 0) {
            throw new IllegalArgumentException("ActivationCallbackPortNr must be '-1' or in the range 1-65535 (inclusive)");
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkState(0);
            this.m_activationCallbackPortNr = n;
        }
    }

    public int getActivationCallbackPortNr() {
        return this.m_activationCallbackPortNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBusComponent(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("BusComponent must be non-null and must have length greater than 0");
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkState(0);
            this.m_busComponentName = string;
        }
    }

    public String getBusComponent() {
        return this.m_busComponentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLicenseId(int n, boolean bl) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkState(0);
            this.m_licenseId = n;
            this.m_licenseOverride = bl;
        }
    }

    public int getLicenseId() {
        return this.m_licenseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLicenseServerName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("LicenseServerName must be non-null and must have length greater than 0");
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkState(0);
            this.m_licenseServerName = string;
        }
    }

    public String getLicenseServerName() {
        return this.m_licenseServerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrencyAllowed(boolean bl) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkState(0);
            this.m_isConcurrencyAllowed = bl;
        }
    }

    public boolean isConcurrencyAllowed() {
        return this.m_isConcurrencyAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticationListener(IAuthenticationListener iAuthenticationListener) {
        s_logger.flowMessage("BDE SERVER: Setting specific Authentication Listener " + iAuthenticationListener.toString());
        if (iAuthenticationListener == null) {
            iAuthenticationListener = DummyAuthenticationListener.getInstance();
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkIsStateAtLeastPaused();
            this.m_authListener = iAuthenticationListener;
            if (this.m_runtime != null) {
                this.m_runtime.setAuthenticationListener(iAuthenticationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControlListener(IReceiverControlListener iReceiverControlListener) {
        s_logger.flowMessage("BDE SERVER: Setting specific Control Listener " + iReceiverControlListener.toString());
        if (iReceiverControlListener == null) {
            iReceiverControlListener = DefaultControlListener.getInstance();
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            this.checkIsStateAtLeastPaused();
            this.m_controlListener = iReceiverControlListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClose() {
        if (m_localCloseFlag.get() != null) {
            return;
        }
        Object object = this.m_stateLock;
        synchronized (object) {
            switch (this.m_state) {
                case 0: {
                    throw new RuntimeException("Receiver was already stopped");
                }
            }
            boolean bl = this.m_controlListener.onClose();
            if (!bl) {
                throw new RuntimeException("Receiver does not allow deactivation");
            }
            switch (this.m_state) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.m_nrEventsInProcess == 0) {
                        this.changeState(0);
                    } else {
                        this.changeState(4);
                    }
                    this.m_runtime = null;
                    this.m_connectionId = -1;
                    break;
                }
                case 4: {
                    if (this.m_nrEventsInProcess == 0) {
                        this.changeState(0);
                    }
                    this.m_runtime = null;
                    this.m_connectionId = -1;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dispatch(String string, String string2, IParameter[] iParameterArray, IParameter iParameter) throws ServerException {
        Object object = this.m_stateLock;
        synchronized (object) {
            while (this.m_state != 1) {
                switch (this.m_state) {
                    case 0: 
                    case 4: {
                        throw new ServerException("The receiver is stopping or has already stopped");
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 5: {
                        throw new ServerException("The receiver state is corrupt");
                    }
                    case 1: {
                        throw new ServerException("The receiver is simultaneously in a running and not-running state: go figure ?!?");
                    }
                    default: {
                        throw new ServerException("The receiver is in an unknown state");
                    }
                }
                this.waitForStateChange();
            }
            ++this.m_nrEventsInProcess;
        }
        try {
            if (iParameter != null) {
                String string3 = "Generic BDE Server: Not a valid BDE call, Return struct is not void: " + iParameter.toString();
                throw new ServerException(string3);
            }
            if (iParameterArray == null) {
                String string4 = "Generic BDE Server: Not a valid BDE call, Parameters struct is null";
                throw new ServerException(string4);
            }
            if (EVENT_FUNCTION_NAME2.equals(string2)) {
                this.processElementBasedProtocol(string, iParameterArray);
                String string5 = null;
                return string5;
            }
            if (EVENT_FUNCTION_NAME.equals(string2) && EVENT_LIBRARY_NAME.equals(string)) {
                this.processXMLBasedProtocol(iParameterArray);
                String string6 = null;
                return string6;
            }
            String string7 = this.onSyncImpl(string, string2, iParameterArray, iParameter);
            return string7;
        }
        finally {
            Object object2 = this.m_stateLock;
            synchronized (object2) {
                --this.m_nrEventsInProcess;
                if (this.m_nrEventsInProcess == 0) {
                    if (this.m_state == 2) {
                        this.changeState(3);
                    } else if (this.m_state == 4 && this.m_runtime == null) {
                        this.changeState(0);
                    }
                }
            }
        }
    }

    private String onSyncImpl(String string, String string2, IParameter[] iParameterArray, IParameter iParameter) throws ServerException {
        s_logger.message("BDE SERVER: Receiver processing synchronous call, library='" + string + "', function='" + string2 + "'");
        IParameter iParameter2 = iParameterArray[0];
        IParameter iParameter3 = iParameterArray[1];
        IParameter iParameter4 = iParameterArray[2];
        this.checkParameter(iParameter2, 1, 1, 0, string2 + "Request");
        this.checkParameter(iParameter3, 2, 2, 0, string2 + "Response");
        this.checkParameter(iParameter4, 3, 2, 0, "Result");
        String string3 = iParameter2.getValueString();
        if (string3 == null || string3.length() == 0) {
            String string4 = "Generic BDE Server: Not a valid BDE call, First parameter (Request) is empty";
            throw new ServerException(string4);
        }
        try {
            String string5 = this.m_syncListener.dispatch(string, string2, string3);
            iParameter3.setValue(string5);
        }
        catch (Exception exception) {
            this.processSyncException(exception, iParameter4);
        }
        return null;
    }

    private void processXMLBasedProtocol(IParameter[] iParameterArray) throws ServerException {
        IParameter iParameter = iParameterArray[0];
        IParameter iParameter2 = iParameterArray[1];
        this.checkParameter(iParameter, 1, 1, 22, "xmlDoc");
        this.checkParameter(iParameter2, 2, 2, 22, "result");
        String string = null;
        String string2 = iParameter.getValueString();
        try {
            int n = string2.indexOf("<eventEntity>");
            int n2 = string2.indexOf("</eventEntity>", n);
            if (n < 0 || n2 < 0) {
                throw new Exception();
            }
            string = string2.substring(n + 13, n2);
        }
        catch (Exception exception) {
            String string3 = "Generic BDE Server: Not a valid event message, could not obtain EventEntity (BDE Name)";
            s_logger.errorMessage(string3);
            throw new ServerException(string3);
        }
        if (string2 == null || string2.length() == 0) {
            String string4 = "Generic BDE Server: Not a valid BDE Event call, First parameter (Request) is empty";
            s_logger.errorMessage(string4);
            throw new ServerException(string4);
        }
        try {
            if (this.m_isConcurrencyAllowed) {
                StringListenerThread.dispatchEvent(string2, string, this.m_eventListener);
            } else {
                StringListenerThread.dispatchEvent(string2, string, this.m_eventListener, this.m_eventLock);
            }
        }
        catch (Throwable throwable) {
            ErrorEvent.processConsumerEventException(this.m_busComponentName, throwable, string2);
        }
        iParameter2.setValue("<Result/>");
    }

    private void processElementBasedProtocol(String string, IParameter[] iParameterArray) throws ServerException {
        block4: {
            IParameter iParameter = iParameterArray[0];
            IParameter iParameter2 = iParameterArray[1];
            IParameter iParameter3 = iParameterArray[2];
            this.checkParameter(iParameter, 1, 1, 0, "onEventRequest");
            this.checkParameter(iParameter2, 2, 2, 0, "onEventResponse");
            this.checkParameter(iParameter3, 3, 2, 0, "Result");
            String string2 = iParameter.getValueString();
            if (string2 == null || string2.length() == 0) {
                s_logger.errorMessage("BDE SERVER: Generic BDE Server: Not a valid BDE call, First parameter (Request) is empty");
                throw new ServerException("BDE SERVER: Generic BDE Server: Not a valid BDE call, First parameter (Request) is empty");
            }
            try {
                if (this.m_isConcurrencyAllowed) {
                    StringListenerThread.dispatchEvent(string2, string, this.m_eventListener);
                    break block4;
                }
                StringListenerThread.dispatchEvent(string2, string, this.m_eventListener, this.m_eventLock);
            }
            catch (Throwable throwable) {
                ErrorEvent.processConsumerEventException(this.m_busComponentName, throwable, string2);
            }
        }
    }

    private void processSyncException(Throwable throwable, IParameter iParameter) throws ServerException {
        if (!(throwable instanceof StringResultException)) {
            if (throwable instanceof BdeServerRuntimeException) {
                throw new ServerException(throwable.getMessage());
            }
            if (throwable instanceof ThreadDeath) {
                throw new ServerException("ThreadDeath exception during processing of call: " + throwable.getMessage());
            }
            throw new ServerException("Unexpected Error during processing of call: " + throwable.getMessage());
        }
        String string = throwable.getMessage();
        iParameter.setValue(string);
    }

    private void checkParameter(IParameter iParameter, int n, int n2, int n3, String string) throws ServerException {
        if (iParameter == null) {
            String string2 = "BDE SERVER: Not a valid BDE call, parameter " + n + ", for BDE call is null";
            s_logger.errorMessage(string2);
            throw new ServerException(string2);
        }
        if (iParameter.getType() != n3) {
            String string3 = "BDE SERVER: Not a valid BDE call, unexpected type for parameter " + n + ", should be " + n3 + ", parameter: " + iParameter.toString();
            s_logger.errorMessage(string3);
            throw new ServerException(string3);
        }
        if (iParameter.getScope() != n2) {
            String string4 = "BDE SERVER: Not a valid BDE call, unexpected scope for parameter " + n + ", should be " + n2 + ", parameter: " + iParameter.toString();
            s_logger.errorMessage(string4);
            throw new ServerException(string4);
        }
        if (!iParameter.getName().equals(string)) {
            String string5 = "BDE SERVER: Not a valid BDE call, unexpected name for parameter " + n + ", should be '" + string + "', parameter: " + iParameter.toString();
            s_logger.errorMessage(string5);
            throw new ServerException(string5);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ServerRuntimeStopper
    implements Runnable {
        private ServerRuntimeStopper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StringReceiver.this.m_stopResult = null;
            boolean bl = StringReceiver.this.m_runtime.stopComponent(StringReceiver.this.m_connectionId);
            if (!bl) {
                Object object = StringReceiver.this.m_stateLock;
                synchronized (object) {
                    StringReceiver.this.changeState(5);
                    StringReceiver.this.m_stopResult = "Could not stop bus component '" + StringReceiver.this.m_busComponentName + "', see the log file for " + "details";
                    throw new ReceiverException(StringReceiver.this.m_stopResult);
                }
            }
            m_localCloseFlag.set("local");
            StringReceiver.this.m_runtime.stopServerRuntime();
            StringReceiver.this.m_backendReference = null;
            m_localCloseFlag.set(null);
            Object object = StringReceiver.this.m_stateLock;
            synchronized (object) {
                StringReceiver.this.m_runtime = null;
                StringReceiver.this.m_connectionId = -1;
                if (StringReceiver.this.m_nrEventsInProcess == 0) {
                    StringReceiver.this.changeState(0);
                }
            }
        }
    }
}

