/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.impl;

import com.ssaglobal.bdeserver.BdeServerRuntimeException;
import com.ssaglobal.bdeserver.StringResultException;
import com.ssaglobal.bdeserver.impl.IStringEvent;
import com.ssaglobal.bdeserver.impl.IStringEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class StringListenerThread
implements Runnable {
    private static final List s_freeThreads = new ArrayList();
    private static final List s_busyThreads = new ArrayList();
    private static final Map s_threadMap = new HashMap();
    private boolean m_isBusy = false;
    private boolean m_isStopping = false;
    private IStringEventListener m_eventlistener = null;
    private String m_string = null;
    private String m_eventEntity = null;
    private Throwable m_throwable = null;
    private boolean m_isAcknowledged = true;
    private Object m_concurrencyLock = null;
    private int m_mapRefCount = 0;

    StringListenerThread() {
    }

    static void dispatchEvent(String string, String string2, IStringEventListener iStringEventListener) throws StringResultException, BdeServerRuntimeException {
        StringListenerThread.getFreeThread().dispatchEventImpl(string, string2, iStringEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispatchEvent(String string, String string2, IStringEventListener iStringEventListener, Object object) throws StringResultException, BdeServerRuntimeException {
        StringListenerThread stringListenerThread;
        Object object2 = object;
        synchronized (object2) {
            stringListenerThread = (StringListenerThread)s_threadMap.get(object);
            if (stringListenerThread == null) {
                stringListenerThread = StringListenerThread.getFreeThread();
                s_threadMap.put(object, stringListenerThread);
                stringListenerThread.setConcurrencyLock(object);
            }
            stringListenerThread.addRef();
        }
        stringListenerThread.dispatchEventImpl(string, string2, iStringEventListener);
    }

    private static synchronized StringListenerThread getFreeThread() {
        StringListenerThread stringListenerThread;
        int n = s_freeThreads.size();
        if (n == 0) {
            stringListenerThread = new StringListenerThread();
            new Thread(stringListenerThread).start();
        } else {
            stringListenerThread = (StringListenerThread)s_freeThreads.remove(n - 1);
        }
        s_busyThreads.add(stringListenerThread);
        return stringListenerThread;
    }

    private static synchronized void freeThread(StringListenerThread stringListenerThread) {
        boolean bl = s_busyThreads.remove(stringListenerThread);
        stringListenerThread.stop();
    }

    private static synchronized void freeThread(StringListenerThread stringListenerThread, Object object) {
        Object v = s_threadMap.remove(object);
        StringListenerThread.freeThread(stringListenerThread);
    }

    private void setConcurrencyLock(Object object) {
        this.m_concurrencyLock = object;
    }

    private void addRef() {
        ++this.m_mapRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dispatchEventImpl(String string, String string2, IStringEventListener iStringEventListener) throws StringResultException {
        while (this.m_isBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isBusy = true;
        this.m_string = string;
        this.m_eventEntity = string2;
        this.m_eventlistener = iStringEventListener;
        this.m_throwable = null;
        this.m_isAcknowledged = false;
        this.notifyAll();
        while (!this.m_isAcknowledged) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            if (this.m_throwable != null) {
                Throwable throwable = this.m_throwable;
                if (throwable instanceof StringResultException) {
                    throw (StringResultException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException("Non-runtime subclass of java.lang.Exception thrown in StringEvent handling code; this should never happen", throwable);
            }
            Object var6_7 = null;
            if (this.m_eventlistener == null) {
                this.m_isBusy = false;
                this.notifyAll();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (this.m_eventlistener == null) {
                this.m_isBusy = false;
                this.notifyAll();
            }
            throw throwable;
        }
    }

    private synchronized void stop() {
        while (this.m_isBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_isBusy = true;
        this.m_isStopping = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            StringListenerThread stringListenerThread = this;
            // MONITORENTER : stringListenerThread
            while (!this.m_isBusy) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : stringListenerThread
            if (this.m_isStopping) {
                return;
            }
            StringEvent stringEvent = new StringEvent(this.m_string, this.m_eventEntity);
            try {
                this.m_eventlistener.onEvent(stringEvent);
            }
            catch (StringResultException stringResultException) {
                this.m_throwable = stringResultException;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.m_throwable = throwable;
            }
            StringListenerThread stringListenerThread2 = this;
            // MONITORENTER : stringListenerThread2
            if (this.m_isAcknowledged) {
                this.m_isBusy = false;
            }
            this.m_string = null;
            this.m_eventEntity = null;
            this.m_eventlistener = null;
            this.m_isAcknowledged = true;
            this.notifyAll();
            // MONITOREXIT : stringListenerThread2
            if (this.m_concurrencyLock != null) {
                Object object = this.m_concurrencyLock;
                // MONITORENTER : object
                --this.m_mapRefCount;
                if (this.m_mapRefCount < 1) {
                    Object object2 = this.m_concurrencyLock;
                    this.m_concurrencyLock = null;
                    StringListenerThread.freeThread(this, object2);
                }
                // MONITOREXIT : object
                continue;
            }
            StringListenerThread.freeThread(this);
        }
    }

    private class StringEvent
    implements IStringEvent {
        private final String m_string;
        private final String m_eventEntity;

        private StringEvent(String string, String string2) {
            this.m_string = string;
            this.m_eventEntity = string2;
        }

        public String getString() {
            return this.m_string;
        }

        public String getEventEntity() {
            return this.m_eventEntity;
        }
    }
}

