/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.impl;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.bdeimpl.generic.ErrorEvent;
import com.ssaglobal.bdeserver.impl.IStringEvent;
import com.ssaglobal.bdeserver.impl.IStringEventListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;

final class FileBuffer
implements Runnable {
    private static final String EVENT_FILE_PREFIX = ".event";
    private static final String FILE_ENCODING = "UTF8";
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeserver.impl", "FileBuffer");
    private static final String LOG_PREFIX = "BDE SERVER FileBuffer: ";
    private static DecimalFormat m_nf = new DecimalFormat();
    private static String m_lastTimestamp;
    private static int m_lastSequence;
    private String m_queuePath;
    private ArrayList m_eventQueue = new ArrayList();
    IStringEventListener m_stringListener;
    private File queueDir = null;
    private boolean keepRunning = true;
    private String m_buscomponentId = null;

    public FileBuffer(String string, String string2) throws Exception {
        s_logger.message("BDE SERVER FileBuffer: Creating for queuePath='" + string2 + "', and BusComponent '" + string + "'");
        this.m_queuePath = string2;
        this.queueDir = new File(string2);
        this.m_buscomponentId = string;
        if (!this.queueDir.exists()) {
            String string3 = "Cannot start file-based queue, folder '" + string2 + "' is non existing";
            s_logger.errorMessage(LOG_PREFIX + string3);
            throw new Exception(string3);
        }
    }

    public void processQueue() {
        Object object;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        s_logger.message("BDE SERVER FileBuffer: QueueFolder = '" + this.queueDir.getAbsolutePath() + "'");
        s_logger.flowMessage("BDE SERVER FileBuffer: Search for already existing events");
        File[] fileArray = this.queueDir.listFiles();
        s_logger.flowMessage("BDE SERVER FileBuffer: found " + fileArray.length + " files/folders in QueueFolder");
        this.m_eventQueue.clear();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && ((String)(object = fileArray[n].getAbsolutePath())).endsWith(EVENT_FILE_PREFIX)) {
                s_logger.flowMessage("BDE SERVER FileBuffer: found already existing event file '" + (String)object + "'");
                treeSet.add(object);
            }
            ++n;
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            QueueEntry queueEntry = new QueueEntry();
            queueEntry.fileName = string;
            queueEntry.requestRef = new SoftReference<Object>(null);
            this.m_eventQueue.add(queueEntry);
        }
    }

    public void setListener(IStringEventListener iStringEventListener) {
        this.m_stringListener = iStringEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(IStringEvent iStringEvent) throws IOException {
        String string;
        Object object;
        s_logger.message("BDE SERVER FileBuffer: Adding new event to queue");
        DecimalFormat decimalFormat = m_nf;
        synchronized (decimalFormat) {
            object = String.valueOf(new Date().getTime());
            m_lastSequence = ((String)object).equals(m_lastTimestamp) ? ++m_lastSequence : 1;
            m_lastTimestamp = object;
            string = this.m_queuePath + "/" + (String)object + "-" + m_nf.format(m_lastSequence) + EVENT_FILE_PREFIX;
        }
        object = new File(string);
        ((File)object).getParentFile().mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = iStringEvent.getString().getBytes(FILE_ENCODING);
        byte[] byArray2 = iStringEvent.getEventEntity().getBytes(FILE_ENCODING);
        fileOutputStream.write(byArray2);
        fileOutputStream.write(35);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        s_logger.message("BDE SERVER FileBuffer: Created new event file '" + ((File)object).getAbsolutePath() + "'");
        QueueEntry queueEntry = new QueueEntry();
        queueEntry.fileName = string;
        queueEntry.requestRef = new SoftReference<StringEvent>(new StringEvent(iStringEvent, (File)object));
        ArrayList arrayList = this.m_eventQueue;
        synchronized (arrayList) {
            s_logger.flowMessage("BDE SERVER FileBuffer: Adding to local eventqueue");
            this.m_eventQueue.add(queueEntry);
            s_logger.flowMessage("BDE SERVER FileBuffer: current local queue length = " + this.m_eventQueue.size());
            this.m_eventQueue.notify();
        }
    }

    public void stopProcessing() {
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        s_logger.flowMessage("BDE SERVER FileBuffer: Starting event processing thread");
        while (this.keepRunning) {
            QueueEntry queueEntry = null;
            ArrayList arrayList = this.m_eventQueue;
            synchronized (arrayList) {
                if (this.m_eventQueue.isEmpty()) {
                    try {
                        s_logger.flowMessage("BDE SERVER FileBuffer: Waiting for new event");
                        this.m_eventQueue.wait();
                        queueEntry = (QueueEntry)this.m_eventQueue.remove(0);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    queueEntry = (QueueEntry)this.m_eventQueue.remove(0);
                }
            }
            if (queueEntry == null) continue;
            IStringEvent iStringEvent = (IStringEvent)queueEntry.requestRef.get();
            File file2 = new File(queueEntry.fileName);
            if (iStringEvent == null) {
                s_logger.flowMessage("BDE SERVER FileBuffer: reading event file '" + file2.getAbsolutePath() + "'");
                try {
                    int n = (int)file2.length();
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    byte[] byArray = new byte[n];
                    s_logger.message("Reading " + n + " bytes from event file");
                    int n2 = 0;
                    int n3 = 0;
                    while (n2 < byArray.length && (n3 = ((InputStream)fileInputStream).read(byArray, n2, byArray.length - n2)) >= 0) {
                        n2 += n3;
                    }
                    if (n2 < byArray.length) {
                        throw new IOException("Could not completely read file " + file2.getName());
                    }
                    ((InputStream)fileInputStream).close();
                    s_logger.flowBytes(byArray);
                    String string = new String(byArray, FILE_ENCODING);
                    int n4 = string.indexOf(35);
                    String string2 = string.substring(n4 + 1);
                    String string3 = string.substring(0, n4);
                    iStringEvent = new StringEvent(string2, string3, file2);
                }
                catch (Exception exception) {
                    s_logger.errorMessage("BDE SERVER FileBuffer: error reading file '" + file2.getAbsolutePath() + "' " + exception.getMessage());
                }
            } else {
                s_logger.flowMessage("BDE SERVER FileBuffer: event is also in memory queue, no need to read from file");
            }
            if (iStringEvent != null) {
                try {
                    s_logger.flowMessage("BDE SERVER FileBuffer: pass event tot handler");
                    this.m_stringListener.onEvent(iStringEvent);
                }
                catch (Throwable throwable) {
                    s_logger.errorMessage("BDE SERVER FileBuffer: Error occured while processing event; " + throwable.getMessage());
                    ErrorEvent.processConsumerEventException(this.m_buscomponentId, throwable, iStringEvent.getString());
                }
            }
            s_logger.flowMessage("BDE SERVER FileBuffer: remove event file " + file2.getAbsolutePath());
            file2.delete();
        }
        this.keepRunning = true;
        s_logger.flowMessage("BDE SERVER FileBuffer: Event processing thread has stopped");
    }

    static {
        m_nf.setGroupingUsed(false);
        m_nf.setMinimumIntegerDigits(4);
    }

    private class StringEvent
    implements IStringEvent {
        private final String m_string;
        private final String m_eventEntity;
        private final File m_file;

        private StringEvent(String string, String string2, File file2) {
            this.m_string = string;
            this.m_eventEntity = string2;
            this.m_file = file2;
        }

        private StringEvent(IStringEvent iStringEvent, File file2) {
            this.m_string = iStringEvent.getString();
            this.m_eventEntity = iStringEvent.getEventEntity();
            this.m_file = file2;
        }

        public String getString() {
            return this.m_string;
        }

        public String getEventEntity() {
            return this.m_eventEntity;
        }
    }

    private class QueueEntry {
        String fileName;
        SoftReference requestRef;

        private QueueEntry() {
        }
    }
}

