/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.impl;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.bdeserver.BdeServerRuntimeException;
import com.ssaglobal.bdeserver.FilterReceiver;
import com.ssaglobal.bdeserver.IReceiver;
import com.ssaglobal.bdeserver.IStringBdeListener;
import com.ssaglobal.bdeserver.StringResultException;
import com.ssaglobal.bdeserver.configuration.ConfigurationException;
import com.ssaglobal.bdeserver.configuration.ServerConfiguration;
import com.ssaglobal.bdeserver.impl.FileBuffer;
import com.ssaglobal.bdeserver.impl.IStringEvent;
import com.ssaglobal.bdeserver.impl.IStringEventListener;
import com.ssaglobal.bdeserver.impl.IStringSyncListener;
import com.ssaglobal.bdeserver.impl.StringReceiver;

public final class BufferedStringReceiver
extends FilterReceiver
implements IReceiver {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$ssaglobal$bdeserver$impl$BufferedStringReceiver == null ? (class$com$ssaglobal$bdeserver$impl$BufferedStringReceiver = BufferedStringReceiver.class$("com.ssaglobal.bdeserver.impl.BufferedStringReceiver")) : class$com$ssaglobal$bdeserver$impl$BufferedStringReceiver);
    private static final String LOG_PREFIX = "BDE SERVER BufferedStringReceiver: ";
    private IStringBdeListener m_stringBdeListener;
    private StringReceiver m_stringReceiver;
    private boolean m_paused = false;
    private boolean bPersistentQueueEnabled = false;
    private FileBuffer m_fb = null;
    private String m_buscomponentId = null;
    static /* synthetic */ Class class$com$ssaglobal$bdeserver$impl$BufferedStringReceiver;

    public BufferedStringReceiver(IStringBdeListener iStringBdeListener, String string) {
        Object object;
        Object object2;
        if (iStringBdeListener == null) {
            throw new IllegalArgumentException("String Bde Listener must not be null");
        }
        this.m_buscomponentId = string;
        s_logger.message("BDE SERVER BufferedStringReceiver: Try to find (BusComponent) property for PersistentQueuePath");
        try {
            object2 = ServerConfiguration.getServerConfiguration(string);
            object = ((ServerConfiguration)object2).getPersistentQueuePath();
            s_logger.message("BDE SERVER BufferedStringReceiver: found property for PersistentQueuePath='" + (String)object + "'");
            this.m_fb = new FileBuffer(string, (String)object);
            this.bPersistentQueueEnabled = true;
        }
        catch (ConfigurationException configurationException) {
            s_logger.message(LOG_PREFIX + configurationException.getMessage());
            s_logger.message("BDE SERVER BufferedStringReceiver: Not found property for PersistentQueuePath, disabeling persistent queue");
        }
        catch (Exception exception) {
            s_logger.message("BDE SERVER BufferedStringReceiver: Persistent Queue not enabled: " + exception.getMessage());
        }
        this.m_stringBdeListener = iStringBdeListener;
        object2 = new BdeListener();
        object = new BdeListener();
        if (this.bPersistentQueueEnabled) {
            s_logger.flowMessage("BDE SERVER BufferedStringReceiver: Re-direct Bde Events to the file Queue");
            this.m_fb.setListener((IStringEventListener)object);
            s_logger.flowMessage("BDE SERVER BufferedStringReceiver: set Bde Event Listener on Queue");
            object = new EventQueueListener();
        }
        this.m_stringReceiver = new StringReceiver((IStringSyncListener)object2, (IStringEventListener)object, string);
        this.setDelegate(this.m_stringReceiver);
    }

    public void start() {
        if (this.bPersistentQueueEnabled) {
            s_logger.message("BDE SERVER BufferedStringReceiver: Search for existing events");
            this.m_fb.processQueue();
            s_logger.message("BDE SERVER BufferedStringReceiver: Start processing events");
            Thread thread = new Thread(this.m_fb);
            thread.setName("FileBufferProc");
            thread.start();
            if (!this.m_paused) {
                s_logger.message("BDE SERVER BufferedStringReceiver: Start OpenWorld Server");
                super.start();
            }
            this.m_paused = false;
        } else {
            s_logger.message("BDE SERVER BufferedStringReceiver: Start OpenWorld Server");
            super.start();
        }
    }

    public void pause() {
        if (this.bPersistentQueueEnabled) {
            s_logger.message("BDE SERVER BufferedStringReceiver: pause processing events");
            this.m_fb.stopProcessing();
            this.m_paused = true;
        } else {
            super.pause();
        }
    }

    public boolean isPaused() {
        if (this.bPersistentQueueEnabled) {
            return this.m_paused;
        }
        return super.isPaused();
    }

    public void stop() {
        if (this.bPersistentQueueEnabled) {
            s_logger.message("BDE SERVER BufferedStringReceiver: Stop processing events");
            this.m_fb.stopProcessing();
            s_logger.message("BDE SERVER BufferedStringReceiver: Stop OpenWorld Server");
            super.stop();
            this.m_paused = false;
        } else {
            s_logger.message("BDE SERVER BufferedStringReceiver: Stop OpenWorld Server");
            super.stop();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BdeListener
    implements IStringSyncListener,
    IStringEventListener {
        private BdeListener() {
        }

        public String dispatch(String string, String string2, String string3) throws StringResultException, BdeServerRuntimeException {
            s_logger.flowMessage("BDE SERVER BufferedStringReceiver: pass through synchronous BDE call");
            return BufferedStringReceiver.this.m_stringBdeListener.dispatch(string, string2, string3);
        }

        public void onEvent(IStringEvent iStringEvent) throws StringResultException, BdeServerRuntimeException {
            s_logger.flowMessage("BDE SERVER BufferedStringReceiver: pass through event BDE");
            BufferedStringReceiver.this.m_stringBdeListener.onEvent(iStringEvent.getString(), iStringEvent.getEventEntity());
        }
    }

    private class EventQueueListener
    implements IStringEventListener {
        private EventQueueListener() {
        }

        public void onEvent(IStringEvent iStringEvent) throws StringResultException {
            try {
                s_logger.flowMessage("BDE SERVER BufferedStringReceiver: pass through event (put in file queue)");
                BufferedStringReceiver.this.m_fb.addToQueue(iStringEvent);
            }
            catch (Exception exception) {
                throw new StringResultException("error is storing/buffering event ");
            }
        }
    }
}

