/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.generic;

import com.baan.b3.dom.Element;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.bdeimpl.generic.BdeImplException;
import com.ssaglobal.bdeimpl.generic.BdeImplResultException;
import com.ssaglobal.bdeimpl.generic.BdeProxy;
import com.ssaglobal.bdeimpl.generic.Event;
import com.ssaglobal.bdeserver.BaanDomResultException;
import com.ssaglobal.bdeserver.BdeServerRuntimeException;
import com.ssaglobal.bdeserver.FilterReceiver;
import com.ssaglobal.bdeserver.IBaanDomBdeListener;
import com.ssaglobal.bdeserver.IReceiver;
import com.ssaglobal.bdeserver.generic.IBdeListener;
import com.ssaglobal.bdeserver.impl.BaanDomReceiver;

public final class BdeReceiver
extends FilterReceiver
implements IReceiver {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeserver.generic", "BdeReceiver");
    private static final String LOG_PREFIX = "BDE SERVER BdeReceiver: ";
    private IBdeListener m_bdeListener;
    private BaanDomReceiver m_baanDomReceiver;

    public BdeReceiver(IBdeListener iBdeListener, String string) {
        if (iBdeListener == null) {
            throw new IllegalArgumentException("Baan DOM BdeListener must not be null");
        }
        this.m_bdeListener = iBdeListener;
        BdeListener bdeListener = new BdeListener();
        this.m_baanDomReceiver = new BaanDomReceiver(bdeListener, string);
        this.setDelegate(this.m_baanDomReceiver);
    }

    private class BdeListener
    implements IBaanDomBdeListener {
        private BdeListener() {
        }

        public Element dispatch(String string, String string2, Element element) throws BaanDomResultException, BdeServerRuntimeException {
            s_logger.flowMessage("BDE SERVER BdeReceiver: pass through method call, convert Dom1 -> BdeProxy");
            try {
                BdeProxy bdeProxy = new BdeProxy(element);
                BdeProxy bdeProxy2 = BdeReceiver.this.m_bdeListener.dispatch(string, string2, bdeProxy);
                return bdeProxy2.getRoot();
            }
            catch (BdeImplResultException bdeImplResultException) {
                s_logger.flowMessage("BDE SERVER BdeReceiver: ResultException thrown, convert BdeProxy -> DOM1");
                throw new BaanDomResultException(bdeImplResultException.getBdeMessage().getRoot());
            }
        }

        public void onEvent(Element element) throws BaanDomResultException, BdeServerRuntimeException {
            try {
                s_logger.flowMessage("BDE SERVER BdeReceiver: pass through event, convert Dom1 -> BdeProxy");
                Event event = new Event(element);
                BdeReceiver.this.m_bdeListener.onEvent(event);
            }
            catch (BdeImplResultException bdeImplResultException) {
                s_logger.flowMessage("BDE SERVER BdeReceiver: ResultException thrown, convert BdeProxy -> DOM1");
                throw new BaanDomResultException(bdeImplResultException.getBdeMessage().getRoot());
            }
            catch (BdeImplException bdeImplException) {
            }
        }
    }
}

