/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bdeserver.event;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.ssaglobal.bde.BdeException;
import com.ssaglobal.bdeimpl.generic.BdeImplResultException;
import com.ssaglobal.bdeimpl.generic.BdeProxy;
import com.ssaglobal.bdeimpl.generic.Event;
import com.ssaglobal.bdeimpl.xml.ElementEvent;
import com.ssaglobal.bdeserver.BdeServerRuntimeException;
import com.ssaglobal.bdeserver.FilterReceiver;
import com.ssaglobal.bdeserver.event.IElementEventListener;
import com.ssaglobal.bdeserver.generic.BdeReceiver;
import com.ssaglobal.bdeserver.generic.IBdeListener;

public class ElementReceiver
extends FilterReceiver {
    private BdeReceiver m_bdeReceiver;
    private IElementEventListener m_elementEventListener;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.ssaglobal.bdeserver.event", "ElementReceiver");
    private static final String LOG_PREFIX = "BDE SERVER Event ElementReceiver: ";

    public ElementReceiver(IElementEventListener iElementEventListener, String string) {
        if (iElementEventListener == null) {
            throw new IllegalArgumentException("Event Listener must not be null");
        }
        this.m_elementEventListener = iElementEventListener;
        BdeEventListener bdeEventListener = new BdeEventListener();
        this.m_bdeReceiver = new BdeReceiver(bdeEventListener, string);
        this.setDelegate(this.m_bdeReceiver);
    }

    private class BdeEventListener
    implements IBdeListener {
        private BdeEventListener() {
        }

        public BdeProxy dispatch(String string, String string2, BdeProxy bdeProxy) throws BdeImplResultException, BdeServerRuntimeException {
            String string3 = "Incoming BDE Method call, This Bde Server only handles events";
            s_logger.errorMessage(ElementReceiver.LOG_PREFIX + string3);
            throw new BdeServerRuntimeException(string3);
        }

        public void onEvent(Event event) throws BdeImplResultException, BdeServerRuntimeException {
            s_logger.message("BDE SERVER Event ElementReceiver: pass through event, convert Event -> ElementEvent");
            ElementEvent elementEvent = null;
            try {
                elementEvent = new ElementEvent(event);
            }
            catch (BdeException bdeException) {
                throw new BdeServerRuntimeException("Error creating ElementEvent " + bdeException.getMessage());
            }
            ElementReceiver.this.m_elementEventListener.onEvent(elementEvent);
        }
    }
}

